/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.RuntimeServices;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.Resource;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.ResourceCache;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class ResourceCacheImpl
implements ResourceCache {
    protected Map<Object, Resource> cache = new ConcurrentHashMap<Object, Resource>(512, 0.5f, 30);
    protected RuntimeServices rsvc = null;
    protected Logger log;

    @Override
    public void initialize(RuntimeServices rs) {
        this.rsvc = rs;
        int maxSize = this.rsvc.getInt("resource.manager.cache.default_size", 89);
        if (maxSize > 0) {
            Map<Object, Resource> lruCache = Collections.synchronizedMap(new LRUMap(maxSize));
            lruCache.putAll(this.cache);
            this.cache = lruCache;
        }
        this.rsvc.getLog().debug("initialized ({}) with {} cache map.", this.getClass(), this.cache.getClass());
    }

    @Override
    public Resource get(Object key) {
        return this.cache.get(key);
    }

    @Override
    public Resource put(Object key, Resource value) {
        return this.cache.put(key, value);
    }

    @Override
    public Resource remove(Object key) {
        return this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Iterator<Object> enumerateKeys() {
        return this.cache.keySet().iterator();
    }

    private static class LRUMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 5889225121697975043L;
        private int cacheSize;

        public LRUMap(int cacheSize) {
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }
}

