/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.loader;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.ResourceNotFoundException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.Resource;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.loader.ResourceLoader;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.util.ClassUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.util.ExtProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ClasspathResourceLoader
extends ResourceLoader {
    @Override
    public void init(ExtProperties configuration) {
        this.log.trace("ClasspathResourceLoader: initialization complete.");
    }

    @Override
    public Reader getResourceReader(String name, String encoding) throws ResourceNotFoundException {
        Reader result = null;
        if (StringUtils.isEmpty(name)) {
            throw new ResourceNotFoundException("No template name provided");
        }
        InputStream rawStream = null;
        try {
            rawStream = ClassUtils.getResourceAsStream(this.getClass(), name);
            if (rawStream != null) {
                result = this.buildReader(rawStream, encoding);
            }
        }
        catch (Exception fnfe) {
            if (rawStream != null) {
                try {
                    rawStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ResourceNotFoundException("ClasspathResourceLoader problem with template: " + name, fnfe, this.rsvc.getLogContext().getStackTrace());
        }
        if (result == null) {
            String msg = "ClasspathResourceLoader Error: cannot find resource " + name;
            throw new ResourceNotFoundException(msg, null, this.rsvc.getLogContext().getStackTrace());
        }
        return result;
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        return false;
    }

    @Override
    public long getLastModified(Resource resource) {
        return 0L;
    }
}

