/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.loader;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.ResourceNotFoundException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.exception.VelocityException;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.Resource;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.runtime.resource.loader.ResourceLoader;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.velocity.util.ExtProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class FileResourceLoader
extends ResourceLoader {
    private List<String> paths = new ArrayList<String>();
    private Map<String, String> templatePaths = Collections.synchronizedMap(new HashMap());

    @Override
    public void init(ExtProperties configuration) {
        this.log.trace("FileResourceLoader: initialization starting.");
        this.paths.addAll(configuration.getVector("path"));
        ListIterator<String> it = this.paths.listIterator();
        while (it.hasNext()) {
            String path = StringUtils.trim(it.next());
            it.set(path);
            this.log.debug("FileResourceLoader: adding path '{}'", (Object)path);
        }
        this.log.trace("FileResourceLoader: initialization complete.");
    }

    @Override
    public Reader getResourceReader(String templateName, String encoding) throws ResourceNotFoundException {
        if (StringUtils.isEmpty(templateName)) {
            throw new ResourceNotFoundException("Need to specify a file name or file path!");
        }
        for (String path : this.paths) {
            InputStream rawStream = null;
            Reader reader = null;
            try {
                rawStream = this.findTemplate(path, templateName);
                if (rawStream != null) {
                    reader = this.buildReader(rawStream, encoding);
                }
            }
            catch (IOException ioe) {
                this.closeQuiet(rawStream);
                String msg = "Exception while loading Template " + templateName;
                this.log.error(msg, (Throwable)ioe);
                throw new VelocityException(msg, ioe, this.rsvc.getLogContext().getStackTrace());
            }
            if (reader == null) continue;
            this.templatePaths.put(templateName, path);
            return reader;
        }
        throw new ResourceNotFoundException("FileResourceLoader: cannot find " + templateName);
    }

    @Override
    public boolean resourceExists(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (String path : this.paths) {
            try {
                File file = this.getFile(path, name);
                if (!file.canRead()) continue;
                return true;
            }
            catch (Exception ioe) {
                this.log.debug("Exception while checking for template {}", (Object)name);
            }
        }
        return false;
    }

    private InputStream findTemplate(String path, String template) throws IOException {
        try {
            File file = this.getFile(path, template);
            if (file.canRead()) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file.getAbsolutePath());
                    return fis;
                }
                catch (IOException e) {
                    this.closeQuiet(fis);
                    throw e;
                }
            }
            return null;
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    private void closeQuiet(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isSourceModified(Resource resource) {
        boolean modified = true;
        String fileName = resource.getName();
        String path = this.templatePaths.get(fileName);
        File currentFile = null;
        for (int i = 0; currentFile == null && i < this.paths.size(); ++i) {
            String testPath = this.paths.get(i);
            File testFile = this.getFile(testPath, fileName);
            if (!testFile.canRead()) continue;
            currentFile = testFile;
        }
        File file = this.getFile(path, fileName);
        if (currentFile != null && file.exists() && currentFile.equals(file) && file.canRead()) {
            modified = file.lastModified() != resource.getLastModified();
        }
        return modified;
    }

    @Override
    public long getLastModified(Resource resource) {
        String path = this.templatePaths.get(resource.getName());
        File file = this.getFile(path, resource.getName());
        if (file.canRead()) {
            return file.lastModified();
        }
        return 0L;
    }

    private File getFile(String path, String template) {
        File file = null;
        if ("".equals(path)) {
            file = new File(template);
        } else {
            if (template.startsWith("/")) {
                template = template.substring(1);
            }
            file = new File(path, template);
        }
        return file;
    }
}

