/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwk;

import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwk.EllipticCurveJsonWebKey;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwk.JsonWebKey;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwk.OctetKeyPairJsonWebKey;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwk.PublicJsonWebKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SimpleJwkFilter {
    public static boolean OMITTED_OKAY = true;
    public static boolean VALUE_REQUIRED = false;
    private static final String[] EMPTY = new String[2];
    private Criteria kid;
    private MultiValueCriteria kty;
    private Criteria use;
    private Criteria alg;
    private Criteria x5t;
    private Criteria x5tS256;
    private boolean allowThumbsFallbackDeriveFromX5c;
    private MultiValueCriteria keyOps;
    private MultiValueCriteria crv;

    public void setKid(String expectedKid, boolean omittedValueAcceptable) {
        this.kid = new Criteria(expectedKid, omittedValueAcceptable);
    }

    public void setKty(String expectedKty) {
        this.kty = new MultiValueCriteria(new String[]{expectedKty}, false);
    }

    public void setKtys(String[] expectedKtys, boolean omittedValueAcceptable) {
        this.kty = new MultiValueCriteria(expectedKtys, omittedValueAcceptable);
    }

    public void setUse(String expectedUse, boolean omittedValueAcceptable) {
        this.use = new Criteria(expectedUse, omittedValueAcceptable);
    }

    public void setKeyOperations(String[] expectedKeyOps, boolean omittedValueAcceptable) {
        this.keyOps = new MultiValueCriteria(expectedKeyOps, omittedValueAcceptable);
    }

    public void setAlg(String expectedAlg, boolean omittedValueAcceptable) {
        this.alg = new Criteria(expectedAlg, omittedValueAcceptable);
    }

    public void setX5t(String expectedThumb, boolean omittedValueAcceptable) {
        this.x5t = new Criteria(expectedThumb, omittedValueAcceptable);
    }

    public void setX5tS256(String expectedThumb, boolean omittedValueAcceptable) {
        this.x5tS256 = new Criteria(expectedThumb, omittedValueAcceptable);
    }

    public void setAllowFallbackDeriveFromX5cForX5Thumbs(boolean allow) {
        this.allowThumbsFallbackDeriveFromX5c = allow;
    }

    public void setCrv(String expectedCrv, boolean omittedValueAcceptable) {
        this.crv = new MultiValueCriteria(new String[]{expectedCrv}, omittedValueAcceptable);
    }

    public void setCrvs(String[] expectedCrvs, boolean omittedValueAcceptable) {
        this.crv = new MultiValueCriteria(expectedCrvs, omittedValueAcceptable);
    }

    public List<JsonWebKey> filter(Collection<JsonWebKey> jsonWebKeys) {
        ArrayList<JsonWebKey> filtered = new ArrayList<JsonWebKey>();
        for (JsonWebKey jwk : jsonWebKeys) {
            boolean match = this.isMatch(this.kid, jwk.getKeyId());
            match &= this.kty == null || this.kty.meetsCriteria(jwk.getKeyType());
            match &= this.isMatch(this.use, jwk.getUse());
            match &= this.isMatch(this.alg, jwk.getAlgorithm());
            String[] thumbs = this.getThumbs(jwk, this.allowThumbsFallbackDeriveFromX5c);
            match &= this.isMatch(this.x5t, thumbs[0]);
            match &= this.isMatch(this.x5tS256, thumbs[1]);
            match &= this.crv == null || this.crv.meetsCriteria(this.getCrv(jwk));
            if (!(match &= this.keyOps == null || this.keyOps.meetsCriteria(jwk.getKeyOps()))) continue;
            filtered.add(jwk);
        }
        return filtered;
    }

    boolean isMatch(Criteria criteria, String value) {
        return criteria == null || criteria.meetsCriteria(value);
    }

    String getCrv(JsonWebKey jwk) {
        if (jwk instanceof EllipticCurveJsonWebKey) {
            return ((EllipticCurveJsonWebKey)jwk).getCurveName();
        }
        if (jwk instanceof OctetKeyPairJsonWebKey) {
            return ((OctetKeyPairJsonWebKey)jwk).getSubtype();
        }
        return null;
    }

    String[] getThumbs(JsonWebKey jwk, boolean allowFallbackDeriveFromX5c) {
        if (this.x5t == null && this.x5tS256 == null) {
            return EMPTY;
        }
        if (jwk instanceof PublicJsonWebKey) {
            PublicJsonWebKey publicJwk = (PublicJsonWebKey)jwk;
            String x5t = publicJwk.getX509CertificateSha1Thumbprint(allowFallbackDeriveFromX5c);
            String x5tS256 = publicJwk.getX509CertificateSha256Thumbprint(allowFallbackDeriveFromX5c);
            return new String[]{x5t, x5tS256};
        }
        return EMPTY;
    }

    private static class Criteria {
        String value;
        boolean noValueOk;

        private Criteria(String value, boolean noValueOk) {
            this.value = value;
            this.noValueOk = noValueOk;
        }

        public boolean meetsCriteria(String value) {
            if (value == null) {
                return this.noValueOk;
            }
            return value.equals(this.value);
        }
    }

    private static class MultiValueCriteria {
        String[] values;
        boolean noValueOk;

        private MultiValueCriteria(String[] values, boolean noValueOk) {
            this.values = values;
            this.noValueOk = noValueOk;
        }

        public boolean meetsCriteria(String value) {
            return this.meetsCriteria(Collections.singletonList(value));
        }

        public boolean meetsCriteria(List<String> values) {
            if (values == null) {
                return this.noValueOk;
            }
            for (String value : this.values) {
                if (!values.contains(value)) continue;
                return true;
            }
            return false;
        }
    }
}

