/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer;

import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.ErrorCodeValidator;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtContext;
import java.util.Collections;
import java.util.List;

public class InvalidJwtException
extends Exception {
    private List<ErrorCodeValidator.Error> details = Collections.emptyList();
    private JwtContext jwtContext;

    public InvalidJwtException(String message, List<ErrorCodeValidator.Error> details, JwtContext jwtContext) {
        super(message);
        this.details = details;
        this.jwtContext = jwtContext;
    }

    public InvalidJwtException(String message, ErrorCodeValidator.Error detail, Throwable cause, JwtContext jwtContext) {
        super(message, cause);
        this.jwtContext = jwtContext;
        this.details = Collections.singletonList(detail);
    }

    public boolean hasErrorCode(int code) {
        for (ErrorCodeValidator.Error error : this.details) {
            if (code != error.getErrorCode()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExpired() {
        return this.hasErrorCode(1);
    }

    public List<ErrorCodeValidator.Error> getErrorDetails() {
        return this.details;
    }

    public JwtContext getJwtContext() {
        return this.jwtContext;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessage());
        if (!this.details.isEmpty()) {
            sb.append(" Additional details: ");
            sb.append(this.details);
        }
        return sb.toString();
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }
}

