/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.handler.ManagementApiResponseHandler;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ApplicationSecretResponse;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaAdapterConfiguration;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretProvider;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import java.io.IOException;
import org.sourceid.saml20.adapter.conf.Configuration;

public class DefaultAppSecretProvider
implements AppSecretProvider {
    private final Configuration configuration;
    private final TokenService tokenService;
    private final WorkerApiClient workerApiClient;

    public DefaultAppSecretProvider(Configuration configuration, TokenService tokenService, WorkerApiClient workerApiClient) {
        this.configuration = configuration;
        this.tokenService = tokenService;
        this.workerApiClient = workerApiClient;
    }

    @Override
    public String getAppSecret(String appId) throws AccessTokenProviderException, IOException {
        if (PingOneMfaAdapterConfiguration.PingOneEnvironmentField.isConfigured(this.configuration) && this.tokenService != null && this.workerApiClient != null) {
            String token = this.tokenService.getToken();
            return this.workerApiClient.getApplicationSecret(new ManagementApiResponseHandler<ApplicationSecretResponse>(ApplicationSecretResponse.class), token, appId).getSecret();
        }
        return PingOneMfaAdapterConfiguration.EndUserClientSecretField.getEndUserClientSecret(this.configuration);
    }
}

