/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.access.BaseUrlAccessor;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class DomainInfoUtil {
    public static String getBaseUrlFromRequest(Map<String, Object> params, HttpServletRequest req) {
        String currentBaseUrl = null;
        try {
            currentBaseUrl = BaseUrlAccessor.getCurrentBaseUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(currentBaseUrl)) {
            currentBaseUrl = (String)params.get("com.pingidentity.adapter.input.parameter.current.server.base.url");
        }
        if (StringUtils.isBlank(currentBaseUrl)) {
            currentBaseUrl = (String)params.get("com.pingidentity.adapter.input.parameter.server.base.url");
        }
        StringBuilder baseUrl = null;
        if (StringUtils.isNotBlank(currentBaseUrl)) {
            if (StringUtils.countMatches((CharSequence)currentBaseUrl, "/") > 2) {
                currentBaseUrl = currentBaseUrl.substring(0, StringUtils.ordinalIndexOf(currentBaseUrl, "/", 3));
            }
            baseUrl = new StringBuilder(currentBaseUrl);
        } else {
            String scheme = req.getScheme();
            String host = req.getServerName();
            int port = req.getServerPort();
            baseUrl = new StringBuilder(scheme).append("://").append(host);
            if ("http".equalsIgnoreCase(scheme) && port != 80 || "https".equalsIgnoreCase(scheme) && port != 443) {
                baseUrl.append(":").append(port);
            }
        }
        return baseUrl.toString();
    }

    public static String getOriginDomain(HttpServletRequest req) {
        String clientBaseUrl = null;
        Enumeration headerNames = req.getHeaderNames();
        if (headerNames == null) {
            return null;
        }
        while (headerNames.hasMoreElements()) {
            String header = (String)headerNames.nextElement();
            if (!header.equalsIgnoreCase("Origin")) continue;
            clientBaseUrl = req.getHeader(header);
            break;
        }
        if (StringUtils.isBlank(clientBaseUrl)) {
            return null;
        }
        String httpSchemePrefix = "http://";
        String httpsSchemePrefix = "https://";
        if (clientBaseUrl.startsWith(httpsSchemePrefix)) {
            String urlWithoutPrefix = clientBaseUrl.substring(httpSchemePrefix.length());
            clientBaseUrl = urlWithoutPrefix.contains(":") ? clientBaseUrl.substring(httpsSchemePrefix.length(), clientBaseUrl.lastIndexOf(58)) : clientBaseUrl.substring(httpsSchemePrefix.length());
        } else if (clientBaseUrl.startsWith(httpSchemePrefix)) {
            String urlWithoutPrefix = clientBaseUrl.substring(httpSchemePrefix.length());
            clientBaseUrl = urlWithoutPrefix.contains(":") ? clientBaseUrl.substring(httpSchemePrefix.length(), clientBaseUrl.lastIndexOf(58)) : clientBaseUrl.substring(httpSchemePrefix.length());
        }
        if (clientBaseUrl.contains("/")) {
            clientBaseUrl = clientBaseUrl.substring(0, clientBaseUrl.indexOf("/"));
        }
        return clientBaseUrl;
    }

    public static String getCurrentDomain(Map<String, Object> inParameters, HttpServletRequest req) {
        String currentBaseUrl = null;
        try {
            currentBaseUrl = BaseUrlAccessor.getCurrentBaseUrl();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String httpSchemePrefix = "http://";
        String httpsSchemePrefix = "https://";
        if (StringUtils.isBlank(currentBaseUrl) && StringUtils.isBlank(currentBaseUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.current.server.base.url"))) {
            currentBaseUrl = (String)inParameters.get("com.pingidentity.adapter.input.parameter.server.base.url");
        }
        if (currentBaseUrl.startsWith(httpsSchemePrefix)) {
            String urlWithoutPrefix = currentBaseUrl.substring(httpSchemePrefix.length());
            currentBaseUrl = urlWithoutPrefix.contains(":") ? currentBaseUrl.substring(httpsSchemePrefix.length(), currentBaseUrl.lastIndexOf(58)) : currentBaseUrl.substring(httpsSchemePrefix.length());
        } else if (currentBaseUrl.startsWith(httpSchemePrefix)) {
            String urlWithoutPrefix = currentBaseUrl.substring(httpSchemePrefix.length());
            currentBaseUrl = urlWithoutPrefix.contains(":") ? currentBaseUrl.substring(httpSchemePrefix.length(), currentBaseUrl.lastIndexOf(58)) : currentBaseUrl.substring(httpSchemePrefix.length());
        }
        if (currentBaseUrl.contains("/")) {
            currentBaseUrl = currentBaseUrl.substring(0, currentBaseUrl.indexOf("/"));
        }
        return currentBaseUrl;
    }
}

