/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwk.HttpsJwks;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtConsumer;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtConsumerBuilder;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.keys.resolvers.HttpsJwksVerificationKeyResolver;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class IdToken {
    private final String idToken;
    private JwtClaims jwtClaims;

    public IdToken(String idToken) throws InvalidJwtException {
        this.idToken = idToken;
        this.setJwtClaims();
    }

    public IdToken(String idToken, String jwksUrl, String expectedIssuer, String expectedAudience) throws InvalidJwtException {
        this.idToken = idToken;
        this.setJwtClaims(jwksUrl, expectedIssuer, expectedAudience);
    }

    public PingOneEnrollment getP1Enrollment() throws IOException, MalformedClaimException {
        ObjectMapper objectMapper = ObjectMappers.getDefault();
        String p1EnrollmentString = objectMapper.writeValueAsString(this.jwtClaims.getClaimValue("p1.enrollment", Map.class));
        if (StringUtils.isNotBlank(p1EnrollmentString)) {
            return ObjectMappers.getDefault().readValue(p1EnrollmentString, PingOneEnrollment.class);
        }
        return null;
    }

    public List<String> getAmr() {
        return (List)this.jwtClaims.getClaimValue("amr");
    }

    public void setJwtClaims() throws InvalidJwtException {
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipSignatureVerification().build();
        this.jwtClaims = jwtConsumer.processToClaims(this.idToken);
    }

    private void setJwtClaims(String jwksUrl, String expectedIssuer, String expectedAudience) throws InvalidJwtException {
        HttpsJwks httpsJwks = new HttpsJwks(jwksUrl);
        HttpsJwksVerificationKeyResolver verificationKeyResolver = new HttpsJwksVerificationKeyResolver(httpsJwks);
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setRequireSubject().setExpectedIssuer(expectedIssuer).setExpectedAudience(expectedAudience).setVerificationKeyResolver(verificationKeyResolver).build();
        this.jwtClaims = jwtConsumer.processToClaims(this.idToken);
    }

    public static enum AmrValues {
        SWK,
        EMAIL,
        SMS,
        TEL,
        OTP,
        USER,
        EXTRA_VERIFICATION,
        MCA,
        MFA,
        FIDO;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class PingOneEnrollment {
        private String pairingKey;
        private String pairingKeyId;
        private String status;
        private String serverPayload;

        public String getPairingKey() {
            return this.pairingKey;
        }

        public void setPairingKey(String pairingKey) {
            this.pairingKey = pairingKey;
        }

        public String getPairingKeyId() {
            return this.pairingKeyId;
        }

        public void setPairingKeyId(String pairingKeyId) {
            this.pairingKeyId = pairingKeyId;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getServerPayload() {
            return this.serverPayload;
        }

        public void setServerPayload(String serverPayload) {
            this.serverPayload = serverPayload;
        }
    }
}

