/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class InParamsUtil {
    private InParamsUtil() {
    }

    public static String getUsername(Map<String, Object> inParams, String usernameAttribute) {
        Map chainedAttributes = (Map)inParams.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (StringUtils.isNotEmpty(usernameAttribute) && chainedAttributes != null) {
            return chainedAttributes.entrySet().stream().filter(it -> usernameAttribute.equals(it.getKey())).map(it -> ((AttributeValue)it.getValue()).getValue()).findFirst().orElse(null);
        }
        return null;
    }

    public static Optional<String> getUsePasswordConfigAttribute(Map<String, Object> inParams, String usePasswordConfigAttribute) {
        Map chainedAttributes = (Map)inParams.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (StringUtils.isNotEmpty(usePasswordConfigAttribute) && chainedAttributes != null) {
            return chainedAttributes.entrySet().stream().filter(it -> usePasswordConfigAttribute.equals(it.getKey())).map(it -> ((AttributeValue)it.getValue()).getValue()).findFirst();
        }
        return Optional.empty();
    }

    public static Optional<String> getBypassDeviceMFABeforeDeviceMgmtAttribute(Map<String, Object> inParams, String bypassDeviceMFABeforeDeviceMgmtAttribute) {
        Map chainedAttributes = (Map)inParams.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (StringUtils.isNotEmpty(bypassDeviceMFABeforeDeviceMgmtAttribute) && chainedAttributes != null) {
            return chainedAttributes.entrySet().stream().filter(it -> bypassDeviceMFABeforeDeviceMgmtAttribute.equals(it.getKey())).map(it -> ((AttributeValue)it.getValue()).getValue()).findFirst();
        }
        return Optional.empty();
    }

    public static boolean isUserIdAuthenticated(Map<String, Object> inParams) {
        boolean userIdAuthenticated = true;
        if (inParams.containsKey("com.pingidentity.adapter.input.parameter.userid.authenticated")) {
            userIdAuthenticated = (Boolean)inParams.get("com.pingidentity.adapter.input.parameter.userid.authenticated");
        }
        return userIdAuthenticated;
    }

    public static List<String> getAttributeFromChainedByPrefix(Map<String, Object> inParams, String attributePrefix) {
        Map chainedAttributes = (Map)inParams.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (chainedAttributes != null) {
            return chainedAttributes.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith(attributePrefix)).sorted((a, b) -> {
                Comparator comparator = Map.Entry.comparingByKey(Comparator.naturalOrder());
                return comparator.compare(a, b);
            }).map(it -> ((AttributeValue)it.getValue()).getValuesAsCollection()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

