/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.locale.LocaleUtil;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class LanguagePackMessagesSupport {
    public String pingoneMfaAdapterMessages;
    public String authnApiMessages = "authn-api-messages";

    public LanguagePackMessagesSupport(String messageProperties) {
        this.pingoneMfaAdapterMessages = messageProperties;
    }

    public String getPingOneMfaAdapterMessage(HttpServletRequest req, String key) {
        return this.getMessage(req, this.pingoneMfaAdapterMessages, key);
    }

    public String getPingOneMfaAdapterMessage(HttpServletRequest req, String key, String ... substitutions) {
        return this.getMessage(req, this.pingoneMfaAdapterMessages, key, substitutions);
    }

    public String getAuthnApiMessage(HttpServletRequest req, String key) {
        return this.getMessage(req, this.authnApiMessages, key);
    }

    public String getMessage(HttpServletRequest req, String resourceBundleBaseName, String key) {
        return this.getMessage(req, resourceBundleBaseName, key, null);
    }

    private String getMessage(HttpServletRequest req, String resourceBundleBaseName, String key, String ... substitutions) {
        LanguagePackMessages lpm = this.getLanguagePackMessages(req, resourceBundleBaseName);
        String message = lpm.getMessage(key, substitutions);
        if (message == null) {
            message = key;
        }
        return message;
    }

    public LanguagePackMessages getPingOneMfaAdapterMessages(HttpServletRequest req) {
        Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)req);
        return new LanguagePackMessages(this.pingoneMfaAdapterMessages, userLocale);
    }

    public LanguagePackMessages getLanguagePackMessages(HttpServletRequest req, String resourceBundleBaseName) {
        Locale userLocale = LocaleUtil.getUserLocale((HttpServletRequest)req);
        return new LanguagePackMessages(resourceBundleBaseName, userLocale);
    }
}

