/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.lang.JoseException;
import java.nio.charset.StandardCharsets;

public class LoginHintTokenUtil {
    public static String generateLoginHintToken(String authPath, String clientId, String clientSecret, String envId, String subject) throws JoseException {
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setIssuer(clientId);
        jwtClaims.setSubject(subject);
        jwtClaims.setAudience(authPath + "/" + envId + "/as");
        jwtClaims.setIssuedAtToNow();
        jwtClaims.setExpirationTimeMinutesInTheFuture(5.0f);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(jwtClaims.toJson());
        jws.setKey(new HmacKey(clientSecret.getBytes(StandardCharsets.UTF_8)));
        jws.setAlgorithmHeaderValue("HS256");
        return jws.getCompactSerialization();
    }
}

