/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.api.client.flows.FlowsApiClient;
import com.pingidentity.adapters.pingone.mfa.api.client.worker.WorkerApiClient;
import com.pingidentity.adapters.pingone.mfa.api.handler.ManagementApiResponseHandler;
import com.pingidentity.adapters.pingone.mfa.api.model.ApiErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.applications.Application;
import com.pingidentity.adapters.pingone.mfa.api.model.flows.Status;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.DeviceAuthenticationPolicy;
import com.pingidentity.adapters.pingone.mfa.api.model.policies.OfflineDeviceAvailableMethod;
import com.pingidentity.adapters.pingone.mfa.api.model.request.ActivateDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckAssertionRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckOtpRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CheckUsernameRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CustomChallenge;
import com.pingidentity.adapters.pingone.mfa.api.model.request.DeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.EmailDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.Notification;
import com.pingidentity.adapters.pingone.mfa.api.model.request.OfflineDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.PairingKeyRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.SelectDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.SetDeviceOrderRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.SmsDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.TOTPDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.UserRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.VoiceDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.WebAuthnDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.WhatsAppDeviceRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.ClientContext;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.CreateAuthenticationCodesRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.LifeTime;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.CreateDeviceAuthenticationRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDeviceInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.request.onetimedeviceotpflow.OneTimeDevicesInfo;
import com.pingidentity.adapters.pingone.mfa.api.model.request.usernamelessauth.UsernamelessAuthCreateRequest;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AssertionRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthSession;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthenticationCodesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.AuthorizeResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CommonFlowResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CompletedResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CreateOneTimeDeviceAuthenticationRequestResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.CreateUsernamelessAuthenticationResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.DeviceSelectionRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.EmbeddedResources;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorDetail;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ErrorResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FailedResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowError;
import com.pingidentity.adapters.pingone.mfa.api.model.response.FlowResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.InnerError;
import com.pingidentity.adapters.pingone.mfa.api.model.response.MFASettingsResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.OtpRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.PairingKey;
import com.pingidentity.adapters.pingone.mfa.api.model.response.PushConfirmationRequiredResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.PushConfirmationTimedOutResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UnavailableDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UnavailableLockedDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UserDevicesResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.UsernamelessAuthAssertionCheckRequestResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.response.ValidateOneTimeDeviceAuthenticationRequestResponse;
import com.pingidentity.adapters.pingone.mfa.api.model.users.User;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.MobileDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.OfflineDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.TOTPDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Test;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.FIDO2Device;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PlatformDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.PublicKeyCredentialRequestOptions;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.SecurityKeyDevice;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.fido.WebAuthnDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.ActionSpec;
import com.pingidentity.adapters.pingone.mfa.authn.api.ActivateOfflineDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.ActivateWebAuthnDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.CheckAssertion;
import com.pingidentity.adapters.pingone.mfa.authn.api.ContinueBiometricDeviceAuthentication;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomAuthenticate;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomAuthnErrorDetail;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomPushConfirmationRejected;
import com.pingidentity.adapters.pingone.mfa.authn.api.CustomSelectDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.Device;
import com.pingidentity.adapters.pingone.mfa.authn.api.DevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.ErrorDetailSpec;
import com.pingidentity.adapters.pingone.mfa.authn.api.Lock;
import com.pingidentity.adapters.pingone.mfa.authn.api.MobileDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.Nickname;
import com.pingidentity.adapters.pingone.mfa.authn.api.OfflineDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.PingOneMfaAuthnApiSupport;
import com.pingidentity.adapters.pingone.mfa.authn.api.RemoveDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.SelectDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.authn.api.SetDefaultDevice;
import com.pingidentity.adapters.pingone.mfa.authn.api.StateSpec;
import com.pingidentity.adapters.pingone.mfa.authn.api.SubmitEmailTarget;
import com.pingidentity.adapters.pingone.mfa.authn.api.SubmitOfflineDeviceTarget;
import com.pingidentity.adapters.pingone.mfa.authn.api.SubmitPhoneDeviceTarget;
import com.pingidentity.adapters.pingone.mfa.authn.api.WebAuthnDevicePairingMethod;
import com.pingidentity.adapters.pingone.mfa.config.CoreContract;
import com.pingidentity.adapters.pingone.mfa.config.OverwriteAuthenticationMethodsConfig;
import com.pingidentity.adapters.pingone.mfa.config.PingIdSdkMfaStatus;
import com.pingidentity.adapters.pingone.mfa.config.PingOneMfaStatus;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.exception.ApiResponseException;
import com.pingidentity.adapters.pingone.mfa.exception.InvalidActionException;
import com.pingidentity.adapters.pingone.mfa.exception.ObsoleteDeviceException;
import com.pingidentity.adapters.pingone.mfa.exception.RateLimitApiResponseException;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.DynamicData;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.tuple.Pair;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.Log;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.LogFactory;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.entity.ContentType;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.mfa.template.PingOneMfaTemplateSupport;
import com.pingidentity.adapters.pingone.mfa.template.TemplateParameter;
import com.pingidentity.adapters.pingone.mfa.util.AccountRecoveryFlowUtil;
import com.pingidentity.adapters.pingone.mfa.util.AppSecretCache;
import com.pingidentity.adapters.pingone.mfa.util.AuditLogger;
import com.pingidentity.adapters.pingone.mfa.util.DeviceDetails;
import com.pingidentity.adapters.pingone.mfa.util.DevicePairingMethods;
import com.pingidentity.adapters.pingone.mfa.util.DeviceSnapshot;
import com.pingidentity.adapters.pingone.mfa.util.DevicesSnapShotList;
import com.pingidentity.adapters.pingone.mfa.util.DomainInfoUtil;
import com.pingidentity.adapters.pingone.mfa.util.ErrorResponseUtil;
import com.pingidentity.adapters.pingone.mfa.util.IdToken;
import com.pingidentity.adapters.pingone.mfa.util.InParamsUtil;
import com.pingidentity.adapters.pingone.mfa.util.LanguagePackMessagesSupport;
import com.pingidentity.adapters.pingone.mfa.util.LoginHintTokenUtil;
import com.pingidentity.adapters.pingone.mfa.util.MfaFailed;
import com.pingidentity.adapters.pingone.mfa.util.ModelMapperUtil;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import com.pingidentity.adapters.pingone.mfa.util.PingOneMfaStateSupport;
import com.pingidentity.adapters.pingone.mfa.util.PollingRequestResponse;
import com.pingidentity.adapters.pingone.mfa.util.RequestParamUtil;
import com.pingidentity.adapters.pingone.mfa.util.StatusMapping;
import com.pingidentity.adapters.pingone.mfa.util.TrackerCookieData;
import com.pingidentity.adapters.pingone.mfa.util.TrackerCookieInfo;
import com.pingidentity.adapters.pingone.mfa.util.TrackerCookieObfuscator;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.TokenService;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.api.authn.common.CommonErrorDetailSpec;
import com.pingidentity.sdk.api.authn.common.CommonErrorSpec;
import com.pingidentity.sdk.api.authn.common.CommonStateSpec;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.model.AuthnError;
import com.pingidentity.sdk.api.authn.model.AuthnErrorDetail;
import com.pingidentity.sdk.api.authn.model.ResourceRef;
import com.pingidentity.sdk.api.authn.model.action.CheckOtp;
import com.pingidentity.sdk.api.authn.model.action.SelectDevice;
import com.pingidentity.sdk.api.authn.spec.AuthnErrorDetailSpec;
import com.pingidentity.sdk.api.authn.spec.AuthnErrorSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.api.authn.util.ParamMapping;
import com.pingidentity.sdk.locale.LocaleUtil;
import com.pingidentity.sdk.template.TemplateRendererUtilException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;

public class PingOneMfaHandler {
    public static final String PROMPT_QUERY_PARAM = "prompt";
    public static String SMS_DEVICE_BASE_NICKNAME = "SMS Number ";
    public static String VOICE_DEVICE_BASE_NICKNAME = "Voice Number ";
    public static String EMAIL_DEVICE_BASE_NICKNAME = "Email ";
    public static String WHATSAPP_DEVICE_BASE_NICKNAME = "WhatsApp ";
    private static final ParamMapping<CheckOtp, String> OTP_PARAM_MAPPING = new ParamMapping(TemplateParameter.OTP.toString(), CheckOtp.class, CheckOtp::getOtp, Function.identity());
    private static final ParamMapping<CheckAssertion, String> ASSERTION_PARAM_MAPPING = new ParamMapping(TemplateParameter.ASSERTION.toString(), CheckAssertion.class, CheckAssertion::getAssertion, Function.identity());
    private static final ParamMapping<CheckAssertion, String> COMPATIBILITY_PARAM_MAPPING = new ParamMapping(TemplateParameter.COMPATIBILITY.toString(), CheckAssertion.class, CheckAssertion::getCompatibility, Function.identity());
    private static final ParamMapping<CheckAssertion, String> ORIGIN_PARAM_MAPPING = new ParamMapping(TemplateParameter.ORIGIN.toString(), CheckAssertion.class, CheckAssertion::getOrigin, Function.identity());
    private static final ParamMapping<SelectDevicePairingMethod, DevicePairingMethod> DEVICE_PAIRING_METHOD_PARAM_MAPPING = new ParamMapping(TemplateParameter.SELECT_DEVICE_PAIRING_METHOD.toString(), SelectDevicePairingMethod.class, SelectDevicePairingMethod::getDevicePairingMethod, devicePairingMethodStr -> {
        DevicePairingMethod devicePairingMethod = null;
        String[] devicePairingMethodParts = devicePairingMethodStr.split("\\.");
        Device.Type deviceType = Device.Type.fromName(devicePairingMethodParts[0]);
        switch (deviceType) {
            case ANDROID: 
            case IPHONE: {
                break;
            }
            case MOBILE: {
                devicePairingMethod = DevicePairingMethods.mobile(devicePairingMethodParts[1]);
                break;
            }
            default: {
                devicePairingMethod = DevicePairingMethods.getDeviceParingMethod(devicePairingMethodParts[0]);
            }
        }
        return devicePairingMethod;
    });
    private static final ParamMapping<ActivateWebAuthnDevice, String> ACTIVATE_WEBAUTHN_DEVICE_PARAM_MAPPING = new ParamMapping(TemplateParameter.WEBAUTHN_DEVICE_ATTESTATION.toString(), ActivateWebAuthnDevice.class, ActivateWebAuthnDevice::getAttestation, Function.identity());
    private static final ParamMapping<ActivateWebAuthnDevice, String> ACTIVATE_WEBAUTHN_DEVICE_ORIGIN_PARAM_MAPPING = new ParamMapping(TemplateParameter.ORIGIN.toString(), ActivateWebAuthnDevice.class, ActivateWebAuthnDevice::getOrigin, Function.identity());
    private static final ParamMapping<ContinueBiometricDeviceAuthentication, String> CONTINUE_BIOMETRIC_DEVICE_AUTHENTICATION_ORIGIN_PARAM_MAPPING = new ParamMapping(TemplateParameter.ORIGIN.toString(), ContinueBiometricDeviceAuthentication.class, ContinueBiometricDeviceAuthentication::getOrigin, Function.identity());
    private static final Map<String, MfaFailed> MFA_FAILED_MAP;
    private static final List<String> PAIRING_OFFLINE_STATUSES;
    private static final List<String> ACTIVATION_OFFLINE_STATUSES;
    private final AuthnApiSupport authnApiSupport = AuthnApiSupport.getDefault();
    private final String authPath;
    private final String envId;
    private final String applicationId;
    private final String authenticationPolicy;
    private String registrationPolicy;
    private final FlowsApiClient flowsApiClient;
    private final WorkerApiClient workerApiClient;
    private final TokenService tokenService;
    private final PingOneMfaTemplateSupport pingOneMfaTemplateSupport;
    private final PingOneMfaAuthnApiSupport pingOneMfaAuthnApiSupport;
    private final AppSecretCache appSecretCache;
    private final boolean showSuccessScreen;
    private final boolean showErrorScreen;
    private final boolean showTimeoutScreen;
    private final boolean apiFailureBypass;
    private final boolean invalidUserBypass;
    private final boolean changeDeviceAllowed;
    private final boolean allowSetupMfa;
    private final boolean isCookieTrackingEnabled;
    private final boolean allowSkipMfa;
    private final boolean allowDeviceManagement;
    private final boolean provisionUser;
    private final boolean provisionAuthenticationMethods;
    private final boolean updateAuthenticationMethods;
    private final OverwriteAuthenticationMethodsConfig overwriteAuthenticationMethodsConfiguration;
    private boolean automaticAuthCodeRefreshEnabled;
    private final String smsAttribute;
    private final String voiceAttribute;
    private final String emailAttribute;
    private final String whatsAppAttribute;
    private final String usernameAttribute;
    private final String defaultDeviceType;
    private final String notificationTemplateVariantOverride;
    private final String applicationIdForQRFlow;
    private final String populationId;
    private boolean allowOnlyPredefineValuesForPhoneOrEmailDevices;
    private static final Log log;
    private static final IntegrationsLogger LOG;
    private AuditLogger auditLogger;
    private static final Map<String, String> DAILY_LIMIT_EXCEEDED_ERROR_MESSAGE_KEY_MAP;
    private static final Map<Device.Type, MfaFailed> DAILY_LIMIT_EXCEEDED_MFA_FAILED_MAP;

    public boolean isBrowserIncompatibileForFIDOAuthFlow(HttpServletRequest req) {
        String compatibility = (String)COMPATIBILITY_PARAM_MAPPING.getValue(req);
        return "NONE".equalsIgnoreCase(compatibility);
    }

    private PingOneMfaHandler(Builder builder) {
        this.authPath = builder.authPath;
        this.envId = builder.envId;
        this.applicationId = builder.applicationId;
        this.authenticationPolicy = builder.authenticationPolicy;
        this.registrationPolicy = builder.registrationPolicy;
        this.flowsApiClient = builder.flowsApiClient;
        this.workerApiClient = builder.workerApiClient;
        this.tokenService = builder.tokenService;
        this.showSuccessScreen = builder.showSuccessScreen;
        this.showErrorScreen = builder.showErrorScreen;
        this.showTimeoutScreen = builder.showTimeoutScreen;
        this.pingOneMfaTemplateSupport = builder.pingOneMfaTemplateSupport;
        this.pingOneMfaAuthnApiSupport = builder.pingOneMfaAuthnApiSupport;
        this.appSecretCache = builder.appSecretCache;
        this.apiFailureBypass = builder.apiFailureBypass;
        this.invalidUserBypass = builder.invalidUserBypass;
        this.changeDeviceAllowed = builder.changeDeviceAllowed;
        this.allowSetupMfa = builder.allowSetupMfa;
        this.allowSkipMfa = builder.allowSkipMfa;
        this.allowDeviceManagement = builder.allowMgtDevices;
        this.provisionUser = builder.provisionUser;
        this.automaticAuthCodeRefreshEnabled = builder.automaticAuthCodeRefreshEnabled;
        this.auditLogger = new AuditLogger(builder.auditLoggingEnabled);
        this.provisionAuthenticationMethods = builder.provisionAuthenticationMethods;
        this.updateAuthenticationMethods = builder.updateAuthenticationMethods;
        this.overwriteAuthenticationMethodsConfiguration = builder.overrideAuthenticationMethodConfiguration;
        this.smsAttribute = builder.smsAttribute;
        this.voiceAttribute = builder.voiceAttribute;
        this.emailAttribute = builder.emailAttribute;
        this.whatsAppAttribute = builder.whatsAppAttribute;
        this.usernameAttribute = builder.usernameAttribute;
        this.defaultDeviceType = builder.defaultDeviceType;
        this.isCookieTrackingEnabled = builder.isCookieTrackingEnabled;
        this.notificationTemplateVariantOverride = builder.notificationTemplateVariantOverride;
        this.applicationIdForQRFlow = builder.applicationIdForQRFlow;
        this.allowOnlyPredefineValuesForPhoneOrEmailDevices = builder.allowOnlyPredefineValuesForPhoneOrEmailDevices;
        this.populationId = builder.populationId;
        this.replaceRegistrationPolicyNameToId(this.tokenService, this.workerApiClient, this.registrationPolicy);
    }

    private void replaceRegistrationPolicyNameToId(TokenService tokenService, WorkerApiClient workerApiClient, String registrationPolicyName) {
        List<DeviceAuthenticationPolicy> allMFAPolicies;
        if (StringUtils.isBlank(registrationPolicyName)) {
            return;
        }
        try {
            String accessToken = tokenService.getToken();
            allMFAPolicies = workerApiClient.getAllMFAPolicies(accessToken);
        }
        catch (AccessTokenProviderException e) {
            log.error("an error to get token is avoiding the instantiate handler to handle pingOne requests");
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error("an error to get your pingOne MFA policies is avoiding the instantiate handler to handle pingOne requests");
            throw new RuntimeException(e);
        }
        if (allMFAPolicies.stream().anyMatch(mfaPolicy -> mfaPolicy.getName().equals(registrationPolicyName))) {
            this.registrationPolicy = allMFAPolicies.stream().filter(mfaPolicy -> mfaPolicy.getName().equals(registrationPolicyName)).findAny().get().getId().toString();
        }
    }

    public AuthnAdapterResponse handleAuthenticateRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, boolean fidoCookieReceived) throws AuthnErrorException, IOException, JoseException, AccessTokenProviderException {
        OneTimeDevicesInfo oneTimeDevicesInfo;
        Map chainedAttributes;
        boolean shouldSupportOnetimeDeviceFlow;
        if (this.updateAuthenticationMethods && !AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
            this.updateAuthenticationMethods(inParameters);
        }
        boolean bl = shouldSupportOnetimeDeviceFlow = (chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes")) != null && chainedAttributes.get("support-one-time-device-otp") != null && "true".equalsIgnoreCase(((AttributeValue)chainedAttributes.get("support-one-time-device-otp")).getValue()) && StringUtils.isBlank(stateSupport.getPreviousPfStatus());
        if (shouldSupportOnetimeDeviceFlow && !(oneTimeDevicesInfo = this.getOneTimeDevicesInfoObject(inParameters)).getDevices().isEmpty()) {
            try {
                String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
                User pingOneUser = this.getUserByIdOrName(username);
                if (pingOneUser != null) {
                    stateSupport.setUser(ModelMapperUtil.map(pingOneUser));
                    return this.initiateOneTimeDeviceOTPAuthenticationFlow(req, resp, inParameters, oneTimeDevicesInfo, stateSupport);
                }
            }
            catch (AuthnErrorException e) {
                return this.handleAuthnErrorException(req, resp, e);
            }
            catch (AccessTokenProviderException | InvalidActionException | JoseException | AuthnAdapterException e) {
                LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
                return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
            }
        }
        try {
            FlowResponse flowResponse = this.initiateFlow(req, inParameters, stateSupport);
            String initFlowResponseStatus = flowResponse.getStatus();
            boolean isDeviceAbsent = true;
            if (Status.OTP_REQUIRED.toString().equals(initFlowResponseStatus) || Status.ASSERTION_REQUIRED.toString().equals(initFlowResponseStatus) || Status.DEVICE_SELECTION_REQUIRED.toString().equals(initFlowResponseStatus) || Status.PUSH_CONFIRMATION_REQUIRED.toString().equals(initFlowResponseStatus)) {
                String trackerCookieData;
                List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> devices = ((CommonFlowResponse)flowResponse).getEmbeddedResources().getDevices();
                stateSupport.setIsFidoAggregationEnabled(((CommonFlowResponse)flowResponse).isAggregateFido2Devices());
                if (!Status.DEVICE_SELECTION_REQUIRED.toString().equals(initFlowResponseStatus)) {
                    String auditMessagePrefix = "P1 MFA device was selected for authentication. Device Type: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getType() + " Device Nickname: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getNickname();
                    this.auditLogger.auditLog(auditMessagePrefix, req);
                }
                if (fidoCookieReceived && StringUtils.isNotBlank(trackerCookieData = this.getTrackerCookieData(req))) {
                    DeviceDetails cookieDeviceDetails = this.getTrackerCookieData(trackerCookieData);
                    for (com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device currentDevice : devices) {
                        if (!currentDevice.getId().equals(cookieDeviceDetails.getDeviceId())) continue;
                        isDeviceAbsent = false;
                    }
                    if (isDeviceAbsent) {
                        TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
                        this.deleteTrackerCookie(resp, trackerCookieInfo.getCookieDomain(), "/idp", trackerCookieInfo.isHttpOnly(), trackerCookieInfo.isSecure());
                    }
                }
                if (fidoCookieReceived && !isDeviceAbsent) {
                    return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
                }
            }
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
        }
        catch (ApiResponseException e) {
            if (e.getErrorResponse() != null) {
                String auditLog = "Error encountered while trying to authenticate user with P1. Status code: " + e.getStatusCode() + ", Error message: " + e.getErrorResponse().getMessage();
                this.auditLogger.auditLog(auditLog, req);
                log.debug("Error invoking authentication request flow, Error response: " + e.getErrorResponse().getMessage());
            }
            return this.handleErrorResponse(req, resp, inParameters, stateSupport, null, e);
        }
    }

    private static String getIpAddress(HttpServletRequest req) {
        return req.getRemoteAddr();
    }

    public AuthnAdapterResponse handleUsePasswordAuthnRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) {
        TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
        boolean isHttpOnly = trackerCookieInfo.isHttpOnly();
        boolean isSecureCookie = trackerCookieInfo.isSecure();
        String domain = trackerCookieInfo.getCookieDomain();
        String path = trackerCookieInfo.getCookiePath();
        this.deleteTrackerCookie(resp, domain, path, isHttpOnly, isSecureCookie);
        log.debug("Handling request to exit from adapter with action.");
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        attributeMap.put(CoreContract.POLICY_ACTION.toString(), "UsePassword");
        authnAdapterResponse.setAttributeMap(attributeMap);
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.ACTION);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleSetDefaultDeviceRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AuthnErrorException, IOException, AccessTokenProviderException {
        String deviceIdForDefault = null;
        if (this.authnApiSupport.isApiRequest(req)) {
            try {
                SetDefaultDevice setDefaultDevice = (SetDefaultDevice)((Object)this.authnApiSupport.deserializeAsModel(req, SetDefaultDevice.class));
                deviceIdForDefault = StringUtils.isNotBlank(setDefaultDevice.getDeviceRef().getId()) ? setDefaultDevice.getDeviceRef().getId() : null;
            }
            catch (AuthnErrorException | IOException setDefaultDevice) {}
        } else {
            deviceIdForDefault = req.getParameter(TemplateParameter.DEFAULT_DEVICE_ID.toString());
        }
        List<Device> storeDevices = stateSupport.getDevices();
        String deviceIdReceived = deviceIdForDefault;
        Optional<Device> device = storeDevices.stream().filter(it -> it.getId().equals(deviceIdReceived)).findFirst();
        if (this.authnApiSupport.isApiRequest(req) && !device.isPresent()) {
            log.error("Received invalid device id: " + deviceIdForDefault + " to set as default.");
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_DEVICE.makeInstance()));
            throw new AuthnErrorException(authnError);
        }
        log.debug("Setting device default to deviceId: " + deviceIdForDefault);
        if (StringUtils.isNotBlank(deviceIdForDefault)) {
            String accessToken = this.tokenService.getToken();
            try {
                String userId = stateSupport.getUserId();
                this.workerApiClient.setDefaultDevice(accessToken, userId, deviceIdForDefault);
                List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> getUpdatedDevicesResponse = this.workerApiClient.getUserDevices(accessToken, userId, null);
                List<Device> devices = ModelMapperUtil.map(getUpdatedDevicesResponse);
                for (int index = 0; index < devices.size(); ++index) {
                    devices.get(index).setDefaultDevice(index == 0);
                }
                this.updateStoreDevicesAfterSetDefault(stateSupport, devices);
                List<Device> filteredDevices = stateSupport.getDevices();
                this.writeDeviceSelectionRequiredResponse(req, resp, inParameters, stateSupport, filteredDevices, null);
                AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return authnAdapterResponse;
            }
            catch (ApiResponseException e) {
                LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.SET_DEFAULT_DEVICE_ACTION_FAILURE, deviceIdForDefault, stateSupport.getUser().getId());
            }
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse triggerFIDODeviceSelection(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, DeviceDetails deviceDetails, DeviceSelectionRequiredResponse deviceSelectionRequiredResponse) throws ObsoleteDeviceException, AccessTokenProviderException, JoseException, AuthnErrorException, IOException {
        String deviceId = deviceDetails.getDeviceId();
        this.getAndStoreDevices(deviceSelectionRequiredResponse, stateSupport, req, inParameters);
        this.getAndStoreUser(inParameters, stateSupport);
        String sessionToken = stateSupport.getSessionToken();
        String flowId = stateSupport.getFlowId();
        List<Device> devices = stateSupport.getDevices();
        Optional<Device> device = devices.stream().filter(it -> it.getId().equals(deviceId)).findFirst();
        if (device.isPresent()) {
            Device fidoDevice = device.get();
            stateSupport.setSelectedDeviceType(fidoDevice);
            SelectDeviceRequest selectDeviceRequest = new SelectDeviceRequest(ModelMapperUtil.pingOneDevice(fidoDevice.getId()));
            FlowResponse flowResponse = this.flowsApiClient.selectDevice(flowId, selectDeviceRequest, sessionToken);
            String auditMessagePrefix = "P1 MFA device was selected for authentication. Device Type: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getType() + " Device Nickname: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getNickname();
            this.auditLogger.auditLog(auditMessagePrefix, req);
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
        }
        throw new ObsoleteDeviceException("Device not found");
    }

    /*
     * Enabled aggressive block sorting
     */
    public AuthnAdapterResponse handleOneTimeDeviceOTPMethodTypeInputRequiredRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OneTimeDevicesInfo oneTimeDevicesInfo, PingOneMfaStateSupport stateSupport, ErrorResponse errorResponse) throws IOException, AuthnErrorException {
        stateSupport.setPreviousPfStatus(StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE.getStatus());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        if (this.authnApiSupport.isApiRequest(req)) {
            if (errorResponse == null) {
                this.pingOneMfaAuthnApiSupport.writeOneTimeDeviceMethodSelectionInputRequiredResponse(req, resp, oneTimeDevicesInfo);
                return authnAdapterResponse;
            }
            AuthnError authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
            AuthnErrorDetail authnErrorDetail = null;
            String authnApiUserMessageKey = "authn.api.otp.attempts.limit";
            if (errorResponse.getDetails() == null) throw new AuthnErrorException(authnError);
            ErrorDetail errorDetail = errorResponse.getDetails().get(0);
            String errorDetailCode = errorResponse.getErrorDetailCode();
            authnErrorDetail = CommonErrorDetailSpec.INVALID_DEVICE.makeInstance();
            if (errorDetailCode.equals("QUOTA_EXCEEDED")) {
                authnApiUserMessageKey = "authn.api.invalid.otp";
            } else {
                if (PingOneMfaHandler.isOneTimeDeviceNotificationCoolDownError(errorResponse)) {
                    this.writeMfaFailedResponseWithCoolDown(req, resp, inParameters, MfaFailed.NO_USABLE_DEVICES_WITH_COOLDOWN, errorResponse.getCoolDownExpiresAt());
                    return authnAdapterResponse;
                }
                if (errorDetailCode.equals("NO_USABLE_DEVICES")) {
                    authnApiUserMessageKey = MfaFailed.NO_USABLE_DEVICES.getAuthnApiUserMessageKey();
                }
            }
            if (authnErrorDetail == null) throw new AuthnErrorException(authnError);
            Object userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
            if (errorDetail.getMessage() != null) {
                userMessage = errorDetail.getMessage() + ". " + (String)userMessage;
            }
            authnErrorDetail.setUserMessage((String)userMessage);
            CustomAuthnErrorDetail customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
            Long attemptsRemaining = errorResponse.getAttemptsRemaining();
            customAuthnErrorDetail.setAttemptsRemaining(attemptsRemaining);
            authnError.setDetails(Collections.singletonList(customAuthnErrorDetail));
            throw new AuthnErrorException(authnError);
        }
        if (PingOneMfaHandler.isOneTimeDeviceNotificationCoolDownError(errorResponse)) {
            if (oneTimeDevicesInfo.isDeviceSelectionRequired()) {
                return this.handleNotificationCoolDownError(req, resp, inParameters, errorResponse, true);
            }
            this.writeMfaFailedResponseWithCoolDown(req, resp, inParameters, MfaFailed.NO_USABLE_DEVICES_WITH_COOLDOWN, errorResponse.getCoolDownExpiresAt());
            return authnAdapterResponse;
        }
        if (!PingOneMfaHandler.isOneTimeDeviceDailyLimitExceededError(errorResponse)) {
            this.pingOneMfaTemplateSupport.renderOneTimeDeviceMethodSelectionTemplate(req, resp, inParameters, oneTimeDevicesInfo, errorResponse);
            return authnAdapterResponse;
        }
        if (!oneTimeDevicesInfo.isDeviceSelectionRequired()) {
            this.writeMfaFailedResponse(req, resp, inParameters, MfaFailed.NO_USABLE_DEVICES);
            return authnAdapterResponse;
        }
        OneTimeDeviceInfo.Type selectedDeviceType = this.getSelectedOneTimeDeviceType(oneTimeDevicesInfo, Objects.nonNull(this.getSelectedDeviceRef(req)) ? this.getSelectedDeviceRef(req).getId() : null);
        String templateErrorMessageKey = this.getDailyLimitExceededErrorMessageKey(Objects.nonNull((Object)selectedDeviceType) ? selectedDeviceType.name() : null);
        this.pingOneMfaTemplateSupport.renderDeviceLockedTemplate(req, resp, inParameters, null, templateErrorMessageKey, true);
        return authnAdapterResponse;
    }

    private static boolean isOneTimeDeviceNotificationCoolDownError(ErrorResponse errorResponse) {
        return errorResponse != null && "NO_USABLE_DEVICES".equals(errorResponse.getErrorDetailCode()) && errorResponse.getCoolDownExpiresAt() != null;
    }

    private static boolean isOneTimeDeviceDailyLimitExceededError(ErrorResponse errorResponse) {
        return Objects.nonNull(errorResponse) && "REQUEST_FAILED".equals(errorResponse.getCode()) && "NO_USABLE_DEVICES".equals(errorResponse.getErrorDetailCode());
    }

    public AuthnAdapterResponse handleOneTimeDeviceCheckOtpRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException, AuthnErrorException {
        block5: {
            String accessToken = this.tokenService.getToken();
            String otp = (String)OTP_PARAM_MAPPING.getValue(req);
            String deviceAuthenticationRequestId = stateSupport.getDeviceAuthenticationRequestId();
            try {
                ValidateOneTimeDeviceAuthenticationRequestResponse validateOneTimeDeviceAuthenticationRequestResponse = this.workerApiClient.validateOneTimeDeviceAuthenticationRequestOTP(accessToken, new CheckOtpRequest(otp), deviceAuthenticationRequestId);
                String status = validateOneTimeDeviceAuthenticationRequestResponse.getStatus();
                switch (Status.valueOf(status)) {
                    case COMPLETED: {
                        stateSupport.removeOneTimeDeviceOtpDevices();
                        stateSupport.removeSelectedOneTimeDeviceOtpDevice();
                        stateSupport.removeDeviceAuthenticationRequestId();
                        stateSupport.removeUsernamelessAuthenticationRequestResponse();
                        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
                        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                        authnAdapterResponse.setAttributeMap(this.fulfillBypassedAttributeMapOneTimeDeviceAuthenticationFlow(validateOneTimeDeviceAuthenticationRequestResponse, username));
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                        stateSupport.removePreviousPfStatus();
                        return authnAdapterResponse;
                    }
                }
            }
            catch (ApiResponseException e) {
                if (e.getErrorResponse() == null) break block5;
                ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
                log.debug("Error response details: " + errorResponse.getPrettyErrorDetails());
                this.handleOneTimeDeviceMethodOtpInputErrorResponse(req, resp, inParameters, errorResponse, stateSupport.getSelectedOneTimeDeviceOtpDevice(), stateSupport);
            }
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleDeviceAuthenticationStatusRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AuthnErrorException {
        String pingOneStatus = stateSupport.getPreviousPfStatus();
        String errorKey = null;
        if (StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE.getStatus().equals(pingOneStatus)) {
            if (this.authnApiSupport.isApiRequest(req)) {
                this.pingOneMfaAuthnApiSupport.writeOneTimeDeviceMethodOtpInputRequiredResponse(req, resp, stateSupport.getSelectedOneTimeDeviceOtpDevice(), stateSupport.getOneTimeDeviceOtpDevices(), stateSupport.getMfaPolicy().getOtpLifeTime(stateSupport.getSelectedOneTimeDeviceOtpDevice().getType().toString()), null);
            } else {
                int otpLength = this.getOtpLength(stateSupport, stateSupport.getSelectedOneTimeDeviceOtpDevice().getType().toString());
                this.pingOneMfaTemplateSupport.renderOneTimeDeviceMethodOtpRequiredTemplate(req, resp, inParameters, errorKey, stateSupport.getSelectedOneTimeDeviceOtpDevice(), stateSupport.getOneTimeDeviceOtpDevices(), null, otpLength, null);
            }
        } else if (StateSpec.ONE_TIME_DEVICE_OTP_METHOD_TYPE_INPUT_REQUIRED_RESPONSE.getStatus().equals(pingOneStatus)) {
            return this.handleOneTimeDeviceOTPMethodTypeInputRequiredRequest(req, resp, inParameters, stateSupport.getOneTimeDeviceOtpDevices(), stateSupport, null);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void handleOneTimeDeviceMethodOtpInput(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OneTimeDeviceInfo selectedOneTimeDeviceInfo, PingOneMfaStateSupport stateSupport, com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification notification) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeOneTimeDeviceMethodOtpInputRequiredResponse(req, resp, selectedOneTimeDeviceInfo, stateSupport.getOneTimeDeviceOtpDevices(), stateSupport.getMfaPolicy().getOtpLifeTime(selectedOneTimeDeviceInfo.getType().toString()), notification);
        } else {
            int otpLength = this.getOtpLength(stateSupport, selectedOneTimeDeviceInfo.getType().toString());
            this.pingOneMfaTemplateSupport.renderOneTimeDeviceMethodOtpRequiredTemplate(req, resp, inParameters, null, selectedOneTimeDeviceInfo, stateSupport.getOneTimeDeviceOtpDevices(), null, otpLength, notification);
        }
    }

    private void handleOneTimeDeviceMethodOtpInputErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, ErrorResponse errorResponse, OneTimeDeviceInfo selectedOneTimeDeviceInfo, PingOneMfaStateSupport stateSupport) throws IOException, AuthnErrorException {
        String errorDetailCode = errorResponse.getErrorDetailCode();
        if (this.authnApiSupport.isApiRequest(req)) {
            String authnApiUserMessageKey = "";
            AuthnErrorDetail authnErrorDetail = null;
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            Long quotaLimit = null;
            Long cooldownPeriod = null;
            Long attemptsRemaining = null;
            switch (errorDetailCode) {
                case "INVALID_VALUE": {
                    authnErrorDetail = CommonErrorDetailSpec.INVALID_OTP.makeInstance();
                    authnApiUserMessageKey = "authn.api.invalid.otp";
                    break;
                }
                case "INVALID_OTP": {
                    authnErrorDetail = CommonErrorDetailSpec.INVALID_OTP.makeInstance();
                    authnApiUserMessageKey = "authn.api.invalid.otp";
                    attemptsRemaining = errorResponse.getAttemptsRemaining();
                    break;
                }
                case "QUOTA_EXCEEDED": {
                    authnErrorDetail = CommonErrorDetailSpec.OTP_ATTEMPTS_LIMIT.makeInstance();
                    authnApiUserMessageKey = "authn.api.otp.attempts.limit";
                    cooldownPeriod = errorResponse.getCoolDownExpiresAt();
                    quotaLimit = errorResponse.getQuotaLimit();
                    break;
                }
                case "LIMIT_EXCEEDED": {
                    this.handleNotificationCoolDownError(req, resp, inParameters, errorResponse, true);
                }
            }
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
                authnErrorDetail.setUserMessage(userMessage);
                CustomAuthnErrorDetail customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
                customAuthnErrorDetail.setCoolDownExpiresAt(cooldownPeriod);
                customAuthnErrorDetail.setQuotaLimit(quotaLimit);
                customAuthnErrorDetail.setAttemptsRemaining(attemptsRemaining);
                authnError.setDetails(Collections.singletonList(customAuthnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        if (errorDetailCode.equals("QUOTA_EXCEEDED")) {
            this.pingOneMfaTemplateSupport.renderDeviceLockedTemplate(req, resp, inParameters, null, "incorrect.otp.limit.exhausted.authentication", true);
            return;
        }
        if (errorDetailCode.equals("LIMIT_EXCEEDED")) {
            this.handleNotificationCoolDownError(req, resp, inParameters, errorResponse, true);
        }
        if (ErrorResponseUtil.isInvalidOrExpiredOtp(errorResponse)) {
            int otpLength = this.getOtpLength(stateSupport, selectedOneTimeDeviceInfo.getType().toString());
            String errorMessageKey = ErrorResponseUtil.getBadOtpErrorMessageKey(errorResponse);
            this.pingOneMfaTemplateSupport.renderOneTimeDeviceMethodOtpRequiredTemplate(req, resp, inParameters, errorMessageKey, selectedOneTimeDeviceInfo, stateSupport.getOneTimeDeviceOtpDevices(), errorResponse.getAttemptsRemaining(), otpLength, null);
        }
    }

    public AuthnAdapterResponse handleCreateOneTimeDeviceAuthenticationRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OneTimeDeviceInfo selectedOneTimeDeviceInfo, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException, AuthnErrorException {
        block3: {
            String accessToken = this.tokenService.getToken();
            String userId = this.getUserId(stateSupport, inParameters);
            try {
                CreateDeviceAuthenticationRequest createDeviceAuthenticationRequest = new CreateDeviceAuthenticationRequest(userId, selectedOneTimeDeviceInfo);
                createDeviceAuthenticationRequest.setNotification(this.extractNotificationTemplate(inParameters, LocaleUtil.getUserLocale((HttpServletRequest)req).toString()));
                CreateOneTimeDeviceAuthenticationRequestResponse createOneTimeDeviceAuthenticationRequestResponse = this.workerApiClient.createOneTimeDeviceAuthenticationRequest(new ManagementApiResponseHandler<CreateOneTimeDeviceAuthenticationRequestResponse>(CreateOneTimeDeviceAuthenticationRequestResponse.class), accessToken, createDeviceAuthenticationRequest);
                stateSupport.setPreviousPfStatus(StateSpec.ONE_TIME_DEVICE_OTP_INPUT_REQUIRED_RESPONSE.getStatus());
                stateSupport.setSelectedOneTimeDeviceOtpDevice(selectedOneTimeDeviceInfo);
                String pingOneStatus = createOneTimeDeviceAuthenticationRequestResponse.getStatus();
                if (Status.OTP_REQUIRED.toString().equals(pingOneStatus)) {
                    String auditMessagePrefix = "P1 MFA one-time-device flow was selected for authentication.";
                    this.auditLogger.auditLog(auditMessagePrefix, req);
                    stateSupport.setDeviceAuthenticationRequestId(createOneTimeDeviceAuthenticationRequestResponse.getId());
                    this.getAndStoreMFAPolicy(stateSupport);
                    this.handleOneTimeDeviceMethodOtpInput(req, resp, inParameters, selectedOneTimeDeviceInfo, stateSupport, this.getNotificationCoolDownExpiresAt(createOneTimeDeviceAuthenticationRequestResponse));
                }
            }
            catch (ApiResponseException e) {
                if (e.getErrorResponse() == null) break block3;
                ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
                log.debug("Error response details: " + errorResponse.getPrettyErrorDetails());
                this.handleOneTimeDeviceOTPMethodTypeInputRequiredRequest(req, resp, inParameters, stateSupport.getOneTimeDeviceOtpDevices(), stateSupport, errorResponse);
            }
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleUsernameLessAuthenticationCheckAssertionRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException {
        String accessToken = this.tokenService.getToken();
        String assertion = (String)ASSERTION_PARAM_MAPPING.getValue(req);
        String compatibility = (String)COMPATIBILITY_PARAM_MAPPING.getValue(req);
        String origin = (String)ORIGIN_PARAM_MAPPING.getValue(req);
        if (StringUtils.isBlank(origin)) {
            origin = DomainInfoUtil.getBaseUrlFromRequest(inParameters, req);
        }
        String deviceAuthenticationId = stateSupport.getDeviceAuthenticationRequestId();
        CheckAssertionRequest checkAssertionRequest = new CheckAssertionRequest(assertion, origin, compatibility);
        try {
            UsernamelessAuthAssertionCheckRequestResponse checkAssertionRequestResponse = this.workerApiClient.checkUsernamelessAuthenticationCheckAssertionRequest(accessToken, checkAssertionRequest, deviceAuthenticationId);
            String status = checkAssertionRequestResponse.getStatus();
            if (CommonStateSpec.COMPLETED.getStatus().equals(status)) {
                AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                authnAdapterResponse.setAttributeMap(this.fulfillUsernamelessAuthenticationFlowAttributeMap(checkAssertionRequestResponse));
                return authnAdapterResponse;
            }
            LOG.log(PingOneMfaIdpAdapterLogEvent.FAILED_ASSERTION_VALIDATION_IN_USERNAMELESS_FLOW);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
        catch (IOException ie) {
            LOG.log(PingOneMfaIdpAdapterLogEvent.FAILED_ASSERTION_VALIDATION_IN_USERNAMELESS_FLOW);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
    }

    public AuthnAdapterResponse handleUsernamelessAuthenticationCreateAuthenticationRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, String authenticationPolicy) throws AccessTokenProviderException, IOException, AuthnErrorException {
        String accessToken = this.tokenService.getToken();
        String currentDomain = DomainInfoUtil.getCurrentDomain(inParameters, req);
        String status = stateSupport.getPreviousPfStatus();
        if (this.authnApiSupport.isApiRequest(req) && StringUtils.isBlank(status)) {
            this.pingOneMfaAuthnApiSupport.writeBiometricAuthenticationInfoRequiredResponse(req, resp);
            stateSupport.setPreviousPfStatus(StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus());
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return authnAdapterResponse;
        }
        if (this.authnApiSupport.isApiRequest(req) && StateSpec.BIOMETRIC_DEVICE_AUTHENTICATION_INFO_REQUIRED.getStatus().equals(status) && StringUtils.isBlank(currentDomain = (String)CONTINUE_BIOMETRIC_DEVICE_AUTHENTICATION_ORIGIN_PARAM_MAPPING.getValue(req))) {
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            throw new AuthnErrorException(authnError);
        }
        DeviceAuthenticationPolicy deviceAuthenticationPolicy = this.workerApiClient.getMFAPolicyFromAuthenticationPolicy(accessToken, authenticationPolicy);
        UsernamelessAuthCreateRequest usernamelessAuthCreateRequest = new UsernamelessAuthCreateRequest(currentDomain);
        usernamelessAuthCreateRequest.setMfaPolicyId(String.valueOf(deviceAuthenticationPolicy.getId()));
        Optional.ofNullable(this.getCustomChallenge(inParameters)).ifPresent(challenge -> usernamelessAuthCreateRequest.setWebAuthn(new CustomChallenge((String)challenge)));
        try {
            CreateUsernamelessAuthenticationResponse createUsernamelessAuthenticationResponse = this.workerApiClient.createUsernamelessAuthenticationRequest(new ManagementApiResponseHandler<CreateUsernamelessAuthenticationResponse>(CreateUsernamelessAuthenticationResponse.class), accessToken, usernamelessAuthCreateRequest);
            String messagePrefix = "P1 MFA biometric flow (username-less) selected for authentication. Relying Party identifier: " + createUsernamelessAuthenticationResponse.getRp().getId();
            this.auditLogger.auditLog(messagePrefix, req);
            status = createUsernamelessAuthenticationResponse.getStatus();
            if (StateSpec.ASSERTION_REQUIRED.getStatus().equals(status)) {
                String publicKeyCredentialRequestStr = createUsernamelessAuthenticationResponse.getPublicKeyCredentialRequestOptions();
                stateSupport.setUsernamelessAuthenticationRequestResponse(createUsernamelessAuthenticationResponse);
                stateSupport.setPreviousPfStatus(StateSpec.ASSERTION_REQUIRED.getStatus());
                stateSupport.setDeviceAuthenticationRequestId(createUsernamelessAuthenticationResponse.getId());
                PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions = ObjectMappers.getDefault().readValue(publicKeyCredentialRequestStr, PublicKeyCredentialRequestOptions.class);
                this.writeUsernamelessAssertionRequiredResponse(req, resp, inParameters, stateSupport, publicKeyCredentialRequestOptions);
                AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return authnAdapterResponse;
            }
            LOG.log(PingOneMfaIdpAdapterLogEvent.UNEXPECTED_RESPONSE_ERROR_IN_USERNAMELESS_FLOW);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
        catch (IOException ioException) {
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST_FOR_USERNAMELESS_FLOW, ioException);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
    }

    public AuthnAdapterResponse handleCreateAuthenticationCodesRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException, AuthnErrorException {
        AuthenticationCodesResponse authenticationCodesResponse;
        if (StringUtils.isBlank(this.applicationIdForQRFlow)) {
            LOG.log(PingOneMfaIdpAdapterLogEvent.APPLICATION_ID_UNCONFIGURED_FOR_AUTHENTICATION_CODE_FLOW);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setErrorMessage(PingOneMfaIdpAdapterLogEvent.APPLICATION_ID_UNCONFIGURED_FOR_AUTHENTICATION_CODE_FLOW.getMessage());
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
        String accessToken = this.tokenService.getToken();
        CreateAuthenticationCodesRequest createAuthenticationCodesRequest = this.getCreateAuthenticationCodeRequest(req, inParameters, stateSupport);
        try {
            authenticationCodesResponse = this.workerApiClient.createAuthenticationCodes(accessToken, createAuthenticationCodesRequest);
        }
        catch (IOException ioException) {
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.AUTHENTICATION_CODE_FLOW_ERROR_INVALID_REQUEST, ioException);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
        String auditMessagePrefix = "P1 MFA authentication code flow was selected for authentication. Application ID: " + authenticationCodesResponse.getApplication().getId();
        this.auditLogger.auditLog(auditMessagePrefix, req);
        stateSupport.setPreviousPfStatus(StateSpec.AUTHENTICATION_CODE_RESPONSE_REQUIRED.getStatus());
        stateSupport.setAuthenticationCodeId(authenticationCodesResponse.getId());
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeAuthenticationCodeResponseRequiredResponse(req, resp, authenticationCodesResponse);
        } else {
            this.pingOneMfaTemplateSupport.renderAuthenticationCodeResponseRequiredTemplate(req, resp, inParameters, authenticationCodesResponse);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleSelectDeviceRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse getFlowResponse) throws AuthnErrorException, IOException, JoseException, AccessTokenProviderException {
        String flowId = stateSupport.getFlowId();
        String sessionToken = stateSupport.getSessionToken();
        if (getFlowResponse == null) {
            getFlowResponse = this.flowsApiClient.getFlow(flowId, sessionToken);
        }
        String status = getFlowResponse.getStatus();
        if (this.authnApiSupport.isApiRequest(req)) {
            ResourceRef receivedResourceRef;
            CustomSelectDevice selectDevice = (CustomSelectDevice)((Object)this.authnApiSupport.deserializeAsModel(req, CustomSelectDevice.class));
            ResourceRef resourceRef = stateSupport.getSelectedDeviceRef();
            if (selectDevice != null && resourceRef != null && (receivedResourceRef = selectDevice.getDeviceRef()) != null) {
                String previousDeviceId = resourceRef.getId();
                String receivedDeviceId = receivedResourceRef.getId();
                if (previousDeviceId != null && receivedDeviceId != null && !this.changeDeviceAllowed && !previousDeviceId.equalsIgnoreCase(receivedDeviceId)) {
                    AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                    authnError.setDetails(Collections.singletonList(ErrorDetailSpec.CHANGE_AUTHENTICATION_METHOD_NOT_ALLOWED.makeInstanceBuilder().build()));
                    throw new AuthnErrorException(authnError);
                }
            }
        }
        if (!this.authnApiSupport.isApiRequest(req) && (CommonStateSpec.COMPLETED.getStatus().equals(status) || CommonStateSpec.FAILED.getStatus().equals(status))) {
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, getFlowResponse);
        }
        ResourceRef selectedDeviceRef = this.getSelectedDeviceRef(req);
        String previousPfStatus = stateSupport.getPreviousPfStatus();
        log.debug("Inside device selection request");
        if (!(stateSupport.getSelectedDeviceRef() == null || selectedDeviceRef == null || selectedDeviceRef.getId() == null || selectedDeviceRef.getId().equals(stateSupport.getSelectedDeviceRef().getId()) || this.authnApiSupport.isApiRequest(req) || this.changeDeviceAllowed)) {
            boolean userCancelledFIDOAuth = Status.ASSERTION_REQUIRED.toString().equals(status);
            return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, userCancelledFIDOAuth);
        }
        try {
            FlowResponse flowResponse;
            List<Device> devices;
            if (!this.authnApiSupport.isApiRequest(req) && StringUtils.isBlank(selectedDeviceRef.getId()) && !StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus().equals(previousPfStatus)) {
                boolean shouldAggregateFidoDevices;
                log.debug("Rendering device selection template for device change");
                devices = stateSupport.getDevices();
                String errorMessageKey = null;
                if ("ASSERTION_REQUIRED".equals(stateSupport.getPreviousPfStatus()) && !devices.isEmpty() && !devices.get(0).isUsable()) {
                    errorMessageKey = "auth.failed.assertion.policy.error.message";
                }
                if (req.getParameterMap().containsKey(TemplateParameter.COMPATIBILITY.toString()) && "None".equalsIgnoreCase(req.getParameter(TemplateParameter.COMPATIBILITY.toString()))) {
                    errorMessageKey = "incompatible.device";
                }
                this.pingOneMfaTemplateSupport.renderDeviceSelectionTemplate(req, resp, inParameters, (shouldAggregateFidoDevices = this.shouldAggregateFidoDevices(devices, stateSupport.getIsFidoAggregationEnabled())) ? this.getDevicesWithAggregatedFido(devices) : devices, errorMessageKey, null, this.isAddMethodPermitted(inParameters, stateSupport), stateSupport.isManualPairingFlow(), !stateSupport.getBypassMfaBeforeDeviceMgmt(), stateSupport.getSupportUsePasswordPolicyAction(), this.isDevicesManagementAllowed(inParameters, stateSupport), shouldAggregateFidoDevices);
                AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return authnAdapterResponse;
            }
            if (StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus().equals(previousPfStatus)) {
                if (!this.authnApiSupport.isApiRequest(req)) {
                    return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                }
                log.debug("Mobile push confirmation rejected as previous status");
                devices = stateSupport.getDevices();
                if (this.authnApiSupport.isApiRequest(req) && !this.isValidSelectedDevice(devices, selectedDeviceRef)) {
                    return this.handleInvalidDeviceError(req, resp, inParameters, stateSupport, null);
                }
                flowResponse = this.initiateFlow(req, inParameters, stateSupport);
                flowId = flowResponse.getId();
                AuthnAdapterResponse authnAdapterResponse = !this.authnApiSupport.isApiRequest(req) && selectedDeviceRef.getId().isEmpty() ? this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse) : this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse, false);
                if (authnAdapterResponse != null) {
                    return authnAdapterResponse;
                }
                log.debug("Initiating select device flow for device id: " + selectedDeviceRef.getId());
                flowResponse = this.flowsApiClient.selectDevice(flowId, new SelectDeviceRequest(ModelMapperUtil.pingOneDevice(selectedDeviceRef.getId())), sessionToken);
                if (flowResponse instanceof CommonFlowResponse) {
                    String auditMessagePrefix = "P1 MFA device was selected for authentication. Device Type: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getType() + " Device Nickname: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getNickname();
                    this.auditLogger.auditLog(auditMessagePrefix, req);
                }
            } else {
                log.debug("Initiating select device flow for device id: " + selectedDeviceRef.getId());
                sessionToken = stateSupport.getSessionToken();
                SelectDeviceRequest selectDeviceRequest = new SelectDeviceRequest(ModelMapperUtil.pingOneDevice(selectedDeviceRef.getId()));
                selectDeviceRequest.setNotification(this.extractNotificationTemplate(inParameters, LocaleUtil.getUserLocale((HttpServletRequest)req).toString()));
                flowResponse = this.flowsApiClient.selectDevice(flowId, selectDeviceRequest, sessionToken);
                if (flowResponse instanceof CommonFlowResponse) {
                    String auditMessagePrefix = "P1 MFA device was selected for authentication. Device Type: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getType() + " Device Nickname: " + ((CommonFlowResponse)flowResponse).getFullObjectSelectedDevice().getNickname();
                    this.auditLogger.auditLog(auditMessagePrefix, req);
                }
            }
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
        }
        catch (ApiResponseException e) {
            if (e.getErrorResponse() != null) {
                log.debug("Error invoking device selection flow, Error response: " + e.getErrorResponse().getMessage());
            }
            return this.handleErrorResponse(req, resp, inParameters, stateSupport, getFlowResponse, e);
        }
    }

    public AuthnAdapterResponse handleDeleteDeviceRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, JoseException {
        String deviceToRemoveId;
        this.validateDeviceManagementAllowed(inParameters, stateSupport);
        if (this.authnApiSupport.isApiRequest(req)) {
            RemoveDevice deviceRef = (RemoveDevice)this.authnApiSupport.deserializeAsModel(req, RemoveDevice.class);
            deviceToRemoveId = StringUtils.isNotBlank(deviceRef.getDeviceRef().getId()) ? deviceRef.getDeviceRef().getId() : null;
            List<Device> storeDevices = stateSupport.getDevices();
            String deviceIdReceived = deviceToRemoveId;
            Optional<Device> device = storeDevices.stream().filter(it -> it.getId().equals(deviceIdReceived)).findFirst();
            if (!device.isPresent()) {
                log.error("Received invalid device id: " + deviceToRemoveId + " to delete.");
                AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_DEVICE.makeInstance()));
                throw new AuthnErrorException(authnError);
            }
        } else {
            deviceToRemoveId = req.getParameter(TemplateParameter.DELETE_DEVICE_ID.toString());
        }
        if (stateSupport.getBypassMfaBeforeDeviceMgmt()) {
            this.removeDevice(stateSupport.getUserId(), deviceToRemoveId);
            this.updateUserDevicesList(stateSupport);
            log.debug("device with ID: " + deviceToRemoveId + " was removed without additional MFA due to configured bypass settings.");
            return this.onMfaSuccess(req, resp, inParameters, stateSupport);
        }
        stateSupport.setDeviceToRemoveId(deviceToRemoveId);
        log.debug("deviceId was stored - trigger an authentication flow before removing the device");
        AuthnAdapterResponse authnAdapterResponse = this.handleFlowResponse(req, resp, inParameters, stateSupport, this.initiateFlow(req, inParameters, stateSupport));
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleCancelDeviceRemovalRequest(PingOneMfaStateSupport stateSupport) {
        stateSupport.removeDeviceToRemoveId();
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        String errorMessage = "User has canceled device removal";
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        authnAdapterResponse.setErrorMessage(errorMessage);
        return authnAdapterResponse;
    }

    public ResourceRef getSelectedDeviceRef(HttpServletRequest req) {
        ResourceRef selectedDeviceRef;
        if (this.authnApiSupport.isApiRequest(req)) {
            SelectDevice selectDevice;
            try {
                selectDevice = (SelectDevice)this.authnApiSupport.deserializeAsModel(req, CustomSelectDevice.class);
            }
            catch (AuthnErrorException | IOException ignored) {
                return null;
            }
            selectedDeviceRef = selectDevice.getDeviceRef();
        } else {
            String selectedDeviceId = req.getParameter(TemplateParameter.SELECTED_DEVICE_ID.toString());
            ResourceRef ref = new ResourceRef();
            ref.setId(selectedDeviceId);
            selectedDeviceRef = ref;
        }
        return selectedDeviceRef;
    }

    public AuthnAdapterResponse handleUpdateDeviceNickname(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, JoseException {
        Nickname updatedNickname;
        this.validateDeviceManagementAllowed(inParameters, stateSupport);
        if (this.authnApiSupport.isApiRequest(req)) {
            updatedNickname = (Nickname)this.authnApiSupport.deserializeAsModel(req, Nickname.class);
            String deviceId = updatedNickname.getId();
            List<Device> storeDevices = stateSupport.getDevices();
            Optional<Device> existingDevice = storeDevices.stream().filter(it -> it.getId().equals(deviceId)).findFirst();
            if (!existingDevice.isPresent()) {
                log.error("Received invalid device id: " + deviceId + " to update.");
                AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_DEVICE.makeInstance()));
                throw new AuthnErrorException(authnError);
            }
        } else {
            updatedNickname = ObjectMappers.getDefault().readValue(req.getParameter(TemplateParameter.UPDATE_DEVICE_NICKNAME.toString()), Nickname.class);
        }
        if (stateSupport.isUpdateNicknameDuringDevicePairing() || stateSupport.getBypassMfaBeforeDeviceMgmt()) {
            this.updateDevice(stateSupport.getUserId(), updatedNickname);
            stateSupport.setIsUpdateNicknameDuringDevicePairing(false);
            stateSupport.getDevices().stream().filter(device -> device.getId().equals(updatedNickname.getId())).findFirst().ifPresent(device -> device.setNickname(updatedNickname.getNickname()));
            log.debug("nickname of device with ID: " + updatedNickname.getId() + " was updated.");
            return this.onMfaSuccess(req, resp, inParameters, stateSupport);
        }
        stateSupport.setUpdatedNickname(updatedNickname);
        log.debug("device was stored - trigger an authentication flow before updating the device");
        FlowResponse authenticationResponse = this.initiateFlow(req, inParameters, stateSupport);
        AuthnAdapterResponse authnAdapterResponse = this.handleFlowResponse(req, resp, inParameters, stateSupport, authenticationResponse);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleSkipUpdateNicknameDuringDevicePairingRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, JoseException {
        stateSupport.setIsUpdateNicknameDuringDevicePairing(false);
        return this.onMfaSuccess(req, resp, inParameters, stateSupport);
    }

    private void validateDeviceManagementAllowed(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AuthnErrorException {
        if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
            String errorMessage = "MFA devices cannot be edited/removed during password reset.";
            log.error(errorMessage);
            AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
            authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
        if (!this.isDevicesManagementAllowed(inParameters, stateSupport)) {
            String errorMessage = "user is not allowed to perform actions on device";
            log.error(errorMessage);
            AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
            authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
    }

    private String getAttributesFromInputParams(HttpServletRequest req, Map<String, Object> inParameters, String fieldName) {
        if (StringUtils.isBlank(fieldName)) {
            return null;
        }
        Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        Map trackedParameters = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        if (chainedAttributes != null && chainedAttributes.containsKey(fieldName) && StringUtils.isNotBlank(((AttributeValue)chainedAttributes.get(fieldName)).getValue())) {
            return ((AttributeValue)chainedAttributes.get(fieldName)).getValue();
        }
        if (signedRequestClaims != null && signedRequestClaims.containsKey(fieldName) && signedRequestClaims.get(fieldName) != null) {
            Object object = signedRequestClaims.get(fieldName);
            if (object instanceof String) {
                return (String)object;
            }
        } else if (trackedParameters != null && trackedParameters.containsKey(fieldName) && StringUtils.isNotBlank((CharSequence)((List)trackedParameters.get(fieldName)).get(0))) {
            return (String)((List)trackedParameters.get(fieldName)).get(0);
        }
        return null;
    }

    public CreateAuthenticationCodesRequest getCreateAuthenticationCodeRequest(HttpServletRequest req, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        CreateAuthenticationCodesRequest createAuthenticationCodesRequest = new CreateAuthenticationCodesRequest();
        createAuthenticationCodesRequest.setApplication(new com.pingidentity.adapters.pingone.mfa.api.model.request.authenticationcode.Application(this.applicationIdForQRFlow));
        String clientContextHeader = this.getAttributesFromInputParams(req, inParameters, "p1mfa.authenticationcode.clientContext.header");
        String clientContextBody = this.getAttributesFromInputParams(req, inParameters, "p1mfa.authenticationcode.clientContext.body");
        String lifeTimeDuration = this.getAttributesFromInputParams(req, inParameters, "p1mfa.authenticationcode.lifeTime.duration");
        String lifeTimeTimeUnit = this.getAttributesFromInputParams(req, inParameters, "p1mfa.authenticationcode.lifeTime.timeUnit");
        String userApproval = this.getAttributesFromInputParams(req, inParameters, "p1mfa.authenticationcode.userApproval");
        if (StringUtils.isNotBlank(clientContextHeader) || StringUtils.isNotBlank(clientContextBody)) {
            ClientContext clientContext = new ClientContext(clientContextHeader, clientContextBody);
            createAuthenticationCodesRequest.setClientContext(clientContext);
        }
        try {
            if (StringUtils.isNotBlank(lifeTimeDuration) && StringUtils.isNotBlank(lifeTimeTimeUnit)) {
                int duration = Integer.parseInt(lifeTimeDuration);
                LifeTime lifeTime = new LifeTime(duration, lifeTimeTimeUnit);
                createAuthenticationCodesRequest.setLifeTime(lifeTime);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        createAuthenticationCodesRequest.setUserApproval(userApproval);
        return createAuthenticationCodesRequest;
    }

    public AuthnAdapterResponse handleCheckAssertionRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse getFlowResponse) throws AuthnErrorException, IOException, AccessTokenProviderException, JoseException {
        String assertion = (String)ASSERTION_PARAM_MAPPING.getValue(req);
        String compatibility = (String)COMPATIBILITY_PARAM_MAPPING.getValue(req);
        String origin = (String)ORIGIN_PARAM_MAPPING.getValue(req);
        if (StringUtils.isBlank(origin)) {
            origin = DomainInfoUtil.getBaseUrlFromRequest(inParameters, req);
        }
        String flowId = stateSupport.getFlowId();
        try {
            String sessionToken = stateSupport.getSessionToken();
            log.debug("Invoking check assertion flow");
            FlowResponse checkAssertionFlowResponse = this.flowsApiClient.checkAssertion(flowId, new CheckAssertionRequest(assertion, origin, compatibility), sessionToken);
            ResourceRef ref = stateSupport.getSelectedDeviceRef();
            List<Device> devices = stateSupport.getDevices();
            Optional<Device> device = devices.stream().filter(it -> it.getId().equals(ref.getId())).findFirst();
            if (device.isPresent()) {
                Device fidoDevice = device.get();
                stateSupport.setSelectedDeviceType(fidoDevice);
            }
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, checkAssertionFlowResponse);
        }
        catch (ApiResponseException e) {
            if (e.getErrorResponse() != null) {
                log.debug("Error invoking check assertion flow, Error response: " + e.getErrorResponse().getMessage());
            }
            return this.handleErrorResponse(req, resp, inParameters, stateSupport, getFlowResponse, e);
        }
    }

    public AuthnAdapterResponse handleCheckOtpRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse getFlowResponse) throws AuthnErrorException, IOException, AccessTokenProviderException, JoseException {
        String otp = (String)OTP_PARAM_MAPPING.getValue(req);
        String flowId = stateSupport.getFlowId();
        try {
            String sessionToken = stateSupport.getSessionToken();
            log.debug("Invoking check otp flow");
            FlowResponse checkOtpFlowResponse = this.flowsApiClient.checkOtp(flowId, new CheckOtpRequest(otp), sessionToken);
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, checkOtpFlowResponse);
        }
        catch (ApiResponseException e) {
            if (e.getErrorResponse() != null) {
                log.debug("Error invoking check otp flow, Error response: " + e.getErrorResponse().getMessage());
            }
            return this.handleErrorResponse(req, resp, inParameters, stateSupport, getFlowResponse, e);
        }
    }

    private void sendResponsetoAJAXAuthenticationCodePollingRequest(HttpServletRequest req, HttpServletResponse resp, boolean continuePolling, String requestStatus) {
        resp.setContentType("application/json");
        PollingRequestResponse pollingRequestResponse = new PollingRequestResponse(requestStatus, continuePolling);
        try {
            String response = ObjectMappers.getDefault().writeValueAsString(pollingRequestResponse);
            resp.getWriter().write(response);
            resp.getWriter().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public AuthnAdapterResponse handleAuthenticationCodeFailed(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleAuthenticationCodeCompleted(PingOneMfaStateSupport stateSupport) {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        stateSupport.setMfaCompletedCode(PingOneMfaStatus.MOBILE_LOGIN_AUTHENTICATION_CODE.toString());
        String userId = stateSupport.getAuthenticationCodeFlowRequestUserId();
        String userName = null;
        try {
            String accessToken = this.tokenService.getToken();
            User user = this.workerApiClient.getUserById(accessToken, userId);
            userName = user.getUsername();
        }
        catch (AccessTokenProviderException | IOException exception) {
            // empty catch block
        }
        authnAdapterResponse.setAttributeMap(this.fulfillBypassedAttributeMapAuthenticationCodeFlow(userId, userName));
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleAuthenticationCodeStatusRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException {
        String authenticationCodeId = stateSupport.getAuthenticationCodeId();
        String accessToken = this.tokenService.getToken();
        AuthenticationCodesResponse authenticationCodesResponse = this.workerApiClient.checkAuthenticationCodeRequestStatus(accessToken, authenticationCodeId);
        String status = authenticationCodesResponse.getStatus();
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        stateSupport.setAuthenticationCodeFlowRequestStatus(status);
        if ("COMPLETED".equalsIgnoreCase(status)) {
            stateSupport.setPreviousPfStatus(CommonStateSpec.MFA_COMPLETED.getStatus());
            stateSupport.setMfaCompletedCode(PingOneMfaStatus.MOBILE_LOGIN_AUTHENTICATION_CODE.toString());
            authnAdapterResponse.getUsername();
            stateSupport.setAuthenticationCodeFlowRequestUserId(authenticationCodesResponse.getUser().getId());
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            if (this.authnApiSupport.isApiRequest(req)) {
                this.pingOneMfaAuthnApiSupport.writeMfaCompletedResponse(req, resp, PingOneMfaStatus.MOBILE_LOGIN_AUTHENTICATION_CODE.toString());
            } else {
                this.sendResponsetoAJAXAuthenticationCodePollingRequest(req, resp, false, status);
            }
        } else {
            if ("EXPIRED".equalsIgnoreCase(status) || "UNCLAIMED".equalsIgnoreCase(status) || "CLAIMED".equalsIgnoreCase(status)) {
                if (this.automaticAuthCodeRefreshEnabled && "EXPIRED".equalsIgnoreCase(status)) {
                    return this.handleCreateAuthenticationCodesRequest(req, resp, inParameters, stateSupport);
                }
                if (this.authnApiSupport.isApiRequest(req)) {
                    this.pingOneMfaAuthnApiSupport.writeAuthenticationCodeResponseRequiredResponse(req, resp, authenticationCodesResponse);
                } else {
                    this.pingOneMfaTemplateSupport.renderAuthenticationCodeResponseRequiredTemplate(req, resp, inParameters, authenticationCodesResponse);
                }
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return authnAdapterResponse;
            }
            if ("DENIED".equalsIgnoreCase(status)) {
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                log.debug("Received claim status as \"DENIED\", so failing the authentication");
                stateSupport.setPreviousPfStatus(CommonStateSpec.MFA_FAILED.getStatus());
                if (this.authnApiSupport.isApiRequest(req)) {
                    MfaFailed mfaFailed = MfaFailed.AUTHENTICATION_CODE_REQUIEST_APPROVAL_DENIED;
                    this.pingOneMfaAuthnApiSupport.writeMfaFailedResponse(req, resp, mfaFailed.getMessage(), mfaFailed.getCode(), mfaFailed.getAuthnApiUserMessageKey());
                } else {
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                    return authnAdapterResponse;
                }
            }
        }
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleAuthenticationCodeStatusPollRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException {
        String authenticationCodeId = stateSupport.getAuthenticationCodeId();
        String accessToken = this.tokenService.getToken();
        AuthenticationCodesResponse authenticationCodesResponse = this.workerApiClient.checkAuthenticationCodeRequestStatus(accessToken, authenticationCodeId);
        String status = authenticationCodesResponse.getStatus();
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        stateSupport.setAuthenticationCodeFlowRequestStatus(status);
        if ("COMPLETED".equalsIgnoreCase(status)) {
            stateSupport.setPreviousPfStatus(CommonStateSpec.MFA_COMPLETED.getStatus());
            stateSupport.setMfaCompletedCode(PingOneMfaStatus.MOBILE_LOGIN_AUTHENTICATION_CODE.toString());
            authnAdapterResponse.getUsername();
            stateSupport.setAuthenticationCodeFlowRequestUserId(authenticationCodesResponse.getUser().getId());
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            if (this.authnApiSupport.isApiRequest(req)) {
                this.pingOneMfaAuthnApiSupport.writeMfaCompletedResponse(req, resp, PingOneMfaStatus.MOBILE_LOGIN_AUTHENTICATION_CODE.toString());
            } else {
                this.sendResponsetoAJAXAuthenticationCodePollingRequest(req, resp, false, status);
            }
        } else if ("UNCLAIMED".equalsIgnoreCase(status) || "CLAIMED".equalsIgnoreCase(status)) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            if (this.authnApiSupport.isApiRequest(req)) {
                this.pingOneMfaAuthnApiSupport.writeAuthenticationCodeResponseRequiredResponse(req, resp, authenticationCodesResponse);
            } else {
                this.sendResponsetoAJAXAuthenticationCodePollingRequest(req, resp, true, status);
            }
        } else if ("DENIED".equalsIgnoreCase(status)) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            log.debug("Received claim status as \"DENIED\", so failing the authentication");
            stateSupport.setPreviousPfStatus(CommonStateSpec.MFA_FAILED.getStatus());
            if (this.authnApiSupport.isApiRequest(req)) {
                MfaFailed mfaFailed = MfaFailed.AUTHENTICATION_CODE_REQUIEST_APPROVAL_DENIED;
                this.pingOneMfaAuthnApiSupport.writeMfaFailedResponse(req, resp, mfaFailed.getMessage(), mfaFailed.getCode(), mfaFailed.getAuthnApiUserMessageKey());
            } else {
                this.sendResponsetoAJAXAuthenticationCodePollingRequest(req, resp, false, status);
            }
        } else if ("EXPIRED".equalsIgnoreCase(status)) {
            if (this.automaticAuthCodeRefreshEnabled) {
                return this.handleCreateAuthenticationCodesRequest(req, resp, inParameters, stateSupport);
            }
            stateSupport.setPreviousPfStatus(StateSpec.AUTHENTICATION_CODE_RESPONSE_REQUIRED.getStatus());
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            if (this.authnApiSupport.isApiRequest(req)) {
                this.pingOneMfaAuthnApiSupport.writeAuthenticationCodeResponseRequiredResponse(req, resp, authenticationCodesResponse);
            } else {
                this.sendResponsetoAJAXAuthenticationCodePollingRequest(req, resp, false, status);
            }
        }
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handlePollRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse flowResponse) throws IOException, AuthnErrorException, AccessTokenProviderException, JoseException, InvalidActionException {
        String status = stateSupport.getPreviousPfStatus();
        if (StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus().equals(status)) {
            return this.handleMobileActivationPollRequest(req, resp, inParameters, stateSupport);
        }
        return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
    }

    public AuthnAdapterResponse handleContinueAuthenticationRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException {
        log.debug("Received request to continue authentication flow");
        return this.onMfaSuccess(req, resp, inParameters, stateSupport);
    }

    private void setTrackerCookie(HttpServletResponse resp, String cookieDomain, String cookiePath, boolean isHttpOnly, boolean isSecureCookie, String cookieData) {
        try {
            String obfuscatedCookieData = new TrackerCookieObfuscator(false).getObfuscatedCookieData(this.envId, cookieData);
            String safeCookieValue = URLEncoder.encode(obfuscatedCookieData, "UTF-8");
            Cookie trackerCookie = new Cookie("PF_MFA_ADAPTER_TRACKER_COOKIE", safeCookieValue);
            trackerCookie.setHttpOnly(isHttpOnly);
            trackerCookie.setSecure(isSecureCookie);
            trackerCookie.setDomain(cookieDomain);
            trackerCookie.setPath(cookiePath);
            trackerCookie.setMaxAge(630720000);
            resp.addCookie(trackerCookie);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void deleteTrackerCookie(HttpServletResponse resp, String cookieDomain, String cookiePath, boolean isHttpOnly, boolean isSecureCookie) {
        Cookie trackerCookie = new Cookie("PF_MFA_ADAPTER_TRACKER_COOKIE", "");
        trackerCookie.setHttpOnly(isHttpOnly);
        trackerCookie.setSecure(isSecureCookie);
        trackerCookie.setDomain(cookieDomain);
        trackerCookie.setPath(cookiePath);
        trackerCookie.setMaxAge(0);
        resp.addCookie(trackerCookie);
    }

    private void setTrackerCookieIfRequired(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        if (this.isCookieTrackingEnabled && stateSupport.fidoDeviceUseCheck()) {
            String userId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
            Device selectedDevice = stateSupport.getSelectedFIDODevice();
            TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
            TrackerCookieData trackerCookieData = new TrackerCookieData();
            trackerCookieData.update(userId, selectedDevice.getId(), selectedDevice.getType(), selectedDevice.getNickname(), selectedDevice.getTarget());
            ObjectMapper objectMapper = ObjectMappers.getDefault();
            String trackerCookieDataString = null;
            try {
                trackerCookieDataString = objectMapper.writeValueAsString(trackerCookieData);
                this.setTrackerCookie(resp, trackerCookieInfo.getCookieDomain(), "/idp", trackerCookieInfo.isHttpOnly(), trackerCookieInfo.isSecure(), trackerCookieDataString);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
    }

    private AuthnAdapterResponse onMfaSuccess(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException {
        boolean endFlow;
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        boolean mfaCompleted = stateSupport.getMfaCompletedCode() != null;
        String pfStatus = stateSupport.getPreviousPfStatus();
        boolean isContinueFromDevicePairingMethod = StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus().equals(pfStatus);
        boolean bl = endFlow = isContinueFromDevicePairingMethod && mfaCompleted;
        if (stateSupport.isManualPairingFlow() && !endFlow) {
            this.transitionDevicePairingMethodRequired(req, resp, inParameters, stateSupport);
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        } else if (stateSupport.isUpdateNicknameDuringDevicePairing()) {
            this.transitionUpdateNicknameDuringDevicePairing(req, resp, inParameters, stateSupport);
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        } else {
            boolean mobileRequest = stateSupport.getMobileRequest();
            String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
            if (mfaCompleted) {
                this.setTrackerCookieIfRequired(req, resp, inParameters, stateSupport);
                log.debug("Returning from adapter with success, MFA is complete");
                authnAdapterResponse.setAttributeMap(this.fulfillAttributeMap(username, stateSupport.getAuthorizeResponse(), stateSupport, false));
            } else if (mobileRequest) {
                AuthorizeResponse authorizeResponse = stateSupport.getAuthorizeResponse();
                boolean isDevicePaired = this.isDevicePaired(username, authorizeResponse.getIdToken());
                log.debug("Returning from adapter with success. device paired = " + isDevicePaired);
                authnAdapterResponse.setAttributeMap(this.fulfillAttributeMap(username, authorizeResponse, stateSupport, isDevicePaired));
            } else {
                this.setTrackerCookieIfRequired(req, resp, inParameters, stateSupport);
                authnAdapterResponse.setAttributeMap(this.fulfillAttributeMap(username, null, stateSupport, true));
            }
        }
        return authnAdapterResponse;
    }

    private void transitionDevicePairingMethodRequired(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException {
        List<DevicePairingMethod> devicePairingMethods = this.getAllowedDevicePairingMethodsForUser(this.registrationPolicy, inParameters, stateSupport);
        stateSupport.setPreviousPfStatus(StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus());
        stateSupport.setDevicePairingMethods(devicePairingMethods);
        this.writeDevicePairingMethodRequiredResponse(req, resp, inParameters, devicePairingMethods);
    }

    private void removeDevice(String userId, String deviceId) throws AccessTokenProviderException {
        if (StringUtils.isBlank(userId)) {
            log.error("couldn't delete device. missing required input: userId");
            return;
        }
        if (StringUtils.isBlank(deviceId)) {
            log.error("couldn't delete device. missing required input: deviceId to be removed ");
            return;
        }
        log.debug("deleting device: " + deviceId);
        String accessToken = this.tokenService.getToken();
        try {
            this.workerApiClient.deleteDevice(accessToken, userId, deviceId);
        }
        catch (IOException e) {
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.REMOVE_DEVICE_FAILURE, deviceId, userId);
        }
    }

    private void updateUserDevicesList(PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException {
        String accessToken = this.tokenService.getToken();
        List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> getUpdatedDevicesResponse = this.workerApiClient.getUserDevices(accessToken, stateSupport.getUserId(), "status eq \"ACTIVE\"");
        List<Device> devices = ModelMapperUtil.map(getUpdatedDevicesResponse);
        for (int index = 0; index < devices.size(); ++index) {
            if (index == 0) {
                devices.get(index).setDefaultDevice(true);
                continue;
            }
            devices.get(index).setDefaultDevice(false);
        }
        stateSupport.setDevices(devices);
    }

    private Nickname updateDevice(String userId, Nickname nickname) throws AccessTokenProviderException, IOException {
        if (StringUtils.isBlank(userId)) {
            log.error("couldn't delete device. missing required input: userId");
            return null;
        }
        log.debug("starting to update device nickname for device id: " + nickname.getId());
        String accessToken = this.tokenService.getToken();
        try {
            return this.workerApiClient.updateDeviceNickname(accessToken, userId, nickname);
        }
        catch (IOException e) {
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.UPDATE_DEVICE_FAILURE, nickname.getId(), userId);
            throw e;
        }
    }

    private boolean checkEnrollmentClaim(String idTokenString, String userId, String accessToken) throws IOException {
        try {
            IdToken idToken = new IdToken(idTokenString);
            IdToken.PingOneEnrollment pingOneEnrollment = idToken.getP1Enrollment();
            String serverPayload = idToken.getP1Enrollment().getServerPayload();
            if (StringUtils.isNotBlank(serverPayload)) {
                return true;
            }
            String pairingKeyId = pingOneEnrollment.getPairingKeyId();
            PairingKey pairingKeyResponse = this.workerApiClient.getPairingKey(accessToken, userId, pairingKeyId);
            return PairingKey.Status.CLAIMED.equals((Object)pairingKeyResponse.getStatus());
        }
        catch (MalformedClaimException | InvalidJwtException exception) {
            return false;
        }
    }

    private boolean isDevicePaired(String username, String idTokenString) throws IOException, AccessTokenProviderException {
        String accessToken = this.tokenService.getToken();
        User pingOneUser = this.getUserByIdOrName(username);
        String userId = Optional.ofNullable(pingOneUser).map(User::getId).orElse(null);
        return this.checkEnrollmentClaim(idTokenString, userId, accessToken);
    }

    public AuthnAdapterResponse handleCancelAuthnRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, boolean clearTrackerCookie) {
        if (clearTrackerCookie) {
            TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
            boolean isHttpOnly = trackerCookieInfo.isHttpOnly();
            boolean isSecureCookie = trackerCookieInfo.isSecure();
            String domain = trackerCookieInfo.getCookieDomain();
            String path = trackerCookieInfo.getCookiePath();
            this.deleteTrackerCookie(resp, domain, path, isHttpOnly, isSecureCookie);
        }
        log.debug("Handling request to cancel. Returning from adapter with failure");
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setErrorMessage("User cancelled authentication.");
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleUsePasscodeRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws TemplateRendererUtilException {
        List<Device> devices = stateSupport.getDevices();
        ResourceRef selectedDeviceRef = stateSupport.getSelectedDeviceRef();
        this.pingOneMfaTemplateSupport.renderOtpRequiredTemplate(req, resp, inParameters, devices, selectedDeviceRef, this.isAddMethodPermitted(inParameters, stateSupport), 6);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleSetupMfaRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, JoseException {
        boolean previousStateIsSetupMFAAndNoUsableDevice;
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        this.validateIfSetupDeviceAllowed(inParameters, stateSupport);
        stateSupport.setIsManualPairingFlow(true);
        this.getAndStoreMFAPolicy(stateSupport);
        if (stateSupport.getBypassMfaBeforeDeviceMgmt()) {
            this.transitionDevicePairingMethodRequired(req, resp, inParameters, stateSupport);
            return authnAdapterResponse;
        }
        FlowResponse flowResponse = this.initiateFlow(req, inParameters, stateSupport);
        boolean bl = previousStateIsSetupMFAAndNoUsableDevice = this.isNoUsableDeviceError(flowResponse) && StateSpec.MFA_SETUP_REQUIRED.getStatus().equals(stateSupport.getPreviousPfStatus());
        if (previousStateIsSetupMFAAndNoUsableDevice) {
            this.transitionDevicePairingMethodRequired(req, resp, inParameters, stateSupport);
            return authnAdapterResponse;
        }
        authnAdapterResponse = this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
        return authnAdapterResponse;
    }

    private boolean isNoUsableDeviceError(FlowResponse flowResponse) {
        return Optional.of(flowResponse).filter(response -> Status.FAILED.toString().equals(flowResponse.getStatus())).map(response -> (FailedResponse)response).map(FailedResponse::getError).map(FlowError::getCode).map(code -> code.equals(FlowError.Code.NO_USABLE_DEVICES.toString())).orElse(false);
    }

    private void validateIfSetupDeviceAllowed(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AuthnErrorException {
        if (!InParamsUtil.isUserIdAuthenticated(inParameters)) {
            String errorMessage = "Users must be authenticated before MFA devices can be added.";
            AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
            authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
        if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
            String errorMessage = "MFA devices cannot be added during password reset.";
            AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
            authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
        if (!this.allowDeviceManagement && !stateSupport.getPreviousPfStatus().equals(StateSpec.MFA_SETUP_REQUIRED.getStatus()) || stateSupport.getMobileRequest()) {
            String errorMessage = "Adding additional MFA methods is not permitted.";
            AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
            authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
        if (!this.allowSetupMfa && stateSupport.getPreviousPfStatus().equals(StateSpec.MFA_SETUP_REQUIRED.getStatus()) || stateSupport.getMobileRequest()) {
            String errorMessage = "MFA set up is not permitted.";
            AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
            authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
        if (this.isUsedReachedMaxAllowedDevices(stateSupport)) {
            String errorMessage = "You've reached the limit for your authentication methods.";
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnError.setDetails(Collections.singletonList(ErrorDetailSpec.MAXIMUM_ALLOWED_METHODS_LIMIT.makeInstanceBuilder().message(errorMessage).userMessage(errorMessage).build()));
            throw new AuthnErrorException(authnError);
        }
    }

    public AuthnAdapterResponse handleSkipMfaRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AuthnErrorException, AccessTokenProviderException {
        String userId = this.getUserId(stateSupport, inParameters);
        this.validateIfAllowToSkipMfa(stateSupport, userId);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        authnAdapterResponse.setAttributeMap(this.fulfillBypassedAttributeMap(username, false, true));
        LOG.log(PingOneMfaIdpAdapterLogEvent.MFA_SKIPPED);
        return authnAdapterResponse;
    }

    private void validateIfAllowToSkipMfa(PingOneMfaStateSupport stateSupport, String username) throws AuthnErrorException, AccessTokenProviderException, IOException {
        if (this.allowSkipMfa && "MFA_SETUP_REQUIRED".equals(stateSupport.getPreviousPfStatus()) && this.getUserDevicesFromPingOne(username).isEmpty()) {
            return;
        }
        log.debug("Skip MFA request received but 'Allow Users to Skip MFA Setup' is not allowed.");
        AuthnError authnError = CommonErrorSpec.INVALID_REQUEST.makeInstance();
        authnError.setDetails(Collections.singletonList(new AuthnErrorDetail.Builder().message("Allow Users to Skip MFA Setup is not allowed.").build()));
        throw new AuthnErrorException(authnError);
    }

    public AuthnAdapterResponse handleSelectDevicePairingMethodRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AuthnErrorException, AccessTokenProviderException, InvalidActionException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        DevicePairingMethod devicePairingMethod = (DevicePairingMethod)DEVICE_PAIRING_METHOD_PARAM_MAPPING.getValue(req);
        List<DevicePairingMethod> devicePairingMethods = stateSupport.getDevicePairingMethods();
        String userId = this.getUserId(stateSupport, inParameters);
        if (!devicePairingMethods.contains(devicePairingMethod)) {
            if (this.authnApiSupport.isApiRequest(req)) {
                AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                authnError.setDetails(Collections.singletonList(ErrorDetailSpec.INVALID_DEVICE_PAIRING_METHOD.makeInstance()));
                throw new AuthnErrorException(authnError);
            }
            log.debug("An invalid device pairing method was submitted.");
            this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
            return authnAdapterResponse;
        }
        Device.Type deviceType = Device.Type.fromName(devicePairingMethod.getDeviceType());
        switch (deviceType) {
            case ANDROID: 
            case IPHONE: {
                return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
            }
            case MOBILE: {
                this.handleSelectMobileDevicePairingMethodRequest(req, resp, inParameters, stateSupport, (MobileDevicePairingMethod)devicePairingMethod);
                break;
            }
            case SMS: 
            case VOICE: 
            case EMAIL: 
            case WHATSAPP: {
                String status = ((OfflineDevicePairingMethod)devicePairingMethod).getAuthnStateSpecForPairingTargetRequired().getStatus();
                stateSupport.setPreviousPfStatus(status);
                this.writeOfflinePairingRequiredResponse(req, resp, inParameters, stateSupport, deviceType.getName(), null, null);
                break;
            }
            case TOTP: {
                stateSupport.setPreviousPfStatus(StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus());
                this.writeTotpActivationRequiredResponse(req, resp, inParameters, stateSupport, userId, true);
                break;
            }
            case PLATFORM: {
                ((WebAuthnDevicePairingMethod)devicePairingMethod).setUserAgent(req.getHeader("User-Agent"));
                stateSupport.setPreviousPfStatus(StateSpec.PLATFORM_ACTIVATION_REQUIRED.getStatus());
            }
            case SECURITY_KEY: {
                stateSupport.setPreviousPfStatus(StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED.getStatus());
            }
            case FIDO2: {
                stateSupport.setPreviousPfStatus(StateSpec.FIDO2_ACTIVATION_REQUIRED.getStatus());
                this.writeWebAuthnActivationRequiredResponse(req, resp, inParameters, stateSupport, userId, true, (WebAuthnDevicePairingMethod)devicePairingMethod);
            }
        }
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleCancelDevicePairingRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        if (StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus().equals(stateSupport.getPreviousPfStatus()) && stateSupport.getDevicePairingErrorDetail() != null) {
            this.removeFailedActivationRequiredDevice(stateSupport, inParameters);
            return this.returnToDevicePairingRequiredState(req, resp, inParameters, stateSupport);
        }
        if (StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus().equals(stateSupport.getPreviousPfStatus())) {
            if (stateSupport.getDevicePairingErrorDetail() != null) {
                return this.returnToDevicePairingRequiredState(req, resp, inParameters, stateSupport);
            }
            String mfaCompletedCode = stateSupport.getMfaCompletedCode();
            if (StringUtils.isNotEmpty(mfaCompletedCode)) {
                stateSupport.setIsManualPairingFlow(false);
                authnAdapterResponse = this.onMfaSuccess(req, resp, inParameters, stateSupport);
            } else if (stateSupport.getDevices() != null && !stateSupport.getDevices().isEmpty()) {
                com.pingidentity.sdk.api.authn.model.User user = this.getAndStoreUser(inParameters, stateSupport);
                stateSupport.setIsManualPairingFlow(false);
                stateSupport.setPreviousPfStatus(StateSpec.DEVICE_SELECTION_REQUIRED.getStatus());
                this.writeDeviceSelectionRequiredResponse(req, resp, inParameters, stateSupport, stateSupport.getDevices(), user);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            } else {
                stateSupport.setPreviousPfStatus(StateSpec.MFA_SETUP_REQUIRED.getStatus());
                this.writeMfaSetupRequiredResponse(req, resp, inParameters);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            }
        } else {
            this.removeFailedActivationRequiredDevice(stateSupport, inParameters);
            stateSupport.setPreviousPfStatus(StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus());
            List<DevicePairingMethod> devicePairingMethods = stateSupport.getDevicePairingMethods();
            this.writeDevicePairingMethodRequiredResponse(req, resp, inParameters, devicePairingMethods);
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse returnToDevicePairingRequiredState(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        stateSupport.removePreviousPfStatus();
        stateSupport.setPreviousPfStatus(StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus());
        stateSupport.removeDevicePairingErrorDetail();
        stateSupport.removeMfaFailedCode();
        List<DevicePairingMethod> devicePairingMethods = stateSupport.getDevicePairingMethods();
        this.writeDevicePairingMethodRequiredResponse(req, resp, inParameters, devicePairingMethods);
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void removeFailedActivationRequiredDevice(PingOneMfaStateSupport stateSupport, Map<String, Object> inParameters) throws AccessTokenProviderException, IOException {
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device activationRequiredDevice = stateSupport.getActivationRequiredDevice();
        if (activationRequiredDevice != null) {
            String accessToken = this.tokenService.getToken();
            String userId = this.getUserId(stateSupport, inParameters);
            this.workerApiClient.deleteDevice(accessToken, userId, activationRequiredDevice.getId());
            stateSupport.removeActivationRequiredDevice();
        }
    }

    public AuthnAdapterResponse handleSubmitOfflineDeviceTargetRequest(TemplateParameter parameterName, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        this.validateIfDeviceCreationAllowed(stateSupport);
        String deviceType = parameterName.toString().split("[.]")[0];
        Class<? extends SubmitOfflineDeviceTarget> classType = this.getExpectedClassByParameter(parameterName);
        Boolean isTestMode = (Boolean)new ParamMapping("testMode", classType, SubmitOfflineDeviceTarget::getTestMode, Boolean::valueOf).getValue(req);
        this.validateTestMode(isTestMode, req, inParameters);
        String target = (String)new ParamMapping(parameterName.toString(), classType, SubmitOfflineDeviceTarget::getTarget, Function.identity()).getValue(req);
        if (!this.authnApiSupport.isApiRequest(req) && this.allowOnlyPredefineValuesForPhoneOrEmailDevices) {
            OfflineDevicePairingMethod offlineDevicePairingMethod = (OfflineDevicePairingMethod)stateSupport.getDevicePairingMethods().stream().filter(pairingMethod -> pairingMethod.getDeviceType().equalsIgnoreCase(deviceType)).findFirst().get();
            target = offlineDevicePairingMethod.getAllowedValue();
        }
        this.validateDeviceTargetInput(target, stateSupport);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        String userId = this.getUserId(stateSupport, inParameters);
        OfflineDeviceRequest offlineDeviceRequest = this.builfOfflineDeviceRequest(deviceType, target, inParameters, LocaleUtil.getUserLocale((HttpServletRequest)req), isTestMode);
        try {
            Object offlineDevice = this.workerApiClient.createOfflineDevice(this.tokenService.getToken(), userId, offlineDeviceRequest);
            stateSupport.setPreviousPfStatus(offlineDeviceRequest.getActivationRequiredState());
            stateSupport.setActivationRequiredDevice((com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)offlineDevice);
            this.writeOfflineActivationRequiredResponse(req, resp, inParameters, (OfflineDevice)offlineDevice, stateSupport.getMfaPolicy().getOtpLifeTime(((com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)offlineDevice).getType()), this.getOtpLength(stateSupport, ((com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)offlineDevice).getType()));
        }
        catch (ApiResponseException e) {
            String templateErrorMessageKey = null;
            Object authnApiErrorMessageKey = "";
            AuthnErrorDetailSpec authnErrorDetailSpec = null;
            AuthnErrorSpec authnErrorSpec = null;
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            if (errorResponse != null && "INVALID_DATA".equals(errorResponse.getCode()) && "INVALID_VALUE".equals(errorResponse.getErrorDetailCode())) {
                templateErrorMessageKey = offlineDeviceRequest.getInvalidErrorMsgKey();
                authnApiErrorMessageKey = "pingone.mfa." + offlineDeviceRequest.getType().toString().toLowerCase() + ".pairing." + templateErrorMessageKey;
                authnErrorDetailSpec = offlineDeviceRequest.getInvalidErrorDetailSpec();
                authnErrorSpec = CommonErrorSpec.VALIDATION_ERROR;
            } else if (errorResponse != null && "REQUEST_FAILED".equals(errorResponse.getCode()) && "QUOTA_EXCEEDED".equals(errorResponse.getErrorDetailCode())) {
                templateErrorMessageKey = "daily.limit.exceed";
                authnApiErrorMessageKey = "pingone.mfa." + offlineDeviceRequest.getType().toString().toLowerCase() + ".pairing." + templateErrorMessageKey;
                authnErrorDetailSpec = CommonErrorDetailSpec.OTP_RESEND_LIMIT;
                authnErrorSpec = CommonErrorSpec.REQUEST_FAILED;
            } else if (errorResponse != null && "REQUEST_FAILED".equals(errorResponse.getCode()) && "LIMIT_EXCEEDED".equals(errorResponse.getErrorDetailCode())) {
                if (this.authnApiSupport.isApiRequest(req)) {
                    return this.handleNotificationCoolDownError(req, resp, inParameters, errorResponse, true);
                }
                templateErrorMessageKey = "notification.cooldown.temporarily_locked";
            } else {
                throw e;
            }
            this.handleOfflineDeviceActivationErrorResponse(req, resp, inParameters, stateSupport, authnErrorDetailSpec, authnErrorSpec, (String)authnApiErrorMessageKey, templateErrorMessageKey, errorResponse.getCoolDownExpiresAt());
        }
        return authnAdapterResponse;
    }

    private Class<? extends SubmitOfflineDeviceTarget> getExpectedClassByParameter(TemplateParameter parameterName) {
        switch (parameterName) {
            case SMS_PHONE: 
            case VOICE_PHONE: 
            case WHATSAPP_PHONE: {
                return SubmitPhoneDeviceTarget.class;
            }
            case EMAIL: {
                return SubmitEmailTarget.class;
            }
        }
        return SubmitOfflineDeviceTarget.class;
    }

    public AuthnAdapterResponse handleActivateWebAuthnDeviceRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        this.validateIfDeviceIsPairedInOtherSession(inParameters, stateSupport);
        String deviceAttestation = (String)ACTIVATE_WEBAUTHN_DEVICE_PARAM_MAPPING.getValue(req);
        String origin = (String)ACTIVATE_WEBAUTHN_DEVICE_ORIGIN_PARAM_MAPPING.getValue(req);
        if (StringUtils.isBlank(origin)) {
            origin = DomainInfoUtil.getBaseUrlFromRequest(inParameters, req);
        }
        String accessToken = this.tokenService.getToken();
        String userId = this.getUserId(stateSupport, inParameters);
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device activationRequiredDevice = stateSupport.getActivationRequiredDevice();
        ActivateDeviceRequest activateDeviceRequest = new ActivateDeviceRequest(origin, deviceAttestation);
        try {
            com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device activatedDevice = this.workerApiClient.activateDevice(accessToken, userId, activationRequiredDevice.getId(), activateDeviceRequest);
            Device fidoDevice = new Device();
            fidoDevice.setId(activatedDevice.getId());
            fidoDevice.setNickname(activatedDevice.getNickname());
            fidoDevice.setType(activatedDevice.getType());
            stateSupport.setSelectedDeviceType(fidoDevice);
            if (stateSupport.getMfaPolicy().isPromptForNicknameOnPairing(activatedDevice.getType())) {
                this.setStateSupportForUpdateNickname(stateSupport, activationRequiredDevice);
            }
        }
        catch (ApiResponseException e) {
            return this.handleWebAuthNActivationRequiredErrorResponse(req, resp, inParameters, stateSupport, e);
        }
        stateSupport.setIsManualPairingFlow(false);
        return this.onMfaSuccess(req, resp, inParameters, stateSupport);
    }

    private void handleOfflineDeviceActivationErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, AuthnErrorDetailSpec authnErrorDetailSpec, AuthnErrorSpec authnErrorSpec, String authnApiErrorMessageKey, String templateErrorMessageKey, Long coolDownExpiresAt) throws AuthnErrorException, IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            AuthnError authnError = authnErrorSpec.makeInstance();
            AuthnErrorDetail errorDetailSpec = authnErrorDetailSpec.makeInstanceBuilder().userMessage(this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getPingOneMfaAdapterMessage(req, authnApiErrorMessageKey)).build();
            authnError.setDetails(Collections.singletonList(errorDetailSpec));
            throw new AuthnErrorException(authnError);
        }
        if (PAIRING_OFFLINE_STATUSES.contains(stateSupport.getPreviousPfStatus())) {
            this.writeOfflinePairingRequiredResponse(req, resp, inParameters, stateSupport, this.getDeviceType(stateSupport.getPreviousPfStatus()), templateErrorMessageKey, coolDownExpiresAt);
        } else if (ACTIVATION_OFFLINE_STATUSES.contains(stateSupport.getPreviousPfStatus())) {
            OfflineDevice offlineDevice = (OfflineDevice)stateSupport.getActivationRequiredDevice();
            this.writeOfflineActivationRequiredResponse(req, resp, inParameters, offlineDevice, stateSupport.getMfaPolicy().getOtpLifeTime(offlineDevice.getType()), templateErrorMessageKey, null, this.getOtpLength(stateSupport, offlineDevice.getType()));
        } else {
            this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
        }
    }

    public AuthnAdapterResponse handleActivateOfflineDeviceRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        try {
            this.validateIfDeviceIsPairedInOtherSession(inParameters, stateSupport);
            String userId = stateSupport.getUserId();
            String accessToken = this.tokenService.getToken();
            com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device deviceToActivate = stateSupport.getActivationRequiredDevice();
            ParamMapping PARAM_MAPPING = new ParamMapping(deviceToActivate.getType().toLowerCase() + ".activation.otp", ActivateOfflineDevice.class, ActivateOfflineDevice::getOtp, Function.identity());
            String activationOtp = (String)PARAM_MAPPING.getValue(req);
            ActivateDeviceRequest activateDeviceRequest = new ActivateDeviceRequest(activationOtp);
            com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device activatedDevice = this.workerApiClient.activateDevice(accessToken, userId, deviceToActivate.getId(), activateDeviceRequest);
            stateSupport.setIsManualPairingFlow(false);
            if (stateSupport.getMfaPolicy().isPromptForNicknameOnPairing(activatedDevice.getType())) {
                this.setStateSupportForUpdateNickname(stateSupport, activatedDevice);
            }
            return this.onMfaSuccess(req, resp, inParameters, stateSupport);
        }
        catch (ApiResponseException e) {
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            if ("REQUEST_LIMITED".equals(errorResponse.getCode()) && "QUOTA_EXCEEDED".equals(errorResponse.getErrorDetailCode())) {
                this.removeFailedActivationRequiredDevice(stateSupport, inParameters);
                return this.writeIncorrectOTPLimitExceededDeviceLockedError(req, resp, inParameters, errorResponse, false);
            }
            if (ErrorResponseUtil.isInvalidOrExpiredOtp(errorResponse)) {
                this.handleInvalidActivationOtpErrorResponse(req, resp, inParameters, stateSupport, ErrorResponseUtil.getBadOtpErrorMessageKey(errorResponse), errorResponse.getAttemptsRemaining());
                AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
                return authnAdapterResponse;
            }
            throw e;
        }
    }

    private void setStateSupportForUpdateNickname(PingOneMfaStateSupport stateSupport, com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device activatedDevice) {
        stateSupport.setActivatedDevice(activatedDevice);
        stateSupport.setIsUpdateNicknameDuringDevicePairing(true);
        List devices = Optional.ofNullable(stateSupport.getDevices()).orElse(new ArrayList());
        devices.add(ModelMapperUtil.map(activatedDevice));
        stateSupport.setDevices(devices);
    }

    public void transitionUpdateNicknameDuringDevicePairing(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device acivatedDevice = stateSupport.getActivatedDevice();
        String applicationName = "";
        if (acivatedDevice.getType().equalsIgnoreCase("Mobile")) {
            applicationName = this.getMobileApplicationName(stateSupport.getDevicePairingMethods(), stateSupport.getMobilePairingKey());
        }
        stateSupport.setPreviousPfStatus(StateSpec.UPDATE_NICKNAME.getStatus());
        this.writeUpdateNickNameDuringDevicePairingResponse(req, resp, inParameters, acivatedDevice, applicationName);
    }

    public void writeUpdateNickNameDuringDevicePairingResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device device, String applicationName) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeUpdateNicknameDuringDevicePairingResponse(req, resp, device);
        } else {
            this.pingOneMfaTemplateSupport.renderUpdateNicknameDuringDevicePairingTemplate(req, resp, inParameters, device, applicationName);
        }
    }

    private void handleInvalidActivationOtpErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, String templateErrorMessageKey, Long attemptsRemaining) throws AuthnErrorException, IOException, AccessTokenProviderException {
        AuthnError authnError = null;
        CustomAuthnErrorDetail customAuthnErrorDetail = null;
        if (this.authnApiSupport.isApiRequest(req)) {
            authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            customAuthnErrorDetail = new CustomAuthnErrorDetail(CommonErrorDetailSpec.INVALID_OTP.makeInstance());
            customAuthnErrorDetail.setAttemptsRemaining(attemptsRemaining);
        }
        this.writeActivationRequiredError(req, resp, inParameters, stateSupport, authnError, customAuthnErrorDetail, "authn.api.invalid.otp", templateErrorMessageKey, attemptsRemaining);
    }

    private AuthnAdapterResponse writeActivationRequiredError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, AuthnError authnError, AuthnErrorDetail authnErrorDetail, String authnApiUserMessageKey, String templateErrorMessageKey, Long attemptsRemaining) throws AuthnErrorException, IOException, AccessTokenProviderException {
        if (this.authnApiSupport.isApiRequest(req)) {
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
                authnErrorDetail.setUserMessage(userMessage);
                authnError.setDetails(Collections.singletonList(authnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        String status = stateSupport.getPreviousPfStatus();
        if (ACTIVATION_OFFLINE_STATUSES.contains(status)) {
            OfflineDevice offlineDevice = (OfflineDevice)stateSupport.getActivationRequiredDevice();
            this.writeOfflineActivationRequiredResponse(req, resp, inParameters, offlineDevice, stateSupport.getMfaPolicy().getOtpLifeTime(offlineDevice.getType()), templateErrorMessageKey, attemptsRemaining, this.getOtpLength(stateSupport, offlineDevice.getType()));
        } else if (StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus().equals(status)) {
            TOTPDevice totpDevice = (TOTPDevice)stateSupport.getActivationRequiredDevice();
            this.writeTOTPActivationRequiredResponse(req, resp, inParameters, totpDevice, templateErrorMessageKey, attemptsRemaining, stateSupport);
        } else if (StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus().equals(status)) {
            MfaFailed mfaFailed = MfaFailed.SERVER_ERROR;
            if (stateSupport.getDevicePairingErrorDetail() != null && (FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(stateSupport.getDevicePairingErrorDetail().getCode()) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(stateSupport.getDevicePairingErrorDetail().getCode()))) {
                mfaFailed = MfaFailed.DEVICE_INTEGRITY_FAILED;
                this.writeDevicePairingMethodFailedResponse(req, resp, inParameters, stateSupport, mfaFailed);
            } else {
                this.writeMfaFailedResponse(req, resp, inParameters, mfaFailed);
            }
        } else {
            this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void writeTOTPActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, TOTPDevice totpDevice, String templateErrorMessageKey, Long attemptsRemaining, PingOneMfaStateSupport stateSupport) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeTotpActivationRequiredResponse(req, resp, totpDevice);
        } else {
            this.pingOneMfaTemplateSupport.renderTOTPDevicePairingTemplate(req, resp, inParameters, totpDevice, templateErrorMessageKey, attemptsRemaining);
        }
    }

    private void handleSelectMobileDevicePairingMethodRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, MobileDevicePairingMethod devicePairingMethod) throws AccessTokenProviderException, IOException, InvalidActionException {
        this.validateIfDeviceIsPairedInOtherSession(inParameters, stateSupport);
        String accessToken = this.tokenService.getToken();
        String userId = this.getUserId(stateSupport, inParameters);
        Optional<DevicePairingMethod> completeDevicePairingMethod = stateSupport.getDevicePairingMethods().stream().filter(it -> it.getDeviceType().equalsIgnoreCase("Mobile")).filter(it -> devicePairingMethod.getApplicationName().equals(((MobileDevicePairingMethod)it).getApplicationName())).findFirst();
        if (completeDevicePairingMethod.isPresent()) {
            Application application = new Application(((MobileDevicePairingMethod)completeDevicePairingMethod.get()).getApplicationId());
            PairingKeyRequest pairingKeyRequest = new PairingKeyRequest(application);
            pairingKeyRequest.setPolicyRef(this.registrationPolicy);
            PairingKey pairingKey = this.workerApiClient.createPairingKey(accessToken, userId, pairingKeyRequest);
            stateSupport.setMobilePairingKey(pairingKey);
            stateSupport.setPreviousPfStatus(StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus());
            this.writeMobileActivationRequiredResponse(req, resp, inParameters, devicePairingMethod.getApplicationName(), pairingKey.getCode(), true);
        } else {
            this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
        }
    }

    private AuthnAdapterResponse handleMobileActivationPollRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException, AuthnErrorException, InvalidActionException, JoseException {
        String accessToken = this.tokenService.getToken();
        String userId = stateSupport.getUserId();
        PairingKey mobilePairingKey = stateSupport.getMobilePairingKey();
        if (PairingKey.Status.UNCLAIMED.equals((Object)mobilePairingKey.getStatus())) {
            boolean continuePolling;
            PairingKey pairingKey = this.workerApiClient.getPairingKey(accessToken, userId, mobilePairingKey.getId());
            if (PairingKey.Status.CLAIMED.equals((Object)pairingKey.getStatus())) {
                stateSupport.setMobilePairingKey(pairingKey);
                if (this.authnApiSupport.isApiRequest(req)) {
                    stateSupport.setIsManualPairingFlow(false);
                    MobileDevice activatedMobileDevice = this.getActivatedMobileDevice(stateSupport);
                    if (stateSupport.getMfaPolicy().isPromptForNicknameOnPairing(activatedMobileDevice.getType())) {
                        this.setStateSupportForUpdateNickname(stateSupport, activatedMobileDevice);
                    }
                    return this.onMfaSuccess(req, resp, inParameters, stateSupport);
                }
                continuePolling = false;
            } else if (PairingKey.Status.UNCLAIMED.equals((Object)pairingKey.getStatus())) {
                continuePolling = true;
            } else {
                AuthorizeResponse authorizeResponse = stateSupport.getAuthorizeResponse();
                if (authorizeResponse != null && StringUtils.isNotBlank(authorizeResponse.getAccessToken()) && StringUtils.isNotBlank(authorizeResponse.getIdToken())) {
                    stateSupport.setMobilePairingKey(pairingKey);
                    stateSupport.setDevicePairingErrorDetail(pairingKey.getError());
                    if (this.authnApiSupport.isApiRequest(req)) {
                        stateSupport.setIsManualPairingFlow(false);
                        if (pairingKey.getError() != null && (FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(pairingKey.getError().getCode()) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(pairingKey.getError().getCode()))) {
                            ApiResponseException apiResponseException = this.getApiResponseExceptionForDevicePairingFailure(pairingKey);
                            return this.devicePairingMethodFailedServerErrorResponse(req, resp, inParameters, stateSupport, false, apiResponseException);
                        }
                        return this.onMfaSuccess(req, resp, inParameters, stateSupport);
                    }
                    continuePolling = false;
                } else {
                    if (pairingKey.getError() != null && FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(pairingKey.getError().getCode()) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(pairingKey.getError().getCode())) {
                        ApiResponseException apiResponseException = this.getApiResponseExceptionForDevicePairingFailure(pairingKey);
                        return this.devicePairingMethodFailedServerErrorResponse(req, resp, inParameters, stateSupport, false, apiResponseException);
                    }
                    return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                }
            }
            String applicationName = this.getMobileApplicationName(stateSupport.getDevicePairingMethods(), pairingKey);
            this.writeMobileActivationRequiredResponse(req, resp, inParameters, applicationName, pairingKey.getCode(), continuePolling);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return authnAdapterResponse;
        }
        if (mobilePairingKey.getError() != null && PairingKey.Status.FAILED.equals((Object)mobilePairingKey.getStatus()) && (FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(mobilePairingKey.getError().getCode()) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(mobilePairingKey.getError().getCode()))) {
            if (this.authnApiSupport.isApiRequest(req)) {
                stateSupport.setIsManualPairingFlow(false);
                return this.onMfaSuccess(req, resp, inParameters, stateSupport);
            }
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            AuthnErrorDetail authnErrorDetail = CommonErrorDetailSpec.DEVICE_ROOTED.makeInstance();
            String authnApiUserMessageKey = "authn.api.device.rooted";
            String templateErrorMessageKey = "device.integrity.failed";
            return this.writeActivationRequiredError(req, resp, inParameters, stateSupport, authnError, authnErrorDetail, authnApiUserMessageKey, templateErrorMessageKey, null);
        }
        stateSupport.setIsManualPairingFlow(false);
        MobileDevice activatedMobileDevice = this.getActivatedMobileDevice(stateSupport);
        if (stateSupport.getMfaPolicy().isPromptForNicknameOnPairing(activatedMobileDevice.getType())) {
            this.setStateSupportForUpdateNickname(stateSupport, activatedMobileDevice);
        }
        return this.onMfaSuccess(req, resp, inParameters, stateSupport);
    }

    private String getMobileApplicationName(List<DevicePairingMethod> devicePairingMethods, PairingKey pairingKey) {
        String applicationName = "";
        Optional<DevicePairingMethod> devicePairingMethodOptional = devicePairingMethods.stream().filter(devicePairingMethod -> devicePairingMethod.getDeviceType().equalsIgnoreCase("Mobile")).filter(devicePairingMethod -> pairingKey.getApplications().stream().anyMatch(application -> application.getId().equals(((MobileDevicePairingMethod)devicePairingMethod).getApplicationId()))).findFirst();
        if (devicePairingMethodOptional.isPresent()) {
            applicationName = ((MobileDevicePairingMethod)devicePairingMethodOptional.get()).getApplicationName();
        }
        return applicationName;
    }

    private MobileDevice getActivatedMobileDevice(PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException {
        List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> devices = this.workerApiClient.getUserDevices(this.tokenService.getToken(), stateSupport.getUserId(), "status eq \"ACTIVE\" and type eq \"MOBILE\"");
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device latestDevice = devices.stream().max(Comparator.comparing(com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device::getCreatedAt)).get();
        return (MobileDevice)latestDevice;
    }

    private ApiResponseException getApiResponseExceptionForDevicePairingFailure(PairingKey pairingKey) {
        if (pairingKey == null || pairingKey.getError() == null) {
            return null;
        }
        String code = pairingKey.getError().getCode();
        String message = pairingKey.getError().getMessage();
        if (StringUtils.isBlank(code)) {
            return null;
        }
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setCode(code);
        errorResponse.setMessage(message);
        return new ApiResponseException(400, message, errorResponse);
    }

    public AuthnAdapterResponse handleResendOtpRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException, InvalidActionException, AuthnErrorException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device device = stateSupport.getActivationRequiredDevice();
        String userId = this.getUserId(stateSupport, inParameters);
        String accessToken = this.tokenService.getToken();
        this.workerApiClient.deleteDevice(accessToken, userId, device.getId());
        String status = stateSupport.getPreviousPfStatus();
        if (ACTIVATION_OFFLINE_STATUSES.contains(status)) {
            this.validateIfDeviceCreationAllowed(stateSupport);
            String target = ((OfflineDevice)device).getTarget();
            OfflineDeviceRequest offlineDeviceRequest = this.builfOfflineDeviceRequest(status.toLowerCase().split("_")[0], target, inParameters, LocaleUtil.getUserLocale((HttpServletRequest)req), false);
            try {
                Object offlineDevice = this.workerApiClient.createOfflineDevice(accessToken, userId, offlineDeviceRequest);
                stateSupport.setActivationRequiredDevice((com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)offlineDevice);
                this.writeOfflineActivationRequiredResponse(req, resp, inParameters, (OfflineDevice)offlineDevice, stateSupport.getMfaPolicy().getOtpLifeTime(((com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)offlineDevice).getType()), this.getOtpLength(stateSupport, ((com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)offlineDevice).getType()));
            }
            catch (ApiResponseException e) {
                ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
                if (errorResponse != null && "REQUEST_FAILED".equals(errorResponse.getCode()) && "QUOTA_EXCEEDED".equals(errorResponse.getErrorDetailCode())) {
                    String templateErrorMessageKey = "daily.limit.exceed";
                    String authnApiErrorMessageKey = "pingone.mfa." + offlineDeviceRequest.getType().toString().toLowerCase() + ".pairing." + templateErrorMessageKey;
                    this.handleOfflineDeviceActivationErrorResponse(req, resp, inParameters, stateSupport, CommonErrorDetailSpec.OTP_RESEND_LIMIT, CommonErrorSpec.REQUEST_FAILED, authnApiErrorMessageKey, templateErrorMessageKey, null);
                }
                if (errorResponse != null && "REQUEST_FAILED".equals(errorResponse.getCode()) && "LIMIT_EXCEEDED".equals(errorResponse.getErrorDetailCode())) {
                    this.handleNotificationCoolDownError(req, resp, inParameters, errorResponse, false);
                }
                throw e;
            }
        }
        return authnAdapterResponse;
    }

    private String getUserId(PingOneMfaStateSupport stateSupport, Map<String, Object> inParameters) throws AccessTokenProviderException {
        String userId;
        if (stateSupport.getUserId() != null) {
            userId = stateSupport.getUserId();
        } else {
            String username = stateSupport.getUser().getUsername();
            User pingOneUser = this.getUserByIdOrName(username);
            userId = Optional.ofNullable(pingOneUser).map(User::getId).orElse(username);
            stateSupport.setUserId(userId);
        }
        return userId;
    }

    private FlowResponse initiateFlow(HttpServletRequest req, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException, JoseException, AuthnErrorException {
        String dynamicAppId = this.determineApplicationId(inParameters);
        String appSecret = this.appSecretCache.getAppSecret(dynamicAppId);
        String acrValues = this.getAuthnContexts(inParameters);
        String ipAddress = PingOneMfaHandler.getIpAddress(req);
        Notification notificationTemplate = this.extractNotificationTemplate(inParameters, LocaleUtil.getUserLocale((HttpServletRequest)req).toString());
        String notificationsTemplateAsString = null;
        if (notificationTemplate != null) {
            notificationsTemplateAsString = ObjectMappers.getDefault().writeValueAsString(notificationTemplate.getTemplate());
        }
        String contextForTransactionApproval = this.extractClientContext(inParameters);
        String customChallenge = this.getCustomChallenge(inParameters);
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        boolean isTestModeAllowed = "allow".equalsIgnoreCase(this.getValueFromInputSource(signedRequestClaims, "pi.testDevice"));
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        log.debug("Initiating authentication flow for user: " + username);
        String loginHintToken = LoginHintTokenUtil.generateLoginHintToken(this.authPath, dynamicAppId, appSecret, this.envId, username);
        String mobilePayload = this.getMobilePayload(req, inParameters, stateSupport);
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        String requestParam = RequestParamUtil.generateRequestParamToken(this.authPath, dynamicAppId, appSecret, this.envId, ipAddress, notificationsTemplateAsString, contextForTransactionApproval, customChallenge, dynamicData, isTestModeAllowed);
        log.debug(requestParam);
        String sessionToken = stateSupport.getSessionToken();
        String prompt = this.extractParameterFromMultipleInputSources(PROMPT_QUERY_PARAM, inParameters, List.of("com.pingidentity.adapter.input.parameter.signed.request.claims", "com.pingidentity.adapter.tracked.http.request.params"));
        FlowResponse flowResponse = this.flowsApiClient.initiateFlowPost(dynamicAppId, loginHintToken, mobilePayload, acrValues, requestParam, sessionToken, req.getHeader("User-Agent"), prompt);
        stateSupport.setFlowId(flowResponse.getId());
        this.getAndStoreMaxAllowedDevices(stateSupport);
        Optional.ofNullable(flowResponse.getSessionToken()).ifPresent(stateSupport::setSessionToken);
        if (stateSupport.getUserId() == null && flowResponse instanceof CommonFlowResponse) {
            User user = ((CommonFlowResponse)flowResponse).getUser();
            if (user == null || StringUtils.isBlank(user.getId())) {
                user = ((CommonFlowResponse)flowResponse).getEmbeddedResources().getUser();
            }
            if (user != null && StringUtils.isNotBlank(user.getId())) {
                stateSupport.setUserId(user.getId());
            }
        } else if (stateSupport.getUser() == null) {
            stateSupport.setUser(ModelMapperUtil.map(username));
        }
        return flowResponse;
    }

    private AuthnAdapterResponse handleFlowResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse flowResponse) throws IOException, AuthnErrorException, AccessTokenProviderException, JoseException {
        return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse, true);
    }

    public String getTrackerCookieData(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!"PF_MFA_ADAPTER_TRACKER_COOKIE".equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private DeviceDetails getTrackerCookieData(String rawTrackerCookieData) {
        DeviceDetails deviceDetails = null;
        if (StringUtils.isNotBlank(rawTrackerCookieData)) {
            ObjectMapper objectMapper = ObjectMappers.getDefault();
            try {
                String urlDecodedCookieData = URLDecoder.decode(rawTrackerCookieData, "UTF-8");
                String trackerCookieDecodedData = new TrackerCookieObfuscator(false).getDeObfuscatedCookieData(this.envId, urlDecodedCookieData);
                TrackerCookieData cookieDataObj = objectMapper.readValue(trackerCookieDecodedData, TrackerCookieData.class);
                deviceDetails = cookieDataObj.getDeviceDetails();
            }
            catch (JsonProcessingException | UnsupportedEncodingException iOException) {
                // empty catch block
            }
        }
        return deviceDetails;
    }

    private AuthnAdapterResponse handleFlowResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse flowResponse, boolean writeResponse) throws IOException, AuthnErrorException, AccessTokenProviderException, JoseException {
        if (StringUtils.isNotBlank(flowResponse.getSessionToken())) {
            stateSupport.setSessionToken(flowResponse.getSessionToken());
        }
        switch (Status.valueOf(flowResponse.getStatus())) {
            case SIGN_ON_REQUIRED: {
                return this.handleSignOnRequiredResponse(req, resp, inParameters, stateSupport, writeResponse);
            }
            case DEVICE_SELECTION_REQUIRED: {
                String rawTackerCookieData = this.getTrackerCookieData(req);
                if (StringUtils.isNotBlank(rawTackerCookieData) && this.isCookieTrackingEnabled) {
                    DeviceDetails deviceDetails = this.getTrackerCookieData(rawTackerCookieData);
                    try {
                        return this.triggerFIDODeviceSelection(req, resp, inParameters, stateSupport, deviceDetails, (DeviceSelectionRequiredResponse)flowResponse);
                    }
                    catch (ObsoleteDeviceException e) {
                        TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
                        this.deleteTrackerCookie(resp, trackerCookieInfo.getCookieDomain(), "/idp", trackerCookieInfo.isHttpOnly(), trackerCookieInfo.isSecure());
                        log.debug("The device id in tracker cookie is invalid, possibly device was removed on backend. So proceed with normal device selection flow.");
                    }
                }
                return this.handleDeviceSelectionRequiredResponse(req, resp, inParameters, stateSupport, (DeviceSelectionRequiredResponse)flowResponse, writeResponse);
            }
            case ASSERTION_REQUIRED: {
                return this.handleAssertionRequiredResponse(req, resp, inParameters, stateSupport, (AssertionRequiredResponse)flowResponse);
            }
            case OTP_REQUIRED: {
                return this.handleOtpRequiredResponse(req, resp, inParameters, stateSupport, (OtpRequiredResponse)flowResponse);
            }
            case PUSH_CONFIRMATION_REQUIRED: {
                return this.handlePushConfirmationRequiredResponse(req, resp, inParameters, stateSupport, (PushConfirmationRequiredResponse)flowResponse);
            }
            case PUSH_CONFIRMATION_TIMED_OUT: {
                return this.handlePushConfirmationTimedOutResponse(req, resp, inParameters, stateSupport, (PushConfirmationTimedOutResponse)flowResponse);
            }
            case COMPLETED: {
                return this.handleCompletedResponse(req, resp, inParameters, stateSupport, (CompletedResponse)flowResponse);
            }
            case FAILED: {
                return this.handleFailedResponse(req, resp, inParameters, stateSupport, (FailedResponse)flowResponse);
            }
        }
        throw new IllegalStateException("Unexpected value: " + Status.valueOf(flowResponse.getStatus()));
    }

    private void writeAuthenticationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeAuthenticationRequiredResponse(req, resp, username);
        }
    }

    private AuthnAdapterResponse handleSignOnRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, boolean writeResponse) throws IOException, AuthnErrorException, AccessTokenProviderException, JoseException {
        String flowId = stateSupport.getFlowId();
        String sessionToken = stateSupport.getSessionToken();
        String username = StringUtils.isBlank(stateSupport.getUsername()) ? (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid") : stateSupport.getUsername();
        try {
            CheckUsernameRequest checkUsernameRequest = new CheckUsernameRequest(username);
            FlowResponse flowResponse = this.flowsApiClient.checkUsername(flowId, checkUsernameRequest, sessionToken);
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse, writeResponse);
        }
        catch (ApiResponseException e) {
            List<ErrorDetail> details;
            ErrorResponse errorResponse;
            if (400 == e.getStatusCode() && (errorResponse = (ErrorResponse)e.getErrorResponse()) != null && !(details = errorResponse.getDetails()).isEmpty() && details.stream().anyMatch(detail -> "username".equalsIgnoreCase(detail.getTarget()))) {
                String userId = username;
                String accessToken = null;
                try {
                    accessToken = this.tokenService.getToken();
                }
                catch (AccessTokenProviderException accessTokenProviderException) {
                    if (accessTokenProviderException.getCause() instanceof IOException) {
                        throw (IOException)accessTokenProviderException.getCause();
                    }
                    throw accessTokenProviderException;
                }
                User user = this.workerApiClient.getUserById(accessToken, userId);
                username = user.getUsername();
                CheckUsernameRequest checkUsernameRequest = new CheckUsernameRequest(username);
                FlowResponse flowResponse = this.flowsApiClient.checkUsername(flowId, checkUsernameRequest, sessionToken);
                stateSupport.setUsername(username);
                return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse, writeResponse);
            }
            throw e;
        }
    }

    private AuthnAdapterResponse handleDeviceSelectionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, DeviceSelectionRequiredResponse deviceSelectionRequiredResponse, boolean writeResponse) throws IOException {
        List<Device> devices = this.getAndStoreDevices(deviceSelectionRequiredResponse, stateSupport, req, inParameters);
        com.pingidentity.sdk.api.authn.model.User user = this.getAndStoreUser(inParameters, stateSupport);
        if (writeResponse) {
            stateSupport.setPreviousPfStatus(StateSpec.DEVICE_SELECTION_REQUIRED.getStatus());
            this.writeDeviceSelectionRequiredResponse(req, resp, inParameters, stateSupport, devices, user);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return authnAdapterResponse;
        }
        return null;
    }

    public void writeDeviceSelectionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, List<Device> devices, com.pingidentity.sdk.api.authn.model.User user) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeDeviceSelectionRequiredResponse(req, resp, devices, user, stateSupport, this.isAddMethodPermitted(inParameters, stateSupport), stateSupport.getSupportUsePasswordPolicyAction(), this.isDevicesManagementAllowed(inParameters, stateSupport));
        } else {
            boolean shouldAggregateFidoDevices = this.shouldAggregateFidoDevices(devices, stateSupport.getIsFidoAggregationEnabled());
            this.pingOneMfaTemplateSupport.renderDeviceSelectionTemplate(req, resp, inParameters, shouldAggregateFidoDevices ? this.getDevicesWithAggregatedFido(devices) : devices, null, null, this.isAddMethodPermitted(inParameters, stateSupport), stateSupport.isManualPairingFlow(), !stateSupport.getBypassMfaBeforeDeviceMgmt(), stateSupport.getSupportUsePasswordPolicyAction(), this.isDevicesManagementAllowed(inParameters, stateSupport), shouldAggregateFidoDevices);
        }
    }

    private boolean shouldAggregateFidoDevices(List<Device> devices, boolean isFidoAggregationEnabled) {
        return isFidoAggregationEnabled && devices.stream().filter(device -> device.getType().equalsIgnoreCase(Device.Type.FIDO2.getName())).count() > 1L;
    }

    private List<Device> getDevicesWithAggregatedFido(List<Device> devices) {
        ArrayList<Device> devicesWithAggregatedFido = new ArrayList<Device>();
        boolean fidoDeviceSeen = false;
        for (Device device : devices) {
            if (!device.getType().equalsIgnoreCase(Device.Type.FIDO2.getName())) {
                devicesWithAggregatedFido.add(device);
                continue;
            }
            if (fidoDeviceSeen) continue;
            devicesWithAggregatedFido.add(device);
            fidoDeviceSeen = true;
        }
        return devicesWithAggregatedFido;
    }

    private AuthnAdapterResponse handleAssertionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, AssertionRequiredResponse assertionRequiredResponse) throws IOException, JoseException, AccessTokenProviderException, AuthnErrorException {
        List<Device> devices = this.getAndStoreDevices(assertionRequiredResponse, stateSupport, req, inParameters);
        com.pingidentity.sdk.api.authn.model.User user = this.getAndStoreUser(inParameters, stateSupport);
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device selectedDevice = assertionRequiredResponse.getFullObjectSelectedDevice();
        if (selectedDevice == null) {
            selectedDevice = assertionRequiredResponse.getEmbeddedResources().getDevices().get(0);
        }
        String id = selectedDevice.getId();
        boolean isValidDevice = devices.stream().anyMatch(device -> device.getId().equals(id) && device.isUsable());
        if (!isValidDevice && !this.authnApiSupport.isApiRequest(req)) {
            if (devices.size() > 1) {
                return this.handleSelectDeviceRequest(req, resp, inParameters, stateSupport, assertionRequiredResponse);
            }
            log.debug("The only FIDO device that is paired by this user is with different domain. So canceling authentication since user has no other valid device to use.");
            return this.handleCancelAuthnRequest(req, resp, inParameters, false);
        }
        String publicKeyCredentialRequestStr = assertionRequiredResponse.getPublicKeyCredentialRequestOptions();
        ResourceRef selectedDeviceRef = this.getAndStoreSelectedDeviceRef(id, stateSupport);
        stateSupport.setPreviousPfStatus(StateSpec.ASSERTION_REQUIRED.getStatus());
        PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions = ObjectMappers.getDefault().readValue(publicKeyCredentialRequestStr, PublicKeyCredentialRequestOptions.class);
        this.writeAssertionRequiredResponse(req, resp, inParameters, stateSupport, devices, user, selectedDeviceRef, publicKeyCredentialRequestOptions);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleOtpRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, OtpRequiredResponse otpRequiredResponse) throws IOException, AccessTokenProviderException {
        List<Device> devices = this.getAndStoreDevices(otpRequiredResponse, stateSupport, req, inParameters);
        com.pingidentity.sdk.api.authn.model.User user = this.getAndStoreUser(inParameters, stateSupport);
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device selectedDevice = otpRequiredResponse.getFullObjectSelectedDevice();
        stateSupport.setPreviousPfStatus(StateSpec.OTP_REQUIRED.getStatus());
        String id = selectedDevice.getId();
        this.getAndStoreSelectedDeviceRef(id, stateSupport);
        this.writeOtpRequiredResponse(req, resp, inParameters, stateSupport, devices, user, otpRequiredResponse);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void writeUsernamelessAssertionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeUsernamelessFlowAssertionRequiredResponse(req, resp, publicKeyCredentialRequestOptions);
        } else {
            this.pingOneMfaTemplateSupport.renderUsernamelessFlowAssertionRequiredTemplate(req, resp, inParameters, publicKeyCredentialRequestOptions, this.isAddMethodPermitted(inParameters, stateSupport));
        }
    }

    private void writeAssertionRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, List<Device> devices, com.pingidentity.sdk.api.authn.model.User user, ResourceRef selectedDeviceRef, PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeAssertionRequiredResponse(req, resp, devices, user, selectedDeviceRef, publicKeyCredentialRequestOptions, stateSupport, this.isAddMethodPermitted(inParameters, stateSupport), this.isDevicesManagementAllowed(inParameters, stateSupport));
        } else {
            this.pingOneMfaTemplateSupport.renderAssertionRequiredTemplate(req, resp, inParameters, devices, selectedDeviceRef, publicKeyCredentialRequestOptions, this.isAddMethodPermitted(inParameters, stateSupport));
        }
    }

    private void writeOtpRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, List<Device> devices, com.pingidentity.sdk.api.authn.model.User user, OtpRequiredResponse otpRequiredResponse) throws IOException, AccessTokenProviderException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.getAndStoreMFAPolicy(stateSupport);
            String otp = Optional.ofNullable(otpRequiredResponse.getTest()).map(Test::getOTP).orElse(null);
            this.pingOneMfaAuthnApiSupport.writeOtpRequiredResponse(req, resp, devices, user, otp, stateSupport, this.isAddMethodPermitted(inParameters, stateSupport), this.isDevicesManagementAllowed(inParameters, stateSupport), stateSupport.getMfaPolicy().getOtpLifeTime(otpRequiredResponse.getFullObjectSelectedDevice().getType()));
        } else {
            this.pingOneMfaTemplateSupport.renderOtpRequiredTemplate(req, resp, inParameters, devices, stateSupport.getSelectedDeviceRef(), this.isAddMethodPermitted(inParameters, stateSupport), this.getOtpLength(otpRequiredResponse));
        }
    }

    private AuthnAdapterResponse handlePushConfirmationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PushConfirmationRequiredResponse pushConfirmationRequiredResponse) throws IOException {
        List<Device> devices = this.getAndStoreDevices(pushConfirmationRequiredResponse, stateSupport, req, inParameters);
        com.pingidentity.sdk.api.authn.model.User user = this.getAndStoreUser(inParameters, stateSupport);
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device selectedDevice = pushConfirmationRequiredResponse.getFullObjectSelectedDevice();
        if (selectedDevice == null) {
            if (devices.size() == 1) {
                selectedDevice = pushConfirmationRequiredResponse.getEmbeddedResources().getDevices().get(0);
            } else {
                selectedDevice = new MobileDevice();
                selectedDevice.setId("");
            }
        }
        AuthSession authSession = pushConfirmationRequiredResponse.getAuthSession();
        AuthSession.NumberMatching numberMatching = null;
        if (authSession != null) {
            stateSupport.setAuthSessionType(authSession.getType());
            numberMatching = authSession.getNumberMatching();
        }
        String id = selectedDevice.getId();
        ResourceRef selectedDeviceRef = this.getAndStoreSelectedDeviceRef(id, stateSupport);
        stateSupport.setPreviousPfStatus(StateSpec.PUSH_CONFIRMATION_WAITING.getStatus());
        this.writePushConfirmationWaitingResponse(req, resp, inParameters, stateSupport, devices, user, selectedDeviceRef, numberMatching);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void writePushConfirmationWaitingResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, List<Device> devices, com.pingidentity.sdk.api.authn.model.User user, ResourceRef selectedDeviceRef, AuthSession.NumberMatching numberMatching) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writePushConfirmationWaitingResponse(req, resp, devices, user, selectedDeviceRef, stateSupport, this.isAddMethodPermitted(inParameters, stateSupport), this.isDevicesManagementAllowed(inParameters, stateSupport), numberMatching);
        } else {
            Device selectedDevice = this.getDevice(devices, selectedDeviceRef.getId());
            if (selectedDevice == null) {
                selectedDevice = new Device();
                selectedDevice.setId("");
                selectedDevice.setName("");
            }
            this.pingOneMfaTemplateSupport.renderPushConfirmationWaitingResponse(req, resp, inParameters, selectedDevice, devices, this.isAddMethodPermitted(inParameters, stateSupport), numberMatching);
        }
    }

    private AuthnAdapterResponse sendPollingRequestResponse(HttpServletResponse resp, PollingRequestResponse pollingRequestResponse) {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        resp.setContentType(ContentType.APPLICATION_JSON.toString());
        try (PrintWriter writer = resp.getWriter();){
            String response = ObjectMappers.getDefault().writeValueAsString(pollingRequestResponse);
            writer.write(response);
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        }
        catch (IOException ignored) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handlePushConfirmationTimedOutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PushConfirmationTimedOutResponse pushConfirmationTimedOutResponse) throws IOException {
        if (Boolean.parseBoolean(req.getParameter(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString()))) {
            PollingRequestResponse pollingRequestResponse = new PollingRequestResponse("PUSH_CONFIRMATION_TIMED_OUT", false);
            return this.sendPollingRequestResponse(resp, pollingRequestResponse);
        }
        List<Device> devices = this.getAndStoreDevices(pushConfirmationTimedOutResponse, stateSupport, req, inParameters);
        com.pingidentity.sdk.api.authn.model.User user = this.getAndStoreUser(inParameters, stateSupport);
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device selectedDevice = pushConfirmationTimedOutResponse.getFullObjectSelectedDevice();
        if (selectedDevice == null) {
            selectedDevice = pushConfirmationTimedOutResponse.getEmbeddedResources().getDevices().get(0);
        }
        String id = selectedDevice.getId();
        ResourceRef selectedDeviceRef = this.getAndStoreSelectedDeviceRef(id, stateSupport);
        stateSupport.setPreviousPfStatus(StateSpec.PUSH_CONFIRMATION_TIMED_OUT.getStatus());
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        boolean displayTimeoutScreen = this.showTimeoutScreen;
        if (dynamicData != null) {
            if (dynamicData.getPingIdSdkSkipTimeoutScreens() != null) {
                boolean bl = displayTimeoutScreen = dynamicData.getPingIdSdkSkipTimeoutScreens() == false;
            }
            if (dynamicData.getPingoneMfaSkipTimeoutScreens() != null) {
                boolean bl = displayTimeoutScreen = dynamicData.getPingoneMfaSkipTimeoutScreens() == false;
            }
        }
        if (!this.authnApiSupport.isApiRequest(req) && !displayTimeoutScreen) {
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
            return authnAdapterResponse;
        }
        this.writePushConfirmationTimedOutResponse(req, resp, inParameters, stateSupport, devices, user, selectedDeviceRef);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void writePushConfirmationTimedOutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, List<Device> devices, com.pingidentity.sdk.api.authn.model.User user, ResourceRef selectedDeviceRef) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writePushConfirmationTimedOutResponse(req, resp, devices, user, selectedDeviceRef, stateSupport, this.isAddMethodPermitted(inParameters, stateSupport));
        } else {
            Device selectedDevice = this.getDevice(devices, selectedDeviceRef.getId());
            this.pingOneMfaTemplateSupport.renderPushConfirmationTimedOutResponse(req, resp, inParameters, selectedDevice, devices, this.isAddMethodPermitted(inParameters, stateSupport));
        }
    }

    private void writePushConfirmationRejectedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, List<Device> devices, com.pingidentity.sdk.api.authn.model.User user, ResourceRef selectedDeviceRef) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writePushConfirmationRejectedResponse(req, resp, devices, user, selectedDeviceRef, CustomPushConfirmationRejected.Reason.DENIED_BY_USER, stateSupport, this.isAddMethodPermitted(inParameters, stateSupport));
        } else {
            Device selectedDevice = null;
            if (selectedDeviceRef != null) {
                selectedDevice = this.getDevice(devices, selectedDeviceRef.getId());
            }
            this.pingOneMfaTemplateSupport.renderPushConfirmationRejectedResponse(req, resp, inParameters, selectedDevice, this.isAddMethodPermitted(inParameters, stateSupport));
        }
    }

    private void writeMfaSetupRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeMfaSetupRequiredResponse(req, resp, this.allowSkipMfa);
        } else {
            this.pingOneMfaTemplateSupport.renderMfaSetupTemplate(req, resp, inParameters);
        }
    }

    private void writeDevicePairingMethodRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, List<DevicePairingMethod> devicePairingMethods) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeDevicePairingMethodRequiredResponse(req, resp, devicePairingMethods);
        } else {
            this.pingOneMfaTemplateSupport.renderDevicePairingTemplate(req, resp, inParameters, devicePairingMethods, "");
        }
    }

    private void writeOfflinePairingRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, String deviceType, String templateErrorMessageKey, Long coolDownExpiresAt) throws IOException {
        OfflineDevicePairingMethod pairingMethod = stateSupport.getDevicePairingMethods().stream().filter(pm -> pm.getDeviceType().equalsIgnoreCase(deviceType)).findFirst().orElse(null);
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeOfflinePairingRequiredResponse(req, resp, pairingMethod.getMaskedAllowedValue(), pairingMethod.getAuthnStateSpecForPairingTargetRequired());
        } else {
            this.pingOneMfaTemplateSupport.renderOfflinePairingTemplate(req, resp, inParameters, templateErrorMessageKey, pairingMethod, coolDownExpiresAt);
        }
    }

    private void writeMobileActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String applicationName, String mobilePairingKey, boolean continuePolling) throws IOException, InvalidActionException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeMobileActivationRequiredResponse(req, resp, applicationName, mobilePairingKey);
        } else if (this.pingOneMfaTemplateSupport.isPollRequest(req, StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus())) {
            PollingRequestResponse pollingRequestResponse = new PollingRequestResponse(StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus(), continuePolling);
            this.sendPollingRequestResponse(resp, pollingRequestResponse);
        } else {
            this.pingOneMfaTemplateSupport.renderMobileActivationTemplate(req, resp, inParameters, applicationName, mobilePairingKey);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private AuthnAdapterResponse handleWebAuthNActivationRequiredErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, ApiResponseException e) throws AuthnErrorException, TemplateRendererUtilException {
        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device activationRequiredDevice = stateSupport.getActivationRequiredDevice();
        String errorMessageKey = "generic.error";
        String errorMessage = null;
        if (e.getErrorResponse() != null) {
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            log.debug("Error response details: " + errorResponse.getPrettyErrorDetails());
            String code = errorResponse.getCode();
            errorMessage = errorResponse.getMessage();
            switch (code) {
                case "INVALID_DATA": 
                case "REQUEST_FAILED": {
                    String errorDetailCode;
                    switch (errorDetailCode = errorResponse.getErrorDetailCode()) {
                        case "INVALID_VALUE": {
                            errorMessageKey = "validation.error";
                            break;
                        }
                        case "CONSTRAINT_VIOLATION": {
                            if (!"WEBAUTHN_ACTIVATION_REQUIRED".equalsIgnoreCase(stateSupport.getPreviousPfStatus())) break;
                            errorMessageKey = "assertion.policy.error";
                        }
                    }
                    break;
                }
            }
        }
        if (!this.authnApiSupport.isApiRequest(req)) {
            List<DevicePairingMethod> devicePairingMethods = stateSupport.getDevicePairingMethods();
            this.pingOneMfaTemplateSupport.renderDevicePairingTemplate(req, resp, inParameters, devicePairingMethods, errorMessageKey);
            AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return authnAdapterResponse;
        }
        AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
        AuthnErrorDetail authnErrorDetail = ErrorDetailSpec.INVALID_DATA_DEVICE_PAIRING_METHOD.makeInstance();
        if (StringUtils.isNotBlank(errorMessage)) {
            authnErrorDetail.setMessage(errorMessage);
        }
        authnError.setDetails(Collections.singletonList(authnErrorDetail));
        throw new AuthnErrorException(authnError);
    }

    private void writeTotpActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, String userId, boolean createDevice) throws IOException, AccessTokenProviderException {
        TOTPDevice totpDevice;
        if (createDevice) {
            TOTPDeviceRequest totpDeviceRequest = new TOTPDeviceRequest();
            String accessToken = this.tokenService.getToken();
            totpDevice = this.workerApiClient.createTOTPDevice(accessToken, userId, totpDeviceRequest);
            stateSupport.setActivationRequiredDevice(totpDevice);
        } else {
            totpDevice = (TOTPDevice)stateSupport.getActivationRequiredDevice();
        }
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeTotpActivationRequiredResponse(req, resp, totpDevice);
        } else {
            this.pingOneMfaTemplateSupport.renderTOTPDevicePairingTemplate(req, resp, inParameters, totpDevice, null, null);
        }
    }

    private void writeWebAuthnActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, String userId, boolean createDevice, WebAuthnDevicePairingMethod devicePairingMethod) throws IOException, AccessTokenProviderException {
        WebAuthnDevice webAuthnDevice;
        if (createDevice) {
            String currentDomain = DomainInfoUtil.getCurrentDomain(inParameters, req);
            if (devicePairingMethod != null && StringUtils.isNotBlank(devicePairingMethod.getRelyingPartyId())) {
                currentDomain = devicePairingMethod.getRelyingPartyId();
            }
            String relyingPartyName = "PingFederate";
            if (devicePairingMethod != null && StringUtils.isNotBlank(devicePairingMethod.getRelyingPartyName())) {
                relyingPartyName = devicePairingMethod.getRelyingPartyName();
            }
            String accessToken = this.tokenService.getToken();
            WebAuthnDeviceRequest webAuthnDeviceRequest = new WebAuthnDeviceRequest(DeviceRequest.Type.valueOf(devicePairingMethod.getDeviceType()), null, currentDomain, relyingPartyName);
            webAuthnDeviceRequest.setPolicyRef(this.registrationPolicy);
            Optional.ofNullable(this.getCustomChallenge(inParameters)).ifPresent(webAuthnDeviceRequest::setChallenge);
            webAuthnDevice = this.workerApiClient.createWebAuthnDevice(accessToken, userId, webAuthnDeviceRequest);
            String deviceType = webAuthnDevice.getType();
            if (Device.Type.FIDO2.toString().equalsIgnoreCase(deviceType)) {
                WebAuthnDevicePairingMethod pairingMethodWithDisplayName = (WebAuthnDevicePairingMethod)stateSupport.getDevicePairingMethods().stream().filter(pairingMethod -> FIDO2Device.TYPE.equalsIgnoreCase(pairingMethod.getDeviceType())).findFirst().get();
                ((FIDO2Device)webAuthnDevice).setDefaultDisplayName(Optional.ofNullable(pairingMethodWithDisplayName).map(WebAuthnDevicePairingMethod::getDisplayNameKey).orElse(null));
            }
            stateSupport.setActivationRequiredDevice(webAuthnDevice);
        } else {
            webAuthnDevice = (WebAuthnDevice)stateSupport.getActivationRequiredDevice();
        }
        String deviceType = webAuthnDevice.getType();
        if (Device.Type.FIDO2.toString().equalsIgnoreCase(deviceType)) {
            WebAuthnDevicePairingMethod pairingMethodWithDisplayName = (WebAuthnDevicePairingMethod)stateSupport.getDevicePairingMethods().stream().filter(pairingMethod -> FIDO2Device.TYPE.equalsIgnoreCase(pairingMethod.getDeviceType())).findFirst().get();
            ((FIDO2Device)webAuthnDevice).setDefaultDisplayName(Optional.ofNullable(pairingMethodWithDisplayName).map(WebAuthnDevicePairingMethod::getDisplayNameKey).orElse(null));
        }
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeWebAuthnActivationRequiredResponse(req, resp, webAuthnDevice);
        } else {
            this.pingOneMfaTemplateSupport.renderWebAuthnDevicePairingTemplate(req, resp, inParameters, webAuthnDevice, "");
        }
    }

    private void writeOfflineActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OfflineDevice device, OfflineDeviceAvailableMethod.Otp.Lifetime otpLifeTime, int otpLength) throws IOException {
        this.writeOfflineActivationRequiredResponse(req, resp, inParameters, device, otpLifeTime, null, null, otpLength);
    }

    private void writeOfflineActivationRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OfflineDevice device, OfflineDeviceAvailableMethod.Otp.Lifetime otpLifeTime, String templateErrorMessageKey, Long attemptsRemaining, int otpLength) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeOfflineActivationRequiredResponse(req, resp, device, otpLifeTime);
        } else {
            this.pingOneMfaTemplateSupport.renderOfflineActivationTemplate(req, resp, inParameters, device, templateErrorMessageKey, attemptsRemaining, otpLength);
        }
    }

    private AuthnAdapterResponse handleCompletedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, CompletedResponse completedResponse) throws IOException, AuthnErrorException, AccessTokenProviderException, JoseException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        if (Boolean.parseBoolean(req.getParameter(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString()))) {
            PollingRequestResponse pollingRequestResponse = new PollingRequestResponse("COMPLETED", false);
            return this.sendPollingRequestResponse(resp, pollingRequestResponse);
        }
        AuthorizeResponse authorizeResponse = completedResponse.getAuthorizeResponse();
        String sessionToken = stateSupport.getSessionToken();
        if (authorizeResponse == null) {
            String flowId = stateSupport.getFlowId();
            FlowResponse flowResponse = this.flowsApiClient.resume(flowId, sessionToken);
            authnAdapterResponse = this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
        } else {
            stateSupport.setAuthorizeResponse(authorizeResponse);
            String idTokenString = authorizeResponse.getIdToken();
            IdToken.PingOneEnrollment pingOneEnrollment = null;
            try {
                IdToken idToken = new IdToken(idTokenString, this.authPath + "/" + this.envId + "/as/jwks", this.authPath + "/" + this.envId + "/as", this.applicationId);
                pingOneEnrollment = idToken.getP1Enrollment();
            }
            catch (MalformedClaimException | InvalidJwtException idToken) {
                // empty catch block
            }
            if (pingOneEnrollment != null) {
                if (this.authnApiSupport.isApiRequest(req) && "SUCCESS".equals(pingOneEnrollment.getStatus())) {
                    stateSupport.setPreviousPfStatus(CommonStateSpec.MOBILE_PAIRING_REQUIRED.getStatus());
                    this.pingOneMfaAuthnApiSupport.writeMobilePairingRequiredResponse(req, resp, idTokenString);
                } else {
                    authnAdapterResponse = this.onMfaSuccess(req, resp, inParameters, stateSupport);
                }
            } else {
                String mfaCompletedCode = "";
                Pair<PingOneMfaStatus, PingOneMfaStatus.Reason> pingOneMfaStatus = this.getPingOneMfaStatus(authorizeResponse, stateSupport, false);
                if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters) && pingOneMfaStatus.getLeft() == PingOneMfaStatus.WEB_LOGIN_NO_DEVICES) {
                    log.debug("Blocking account reset flow for MFA bypassed user or user with no usable devices. Returning failure.");
                    authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                    return authnAdapterResponse;
                }
                if (pingOneMfaStatus.getLeft() != null) {
                    mfaCompletedCode = pingOneMfaStatus.getLeft().toString();
                }
                stateSupport.setMfaCompletedCode(mfaCompletedCode);
                stateSupport.setPreviousPfStatus(CommonStateSpec.MFA_COMPLETED.getStatus());
                DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
                boolean displaySuccessScreen = this.showSuccessScreen;
                if (dynamicData != null) {
                    if (dynamicData.getPingIdSdkSkipSuccessScreens() != null) {
                        boolean bl = displaySuccessScreen = dynamicData.getPingIdSdkSkipSuccessScreens() == false;
                    }
                    if (dynamicData.getPingoneMfaSkipSuccessScreens() != null) {
                        boolean bl = displaySuccessScreen = dynamicData.getPingoneMfaSkipSuccessScreens() == false;
                    }
                }
                if (stateSupport.getDeviceToRemoveId() != null) {
                    this.removeDevice(stateSupport.getUserId(), stateSupport.getDeviceToRemoveId());
                    stateSupport.removeDeviceToRemoveId();
                    this.updateUserDevicesList(stateSupport);
                }
                if (stateSupport.getUpdatedNickname() != null) {
                    Nickname updatedNickName = this.updateDevice(stateSupport.getUserId(), stateSupport.getUpdatedNickname());
                    Device updatedDevice = stateSupport.getDevices().stream().filter(device -> device.getId().equals(stateSupport.getUpdatedNickname().getId())).findFirst().get();
                    updatedDevice.setNickname(updatedNickName.getNickname());
                    stateSupport.removeUpdatedDevice();
                }
                if (this.authnApiSupport.isApiRequest(req) || displaySuccessScreen) {
                    this.writeMfaCompletedResponse(req, resp, inParameters, mfaCompletedCode, stateSupport);
                } else {
                    if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                        stateSupport.removeSessionToken();
                        try {
                            this.flowsApiClient.signoff(sessionToken);
                        }
                        catch (IOException e) {
                            log.error("Error revoking PingOne session during account recovery", e);
                        }
                    }
                    authnAdapterResponse = this.onMfaSuccess(req, resp, inParameters, stateSupport);
                }
            }
        }
        return authnAdapterResponse;
    }

    private void writeMfaCompletedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, String mfaCompletedCode, PingOneMfaStateSupport stateSupport) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeMfaCompletedResponse(req, resp, mfaCompletedCode);
        } else {
            this.pingOneMfaTemplateSupport.renderMfaCompletedResponse(req, resp, inParameters, stateSupport);
        }
    }

    private AuthnAdapterResponse handleFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FailedResponse failedResponse) throws IOException, AuthnErrorException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        if (Boolean.parseBoolean(req.getParameter(TemplateParameter.POLL_AUTHENTICATION_STATUS.toString()))) {
            PollingRequestResponse pollingRequestResponse = new PollingRequestResponse("FAILED", false);
            return this.sendPollingRequestResponse(resp, pollingRequestResponse);
        }
        FlowError error = failedResponse.getError();
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        MfaFailed mfaFailed = MfaFailed.SERVER_ERROR;
        if (error != null) {
            String message = failedResponse.getError().getMessage();
            String code = failedResponse.getError().getCode();
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.MFA_FAILED, message);
            if (FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(code) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(code)) {
                mfaFailed = MfaFailed.DEVICE_INTEGRITY_FAILED;
            } else {
                if (FlowError.Code.USER_DENIED.name().equals(error.getCode())) {
                    List<Device> devices = stateSupport.getDevices();
                    com.pingidentity.sdk.api.authn.model.User user = stateSupport.getUser();
                    ResourceRef selectedDeviceRef = stateSupport.getSelectedDeviceRef();
                    stateSupport.setPreviousPfStatus(StateSpec.PUSH_CONFIRMATION_REJECTED.getStatus());
                    DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
                    boolean displayErrorScreen = this.showErrorScreen;
                    if (dynamicData != null) {
                        if (dynamicData.getPingIdSdkSkipErrorScreens() != null) {
                            boolean bl = displayErrorScreen = dynamicData.getPingIdSdkSkipErrorScreens() == false;
                        }
                        if (dynamicData.getPingoneMfaSkipErrorScreens() != null) {
                            boolean bl = displayErrorScreen = dynamicData.getPingoneMfaSkipErrorScreens() == false;
                        }
                    }
                    if (!this.authnApiSupport.isApiRequest(req) && !displayErrorScreen) {
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                        return authnAdapterResponse;
                    }
                    this.writePushConfirmationRejectedResponse(req, resp, inParameters, stateSupport, devices, user, selectedDeviceRef);
                    return authnAdapterResponse;
                }
                if (FlowError.Code.INVALID_JTI.name().equals(error.getCode()) || "INVALID_VALUE".equals(error.getCode()) && error.getMessage().toLowerCase().contains("invalid_jwt")) {
                    if (this.authnApiSupport.isApiRequest(req)) {
                        AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
                        authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_MOBILE_PAYLOAD.makeInstance()));
                        throw new AuthnErrorException(authnError);
                    }
                    return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                }
                if (FlowError.Code.NO_USABLE_DEVICES.toString().equals(code)) {
                    if (message.toLowerCase().contains("Failed to send push for device".toLowerCase())) {
                        mfaFailed = MfaFailed.PUSH_FAILED;
                    } else if (PingOneMfaHandler.isOfflineOtpResendLimitReached(message)) {
                        if (this.authnApiSupport.isApiRequest(req)) {
                            mfaFailed = MfaFailed.OTP_RESEND_LIMIT;
                        } else {
                            String selectedDeviceId = Objects.nonNull(this.getSelectedDeviceRef(req)) ? this.getSelectedDeviceRef(req).getId() : null;
                            Device.Type selectedDeviceType = this.getSelectedDeviceType(stateSupport, selectedDeviceId);
                            if (Objects.isNull((Object)selectedDeviceType)) {
                                selectedDeviceType = this.getSelectedDeviceTypeFromErrorMessage(message);
                            }
                            mfaFailed = this.getDailyLimitExceededMfaFailed(selectedDeviceType);
                        }
                    } else if (this.allowSetupMfa) {
                        if (stateSupport.getSupportUsePasswordPolicyAction() && !InParamsUtil.isUserIdAuthenticated(inParameters)) {
                            TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
                            boolean isHttpOnly = trackerCookieInfo.isHttpOnly();
                            boolean isSecureCookie = trackerCookieInfo.isSecure();
                            String domain = trackerCookieInfo.getCookieDomain();
                            String path = trackerCookieInfo.getCookiePath();
                            this.deleteTrackerCookie(resp, domain, path, isHttpOnly, isSecureCookie);
                            log.debug("Exiting from adapter since user is not authenticated and has no MFA device, and adapter is configured to exit with policy action for this.");
                            HashMap<String, String> attributeMap = new HashMap<String, String>();
                            attributeMap.put(CoreContract.POLICY_ACTION.toString(), "UsePassword");
                            authnAdapterResponse.setAttributeMap(attributeMap);
                            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.ACTION);
                            return authnAdapterResponse;
                        }
                        if (!InParamsUtil.isUserIdAuthenticated(inParameters)) {
                            log.debug("Users must be authenticated before MFA devices can be added.");
                        }
                        if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                            log.debug("MFA devices cannot be added during password reset.");
                        }
                        boolean allowSetupMFA = false;
                        try {
                            String accessToken = this.tokenService.getToken();
                            String userId = this.getUserId(stateSupport, inParameters);
                            List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> devices = this.workerApiClient.getUserDevices(accessToken, userId, "status eq \"ACTIVE\"");
                            DeviceAuthenticationPolicy authenticationPolicy = this.workerApiClient.getMFAPolicyFromAuthenticationPolicy(accessToken, this.authenticationPolicy);
                            if (devices.stream().noneMatch(authenticationPolicy::isSupported)) {
                                allowSetupMFA = true;
                            }
                            if (allowSetupMFA && StringUtils.isNotBlank(this.getTrackerCookieData(req))) {
                                TrackerCookieInfo trackerCookieInfo = new TrackerCookieInfo(inParameters, req);
                                this.deleteTrackerCookie(resp, trackerCookieInfo.getCookieDomain(), "/idp", trackerCookieInfo.isHttpOnly(), trackerCookieInfo.isSecure());
                            }
                        }
                        catch (AccessTokenProviderException accessToken) {
                            // empty catch block
                        }
                        if (this.isSetupMfaPermitted(inParameters, stateSupport) && allowSetupMFA) {
                            stateSupport.setPreviousPfStatus(StateSpec.MFA_SETUP_REQUIRED.getStatus());
                            stateSupport.setFlowId(null);
                            this.writeMfaSetupRequiredResponse(req, resp, inParameters);
                            return authnAdapterResponse;
                        }
                        mfaFailed = MfaFailed.NO_USABLE_DEVICES;
                    } else {
                        mfaFailed = MfaFailed.NO_USABLE_DEVICES;
                    }
                } else if (FlowError.Code.MFA_DISABLED.toString().equals(code)) {
                    if (this.invalidUserBypass) {
                        if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                            LOG.log(PingOneMfaIdpAdapterLogEvent.ACCOUNT_RECOVERY_UNSUPPORTED_WITHOUT_MFA);
                            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                            return authnAdapterResponse;
                        }
                        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
                        authnAdapterResponse.setAttributeMap(this.fulfillBypassedAttributeMap(username, true));
                        return authnAdapterResponse;
                    }
                    mfaFailed = MfaFailed.MFA_DISABLED;
                } else if (FlowError.Code.PUSH_CONFIRMATION_TIMED_OUT.toString().equals(code)) {
                    mfaFailed = MfaFailed.NO_RESPONSE_PASSIVE_PUSH;
                } else if (FlowError.Code.PASSWORD_LOCKED_OUT.toString().equals(code)) {
                    stateSupport.setPreviousPfStatus(StateSpec.MFA_FAILED.getStatus());
                    stateSupport.setMfaFailedCode(MfaFailed.ACCOUNT_LOCKED_OUT.getCode());
                    return this.mfaFailedAccountLockedOutResponse(req, resp, inParameters, stateSupport, failedResponse);
                }
            }
        }
        stateSupport.setPreviousPfStatus(StateSpec.MFA_FAILED.getStatus());
        stateSupport.setMfaFailedCode(mfaFailed.getCode());
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        boolean displayErrorScreen = this.showErrorScreen;
        if (dynamicData != null) {
            if (dynamicData.getPingIdSdkSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingIdSdkSkipErrorScreens() == false;
            }
            if (dynamicData.getPingoneMfaSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingoneMfaSkipErrorScreens() == false;
            }
        }
        if (!this.authnApiSupport.isApiRequest(req) && !displayErrorScreen) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        } else {
            Long expiresAt;
            String lockStatus;
            block51: {
                lockStatus = null;
                expiresAt = null;
                if (MfaFailed.NO_USABLE_DEVICES.getCode().equals(mfaFailed.getCode())) {
                    String acrValues = this.getAuthnContexts(inParameters);
                    try {
                        com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification notification;
                        ArrayList<UnavailableDevice> unavailableDevices;
                        FlowError flowError;
                        FlowResponse flowResponse = this.flowsApiClient.initiateFlowVariant(acrValues);
                        CheckUsernameRequest checkUsernameRequest = new CheckUsernameRequest(username);
                        flowResponse = this.flowsApiClient.checkUsername(flowResponse.getId(), checkUsernameRequest, "");
                        if (!(flowResponse instanceof FailedResponse) || (flowError = ((FailedResponse)flowResponse).getError()) == null || (unavailableDevices = flowError.getUnavailableDevices()) == null || unavailableDevices.isEmpty()) break block51;
                        UnavailableDevice unavailableDevice = unavailableDevices.get(0);
                        UnavailableLockedDevice lock = unavailableDevice.getLock();
                        if (lock != null) {
                            lockStatus = lock.getStatus();
                            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                            df.setTimeZone(TimeZone.getTimeZone("UTC"));
                            try {
                                expiresAt = df.parse(lock.getExpiresAt()).getTime();
                            }
                            catch (ParseException parseException) {
                                // empty catch block
                            }
                            mfaFailed = MfaFailed.NO_USABLE_DEVICES_WITH_COOLDOWN;
                        }
                        if ((notification = unavailableDevice.getNotification()) != null) {
                            lockStatus = notification.getStatus();
                            expiresAt = notification.getExpiresAt();
                            mfaFailed = MfaFailed.NO_USABLE_DEVICES_WITH_COOLDOWN;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (StringUtils.isNotBlank(lockStatus) && expiresAt != null) {
                this.writeMfaFailedResponseWithCoolDown(req, resp, inParameters, mfaFailed, expiresAt);
            } else {
                this.writeMfaFailedResponse(req, resp, inParameters, mfaFailed);
            }
        }
        return authnAdapterResponse;
    }

    private static boolean isOfflineOtpResendLimitReached(String message) {
        return message != null && message.matches("(?i).*Daily limit of (SMS|EMAIL|WhatsApp|VOICE) authentication attempts has been exceeded.*");
    }

    public AuthnAdapterResponse mfaFailedServerErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, boolean userCancelledFIDOAuth) throws IOException {
        MfaFailed mfaFailed = MfaFailed.SERVER_ERROR;
        if (userCancelledFIDOAuth) {
            mfaFailed = MfaFailed.CLIENT_CANCELLED_FIDO_AUTH;
        }
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, mfaFailed);
    }

    public AuthnAdapterResponse devicePairingMethodFailedServerErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, boolean userCancelledFIDOAuth, ApiResponseException apiResponseException) throws IOException {
        ApiErrorResponse apiErrorResponse;
        MfaFailed mfaFailed = MfaFailed.SERVER_ERROR;
        if (userCancelledFIDOAuth) {
            mfaFailed = MfaFailed.CLIENT_CANCELLED_FIDO_AUTH;
        }
        if (stateSupport.getDevicePairingErrorDetail() != null && (FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(stateSupport.getDevicePairingErrorDetail().getCode()) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(stateSupport.getDevicePairingErrorDetail().getCode()))) {
            mfaFailed = MfaFailed.DEVICE_INTEGRITY_FAILED;
        } else if (apiResponseException != null && (apiErrorResponse = apiResponseException.getErrorResponse()) instanceof ErrorResponse) {
            ErrorResponse errorResponse = (ErrorResponse)apiErrorResponse;
            String code = errorResponse.getCode().toLowerCase();
            if (code.equalsIgnoreCase("REQUEST_LIMITED")) {
                mfaFailed = MfaFailed.SERVER_ERROR_REQUEST_LIMITED;
            } else if (FlowError.Code.DEVICEINTEGRITY.name().equalsIgnoreCase(code) || FlowError.Code.DEVICE_COMPROMISED.name().equalsIgnoreCase(code)) {
                mfaFailed = MfaFailed.DEVICE_INTEGRITY_FAILED;
            }
            ErrorDetail errorDetail = new ErrorDetail();
            errorDetail.setCode(errorResponse.getCode());
            errorDetail.setMessage(errorResponse.getMessage());
            stateSupport.setDevicePairingErrorDetail(errorDetail);
        }
        return this.devicePairingMethodFailedResponse(req, resp, inParameters, stateSupport, mfaFailed);
    }

    public AuthnAdapterResponse mfaFailedServiceUnavailableResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, MfaFailed.SERVICE_UNAVAILABLE);
    }

    public AuthnAdapterResponse mfaFailedMfaDisabledResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, MfaFailed.MFA_DISABLED);
    }

    public AuthnAdapterResponse mfaFailedUserNotFoundResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, MfaFailed.USER_NOT_FOUND);
    }

    public AuthnAdapterResponse mfaFailedAccountLockedOutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FailedResponse failedResponse) throws IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        boolean displayErrorScreen = this.showErrorScreen;
        if (dynamicData != null) {
            if (dynamicData.getPingIdSdkSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingIdSdkSkipErrorScreens() == false;
            }
            if (dynamicData.getPingoneMfaSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingoneMfaSkipErrorScreens() == false;
            }
        }
        if (!this.authnApiSupport.isApiRequest(req) && !displayErrorScreen) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        } else {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            this.writeMfaFailedAccountLockedOutResponse(req, resp, inParameters, failedResponse);
        }
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse handleRateLimitErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, RateLimitApiResponseException exception) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.authnApiSupport.writeErrorResponse(req, resp, ErrorResponseUtil.transformPingOneErrorToPingFedErrorResponse(exception.getStatusCode(), (ErrorResponse)exception.getErrorResponse()));
        } else {
            this.pingOneMfaTemplateSupport.renderMfaFailedResponse(req, resp, inParameters, "rate.limit.error.title", "rate.limit.error.header", "rate.limit.error.message");
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private void writeMfaFailedAccountLockedOutResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, FailedResponse failedResponse) throws IOException {
        String accountLockedOutErrorMessage;
        MfaFailed mfaFailed;
        FlowError flowError = failedResponse.getError();
        if (flowError.getSecondsUntilUnlock() != null) {
            mfaFailed = MfaFailed.ACCOUNT_LOCKED_OUT_AUTOMATIC_UNLOCK;
            accountLockedOutErrorMessage = this.getLockedOutMessageWithCoolDown(req, mfaFailed, flowError.getSecondsUntilUnlock());
        } else {
            mfaFailed = MfaFailed.ACCOUNT_LOCKED_OUT;
            accountLockedOutErrorMessage = this.getLockedOutMessage(req, mfaFailed);
        }
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeMfaFailedAccountLockedOutResponse(req, resp, mfaFailed.getMessage(), mfaFailed.getCode(), accountLockedOutErrorMessage, flowError.getSecondsUntilUnlock());
        } else {
            this.pingOneMfaTemplateSupport.renderMfaFailedResponseWithCoolDownMessage(req, resp, inParameters, "account.locked.out.title", "account.locked.out.header", accountLockedOutErrorMessage);
        }
    }

    private String getLockedOutMessageWithCoolDown(HttpServletRequest req, MfaFailed mfaFailed, Long secondsUntilUnlock) {
        long friendlyDuration;
        Object unitErrorMessageKey;
        Duration duration = Duration.ofSeconds(secondsUntilUnlock);
        if (duration.toDays() > 0L) {
            unitErrorMessageKey = ".day";
            friendlyDuration = duration.toDays();
        } else if (duration.toHours() > 0L) {
            unitErrorMessageKey = ".hour";
            friendlyDuration = duration.toHours();
        } else if (duration.toMinutes() > 0L) {
            unitErrorMessageKey = ".minute";
            friendlyDuration = duration.toMinutes();
        } else {
            unitErrorMessageKey = ".second";
            friendlyDuration = duration.getSeconds();
        }
        if (friendlyDuration > 1L) {
            unitErrorMessageKey = (String)unitErrorMessageKey + "s";
        }
        String unit = this.getLocalizedMessage(req, mfaFailed, (String)unitErrorMessageKey, new String[0]);
        return this.getLocalizedMessage(req, mfaFailed, "", String.valueOf(friendlyDuration), unit);
    }

    private String getLockedOutMessage(HttpServletRequest req, MfaFailed mfaFailed) {
        return this.getLocalizedMessage(req, mfaFailed, "", new String[0]);
    }

    private String getLocalizedMessage(HttpServletRequest req, MfaFailed mfaFailed, String keySuffix, String ... args) {
        if (this.authnApiSupport.isApiRequest(req)) {
            return this.authnApiSupport.getLocalizedMessage(req, "authn-api-messages", mfaFailed.getAuthnApiUserMessageKey() + keySuffix, args);
        }
        LanguagePackMessagesSupport languagePackMessagesSupport = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport();
        return languagePackMessagesSupport.getPingOneMfaAdapterMessage(req, "pingone.mfa.failed." + mfaFailed.getTemplateErrorMessageKey() + keySuffix, args);
    }

    private AuthnAdapterResponse devicePairingMethodFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, MfaFailed mfaFailed) throws IOException {
        stateSupport.setMfaFailedCode(mfaFailed.getCode());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        boolean displayErrorScreen = this.showErrorScreen;
        if (dynamicData != null) {
            if (dynamicData.getPingIdSdkSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingIdSdkSkipErrorScreens() == false;
            }
            if (dynamicData.getPingoneMfaSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingoneMfaSkipErrorScreens() == false;
            }
        }
        if (!this.authnApiSupport.isApiRequest(req) && !displayErrorScreen) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        } else {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            this.writeDevicePairingMethodFailedResponse(req, resp, inParameters, stateSupport, mfaFailed);
        }
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse mfaFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, MfaFailed mfaFailed) throws IOException {
        stateSupport.setMfaFailedCode(mfaFailed.getCode());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        boolean displayErrorScreen = this.showErrorScreen;
        if (dynamicData != null) {
            if (dynamicData.getPingIdSdkSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingIdSdkSkipErrorScreens() == false;
            }
            if (dynamicData.getPingoneMfaSkipErrorScreens() != null) {
                boolean bl = displayErrorScreen = dynamicData.getPingoneMfaSkipErrorScreens() == false;
            }
        }
        if (!this.authnApiSupport.isApiRequest(req) && !displayErrorScreen) {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        } else {
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            this.writeMfaFailedResponse(req, resp, inParameters, mfaFailed);
        }
        return authnAdapterResponse;
    }

    private void writeDevicePairingMethodFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, MfaFailed mfaFailed) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeDevicePairingMethodFailedResponse(req, resp, mfaFailed.getMessage(), mfaFailed.getCode(), mfaFailed.getAuthnApiUserMessageKey());
        } else {
            this.pingOneMfaTemplateSupport.renderDevicePairingMethodFailedResponse(req, resp, inParameters, mfaFailed.getTemplateErrorMessageKey(), this.isAddMethodPermitted(inParameters, stateSupport), stateSupport);
        }
    }

    private void writeMfaFailedResponseWithCoolDown(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, MfaFailed mfaFailed, Long coolDownExpiresAt) throws IOException {
        long totalSecondsRemaining = (coolDownExpiresAt - System.currentTimeMillis()) / 1000L;
        long hours = totalSecondsRemaining / 3600L;
        long minutes = (totalSecondsRemaining - hours * 3600L) / 60L;
        long seconds = totalSecondsRemaining - hours * 3600L - minutes * 60L;
        long friendlyDuration = 0L;
        String unitErrorMessageKey = ".unit.seconds";
        if (hours >= 1L) {
            unitErrorMessageKey = hours == 1L ? ".unit.hour" : ".unit.hours";
            friendlyDuration = hours;
        } else if (minutes >= 1L) {
            unitErrorMessageKey = minutes == 1L ? ".unit.minute" : ".unit.minutes";
            friendlyDuration = minutes;
        } else if (seconds >= 1L) {
            unitErrorMessageKey = seconds == 1L ? ".unit.second" : ".unit.seconds";
            friendlyDuration = seconds;
        }
        String templateErrorMessageKey = "pingone.mfa.failed." + MfaFailed.NO_USABLE_DEVICES_WITH_COOLDOWN.getTemplateErrorMessageKey();
        LanguagePackMessagesSupport languagePackMessagesSupport = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport();
        String unit = languagePackMessagesSupport.getPingOneMfaAdapterMessage(req, templateErrorMessageKey + unitErrorMessageKey);
        String errorMessagePlainText = languagePackMessagesSupport.getPingOneMfaAdapterMessage(req, templateErrorMessageKey, String.valueOf(friendlyDuration), unit);
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeMfaFailedResponseWithCoolDown(req, resp, mfaFailed.getMessage(), mfaFailed.getCode(), errorMessagePlainText, totalSecondsRemaining);
        } else {
            this.pingOneMfaTemplateSupport.renderMfaFailedResponseWithCoolDownMessage(req, resp, inParameters, "title", "header", errorMessagePlainText);
        }
    }

    private void writeMfaFailedResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, MfaFailed mfaFailed) throws IOException {
        if (this.authnApiSupport.isApiRequest(req)) {
            this.pingOneMfaAuthnApiSupport.writeMfaFailedResponse(req, resp, mfaFailed.getMessage(), mfaFailed.getCode(), mfaFailed.getAuthnApiUserMessageKey());
        } else {
            this.pingOneMfaTemplateSupport.renderMfaFailedResponse(req, resp, inParameters, "title", "header", mfaFailed.getTemplateErrorMessageKey());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AuthnAdapterResponse handleStatusRequest(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, StatusMapping statusMapping) throws IOException, AuthnErrorException, JoseException, AccessTokenProviderException, InvalidActionException {
        String status = statusMapping.getStatus();
        FlowResponse flowResponse = statusMapping.getFlowResponse();
        if (flowResponse != null) {
            return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        if (StateSpec.AUTHENTICATION_REQUIRED.getStatus().equals(status)) {
            if (!this.authnApiSupport.isApiRequest(req)) return this.handleAuthenticateRequest(req, resp, inParameters, stateSupport, false);
            this.writeAuthenticationRequiredResponse(req, resp, inParameters);
            return authnAdapterResponse;
        } else if (CommonStateSpec.MOBILE_PAIRING_REQUIRED.getStatus().equals(status)) {
            String idToken = stateSupport.getAuthorizeResponse().getIdToken();
            this.pingOneMfaAuthnApiSupport.writeMobilePairingRequiredResponse(req, resp, idToken);
            return authnAdapterResponse;
        } else if (CommonStateSpec.MFA_COMPLETED.getStatus().equals(status)) {
            String mfaCompletedCode = stateSupport.getMfaCompletedCode();
            this.writeMfaCompletedResponse(req, resp, inParameters, mfaCompletedCode, stateSupport);
            return authnAdapterResponse;
        } else if (StateSpec.MFA_FAILED.getStatus().equals(status)) {
            String mfaFailedCode = stateSupport.getMfaFailedCode();
            if (MfaFailed.ACCOUNT_LOCKED_OUT.getCode().equals(mfaFailedCode)) {
                flowResponse = this.initiateFlow(req, inParameters, stateSupport);
                return this.handleFlowResponse(req, resp, inParameters, stateSupport, flowResponse);
            }
            MfaFailed mfaFailed = MFA_FAILED_MAP.get(mfaFailedCode);
            this.writeMfaFailedResponse(req, resp, inParameters, mfaFailed);
            return authnAdapterResponse;
        } else if (StateSpec.MFA_SETUP_REQUIRED.getStatus().equals(status)) {
            this.writeMfaSetupRequiredResponse(req, resp, inParameters);
            return authnAdapterResponse;
        } else if (StateSpec.DEVICE_PAIRING_METHOD_REQUIRED.getStatus().equals(status)) {
            List<DevicePairingMethod> devicePairingMethods = stateSupport.getDevicePairingMethods();
            this.writeDevicePairingMethodRequiredResponse(req, resp, inParameters, devicePairingMethods);
            return authnAdapterResponse;
        } else if (PAIRING_OFFLINE_STATUSES.contains(status)) {
            this.writeOfflinePairingRequiredResponse(req, resp, inParameters, stateSupport, this.getDeviceType(status), null, null);
            return authnAdapterResponse;
        } else {
            if (StateSpec.MOBILE_ACTIVATION_REQUIRED.getStatus().equals(status)) {
                return this.handleMobileActivationPollRequest(req, resp, inParameters, stateSupport);
            }
            if (StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus().equals(status)) {
                String userId = this.getUserId(stateSupport, inParameters);
                this.writeTotpActivationRequiredResponse(req, resp, inParameters, stateSupport, userId, false);
                return authnAdapterResponse;
            } else if (ACTIVATION_OFFLINE_STATUSES.contains(status)) {
                OfflineDevice offlineDevice = (OfflineDevice)stateSupport.getActivationRequiredDevice();
                this.writeOfflineActivationRequiredResponse(req, resp, inParameters, offlineDevice, stateSupport.getMfaPolicy().getOtpLifeTime(offlineDevice.getType()), this.getOtpLength(stateSupport, offlineDevice.getType()));
                return authnAdapterResponse;
            } else if (StateSpec.SECURITY_KEY_ACTIVATION_REQUIRED.getStatus().equals(status) || StateSpec.PLATFORM_ACTIVATION_REQUIRED.getStatus().equals(status) || StateSpec.FIDO2_ACTIVATION_REQUIRED.getStatus().equals(status)) {
                String userId = this.getUserId(stateSupport, inParameters);
                this.writeWebAuthnActivationRequiredResponse(req, resp, inParameters, stateSupport, userId, false, null);
                return authnAdapterResponse;
            } else {
                if (!StateSpec.MFA_DEVICE_PAIRING_METHOD_FAILED.getStatus().equals(status)) return authnAdapterResponse;
                String mfaFailedCode = stateSupport.getMfaFailedCode();
                MfaFailed mfaFailed = MfaFailed.DEVICE_INTEGRITY_FAILED;
                this.writeDevicePairingMethodFailedResponse(req, resp, inParameters, stateSupport, mfaFailed);
            }
        }
        return authnAdapterResponse;
    }

    private String getDeviceType(String status) {
        switch (status) {
            case "EMAIL_PAIRING_TARGET_REQUIRED": {
                return "email";
            }
            case "SMS_PAIRING_TARGET_REQUIRED": {
                return "sms";
            }
            case "VOICE_PAIRING_TARGET_REQUIRED": {
                return "voice";
            }
            case "WHATSAPP_PAIRING_TARGET_REQUIRED": {
                return "whatsapp";
            }
        }
        return null;
    }

    private AuthnAdapterResponse handleErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse getFlowResponse, ApiResponseException e) throws AuthnErrorException, IOException, AccessTokenProviderException, JoseException {
        if (e.getErrorResponse() != null) {
            String code;
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            log.debug("Error response details: " + errorResponse.getPrettyErrorDetails());
            switch (code = errorResponse.getCode()) {
                case "INVALID_DATA": {
                    String errorDetailCode = errorResponse.getErrorDetailCode();
                    Long attemptsRemaining = errorResponse.getAttemptsRemaining();
                    switch (errorDetailCode) {
                        case "INVALID_OTP": {
                            if (getFlowResponse instanceof OtpRequiredResponse) {
                                return this.handleInvalidOtpError(req, resp, inParameters, stateSupport, (OtpRequiredResponse)getFlowResponse, "invalid.otp", attemptsRemaining);
                            }
                            if (getFlowResponse instanceof PushConfirmationRequiredResponse) {
                                return this.handleInvalidOtpError(req, resp, inParameters, stateSupport, (PushConfirmationRequiredResponse)getFlowResponse, attemptsRemaining);
                            }
                            return this.handleInvalidOtpError(req, resp, inParameters, stateSupport, (PushConfirmationTimedOutResponse)getFlowResponse, attemptsRemaining);
                        }
                        case "INVALID_VALUE": {
                            String errorDetailTarget;
                            switch (errorDetailTarget = ErrorResponseUtil.getErrorDetailTarget(errorResponse)) {
                                case "username": {
                                    return this.handleInvalidUsernameError(req, resp, inParameters, stateSupport);
                                }
                                case "device": {
                                    InnerError innerError = ErrorResponseUtil.getErrorDetailInnerError(errorResponse);
                                    return this.handleInvalidDeviceError(req, resp, inParameters, stateSupport, innerError);
                                }
                                case "otp": {
                                    if (getFlowResponse instanceof OtpRequiredResponse) {
                                        return this.handleInvalidOtpError(req, resp, inParameters, stateSupport, (OtpRequiredResponse)getFlowResponse, "expired.otp", attemptsRemaining);
                                    }
                                    if (getFlowResponse instanceof PushConfirmationRequiredResponse) {
                                        return this.handleInvalidOtpError(req, resp, inParameters, stateSupport, (PushConfirmationRequiredResponse)getFlowResponse, attemptsRemaining);
                                    }
                                    return this.handleInvalidOtpError(req, resp, inParameters, stateSupport, (PushConfirmationTimedOutResponse)getFlowResponse, attemptsRemaining);
                                }
                                case "request": {
                                    this.appSecretCache.invalidateAppSecret(this.applicationId);
                                }
                            }
                        }
                    }
                    break;
                }
                case "REQUEST_FAILED": {
                    String errorDetailCode;
                    switch (errorDetailCode = errorResponse.getErrorDetailCode()) {
                        case "PUSH_FAILED": {
                            return this.handlePushFailedError(req, resp, inParameters, stateSupport);
                        }
                        case "EMAIL_LIMIT_REACHED": {
                            this.markAllDevicesInStateSupportAsUnusableByTypes(stateSupport, List.of(Device.Type.EMAIL));
                            return this.writeDailyOTPLimitExceededDeviceLockedError(req, resp, inParameters, Device.Type.EMAIL);
                        }
                        case "SMS_VOICE_LIMIT_REACHED": {
                            this.markAllDevicesInStateSupportAsUnusableByTypes(stateSupport, List.of(Device.Type.SMS, Device.Type.VOICE, Device.Type.WHATSAPP));
                            Device.Type selectedDeviceType = this.getSelectedDeviceType(stateSupport, Objects.nonNull(this.getSelectedDeviceRef(req)) ? this.getSelectedDeviceRef(req).getId() : null);
                            return this.writeDailyOTPLimitExceededDeviceLockedError(req, resp, inParameters, selectedDeviceType);
                        }
                        case "WHATSAPP_LIMIT_REACHED": {
                            this.markAllDevicesInStateSupportAsUnusableByTypes(stateSupport, List.of(Device.Type.SMS, Device.Type.VOICE, Device.Type.WHATSAPP));
                            return this.writeDailyOTPLimitExceededDeviceLockedError(req, resp, inParameters, Device.Type.WHATSAPP);
                        }
                        case "NO_USABLE_DEVICES": {
                            return this.handleNoUsableDevices(req, resp, inParameters, stateSupport);
                        }
                        case "LIMIT_EXCEEDED": {
                            this.markDeviceAsLockedInStateSupportIfNeeded(req, stateSupport, (ErrorResponse)e.getErrorResponse());
                            return this.handleNotificationCoolDownError(req, resp, inParameters, errorResponse, true);
                        }
                        case "QUOTA_EXCEEDED": {
                            String errorDetailMessage = ErrorResponseUtil.getErrorDetailMessage(errorResponse).toLowerCase();
                            if (errorDetailMessage.contains("Too many unsuccessful OTP attempts".toLowerCase()) || errorDetailMessage.contains("Too many unsuccessful Push attempts".toLowerCase())) {
                                this.markDeviceAsLockedInStateSupportIfNeeded(req, stateSupport, (ErrorResponse)e.getErrorResponse());
                                return this.writeIncorrectOTPLimitExceededDeviceLockedError(req, resp, inParameters, errorResponse, true);
                            }
                            return this.handleOtpAttemptsLimitError(req, resp, inParameters, stateSupport, getFlowResponse, errorResponse);
                        }
                        case "CONSTRAINT_VIOLATION": {
                            InnerError innerError = ErrorResponseUtil.getErrorDetailInnerError(errorResponse);
                            return this.handleInvalidDeviceError(req, resp, inParameters, stateSupport, innerError);
                        }
                        case "Failed to create a PublicKeyCredentialRequestOptions": {
                            ErrorDetail errorDetail = errorResponse.getDetails().get(0);
                            return this.handleAssertionFailure(req, resp, inParameters, errorDetail);
                        }
                    }
                    break;
                }
                case "REQUEST_LIMITED": {
                    String errorDetailCode;
                    switch (errorDetailCode = errorResponse.getErrorDetailCode()) {
                        case "QUOTA_EXCEEDED": {
                            return this.handleOtpAttemptsLimitError(req, resp, inParameters, stateSupport, getFlowResponse, errorResponse);
                        }
                    }
                    break;
                }
                case "ACCESS_FAILED": {
                    String errorDetailCode = errorResponse.getErrorDetailCode();
                    String errorDetailMessage = ErrorResponseUtil.getErrorDetailMessage(errorResponse);
                    if (!errorDetailCode.equals("POLICY_DENIED") || !errorDetailMessage.contains("MFA is disabled for user")) break;
                    return this.handleMfaDisabledError(req, resp, inParameters, stateSupport);
                }
                case "INVALID_REQUEST": {
                    String errorDetailCode = errorResponse.getErrorDetailCode();
                    String errorDetailTarget = ErrorResponseUtil.getErrorDetailTarget(errorResponse);
                    if (errorDetailCode.equals("INVALID_PARAMETER") && errorDetailTarget.equals("login_hint_token")) {
                        this.appSecretCache.invalidateAppSecret(this.applicationId);
                        return this.handleInvalidUsernameError(req, resp, inParameters, stateSupport);
                    }
                    if (!errorDetailCode.equals("INVALID_VALUE") || !errorDetailTarget.equals("device.id")) break;
                    InnerError innerError = ErrorResponseUtil.getErrorDetailInnerError(errorResponse);
                    return this.handleInvalidDeviceError(req, resp, inParameters, stateSupport, innerError);
                }
            }
        }
        throw e;
    }

    private void markDeviceAsLockedInStateSupportIfNeeded(HttpServletRequest req, PingOneMfaStateSupport stateSupport, ErrorResponse errorResponse) {
        Optional.ofNullable(errorResponse.getCoolDownExpiresAt()).ifPresent(coolDownExpiresAt -> this.markDeviceAsLockedInStateSupport(req, stateSupport, (Long)coolDownExpiresAt));
    }

    private void markDeviceAsLockedInStateSupport(HttpServletRequest req, PingOneMfaStateSupport stateSupport, Long coolDownExpiresAt) {
        String selectedDeviceId = StringUtils.defaultIfBlank(this.fetchSelectedDeviceId(this.getSelectedDeviceRef(req)), this.fetchSelectedDeviceId(stateSupport.getSelectedDeviceRef()));
        stateSupport.getDevices().stream().filter(device -> device.getId().equals(selectedDeviceId)).findFirst().ifPresent(device -> device.setLock(new Lock(Lock.LockStatus.LOCKED, coolDownExpiresAt)));
    }

    private String fetchSelectedDeviceId(ResourceRef resourceRef) {
        return Optional.ofNullable(resourceRef).map(ResourceRef::getId).orElse(null);
    }

    private void updateAuthenticationMethods(Map<String, Object> inParameters) throws AccessTokenProviderException, IOException {
        List<String> potentialPhoneNumbersForSms = InParamsUtil.getAttributeFromChainedByPrefix(inParameters, this.smsAttribute);
        List<String> potentialPhoneNumbersForVoice = InParamsUtil.getAttributeFromChainedByPrefix(inParameters, this.voiceAttribute);
        List<String> potentialPhoneNumbersForWhatsApp = InParamsUtil.getAttributeFromChainedByPrefix(inParameters, this.whatsAppAttribute);
        List<String> potentialEmails = InParamsUtil.getAttributeFromChainedByPrefix(inParameters, this.emailAttribute);
        if (potentialPhoneNumbersForSms.isEmpty() && potentialPhoneNumbersForVoice.isEmpty() && potentialEmails.isEmpty() && potentialPhoneNumbersForWhatsApp.isEmpty()) {
            return;
        }
        String userIdOrUserName = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        User user = this.getUserByIdOrName(userIdOrUserName);
        if (user == null) {
            user = this.provisionedUser(userIdOrUserName);
        }
        String accessToken = this.tokenService.getToken();
        List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> existingDevices = this.workerApiClient.getUserDevices(accessToken, user.getId(), null);
        DevicesSnapShotList devicesSnapShotList = new DevicesSnapShotList();
        devicesSnapShotList.setDevicesSnapshot(existingDevices.stream().map(DeviceSnapshot::new).collect(Collectors.toList()));
        this.updateAuthenticationMethodsByType(Device.Type.SMS, potentialPhoneNumbersForSms, devicesSnapShotList, user, SMS_DEVICE_BASE_NICKNAME);
        this.updateAuthenticationMethodsByType(Device.Type.VOICE, potentialPhoneNumbersForVoice, devicesSnapShotList, user, VOICE_DEVICE_BASE_NICKNAME);
        this.updateAuthenticationMethodsByType(Device.Type.EMAIL, potentialEmails, devicesSnapShotList, user, EMAIL_DEVICE_BASE_NICKNAME);
        this.updateAuthenticationMethodsByType(Device.Type.WHATSAPP, potentialPhoneNumbersForWhatsApp, devicesSnapShotList, user, WHATSAPP_DEVICE_BASE_NICKNAME);
        if (devicesSnapShotList.isListWasChanged() || devicesSnapShotList.isProvisionDevices()) {
            SetDeviceOrderRequest setDeviceOrderRequest = new SetDeviceOrderRequest(this.getDeviceOrder(devicesSnapShotList, this.defaultDeviceType));
            this.workerApiClient.reorderDevices(accessToken, user.getId(), setDeviceOrderRequest);
        }
    }

    public void updateAuthenticationMethodsByType(Device.Type type, List<String> potentialDevicesTargets, DevicesSnapShotList devicesSnapShotList, User user, String baseNickname) throws IOException, AccessTokenProviderException {
        if (potentialDevicesTargets.isEmpty() && OverwriteAuthenticationMethodsConfig.NONE.equals((Object)this.overwriteAuthenticationMethodsConfiguration)) {
            return;
        }
        List<DeviceSnapshot> existingDevicesSnapshot = devicesSnapShotList.getDevicesSnapshot();
        List devicesToBeCreated = potentialDevicesTargets.stream().filter(potentialDeviceTarget -> existingDevicesSnapshot.stream().filter(deviceSnapshot -> deviceSnapshot.getType().equalsIgnoreCase(type.getName())).noneMatch(deviceSnapshot -> potentialDeviceTarget.equalsIgnoreCase(deviceSnapshot.getTargetValue()))).collect(Collectors.toList());
        if (devicesToBeCreated.isEmpty() && !OverwriteAuthenticationMethodsConfig.ALL.equals((Object)this.overwriteAuthenticationMethodsConfiguration)) {
            return;
        }
        String accessToken = this.tokenService.getToken();
        if (!OverwriteAuthenticationMethodsConfig.NONE.equals((Object)this.overwriteAuthenticationMethodsConfiguration)) {
            for (DeviceSnapshot existingDevice : existingDevicesSnapshot) {
                if (!existingDevice.getType().equalsIgnoreCase(type.getName()) || !potentialDevicesTargets.stream().noneMatch(potentialDeviceTarget -> potentialDeviceTarget.equals(existingDevice.getTargetValue()))) continue;
                this.workerApiClient.deleteDevice(accessToken, user.getId(), existingDevice.getId());
                devicesSnapShotList.setListWasChanged(true);
                existingDevice.setDeletedFromOriginalList(true);
            }
        }
        for (String deviceToBeCreated : devicesToBeCreated) {
            String nickname = this.findNickname(type, existingDevicesSnapshot, baseNickname);
            try {
                OfflineDevice newlyCreatedDevice = this.createActiveOfflineDevice(type, deviceToBeCreated, nickname, accessToken, user.getId());
                if (!Objects.nonNull(newlyCreatedDevice)) continue;
                devicesSnapShotList.updateDevicesSnapshotListWithNewlyCreatedDevice(newlyCreatedDevice);
            }
            catch (ApiResponseException e) {
                this.handleDeviceCreationError(e, nickname, user.getUsername());
            }
        }
    }

    private List<String> getDeviceOrder(DevicesSnapShotList deviceSnapshotList, String defaultType) {
        if (deviceSnapshotList.isProvisionDevices()) {
            List defaultDevices = deviceSnapshotList.getDevicesSnapshot().stream().filter(deviceSnapshot -> deviceSnapshot.getType().equalsIgnoreCase(defaultType)).collect(Collectors.toList());
            List restOfDevices = deviceSnapshotList.getDevicesSnapshot().stream().filter(deviceSnapshot -> !deviceSnapshot.getType().equalsIgnoreCase(defaultType)).collect(Collectors.toList());
            defaultDevices.addAll(restOfDevices);
            return defaultDevices.stream().map(DeviceSnapshot::getId).collect(Collectors.toList());
        }
        return deviceSnapshotList.getDevicesSnapshot().stream().filter(deviceSnapshot -> !deviceSnapshot.isDeletedFromOriginalList()).map(DeviceSnapshot::getId).collect(Collectors.toList());
    }

    private String findNickname(Device.Type type, List<DeviceSnapshot> deviceSnapshotList, String defaultNicknamePrefix) {
        for (DeviceSnapshot deviceSnapshot2 : deviceSnapshotList) {
            if (!deviceSnapshot2.getType().equalsIgnoreCase(type.getName()) || !deviceSnapshot2.isDeletedFromOriginalList() || deviceSnapshot2.getNickname() == null) continue;
            return deviceSnapshot2.getNickname();
        }
        List existingPostfixNumbers = deviceSnapshotList.stream().filter(deviceSnapshot -> deviceSnapshot.getType().equalsIgnoreCase(type.getName())).filter(deviceSnapshot -> deviceSnapshot.getNickname() != null && deviceSnapshot.getNickname().startsWith(defaultNicknamePrefix)).filter(deviceSnapshot -> deviceSnapshot.getNickname().substring(defaultNicknamePrefix.length()).matches("\\d+")).map(deviceSnapshot -> deviceSnapshot.getNickname().substring(defaultNicknamePrefix.length())).map(Integer::parseInt).collect(Collectors.toList());
        Optional nextPostfixCounter = existingPostfixNumbers.stream().max(Integer::compareTo);
        return defaultNicknamePrefix + (nextPostfixCounter.isPresent() ? (Integer)nextPostfixCounter.get() + 1 : 1);
    }

    public void handleDeviceCreationError(ApiResponseException e, String nickname, String username) throws ApiResponseException {
        if (e.getErrorResponse() != null) {
            ErrorResponse errorResponse = (ErrorResponse)e.getErrorResponse();
            if ("INVALID_DATA".equals(errorResponse.getCode()) && "INVALID_VALUE".equals(errorResponse.getErrorDetailCode())) {
                LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.INVALID_DEVICE_TARGET_FORMAT, nickname, username);
            } else if ("REQUEST_LIMITED".equals(errorResponse.getCode()) && "LIMIT_EXCEEDED".equals(errorResponse.getErrorDetailCode())) {
                LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.DEVICE_LIMIT_EXCEEDED, nickname, username);
            } else {
                throw e;
            }
        }
    }

    public User getUserByIdOrName(String userIdOrUserName) throws AccessTokenProviderException {
        try {
            String accessToken = this.tokenService.getToken();
            User user = this.workerApiClient.getUserByUsername(accessToken, userIdOrUserName);
            if (user == null) {
                user = this.workerApiClient.getUserById(accessToken, userIdOrUserName);
            }
            return user;
        }
        catch (AccessTokenProviderException | IOException exception) {
            return null;
        }
    }

    private User provisionedUser(String username) throws IOException, AccessTokenProviderException {
        try {
            String accessToken = this.tokenService.getToken();
            User createdUser = this.workerApiClient.createUser(accessToken, new UserRequest(username, this.populationId, true));
            LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.NEW_USER_PROVISIONED, username, createdUser.getId());
            return createdUser;
        }
        catch (ApiResponseException e) {
            ErrorResponse errorResponse;
            if (e.getErrorResponse() != null && "INVALID_REQUEST".equals((errorResponse = (ErrorResponse)e.getErrorResponse()).getCode()) && "UNIQUENESS_VIOLATION".equals(errorResponse.getErrorDetailCode())) {
                LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.NON_UNIQUE_USERNAME, username);
            }
            throw e;
        }
    }

    private AuthnAdapterResponse initiateOneTimeDeviceOTPAuthenticationFlow(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, OneTimeDevicesInfo oneTimeDevicesInfo, PingOneMfaStateSupport stateSupport) throws AuthnAdapterException, IOException, JoseException, AccessTokenProviderException, AuthnErrorException, InvalidActionException {
        AuthnAdapterResponse authnAdapterResponse = null;
        stateSupport.setOneTimeDeviceOtpDevices(oneTimeDevicesInfo);
        authnAdapterResponse = oneTimeDevicesInfo.isDeviceSelectionRequired() ? this.handleOneTimeDeviceOTPMethodTypeInputRequiredRequest(req, resp, inParameters, oneTimeDevicesInfo, stateSupport, null) : this.handleCreateOneTimeDeviceAuthenticationRequest(req, resp, inParameters, oneTimeDevicesInfo.getDevices().get(0), stateSupport);
        return authnAdapterResponse;
    }

    private static List<String> getOneTimeDeviceFlowDeviceData(Map<String, Object> inParams, String deviceTypeAttributeName) {
        AttributeValue attributeValue;
        Map chainedAttributes = (Map)inParams.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (chainedAttributes != null && (attributeValue = (AttributeValue)chainedAttributes.get(deviceTypeAttributeName)) != null) {
            if (attributeValue.isMultiValue()) {
                return chainedAttributes.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith(deviceTypeAttributeName)).map(it -> ((AttributeValue)it.getValue()).getValuesAsCollection()).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            }
            String data = ((AttributeValue)chainedAttributes.get(deviceTypeAttributeName)).getValue();
            if (StringUtils.isNotBlank(data)) {
                return Arrays.asList(data.split(","));
            }
        }
        return Collections.emptyList();
    }

    public OneTimeDevicesInfo getOneTimeDevicesInfoObject(Map<String, Object> inParameters) {
        List<String> phoneNumbersForSms = PingOneMfaHandler.getOneTimeDeviceFlowDeviceData(inParameters, "one-time-device-sms");
        List<String> phoneNumbersForVoice = PingOneMfaHandler.getOneTimeDeviceFlowDeviceData(inParameters, "one-time-device-voice");
        List<String> emails = PingOneMfaHandler.getOneTimeDeviceFlowDeviceData(inParameters, "one-time-device-email");
        List<String> phoneNumbersForWhatsApp = PingOneMfaHandler.getOneTimeDeviceFlowDeviceData(inParameters, "one-time-device-whatsapp");
        OneTimeDevicesInfo oneTimeDevicesInfo = new OneTimeDevicesInfo();
        if (!phoneNumbersForSms.isEmpty()) {
            oneTimeDevicesInfo.addSmsDevices(phoneNumbersForSms);
        }
        if (!phoneNumbersForVoice.isEmpty()) {
            oneTimeDevicesInfo.addVoiceDevices(phoneNumbersForVoice);
        }
        if (!emails.isEmpty()) {
            oneTimeDevicesInfo.addEmailDevices(emails);
        }
        if (!phoneNumbersForWhatsApp.isEmpty()) {
            oneTimeDevicesInfo.addWhatsAppDevices(phoneNumbersForWhatsApp);
        }
        return oneTimeDevicesInfo;
    }

    private AuthnAdapterResponse handleInvalidUsernameError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException, AccessTokenProviderException, AuthnErrorException, JoseException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        String inParamUsernameOrId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        User user = this.getUserByIdOrName(inParamUsernameOrId);
        if (user == null && this.provisionUser && !AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
            OneTimeDevicesInfo oneTimeDevicesInfo;
            String supportOneTimeDeviceOTP;
            Map chainedAttributes;
            String username = Optional.ofNullable(InParamsUtil.getUsername(inParameters, this.usernameAttribute)).orElse(inParamUsernameOrId);
            user = this.provisionedUser(username);
            stateSupport.setUser(ModelMapperUtil.map(user));
            if (this.provisionAuthenticationMethods) {
                this.updateAuthenticationMethods(inParameters);
            }
            if ((chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes")) != null && chainedAttributes.get("support-one-time-device-otp") != null && "true".equalsIgnoreCase(supportOneTimeDeviceOTP = ((AttributeValue)chainedAttributes.get("support-one-time-device-otp")).getValue()) && StringUtils.isBlank(stateSupport.getPreviousPfStatus()) && !(oneTimeDevicesInfo = this.getOneTimeDevicesInfoObject(inParameters)).getDevices().isEmpty()) {
                try {
                    return this.initiateOneTimeDeviceOTPAuthenticationFlow(req, resp, inParameters, oneTimeDevicesInfo, stateSupport);
                }
                catch (AuthnErrorException e) {
                    return this.handleAuthnErrorException(req, resp, e);
                }
                catch (AccessTokenProviderException | InvalidActionException | JoseException | AuthnAdapterException e) {
                    LOG.log((LogEvent)PingOneMfaIdpAdapterLogEvent.ERROR_PROCESSING_REQUEST, e);
                    authnAdapterResponse = this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
                    return authnAdapterResponse;
                }
            }
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
            return this.handleAuthenticateRequest(req, resp, inParameters, stateSupport, false);
        }
        if (this.invalidUserBypass) {
            if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                LOG.log(PingOneMfaIdpAdapterLogEvent.ACCOUNT_RECOVERY_UNSUPPORTED_WITHOUT_MFA);
                authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                return authnAdapterResponse;
            }
        } else {
            LOG.log(PingOneMfaIdpAdapterLogEvent.INVALID_USER_BYPASS_DISABLED);
            return this.mfaFailedUserNotFoundResponse(req, resp, inParameters, stateSupport);
        }
        LOG.log(PingOneMfaIdpAdapterLogEvent.INVALID_USER_BYPASS_ENABLED);
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
        authnAdapterResponse.setAttributeMap(this.fulfillBypassedAttributeMap(inParamUsernameOrId, true));
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleAuthnErrorException(HttpServletRequest req, HttpServletResponse resp, AuthnErrorException e) throws IOException {
        this.authnApiSupport.writeErrorResponse(req, resp, e.getValidationError());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleAssertionFailure(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, ErrorDetail errorDetail) throws AuthnErrorException, IOException {
        String errorMessageKey = "assertion.failed.custom.challenge.already.used";
        if (this.authnApiSupport.isApiRequest(req)) {
            AuthnError authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
            authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_CHALLENGE_RESPONSE.makeInstance()));
            authnError.setUserMessageKey(errorMessageKey);
            throw new AuthnErrorException(authnError);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        this.pingOneMfaTemplateSupport.renderMfaFailedResponse(req, resp, inParameters, "title", "header", errorMessageKey);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleInvalidDeviceError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, InnerError innerError) throws AuthnErrorException, IOException {
        String errorMsgKey = "generic.error.message";
        List<Device> devices = stateSupport.getDevices();
        if (innerError != null) {
            List unusableDevices = innerError.getUnusableDevices().stream().map(UnavailableDevice::getId).collect(Collectors.toList());
            List<String> allowedValues = innerError.getAllowedValues();
            if (allowedValues != null && !allowedValues.isEmpty()) {
                devices.stream().filter(it -> !allowedValues.contains(it.getId())).forEach(it -> it.setUsable(false));
            }
            if (unusableDevices != null && !unusableDevices.isEmpty()) {
                devices.stream().filter(device -> unusableDevices.contains(device.getId())).forEach(device -> device.setUsable(false));
                errorMsgKey = "assertion.policy.error.message";
            }
            stateSupport.setDevices(devices);
        }
        if (this.authnApiSupport.isApiRequest(req)) {
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnError.setDetails(Collections.singletonList(CommonErrorDetailSpec.INVALID_DEVICE.makeInstance()));
            throw new AuthnErrorException(authnError);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        boolean shouldAggregateFidoDevices = this.shouldAggregateFidoDevices(devices, stateSupport.getIsFidoAggregationEnabled());
        this.pingOneMfaTemplateSupport.renderDeviceSelectionTemplate(req, resp, inParameters, shouldAggregateFidoDevices ? this.getDevicesWithAggregatedFido(devices) : devices, errorMsgKey, null, this.isAddMethodPermitted(inParameters, stateSupport), stateSupport.isManualPairingFlow(), !stateSupport.getBypassMfaBeforeDeviceMgmt(), stateSupport.getSupportUsePasswordPolicyAction(), this.isDevicesManagementAllowed(inParameters, stateSupport), shouldAggregateFidoDevices);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleInvalidOtpError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, OtpRequiredResponse otpRequiredResponse, String templateErrorMessageKey, Long attemptsRemaining) throws AuthnErrorException, TemplateRendererUtilException {
        AuthnError authnError = null;
        AuthnErrorDetail authnErrorDetail = null;
        CustomAuthnErrorDetail customAuthnErrorDetail = null;
        if (this.authnApiSupport.isApiRequest(req)) {
            authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnErrorDetail = CommonErrorDetailSpec.INVALID_OTP.makeInstance();
            customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
            customAuthnErrorDetail.setAttemptsRemaining(attemptsRemaining);
        }
        return this.writeOtpRequiredError(req, resp, inParameters, stateSupport, otpRequiredResponse, authnError, (AuthnErrorDetail)customAuthnErrorDetail, "authn.api.invalid.otp", templateErrorMessageKey, attemptsRemaining);
    }

    private AuthnAdapterResponse handleInvalidOtpError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PushConfirmationRequiredResponse pushConfirmationRequiredResponse, Long attemptsRemaining) throws AuthnErrorException, TemplateRendererUtilException {
        AuthnError authnError = null;
        AuthnErrorDetail authnErrorDetail = null;
        CustomAuthnErrorDetail customAuthnErrorDetail = null;
        if (this.authnApiSupport.isApiRequest(req)) {
            authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnErrorDetail = CommonErrorDetailSpec.INVALID_OTP.makeInstance();
            customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
            customAuthnErrorDetail.setAttemptsRemaining(attemptsRemaining);
        }
        return this.writeOtpRequiredError(req, resp, inParameters, stateSupport, pushConfirmationRequiredResponse, authnError, (AuthnErrorDetail)customAuthnErrorDetail, "authn.api.invalid.otp", "invalid.otp", attemptsRemaining);
    }

    private AuthnAdapterResponse handleInvalidOtpError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PushConfirmationTimedOutResponse pushConfirmationTimedOutResponse, Long attemptsRemaining) throws AuthnErrorException, TemplateRendererUtilException {
        AuthnError authnError = null;
        AuthnErrorDetail authnErrorDetail = null;
        CustomAuthnErrorDetail customAuthnErrorDetail = null;
        if (this.authnApiSupport.isApiRequest(req)) {
            authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnErrorDetail = CommonErrorDetailSpec.INVALID_OTP.makeInstance();
            customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
            customAuthnErrorDetail.setAttemptsRemaining(attemptsRemaining);
        }
        return this.writePushConfirmationTimedOutError(req, resp, inParameters, stateSupport, pushConfirmationTimedOutResponse, authnError, customAuthnErrorDetail, "authn.api.invalid.otp", "invalid.otp", attemptsRemaining);
    }

    private AuthnAdapterResponse handleOtpAttemptsLimitError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse flowResponse, ErrorResponse errorResponse) throws AuthnErrorException, IOException, AccessTokenProviderException {
        AuthnError authnError = this.getAuthnErrorForExhaustedOtpAttempts(req, errorResponse);
        CustomAuthnErrorDetail customAuthnErrorDetail = (CustomAuthnErrorDetail)((Object)authnError.getDetails().get(0));
        String authnApiUserMessageKey = "authn.api.otp.attempts.limit";
        String templateErrorMessageKey = "otp.attempts.limit";
        if (!"otp".equalsIgnoreCase(errorResponse.getErrorDetailTarget())) {
            templateErrorMessageKey = "totp.attempts.limit";
            authnApiUserMessageKey = "authn.api.totp.attempts.limit";
        }
        String status = stateSupport.getPreviousPfStatus();
        Long attemptsRemaining = errorResponse.getAttemptsRemaining();
        if (flowResponse instanceof OtpRequiredResponse) {
            return this.writeOtpRequiredError(req, resp, inParameters, stateSupport, (OtpRequiredResponse)flowResponse, authnError, (AuthnErrorDetail)customAuthnErrorDetail, authnApiUserMessageKey, templateErrorMessageKey, attemptsRemaining);
        }
        if (flowResponse instanceof DeviceSelectionRequiredResponse) {
            return this.writeDeviceSelectionRequiredError(req, resp, inParameters, stateSupport, (DeviceSelectionRequiredResponse)flowResponse, authnError, customAuthnErrorDetail, authnApiUserMessageKey, templateErrorMessageKey);
        }
        if (flowResponse instanceof PushConfirmationTimedOutResponse) {
            return this.writePushConfirmationTimedOutError(req, resp, inParameters, stateSupport, (PushConfirmationTimedOutResponse)flowResponse, authnError, customAuthnErrorDetail, authnApiUserMessageKey, templateErrorMessageKey, attemptsRemaining);
        }
        if (flowResponse instanceof PushConfirmationRequiredResponse) {
            return this.writeOtpRequiredError(req, resp, inParameters, stateSupport, (PushConfirmationRequiredResponse)flowResponse, authnError, (AuthnErrorDetail)customAuthnErrorDetail, authnApiUserMessageKey, templateErrorMessageKey, attemptsRemaining);
        }
        if (StateSpec.EMAIL_ACTIVATION_REQUIRED.getStatus().equals(status) || StateSpec.VOICE_ACTIVATION_REQUIRED.getStatus().equals(status) || StateSpec.SMS_ACTIVATION_REQUIRED.getStatus().equals(status) || StateSpec.TOTP_ACTIVATION_REQUIRED.getStatus().equals(status) || StateSpec.WHATSAPP_ACTIVATION_REQUIRED.getStatus().equals(status)) {
            return this.writeActivationRequiredError(req, resp, inParameters, stateSupport, authnError, customAuthnErrorDetail, authnApiUserMessageKey, templateErrorMessageKey, attemptsRemaining);
        }
        return this.mfaFailedServerErrorResponse(req, resp, inParameters, stateSupport, false);
    }

    private AuthnAdapterResponse writeIncorrectOTPLimitExceededDeviceLockedError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, ErrorResponse errorResponse, boolean isChangeDeviceButton) throws AuthnErrorException, TemplateRendererUtilException {
        if (this.authnApiSupport.isApiRequest(req)) {
            throw new AuthnErrorException(this.getAuthnErrorForExhaustedOtpAttempts(req, errorResponse));
        }
        if (errorResponse.getCoolDownExpiresAt() != null && errorResponse.getCoolDownExpiresAt() > 0L) {
            this.pingOneMfaTemplateSupport.renderDeviceLockedTemplateWithCoolDown(req, resp, inParameters, null, "otp.attempts.limit.with.cooldown", isChangeDeviceButton, errorResponse.getCoolDownExpiresAt());
        } else {
            String unsuccessfulPasscodeAttemptsKey = isChangeDeviceButton ? "incorrect.otp.limit.exhausted.authentication" : "incorrect.otp.limit.exhausted.pairing";
            this.pingOneMfaTemplateSupport.renderDeviceLockedTemplate(req, resp, inParameters, null, unsuccessfulPasscodeAttemptsKey, isChangeDeviceButton);
        }
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handleNotificationCoolDownError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, ErrorResponse errorResponse, boolean isChangeDeviceButton) throws AuthnErrorException, TemplateRendererUtilException {
        if (this.authnApiSupport.isApiRequest(req)) {
            throw new AuthnErrorException(ErrorResponseUtil.transformPingOneErrorToPingFedErrorResponse(400, errorResponse));
        }
        this.pingOneMfaTemplateSupport.renderDeviceLockedTemplateWithCoolDown(req, resp, inParameters, null, "notification.cooldown.limit_exceeded", isChangeDeviceButton, errorResponse.getCoolDownExpiresAt());
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnError getAuthnErrorForExhaustedOtpAttempts(HttpServletRequest req, ErrorResponse errorResponse) {
        AuthnErrorDetail authnErrorDetail = CommonErrorDetailSpec.OTP_ATTEMPTS_LIMIT.makeInstance();
        String authnApiUserMessageKey = "authn.api.otp.attempts.limit";
        if (!"otp".equalsIgnoreCase(errorResponse.getErrorDetailTarget())) {
            authnErrorDetail = CommonErrorDetailSpec.TOTP_ATTEMPTS_LIMIT.makeInstance();
            authnApiUserMessageKey = "authn.api.totp.attempts.limit";
        }
        CustomAuthnErrorDetail customAuthnErrorDetail = new CustomAuthnErrorDetail(authnErrorDetail);
        if (errorResponse.getCoolDownExpiresAt() != null) {
            customAuthnErrorDetail.setCoolDownExpiresAt(errorResponse.getCoolDownExpiresAt());
        }
        if (errorResponse.getQuotaLimit() != null) {
            customAuthnErrorDetail.setQuotaLimit(errorResponse.getQuotaLimit());
        }
        if (errorResponse.getAttemptsRemaining() != null) {
            customAuthnErrorDetail.setAttemptsRemaining(errorResponse.getAttemptsRemaining());
        }
        String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
        customAuthnErrorDetail.setUserMessage(userMessage);
        AuthnError authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
        authnError.setDetails(Collections.singletonList(customAuthnErrorDetail));
        return authnError;
    }

    private AuthnAdapterResponse handleOtpResendLimitError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, FlowResponse flowResponse) throws AuthnErrorException, IOException, AccessTokenProviderException {
        AuthnError authnError = null;
        AuthnErrorDetail authnErrorDetail = null;
        if (this.authnApiSupport.isApiRequest(req)) {
            authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
            authnErrorDetail = CommonErrorDetailSpec.OTP_RESEND_LIMIT.makeInstance();
        }
        if (flowResponse instanceof OtpRequiredResponse) {
            return this.writeOtpRequiredError(req, resp, inParameters, stateSupport, (OtpRequiredResponse)flowResponse, authnError, authnErrorDetail, "authn.api.otp.resend.limit", "otp.resend.limit", null);
        }
        return this.writeDeviceSelectionRequiredError(req, resp, inParameters, stateSupport, (DeviceSelectionRequiredResponse)flowResponse, authnError, authnErrorDetail, "authn.api.otp.resend.limit", "otp.resend.limit");
    }

    private AuthnAdapterResponse writeOtpRequiredError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, OtpRequiredResponse getFlowResponse, AuthnError authnError, AuthnErrorDetail authnErrorDetail, String authnApiUserMessageKey, String templateErrorMessageKey, Long attemptsRemaining) throws AuthnErrorException, TemplateRendererUtilException {
        String errorMessagePlainTextWithCooldown = "";
        if (this.authnApiSupport.isApiRequest(req)) {
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
                authnErrorDetail.setUserMessage(userMessage);
                authnError.setDetails(Collections.singletonList(authnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        if (authnErrorDetail instanceof CustomAuthnErrorDetail) {
            errorMessagePlainTextWithCooldown = this.getPlainTextErrorMessageWithCoolDown(req, "pingone.mfa.otp.required.otp.attempts.limit.with.cooldown", ((CustomAuthnErrorDetail)authnErrorDetail).getCoolDownExpiresAt());
        }
        String selectedDeviceId = getFlowResponse.getSelectedDeviceId().getId();
        List<Device> devices = ModelMapperUtil.map(getFlowResponse.getEmbeddedResources().getDevices());
        Device selectedDevice = this.getDevice(devices, selectedDeviceId);
        this.pingOneMfaTemplateSupport.renderOtpRequiredTemplate(req, resp, inParameters, selectedDevice, templateErrorMessageKey, errorMessagePlainTextWithCooldown, devices, this.isAddMethodPermitted(inParameters, stateSupport), attemptsRemaining, this.getOtpLength(getFlowResponse));
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private String getPlainTextErrorMessageWithCoolDown(HttpServletRequest req, String templateErrorMessageKey, Long coolDownExpiresAt) {
        String errorMessagePlainText = null;
        if (coolDownExpiresAt != null && coolDownExpiresAt > 0L) {
            long totalSecondsRemaining = (coolDownExpiresAt - System.currentTimeMillis()) / 1000L;
            long minutes = totalSecondsRemaining % 3600L / 60L;
            long seconds = totalSecondsRemaining % 60L;
            long friendlyDuration = 0L;
            String unitErrorMessageKey = ".unit.seconds";
            if (minutes <= 1L) {
                unitErrorMessageKey = ".unit.minute";
                friendlyDuration = minutes;
            } else if (minutes > 1L) {
                unitErrorMessageKey = ".unit.minutes";
                friendlyDuration = minutes;
            }
            if (minutes == 0L && seconds <= 1L) {
                unitErrorMessageKey = ".unit.second";
                friendlyDuration = seconds;
            }
            if (minutes == 0L && seconds > 1L) {
                unitErrorMessageKey = ".unit.seconds";
                friendlyDuration = seconds;
            }
            LanguagePackMessagesSupport languagePackMessagesSupport = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport();
            String unit = languagePackMessagesSupport.getPingOneMfaAdapterMessage(req, templateErrorMessageKey + unitErrorMessageKey);
            errorMessagePlainText = languagePackMessagesSupport.getPingOneMfaAdapterMessage(req, templateErrorMessageKey, String.valueOf(friendlyDuration), unit);
        }
        return errorMessagePlainText;
    }

    private AuthnAdapterResponse writeOtpRequiredError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PushConfirmationRequiredResponse getFlowResponse, AuthnError authnError, AuthnErrorDetail authnErrorDetail, String authnApiUserMessageKey, String templateErrorMessageKey, Long attemptsRemaining) throws AuthnErrorException, TemplateRendererUtilException {
        if (this.authnApiSupport.isApiRequest(req)) {
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
                authnErrorDetail.setUserMessage(userMessage);
                authnError.setDetails(Collections.singletonList(authnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        String selectedDeviceId = getFlowResponse.getSelectedDeviceId().getId();
        List<Device> devices = ModelMapperUtil.map(getFlowResponse.getEmbeddedResources().getDevices());
        Device selectedDevice = this.getDevice(devices, selectedDeviceId);
        String errorMessagePlainTextWithCooldown = null;
        if (authnErrorDetail instanceof CustomAuthnErrorDetail) {
            errorMessagePlainTextWithCooldown = this.getPlainTextErrorMessageWithCoolDown(req, "pingone.mfa.otp.required.otp.attempts.limit.with.cooldown", ((CustomAuthnErrorDetail)authnErrorDetail).getCoolDownExpiresAt());
        }
        this.pingOneMfaTemplateSupport.renderOtpRequiredTemplate(req, resp, inParameters, selectedDevice, templateErrorMessageKey, errorMessagePlainTextWithCooldown, devices, this.isAddMethodPermitted(inParameters, stateSupport), attemptsRemaining, 6);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse writePushConfirmationTimedOutError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, PushConfirmationTimedOutResponse pushConfirmationTimedOutResponse, AuthnError authnError, AuthnErrorDetail authnErrorDetail, String authnApiUserMessageKey, String templateErrorMessageKey, Long attemptsRemaining) throws AuthnErrorException, TemplateRendererUtilException {
        if (this.authnApiSupport.isApiRequest(req)) {
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
                authnErrorDetail.setUserMessage(userMessage);
                authnError.setDetails(Collections.singletonList(authnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        String selectedDeviceId = pushConfirmationTimedOutResponse.getSelectedDeviceId().getId();
        List<Device> devices = ModelMapperUtil.map(pushConfirmationTimedOutResponse.getEmbeddedResources().getDevices());
        Device selectedDevice = this.getDevice(devices, selectedDeviceId);
        this.pingOneMfaTemplateSupport.renderPushConfirmationTimedOutResponse(req, resp, inParameters, selectedDevice, devices, templateErrorMessageKey, this.isAddMethodPermitted(inParameters, stateSupport), attemptsRemaining);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse writeDeviceSelectionRequiredError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport, DeviceSelectionRequiredResponse deviceSelectionRequiredResponse, AuthnError authnError, AuthnErrorDetail authnErrorDetail, String authnApiUserMessageKey, String templateErrorMessageKey) throws AuthnErrorException, IOException {
        List<Device> devices;
        boolean shouldAggregateFidoDevices;
        if (this.authnApiSupport.isApiRequest(req)) {
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, authnApiUserMessageKey);
                authnErrorDetail.setUserMessage(userMessage);
                authnError.setDetails(Collections.singletonList(authnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        String errorMessagePlainText = null;
        if (authnErrorDetail instanceof CustomAuthnErrorDetail) {
            errorMessagePlainText = this.getPlainTextErrorMessageWithCoolDown(req, "pingone.mfa.device.selection.otp.attempts.limit.with.cooldown", ((CustomAuthnErrorDetail)authnErrorDetail).getCoolDownExpiresAt());
        }
        this.pingOneMfaTemplateSupport.renderDeviceSelectionTemplate(req, resp, inParameters, (shouldAggregateFidoDevices = this.shouldAggregateFidoDevices(devices = ModelMapperUtil.map(deviceSelectionRequiredResponse.getEmbeddedResources().getDevices()), stateSupport.getIsFidoAggregationEnabled())) ? this.getDevicesWithAggregatedFido(devices) : devices, templateErrorMessageKey, errorMessagePlainText, this.isAddMethodPermitted(inParameters, stateSupport), stateSupport.isManualPairingFlow(), !stateSupport.getBypassMfaBeforeDeviceMgmt(), stateSupport.getSupportUsePasswordPolicyAction(), this.isDevicesManagementAllowed(inParameters, stateSupport), shouldAggregateFidoDevices);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse handlePushFailedError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AuthnErrorException, IOException, AccessTokenProviderException {
        boolean shouldAggregateFidoDevices;
        List<Device> devices;
        Device selectedDevice;
        if (this.authnApiSupport.isApiRequest(req)) {
            AuthnError authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
            AuthnErrorDetail authnErrorDetail = CommonErrorDetailSpec.PUSH_FAILED.makeInstance();
            String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, "authn.api.push.failed");
            authnErrorDetail.setUserMessage(userMessage);
            authnError.setDetails(Collections.singletonList(authnErrorDetail));
            throw new AuthnErrorException(authnError);
        }
        ResourceRef selectedDeviceRef = this.getSelectedDeviceRef(req);
        String selectedDeviceId = null;
        if (selectedDeviceRef != null) {
            selectedDeviceId = selectedDeviceRef.getId();
        }
        if ((selectedDevice = this.getDevice(devices = stateSupport.getDevices(), selectedDeviceId)) != null) {
            selectedDevice.setUsable(false);
        }
        this.pingOneMfaTemplateSupport.renderDeviceSelectionTemplate(req, resp, inParameters, (shouldAggregateFidoDevices = this.shouldAggregateFidoDevices(devices, stateSupport.getIsFidoAggregationEnabled())) ? this.getDevicesWithAggregatedFido(devices) : devices, "generic.error.message", null, this.isAddMethodPermitted(inParameters, stateSupport), stateSupport.isManualPairingFlow(), !stateSupport.getBypassMfaBeforeDeviceMgmt(), stateSupport.getSupportUsePasswordPolicyAction(), this.isDevicesManagementAllowed(inParameters, stateSupport), shouldAggregateFidoDevices);
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private boolean isAddMethodPermitted(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        return this.isDevicesManagementAllowed(inParameters, stateSupport) && !this.isUsedReachedMaxAllowedDevices(stateSupport);
    }

    private boolean isUsedReachedMaxAllowedDevices(PingOneMfaStateSupport stateSupport) {
        int maxAllowedDevices;
        int userPairedDevices = Optional.ofNullable(stateSupport).map(PingOneMfaStateSupport::getDevices).map(List::size).orElse(0);
        return userPairedDevices >= (maxAllowedDevices = Optional.ofNullable(stateSupport).map(PingOneMfaStateSupport::getMaxAllowedDevices).orElse(5).intValue());
    }

    private boolean isDevicesManagementAllowed(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        return this.allowDeviceManagement && InParamsUtil.isUserIdAuthenticated(inParameters) && !AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters) && !stateSupport.isManualPairingFlow() && !stateSupport.isRemoveOrUpdateDeviceFlow() && !stateSupport.getMobileRequest();
    }

    private boolean isSetupMfaPermitted(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        return this.allowSetupMfa && InParamsUtil.isUserIdAuthenticated(inParameters) && !AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters) && !stateSupport.getMobileRequest();
    }

    private String getAuthnContexts(Map<String, Object> inParameters) {
        Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        Map trackedParameters = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        String acrReceived = null;
        if (chainedAttributes != null && chainedAttributes.containsKey("pingone-mfa-acr") && StringUtils.isNotBlank(((AttributeValue)chainedAttributes.get("pingone-mfa-acr")).getValue())) {
            acrReceived = ((AttributeValue)chainedAttributes.get("pingone-mfa-acr")).getValue();
            log.debug("Found 'pingone-mfa-acr' with value '" + acrReceived + "' in chained attributes");
        } else if (signedRequestClaims != null && signedRequestClaims.containsKey("pingone-mfa-acr") && signedRequestClaims.get("pingone-mfa-acr") != null) {
            Object object = signedRequestClaims.get("pingone-mfa-acr");
            if (object instanceof String) {
                acrReceived = (String)object;
                log.debug("Found 'pingone-mfa-acr' with value '" + acrReceived + "' in signed request object claims");
            }
        } else if (trackedParameters != null && trackedParameters.containsKey("pingone-mfa-acr") && StringUtils.isNotBlank((CharSequence)((List)trackedParameters.get("pingone-mfa-acr")).get(0))) {
            acrReceived = (String)((List)trackedParameters.get("pingone-mfa-acr")).get(0);
            log.debug("Found 'pingone-mfa-acr' with value '" + acrReceived + "' in tracked parameters");
        }
        if (StringUtils.isNotBlank(acrReceived)) {
            return acrReceived;
        }
        AuthnPolicy authnPolicy = (AuthnPolicy)inParameters.get("com.pingidentity.adapter.input.parameter.authn.policy");
        List acrValues = authnPolicy.getRequestAuthnContexts();
        if (acrValues != null && !acrValues.isEmpty()) {
            String acr = String.join((CharSequence)"%20", acrValues);
            log.debug("Received standards based authentication context value: " + acr);
            return acr;
        }
        return null;
    }

    public String extractClientContext(Map<String, Object> inParameters) {
        Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        Map trackedParameters = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        String clientContext = this.getValueFromInputSource(chainedAttributes, "pi.clientContext");
        if (clientContext == null) {
            clientContext = this.getValueFromInputSource(signedRequestClaims, "pi.clientContext");
        }
        if (clientContext == null) {
            clientContext = this.getValueFromInputSource(trackedParameters, "pi.clientContext");
        }
        ObjectNode jsonObject = ObjectMappers.getDefault().createObjectNode();
        if (clientContext != null) {
            try {
                jsonObject = ObjectMappers.getDefault().readValue(clientContext, ObjectNode.class);
            }
            catch (JsonProcessingException e) {
                log.error("Ignoring invalid pi.clientContext data received in the request. Processing other sources to construct pi.clientContext info");
            }
        }
        if (trackedParameters != null) {
            this.extractDynamicVariables(trackedParameters, "pi.clientContext.").forEach(jsonObject::put);
        }
        if (signedRequestClaims != null) {
            this.extractDynamicVariables(signedRequestClaims, "pi.clientContext.").forEach(jsonObject::put);
        }
        if (chainedAttributes != null) {
            this.extractDynamicVariables(chainedAttributes, "pi.clientContext.").forEach(jsonObject::put);
        }
        if (!jsonObject.isEmpty()) {
            try {
                return ObjectMappers.getDefault().writeValueAsString(jsonObject);
            }
            catch (JsonProcessingException e) {
                log.error("Ignoring invalid pi.clientContext data received in the request.");
            }
        }
        return null;
    }

    public String getCustomChallenge(Map<String, Object> inParameters) {
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        String customChallenge = this.getValueFromInputSource(signedRequestClaims, "pi.webAuthn.challenge");
        return customChallenge;
    }

    public Notification extractNotificationTemplate(Map<String, Object> inParameters, String defaultLocale) {
        Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        Map trackedParameters = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        Notification.Template notificationsTemplate = null;
        String piTemplate = this.getValueFromInputSource(chainedAttributes, "pi.template");
        if (piTemplate == null) {
            piTemplate = this.getValueFromInputSource(signedRequestClaims, "pi.template");
        }
        if (piTemplate == null) {
            piTemplate = this.getValueFromInputSource(trackedParameters, "pi.template");
        }
        if (piTemplate != null) {
            try {
                notificationsTemplate = ObjectMappers.getDefault().readValue(piTemplate, Notification.Template.class);
            }
            catch (JsonProcessingException e) {
                log.error("Ignoring invalid pi.template data received in the request. Processing other sources to construct pi.template info");
            }
        }
        notificationsTemplate = Optional.ofNullable(notificationsTemplate).orElse(new Notification.Template());
        if (trackedParameters != null) {
            this.setIndividualTemplateAttributesFromSource(notificationsTemplate, trackedParameters);
        }
        if (signedRequestClaims != null) {
            this.setIndividualTemplateAttributesFromSource(notificationsTemplate, signedRequestClaims);
        }
        if (chainedAttributes != null) {
            this.setIndividualTemplateAttributesFromSource(notificationsTemplate, chainedAttributes);
        }
        if (notificationsTemplate.getVariables() != null && notificationsTemplate.getVariables().isEmpty()) {
            notificationsTemplate.setVariables(null);
        }
        if (notificationsTemplate.getLocale() == null) {
            notificationsTemplate.setLocale(defaultLocale);
        }
        if (StringUtils.isNotBlank(this.notificationTemplateVariantOverride)) {
            notificationsTemplate.setVariant(this.notificationTemplateVariantOverride);
        }
        return new Notification(notificationsTemplate);
    }

    private void setIndividualTemplateAttributesFromSource(Notification.Template notificationsTemplate, Map<String, ? extends Object> inputSource) {
        notificationsTemplate.setName(Optional.ofNullable(this.getValueFromInputSource(inputSource, "pi.template.name")).orElse(notificationsTemplate.getName()));
        notificationsTemplate.setVariant(Optional.ofNullable(this.getValueFromInputSource(inputSource, "pi.template.variant")).orElse(notificationsTemplate.getVariant()));
        notificationsTemplate.setLocale(Optional.ofNullable(this.getValueFromInputSource(inputSource, "pi.template.locale")).orElse(notificationsTemplate.getLocale()));
        notificationsTemplate.getVariables().putAll(this.extractDynamicVariables(inputSource, "pi.template.variables."));
    }

    private Map<String, String> extractDynamicVariables(Map<String, ? extends Object> chainedAttributes, String keyPrfix) {
        HashMap<String, String> dynamicVariables = new HashMap<String, String>();
        for (String key : chainedAttributes.keySet()) {
            String value;
            if (!key.startsWith(keyPrfix) || !StringUtils.isNotBlank(value = this.castValue(chainedAttributes.get(key)))) continue;
            dynamicVariables.put(key.substring(keyPrfix.length()), value);
        }
        return dynamicVariables;
    }

    private String getValueFromInputSource(Map<String, ? extends Object> source, String key) {
        if (source != null && source.containsKey(key)) {
            return this.castValue(source.get(key));
        }
        return null;
    }

    private String castValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof AttributeValue) {
            return ((AttributeValue)value).getValue();
        }
        if (value instanceof List) {
            return (String)((List)value).get(0);
        }
        if (value instanceof Object) {
            try {
                return ObjectMappers.getDefault().writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                log.error("Received invalid data format for pi.template inside signed request object");
            }
        }
        return null;
    }

    private String getMobilePayload(HttpServletRequest req, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AuthnErrorException, IOException {
        String pidSdkPayload;
        Collection mobilePayloadCollection;
        String mobilePayload = null;
        boolean userAuthenticated = InParamsUtil.isUserIdAuthenticated(inParameters);
        boolean isPasswordResetFlow = AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters);
        if (!userAuthenticated || isPasswordResetFlow) {
            if (!userAuthenticated) {
                log.debug("Ignoring mobile payload since user is not authenticated.");
            }
            if (isPasswordResetFlow) {
                log.debug("Ignoring mobile payload within password reset flow.");
            }
            stateSupport.setMobileRequest(false);
            return null;
        }
        Map trackedParameters = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
        if (trackedParameters != null && (mobilePayloadCollection = (Collection)trackedParameters.get("mobilePayload")) != null && !mobilePayloadCollection.isEmpty()) {
            mobilePayload = (String)mobilePayloadCollection.toArray()[0];
        }
        if (StringUtils.isNotBlank(pidSdkPayload = stateSupport.getPidSdkPayload())) {
            mobilePayload = pidSdkPayload;
        }
        DynamicData dynamicData = stateSupport.getPidSdkDynamicData();
        if (this.authnApiSupport.isApiRequest(req)) {
            if (ActionSpec.AUTHENTICATE.isRequested(req)) {
                CustomAuthenticate authenticate = (CustomAuthenticate)((Object)this.authnApiSupport.deserializeAsModel(req, CustomAuthenticate.class));
                mobilePayload = StringUtils.isNotBlank(authenticate.getMobilePayload()) ? authenticate.getMobilePayload() : mobilePayload;
            } else if (ActionSpec.SELECT_DEVICE.isRequested(req)) {
                CustomSelectDevice selectDevice = (CustomSelectDevice)((Object)this.authnApiSupport.deserializeAsModel(req, CustomSelectDevice.class));
                mobilePayload = StringUtils.isNotBlank(selectDevice.getMobilePayload()) ? selectDevice.getMobilePayload() : mobilePayload;
            }
        }
        stateSupport.setMobileRequest(mobilePayload != null);
        return mobilePayload;
    }

    private AuthnAdapterResponse handleNoUsableDevices(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, MfaFailed.NO_USABLE_DEVICES);
    }

    private AuthnAdapterResponse handleMfaDisabledError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        AuthnAdapterResponse authnAdapterResponse;
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        if (this.invalidUserBypass) {
            if (AccountRecoveryFlowUtil.isPasswordResetRequest(inParameters)) {
                LOG.log(PingOneMfaIdpAdapterLogEvent.ACCOUNT_RECOVERY_UNSUPPORTED_WITHOUT_MFA);
                AuthnAdapterResponse authnAdapterResponse2 = new AuthnAdapterResponse();
                authnAdapterResponse2.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
                return authnAdapterResponse2;
            }
            authnAdapterResponse = new AuthnAdapterResponse();
            authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.SUCCESS);
            authnAdapterResponse.setAttributeMap(this.fulfillBypassedAttributeMap(username, true));
        }
        authnAdapterResponse = this.mfaFailedMfaDisabledResponse(req, resp, inParameters, stateSupport);
        return authnAdapterResponse;
    }

    private List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> getUserDevicesFromPingOne(String username) throws AccessTokenProviderException, IOException {
        String accessToken = this.tokenService.getToken();
        List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> userActiveDevices = this.workerApiClient.getUserDevices(accessToken, username, "status eq \"ACTIVE\"");
        DeviceAuthenticationPolicy authenticationPolicy = this.workerApiClient.getMFAPolicyFromAuthenticationPolicy(accessToken, this.authenticationPolicy);
        return userActiveDevices.stream().filter(authenticationPolicy::isSupported).collect(Collectors.toList());
    }

    public Map<String, Object> fulfillBypassedAttributeMap(String userName, boolean invalidUserError) {
        return this.fulfillBypassedAttributeMap(userName, invalidUserError, false);
    }

    private Map<String, Object> fulfillBypassedAttributeMapOneTimeDeviceAuthenticationFlow(ValidateOneTimeDeviceAuthenticationRequestResponse validateOneTimeDeviceAuthenticationRequestResponse, String username) {
        CoreContract[] values;
        Object pingOneMfaStatus = null;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (CoreContract value : values = CoreContract.values()) {
            if (value.toString().equals(CoreContract.POLICY_ACTION.toString())) continue;
            attributeMap.put(value.toString(), null);
        }
        attributeMap.put(CoreContract.USERNAME.toString(), username);
        String type = validateOneTimeDeviceAuthenticationRequestResponse.getSelectedDevice().getOneTime().getType();
        if ("EMAIL".equalsIgnoreCase(type)) {
            attributeMap.put(CoreContract.P1_MFA_STATUS.toString(), PingOneMfaStatus.WEB_LOGIN_EMAIL.toString());
        } else if ("SMS".equalsIgnoreCase(type)) {
            attributeMap.put(CoreContract.P1_MFA_STATUS.toString(), PingOneMfaStatus.WEB_LOGIN_SMS.toString());
        } else if ("VOICE".equalsIgnoreCase(type)) {
            attributeMap.put(CoreContract.P1_MFA_STATUS.toString(), PingOneMfaStatus.WEB_LOGIN_VOICE.toString());
        }
        return attributeMap;
    }

    private Map<String, Object> fulfillUsernamelessAuthenticationFlowAttributeMap(UsernamelessAuthAssertionCheckRequestResponse assertionCheckRequestResponse) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> deviceList = assertionCheckRequestResponse.getEmbeddedResources().getDevices();
        String selectedDeviceId = assertionCheckRequestResponse.getSelectedDevice().getId();
        String userId = assertionCheckRequestResponse.getUser().getId();
        attributeMap.put(CoreContract.USERNAMELESS_FLOW_USERID.toString(), userId);
        Optional<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> optionalDevice = deviceList.stream().filter(it -> it.getId().equals(selectedDeviceId)).findFirst();
        if (optionalDevice.isPresent()) {
            WebAuthnDevice webAuthnDevice;
            User user;
            com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device selectedDevice = optionalDevice.get();
            if ("PLATFORM".equals(selectedDevice.getType())) {
                attributeMap.put(CoreContract.USERNAMELESS_FLOW_PLATFORM.toString(), ((PlatformDevice)selectedDevice).getPlatform());
            }
            if (selectedDevice instanceof WebAuthnDevice && (user = (webAuthnDevice = (WebAuthnDevice)selectedDevice).getUser()) != null) {
                attributeMap.put(CoreContract.USERNAME.toString(), user.getUsername());
            }
        }
        return attributeMap;
    }

    public Map<String, Object> fulfillBypassedAttributeMapAuthenticationCodeFlow(String userId, String username) {
        CoreContract[] values;
        Object pingOneMfaStatus = null;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (CoreContract value : values = CoreContract.values()) {
            if (value.toString().equals(CoreContract.POLICY_ACTION.toString())) continue;
            attributeMap.put(value.toString(), null);
        }
        attributeMap.put(CoreContract.AUTH_CODE_FLOW_USERID.toString(), userId);
        if (StringUtils.isNotBlank(username)) {
            attributeMap.put(CoreContract.USERNAME.toString(), username);
        }
        attributeMap.put(CoreContract.P1_MFA_STATUS.toString(), PingOneMfaStatus.MOBILE_LOGIN_AUTHENTICATION_CODE.toString());
        return attributeMap;
    }

    public Map<String, Object> fulfillBypassedAttributeMap(String userName, boolean invalidUserError, boolean mfaWasSkipped) {
        CoreContract[] values;
        PingOneMfaStatus pingOneMfaStatus = null;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (CoreContract value : values = CoreContract.values()) {
            if (value.toString().equals(CoreContract.POLICY_ACTION.toString())) continue;
            attributeMap.put(value.toString(), null);
        }
        attributeMap.put(CoreContract.USERNAME.toString(), userName);
        if (invalidUserError && this.invalidUserBypass) {
            pingOneMfaStatus = PingOneMfaStatus.MFA_BYPASSED_INVALID_USER;
        } else if (mfaWasSkipped) {
            pingOneMfaStatus = PingOneMfaStatus.MFA_BYPASSED_SKIP_MFA;
        } else if (this.apiFailureBypass) {
            pingOneMfaStatus = PingOneMfaStatus.MFA_BYPASSED_DURING_ERRORS;
        }
        if (pingOneMfaStatus != null) {
            attributeMap.put(CoreContract.P1_MFA_STATUS.toString(), pingOneMfaStatus.toString());
            attributeMap.put(CoreContract.PID_SDK_STATUS.toString(), PingIdSdkMfaStatus.getPingIdSdkMfaStatus(pingOneMfaStatus).toString());
        }
        return attributeMap;
    }

    private Map<String, Object> fulfillAttributeMap(String userName, AuthorizeResponse authorizeResponse, PingOneMfaStateSupport stateSupport, boolean deviceWasPaired) {
        String idTokenString;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put(CoreContract.USERNAME.toString(), userName);
        if (authorizeResponse != null) {
            String accessToken = authorizeResponse.getAccessToken();
            String idToken = authorizeResponse.getIdToken();
            attributeMap.put(CoreContract.ACCESS_TOKEN.toString(), accessToken);
            attributeMap.put(CoreContract.ID_TOKEN.toString(), idToken);
        }
        Pair<PingOneMfaStatus, PingOneMfaStatus.Reason> pingOneMfaStatusReasonPair = this.getPingOneMfaStatus(authorizeResponse, stateSupport, deviceWasPaired);
        PingOneMfaStatus pingOneMfaStatus = pingOneMfaStatusReasonPair.getLeft();
        PingOneMfaStatus.Reason pingOneMfaStatusReason = pingOneMfaStatusReasonPair.getRight();
        if (pingOneMfaStatus != null) {
            attributeMap.put(CoreContract.P1_MFA_STATUS.toString(), pingOneMfaStatus.toString());
            attributeMap.put(CoreContract.PID_SDK_STATUS.toString(), PingIdSdkMfaStatus.getPingIdSdkMfaStatus(pingOneMfaStatus).toString());
        }
        if (pingOneMfaStatusReason != null) {
            attributeMap.put(CoreContract.P1_MFA_STATUS_REASON.toString(), pingOneMfaStatusReason.toString());
            attributeMap.put(CoreContract.PID_SDK_STATUS_REASON.toString(), PingIdSdkMfaStatus.getPingIdSdkMfaStatusReason(pingOneMfaStatusReason).toString());
        }
        if (authorizeResponse != null && StringUtils.isNotBlank(idTokenString = authorizeResponse.getIdToken())) {
            IdToken idToken = null;
            try {
                String serverPayload;
                idToken = new IdToken(idTokenString);
                IdToken.PingOneEnrollment pingOneEnrollment = idToken.getP1Enrollment();
                if (pingOneEnrollment != null && StringUtils.isNotBlank(serverPayload = pingOneEnrollment.getServerPayload())) {
                    if (pingOneMfaStatus != null) {
                        attributeMap.put(CoreContract.PID_SDK_STATUS.toString(), PingIdSdkMfaStatus.getPingIdSdkMfaStatus(pingOneMfaStatus).toString());
                    }
                    if (pingOneMfaStatusReason != null) {
                        attributeMap.put(CoreContract.PID_SDK_STATUS_REASON.toString(), PingIdSdkMfaStatus.getPingIdSdkMfaStatusReason(pingOneMfaStatusReason).toString());
                    }
                }
            }
            catch (MalformedClaimException | InvalidJwtException | IOException exception) {
                // empty catch block
            }
        }
        return attributeMap;
    }

    private Pair<PingOneMfaStatus, PingOneMfaStatus.Reason> getPingOneMfaStatus(AuthorizeResponse authorizeResponse, PingOneMfaStateSupport stateSupport, boolean deviceWasPaired) {
        PingOneMfaStatus.Reason reason;
        PingOneMfaStatus pingOneMfaStatus;
        block36: {
            pingOneMfaStatus = null;
            reason = null;
            if (authorizeResponse != null) {
                String idTokenString = authorizeResponse.getIdToken();
                boolean mobileRequest = stateSupport.getMobileRequest();
                try {
                    IdToken idToken = new IdToken(idTokenString);
                    List<String> amr = idToken.getAmr();
                    if (deviceWasPaired) {
                        pingOneMfaStatus = PingOneMfaStatus.DEVICE_PAIRED;
                        if (amr.contains(IdToken.AmrValues.SMS.toString())) {
                            reason = PingOneMfaStatus.Reason.MOBILE_LOGIN_SMS;
                        } else if (amr.contains(IdToken.AmrValues.EMAIL.toString())) {
                            reason = PingOneMfaStatus.Reason.MOBILE_LOGIN_EMAIL;
                        } else if (amr.contains(IdToken.AmrValues.TEL.toString())) {
                            reason = PingOneMfaStatus.Reason.MOBILE_LOGIN_VOICE;
                        } else if (amr.contains(IdToken.AmrValues.OTP.toString())) {
                            reason = PingOneMfaStatus.Reason.MOBILE_LOGIN_OTP;
                        } else if (amr.contains(IdToken.AmrValues.USER.toString()) && amr.contains(IdToken.AmrValues.FIDO.toString())) {
                            reason = PingOneMfaStatus.Reason.MOBILE_LOGIN_FIDO;
                        } else if (amr.contains(IdToken.AmrValues.USER.toString()) && amr.contains(IdToken.AmrValues.MCA.toString())) {
                            reason = PingOneMfaStatus.Reason.MOBILE_LOGIN_MOBILE;
                        }
                        break block36;
                    }
                    IdToken.PingOneEnrollment p1Enrollment = null;
                    try {
                        p1Enrollment = idToken.getP1Enrollment();
                    }
                    catch (MalformedClaimException | IOException exception) {
                        // empty catch block
                    }
                    if (p1Enrollment == null) {
                        if (amr.isEmpty()) {
                            pingOneMfaStatus = mobileRequest ? PingOneMfaStatus.DEVICE_NOT_PAIRED : PingOneMfaStatus.WEB_LOGIN_NO_DEVICES;
                        } else if (amr.contains(IdToken.AmrValues.SWK.toString())) {
                            String authSessionType = stateSupport.getAuthSessionType();
                            pingOneMfaStatus = !amr.contains(IdToken.AmrValues.EXTRA_VERIFICATION.toString()) && !amr.contains(IdToken.AmrValues.MCA.toString()) && StringUtils.isNotBlank(authSessionType) && AuthSession.Type.EXTRA_VERIFICATION_PERMISSIVE.toString().equals(authSessionType) ? PingOneMfaStatus.DEVICE_AUTHORIZED_NO_RESPONSE_PASSIVE_PUSH : PingOneMfaStatus.DEVICE_AUTHORIZED;
                        } else if (amr.contains(IdToken.AmrValues.OTP.toString())) {
                            pingOneMfaStatus = mobileRequest ? PingOneMfaStatus.MOBILE_LOGIN_OTP : PingOneMfaStatus.WEB_LOGIN_OTP;
                        } else if (amr.contains(IdToken.AmrValues.SMS.toString())) {
                            pingOneMfaStatus = mobileRequest ? PingOneMfaStatus.MOBILE_LOGIN_SMS : PingOneMfaStatus.WEB_LOGIN_SMS;
                        } else if (amr.contains(IdToken.AmrValues.EMAIL.toString())) {
                            pingOneMfaStatus = mobileRequest ? PingOneMfaStatus.MOBILE_LOGIN_EMAIL : PingOneMfaStatus.WEB_LOGIN_EMAIL;
                        } else if (amr.contains(IdToken.AmrValues.TEL.toString())) {
                            pingOneMfaStatus = mobileRequest ? PingOneMfaStatus.MOBILE_LOGIN_VOICE : PingOneMfaStatus.WEB_LOGIN_VOICE;
                        } else if (amr.contains(IdToken.AmrValues.USER.toString()) && amr.contains(IdToken.AmrValues.FIDO.toString())) {
                            pingOneMfaStatus = !mobileRequest ? PingOneMfaStatus.WEB_LOGIN_FIDO : PingOneMfaStatus.MOBILE_LOGIN_FIDO;
                        } else if (amr.contains(IdToken.AmrValues.USER.toString()) && amr.contains(IdToken.AmrValues.MCA.toString())) {
                            pingOneMfaStatus = !mobileRequest ? PingOneMfaStatus.WEB_LOGIN_MOBILE : PingOneMfaStatus.MOBILE_LOGIN_MOBILE;
                        }
                        break block36;
                    }
                    if (p1Enrollment.getStatus().equals("FAILED")) {
                        pingOneMfaStatus = PingOneMfaStatus.PAIRING_ERROR;
                        break block36;
                    }
                    pingOneMfaStatus = PingOneMfaStatus.DEVICE_NOT_PAIRED;
                }
                catch (InvalidJwtException invalidJwtException) {}
            } else if (deviceWasPaired) {
                pingOneMfaStatus = PingOneMfaStatus.DEVICE_PAIRED;
            }
        }
        return Pair.of(pingOneMfaStatus, reason);
    }

    public void getAndStoreMaxAllowedDevices(PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException {
        if (stateSupport.getMaxAllowedDevices() == null) {
            String accessToken = this.tokenService.getToken();
            MFASettingsResponse mfaSettingsResponse = this.workerApiClient.getMFASettings(accessToken);
            stateSupport.setMaxAllowedDevices(mfaSettingsResponse.getMaxAllowedDevices());
        }
    }

    public void getAndStoreMFAPolicy(PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException {
        if (stateSupport.getMfaPolicy() == null) {
            String accessToken = this.tokenService.getToken();
            DeviceAuthenticationPolicy mfaPolicy = StringUtils.isBlank(this.registrationPolicy) ? this.workerApiClient.getDefaultMFAPolicy(accessToken) : this.workerApiClient.getMFAPolicyById(accessToken, this.registrationPolicy);
            stateSupport.setMfaPolicy(mfaPolicy);
        }
    }

    private void updateStoreDevicesAfterSetDefault(PingOneMfaStateSupport stateSupport, List<Device> updateDeviceList) {
        List<Device> storeDevicesList = stateSupport.getDevices();
        ArrayList<Device> reorderedDevicesList = new ArrayList<Device>();
        Device defaultDevice = updateDeviceList.get(0);
        for (Device storedDevice : storeDevicesList) {
            if (storedDevice.getId().equals(defaultDevice.getId())) {
                storedDevice.setDefaultDevice(true);
                reorderedDevicesList.add(0, storedDevice);
                continue;
            }
            storedDevice.setDefaultDevice(false);
            reorderedDevicesList.add(storedDevice);
        }
        stateSupport.removeDevices();
        stateSupport.setDefaultDeviceId(defaultDevice.getId());
        stateSupport.setDevices(reorderedDevicesList);
    }

    private List<Device> getAndStoreDevices(CommonFlowResponse flowResponse, PingOneMfaStateSupport stateSupport, HttpServletRequest req, Map<String, Object> inParameters) {
        String stateSupportDefaultDeviceId;
        List<Device> initialDevices = ModelMapperUtil.map(flowResponse.getEmbeddedResources().getDevices());
        List<Object> devices = new ArrayList();
        if (!this.authnApiSupport.isApiRequest(req)) {
            List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> devicesInResponse = flowResponse.getEmbeddedResources().getDevices();
            HashMap<String, String> deviceIdToRpIdMap = new HashMap<String, String>();
            for (com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device device : devicesInResponse) {
                if (!SecurityKeyDevice.TYPE.equals(device.getType()) && !PlatformDevice.TYPE.equals(device.getType()) && !FIDO2Device.TYPE.equals(device.getType())) continue;
                if (device instanceof SecurityKeyDevice) {
                    deviceIdToRpIdMap.put(device.getId(), ((SecurityKeyDevice)device).getRp().getId());
                    continue;
                }
                if (device instanceof PlatformDevice) {
                    deviceIdToRpIdMap.put(device.getId(), ((PlatformDevice)device).getRp().getId());
                    continue;
                }
                deviceIdToRpIdMap.put(device.getId(), ((FIDO2Device)device).getRp().getId());
            }
            String currentDomain = DomainInfoUtil.getCurrentDomain(inParameters, req);
            for (Device device : initialDevices) {
                if (SecurityKeyDevice.TYPE.equals(device.getType()) || PlatformDevice.TYPE.equals(device.getType()) || FIDO2Device.TYPE.equals(device.getType())) {
                    if (!currentDomain.endsWith((String)deviceIdToRpIdMap.get(device.getId()))) continue;
                    devices.add(device);
                    continue;
                }
                devices.add(device);
            }
        } else {
            devices = initialDevices;
        }
        if (stateSupport.getDevices() != null) {
            Map oldDeviceMap = stateSupport.getDevices().stream().collect(Collectors.toMap(com.pingidentity.sdk.api.authn.model.Device::getId, Function.identity()));
            devices.forEach(it -> {
                Device od = (Device)oldDeviceMap.get(it.getId());
                if (od != null) {
                    it.setUsable(od.isUsable());
                }
            });
        }
        if (StringUtils.isNotBlank(stateSupportDefaultDeviceId = stateSupport.getDefaultDeviceId())) {
            ArrayList<Device> newOrderedDevices = new ArrayList<Device>();
            for (Device device : devices) {
                if (device.getId().equals(stateSupportDefaultDeviceId)) {
                    device.setDefaultDevice(true);
                    newOrderedDevices.add(0, device);
                    continue;
                }
                device.setDefaultDevice(false);
                newOrderedDevices.add(device);
            }
            devices = newOrderedDevices;
        } else if (!devices.isEmpty()) {
            ((Device)devices.get(0)).setDefaultDevice(true);
        }
        PingOneMfaHandler.retainDeviceLock(stateSupport, devices);
        stateSupport.setDevices(devices);
        return devices;
    }

    private static void retainDeviceLock(PingOneMfaStateSupport stateSupport, List<Device> devices) {
        if (stateSupport == null || stateSupport.getDevices() == null || stateSupport.getDevices().isEmpty() || devices.isEmpty()) {
            return;
        }
        Map<String, Lock> lockMap = stateSupport.getDevices().stream().filter(dev -> dev.getId() != null && dev.getLock() != null && dev.getLock().getExpiresAt() > System.currentTimeMillis()).collect(Collectors.toMap(com.pingidentity.sdk.api.authn.model.Device::getId, Device::getLock, (existing, replacement) -> existing));
        if (lockMap.isEmpty()) {
            return;
        }
        for (Device device : devices) {
            Lock lock;
            if (device == null || device.getId() == null || (lock = lockMap.get(device.getId())) == null) continue;
            device.setLock(lock);
        }
    }

    private com.pingidentity.sdk.api.authn.model.User getAndStoreUser(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) {
        if (stateSupport.getUser() != null) {
            return stateSupport.getUser();
        }
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        com.pingidentity.sdk.api.authn.model.User user = ModelMapperUtil.map(username);
        stateSupport.setUser(user);
        return user;
    }

    private ResourceRef getAndStoreSelectedDeviceRef(String id, PingOneMfaStateSupport stateSupport) {
        ResourceRef selectedDeviceRef = new ResourceRef();
        selectedDeviceRef.setId(id);
        stateSupport.setSelectedDeviceRef(selectedDeviceRef);
        return selectedDeviceRef;
    }

    private boolean isValidSelectedDevice(List<Device> devices, ResourceRef selectedDeviceRef) {
        return devices.stream().anyMatch(device -> device.getId().equals(selectedDeviceRef.getId()));
    }

    private Device getDevice(List<Device> devices, String deviceId) {
        return devices.stream().filter(device -> deviceId.equals(device.getId())).findFirst().orElse(null);
    }

    public List<DevicePairingMethod> getAllowedDevicePairingMethodsForUser(String registrationPolicy, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws AccessTokenProviderException, IOException {
        String accessToken = this.tokenService.getToken();
        UserDevicesResponse userDevicesResponse = this.workerApiClient.getExpandedUserDevices(accessToken, stateSupport.getUserId(), registrationPolicy, "applications", "allowedtypes", "typeDisplayNames");
        List<DevicePairingMethod> allowedPairingMethods = ModelMapperUtil.mapAllowedMethodsTypes(userDevicesResponse.getEmbeddedResources());
        this.filterOutOfflineMethodsIfNeeded(allowedPairingMethods, inParameters, ModelMapperUtil.map(userDevicesResponse.getUserDevices()));
        return allowedPairingMethods;
    }

    private void filterOutOfflineMethodsIfNeeded(List<DevicePairingMethod> allowedPairingMethods, Map<String, Object> inParameters, List<Device> devices) throws AccessTokenProviderException, IOException {
        if (!this.allowOnlyPredefineValuesForPhoneOrEmailDevices) {
            return;
        }
        Iterator<DevicePairingMethod> iterator = allowedPairingMethods.iterator();
        while (iterator.hasNext()) {
            DevicePairingMethod devicePairingMethod = iterator.next();
            if ("SMS".equals(devicePairingMethod.getDeviceType()) && !this.checkAndSetValidInputForPhoneOrEmailDevices((OfflineDevicePairingMethod)devicePairingMethod, inParameters, this.smsAttribute, devices)) {
                iterator.remove();
            }
            if ("Voice".equals(devicePairingMethod.getDeviceType()) && !this.checkAndSetValidInputForPhoneOrEmailDevices((OfflineDevicePairingMethod)devicePairingMethod, inParameters, this.voiceAttribute, devices)) {
                iterator.remove();
            }
            if ("Email".equals(devicePairingMethod.getDeviceType()) && !this.checkAndSetValidInputForPhoneOrEmailDevices((OfflineDevicePairingMethod)devicePairingMethod, inParameters, this.emailAttribute, devices)) {
                iterator.remove();
            }
            if (!"WHATSAPP".equals(devicePairingMethod.getDeviceType()) || this.checkAndSetValidInputForPhoneOrEmailDevices((OfflineDevicePairingMethod)devicePairingMethod, inParameters, this.whatsAppAttribute, devices)) continue;
            iterator.remove();
        }
    }

    private boolean checkAndSetValidInputForPhoneOrEmailDevices(OfflineDevicePairingMethod devicePairingMethod, Map<String, Object> inParameters, String offlineDevicePrefix, List<Device> userDevices) {
        List<String> preDefinedDevices = InParamsUtil.getAttributeFromChainedByPrefix(inParameters, offlineDevicePrefix);
        List existingDevicesByType = userDevices == null ? Collections.emptyList() : userDevices.stream().filter(device -> device.getType().equals(devicePairingMethod.getDeviceType())).map(com.pingidentity.sdk.api.authn.model.Device::getTarget).collect(Collectors.toList());
        if ((preDefinedDevices = preDefinedDevices.stream().filter(preDefinedDevice -> !existingDevicesByType.contains(preDefinedDevice)).collect(Collectors.toList())).isEmpty()) {
            return false;
        }
        devicePairingMethod.setAllowedValue(preDefinedDevices.get(0));
        return true;
    }

    private void validateIfDeviceCreationAllowed(PingOneMfaStateSupport stateSupport) throws InvalidActionException {
        boolean userHasDevicesThatMatchToPolicy;
        boolean bl = userHasDevicesThatMatchToPolicy = stateSupport.getDevices() != null && stateSupport.getDevices().stream().filter(device -> stateSupport.getMfaPolicy().isSupported(device.getType())).count() > 0L;
        if (userHasDevicesThatMatchToPolicy && !stateSupport.getBypassMfaBeforeDeviceMgmt() && StringUtils.isBlank(stateSupport.getMfaCompletedCode())) {
            log.warn("invalid action - creating device without MFA first");
            throw new InvalidActionException("adding new device for MFA requires MFA first");
        }
    }

    private void validateIfDeviceIsPairedInOtherSession(Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws InvalidActionException, AccessTokenProviderException, IOException {
        List<com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device> userDevices;
        if ((stateSupport.getDevices() == null || stateSupport.getDevices().isEmpty()) && !stateSupport.getBypassMfaBeforeDeviceMgmt() && StringUtils.isBlank(stateSupport.getMfaCompletedCode()) && (userDevices = this.workerApiClient.getUserDevices(this.tokenService.getToken(), stateSupport.getUserId(), "status eq \"ACTIVE\"")) != null && !userDevices.isEmpty()) {
            this.removeFailedActivationRequiredDevice(stateSupport, inParameters);
            log.warn("invalid action - creating device without MFA first");
            throw new InvalidActionException("adding new device for MFA requires MFA first");
        }
    }

    private void validateDeviceTargetInput(String deviceTarget, PingOneMfaStateSupport stateSupport) throws AuthnErrorException {
        if (!this.allowOnlyPredefineValuesForPhoneOrEmailDevices) {
            return;
        }
        stateSupport.getDevicePairingMethods().stream().filter(devicePairingMethod -> devicePairingMethod.isOfflineDevice()).filter(devicePairingMethod -> deviceTarget.equals(((OfflineDevicePairingMethod)devicePairingMethod).getAllowedValue())).findFirst().orElseThrow(() -> new AuthnErrorException(new AuthnError(400, "INVALID_DEVICE_TARGET", "only pre-defined devices are allowed")));
    }

    private void validateTestMode(Boolean isTestMode, HttpServletRequest req, Map<String, Object> inParameters) throws AuthnErrorException {
        if (isTestMode == null || !isTestMode.booleanValue()) {
            return;
        }
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        boolean isTestModeAllowed = "allow".equalsIgnoreCase(this.getValueFromInputSource(signedRequestClaims, "pi.testDevice"));
        if (!(isTestModeAllowed &= this.authnApiSupport.isApiRequest(req))) {
            AuthnError authnError = CommonErrorSpec.VALIDATION_ERROR.makeInstance();
            authnError.setDetails(Collections.singletonList(ErrorDetailSpec.TEST_DEVICE_INVALID.makeInstanceBuilder().build()));
            throw new AuthnErrorException(authnError);
        }
    }

    private String determineApplicationId(Map<String, Object> inParameters) {
        Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        Map trackedParameters = (Map)inParameters.get("com.pingidentity.adapter.tracked.http.request.params");
        Map signedRequestClaims = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.signed.request.claims");
        String dynamicAppId = this.getValueFromInputSource(chainedAttributes, "pingone-mfa-application-id");
        if (dynamicAppId == null) {
            dynamicAppId = this.getValueFromInputSource(signedRequestClaims, "pingone-mfa-application-id");
        }
        if (dynamicAppId == null) {
            dynamicAppId = this.getValueFromInputSource(trackedParameters, "pingone-mfa-application-id");
        }
        return Optional.ofNullable(dynamicAppId).orElse(this.applicationId);
    }

    private OfflineDevice createActiveOfflineDevice(Device.Type type, String target, String nickname, String accessToken, String userId) throws IOException {
        OfflineDeviceRequest offlineDeviceRequest = this.getOfflineDeviceRequest(type.getName());
        offlineDeviceRequest.setPolicyRef(this.registrationPolicy);
        offlineDeviceRequest.setTarget(target);
        offlineDeviceRequest.setNickname(nickname);
        return this.workerApiClient.createOfflineDevice(accessToken, userId, offlineDeviceRequest);
    }

    private OfflineDeviceRequest builfOfflineDeviceRequest(String deviceType, String deviceTarget, Map<String, Object> inParameters, Locale locale, Boolean isTestMode) {
        OfflineDeviceRequest offlineDeviceRequest = this.getOfflineDeviceRequest(deviceType);
        offlineDeviceRequest.setNotification(this.extractNotificationTemplate(inParameters, locale.toString()));
        offlineDeviceRequest.setPolicyRef(this.registrationPolicy);
        offlineDeviceRequest.setTestMode(isTestMode);
        offlineDeviceRequest.setTarget(deviceTarget);
        offlineDeviceRequest.setStatus(DeviceRequest.Status.ACTIVATION_REQUIRED);
        return offlineDeviceRequest;
    }

    private OfflineDeviceRequest getOfflineDeviceRequest(String deviceType) {
        switch (deviceType.toLowerCase()) {
            case "email": {
                return new EmailDeviceRequest();
            }
            case "sms": {
                return new SmsDeviceRequest();
            }
            case "voice": {
                return new VoiceDeviceRequest();
            }
            case "whatsapp": {
                return new WhatsAppDeviceRequest();
            }
        }
        return null;
    }

    private int getOtpLength(PingOneMfaStateSupport stateSupport, String deviceType) {
        return Optional.ofNullable(stateSupport.getMfaPolicy()).map(policy -> policy.getOtpLength(deviceType)).orElse(10);
    }

    private int getOtpLength(OtpRequiredResponse otpRequiredResponse) {
        if (Objects.nonNull(otpRequiredResponse.getOtpLength())) {
            return otpRequiredResponse.getOtpLength();
        }
        return otpRequiredResponse.getFullObjectSelectedDevice().getType().equalsIgnoreCase("TOTP") ? 6 : 10;
    }

    private com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Notification getNotificationCoolDownExpiresAt(CreateOneTimeDeviceAuthenticationRequestResponse otpRequiredResponse) {
        return Optional.ofNullable(otpRequiredResponse).map(CreateOneTimeDeviceAuthenticationRequestResponse::getEmbeddedResources).map(EmbeddedResources::getDevices).filter(devices -> !devices.isEmpty()).map(devices -> (com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device)devices.get(0)).filter(device -> device instanceof OfflineDevice).map(device -> (OfflineDevice)device).map(OfflineDevice::getNotification).orElse(null);
    }

    public AuthnAdapterResponse handleFlowTimeOutErrorResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters) throws IOException {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        if (this.authnApiSupport.isApiRequest(req)) {
            this.authnApiSupport.writeErrorResponse(req, resp, new AuthnError.Builder().httpStatus(404).code("NOT_FOUND").message(this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getPingOneMfaAdapterMessage(req, "pingone.mfa.failed.flow.time.out.error.message")).build());
        } else {
            this.pingOneMfaTemplateSupport.renderMfaFailedResponse(req, resp, inParameters, "flow.time.out.error.title", "flow.time.out.error.header", "flow.time.out.error.message");
        }
        return authnAdapterResponse;
    }

    public AuthnAdapterResponse mfaFailedLoginRequiredResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, MfaFailed.LOGIN_REQUIRED);
    }

    public AuthnAdapterResponse mfaFailedInvalidAssertionResponse(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, PingOneMfaStateSupport stateSupport) throws IOException {
        return this.mfaFailedResponse(req, resp, inParameters, stateSupport, MfaFailed.INVALID_ASSERTION);
    }

    private void markAllDevicesInStateSupportAsUnusableByTypes(PingOneMfaStateSupport stateSupport, List<Device.Type> deviceTypes) {
        Optional.ofNullable(stateSupport.getDevices()).orElse(Collections.emptyList()).stream().filter(device -> deviceTypes.stream().anyMatch(type -> device.getType().equalsIgnoreCase(type.toString()))).forEach(device -> device.setUsable(false));
    }

    private AuthnAdapterResponse writeDailyOTPLimitExceededDeviceLockedError(HttpServletRequest req, HttpServletResponse resp, Map<String, Object> inParameters, Device.Type deviceType) throws AuthnErrorException, TemplateRendererUtilException {
        if (this.authnApiSupport.isApiRequest(req)) {
            AuthnError authnError = CommonErrorSpec.REQUEST_FAILED.makeInstance();
            AuthnErrorDetail authnErrorDetail = CommonErrorDetailSpec.OTP_RESEND_LIMIT.makeInstance();
            if (authnErrorDetail != null) {
                String userMessage = this.pingOneMfaTemplateSupport.getLanguagePackMessagesSupport().getAuthnApiMessage(req, "authn.api.otp.resend.limit");
                authnErrorDetail.setUserMessage(userMessage);
                authnError.setDetails(Collections.singletonList(authnErrorDetail));
            }
            throw new AuthnErrorException(authnError);
        }
        this.pingOneMfaTemplateSupport.renderDeviceLockedTemplate(req, resp, inParameters, null, this.getDailyLimitExceededErrorMessageKey(Objects.nonNull((Object)deviceType) ? deviceType.getName() : null), true);
        AuthnAdapterResponse response = new AuthnAdapterResponse();
        response.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return response;
    }

    private String getDailyLimitExceededErrorMessageKey(String deviceType) {
        if (StringUtils.isBlank(deviceType)) {
            return null;
        }
        return DAILY_LIMIT_EXCEEDED_ERROR_MESSAGE_KEY_MAP.getOrDefault(deviceType.toUpperCase(), "generic.daily.limit.exceeded");
    }

    private Device.Type getSelectedDeviceType(PingOneMfaStateSupport stateSupport, String selectedDeviceId) {
        return Optional.ofNullable(stateSupport.getDevices()).orElse(Collections.emptyList()).stream().filter(device -> device.getId().equalsIgnoreCase(selectedDeviceId)).map(device -> this.toDeviceType(device.getType())).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private Device.Type toDeviceType(String type) {
        try {
            return Device.Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    private OneTimeDeviceInfo.Type getSelectedOneTimeDeviceType(OneTimeDevicesInfo devicesInfo, String selectedDeviceId) {
        return Optional.ofNullable(devicesInfo.getDevices()).orElse(new ArrayList()).stream().filter(device -> device.getId().equals(selectedDeviceId)).map(OneTimeDeviceInfo::getType).findFirst().orElse(null);
    }

    private MfaFailed getDailyLimitExceededMfaFailed(Device.Type selectedDeviceType) {
        return Objects.isNull((Object)selectedDeviceType) ? MfaFailed.SERVER_ERROR : DAILY_LIMIT_EXCEEDED_MFA_FAILED_MAP.getOrDefault((Object)selectedDeviceType, MfaFailed.DAILY_OTP_LIMIT_REACHED);
    }

    private Device.Type getSelectedDeviceTypeFromErrorMessage(String message) {
        Pattern pattern = Pattern.compile("Daily limit of (.*?) authentication attempts has been exceeded");
        Matcher matcher = pattern.matcher(message);
        if (matcher.find()) {
            return this.toDeviceType(matcher.group(1));
        }
        return null;
    }

    private String extractParameterFromMultipleInputSources(String parameter, Map<String, Object> source, List<String> sourceKeys) {
        for (String sourceKey : sourceKeys) {
            Map sourceSubMap;
            Object value = source.get(sourceKey);
            if (!(value instanceof Map) || !(sourceSubMap = (Map)value).containsKey(parameter)) continue;
            return this.castValue(sourceSubMap.get(parameter));
        }
        return null;
    }

    static {
        PAIRING_OFFLINE_STATUSES = Arrays.asList(StateSpec.EMAIL_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.SMS_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.VOICE_PAIRING_TARGET_REQUIRED.getStatus(), StateSpec.WHATSAPP_PAIRING_TARGET_REQUIRED.getStatus());
        ACTIVATION_OFFLINE_STATUSES = Arrays.asList(StateSpec.EMAIL_ACTIVATION_REQUIRED.getStatus(), StateSpec.SMS_ACTIVATION_REQUIRED.getStatus(), StateSpec.VOICE_ACTIVATION_REQUIRED.getStatus(), StateSpec.WHATSAPP_ACTIVATION_REQUIRED.getStatus());
        MFA_FAILED_MAP = new HashMap<String, MfaFailed>();
        Arrays.stream(MfaFailed.values()).forEach(value -> MFA_FAILED_MAP.put(value.getCode(), (MfaFailed)((Object)value)));
        log = LogFactory.getLog(PingOneMfaHandler.class);
        LOG = new IntegrationsLogger(PingOneMfaHandler.class);
        DAILY_LIMIT_EXCEEDED_ERROR_MESSAGE_KEY_MAP = Map.of("EMAIL", "email.daily.limit.exceeded", "VOICE", "voice.daily.limit.exceeded", "SMS", "sms.daily.limit.exceeded", "WHATSAPP", "whatsapp.daily.limit.exceeded");
        DAILY_LIMIT_EXCEEDED_MFA_FAILED_MAP = Map.of(Device.Type.EMAIL, MfaFailed.DAILY_EMAIL_LIMIT_REACHED, Device.Type.SMS, MfaFailed.DAILY_SMS_LIMIT_REACHED, Device.Type.VOICE, MfaFailed.DAILY_VOICE_LIMIT_REACHED, Device.Type.WHATSAPP, MfaFailed.DAILY_WHATSAPP_LIMIT_REACHED);
    }

    public static class Builder {
        private String authPath;
        private String envId;
        private String applicationId;
        private String authenticationPolicy;
        private String registrationPolicy;
        private FlowsApiClient flowsApiClient;
        private WorkerApiClient workerApiClient;
        private TokenService tokenService;
        private PingOneMfaTemplateSupport pingOneMfaTemplateSupport;
        private PingOneMfaAuthnApiSupport pingOneMfaAuthnApiSupport;
        private AppSecretCache appSecretCache;
        private boolean showSuccessScreen = true;
        private boolean showErrorScreen = true;
        private boolean showTimeoutScreen = true;
        private boolean invalidUserBypass = false;
        private boolean rootedJailbrokenDeviceBypass = false;
        private boolean apiFailureBypass = false;
        private boolean changeDeviceAllowed = true;
        private boolean auditLoggingEnabled = false;
        private boolean automaticAuthCodeRefreshEnabled = true;
        private boolean allowSetupMfa = false;
        private boolean allowSkipMfa = false;
        private boolean allowMgtDevices = false;
        private boolean provisionUser = false;
        private boolean provisionAuthenticationMethods = false;
        private boolean updateAuthenticationMethods = false;
        private OverwriteAuthenticationMethodsConfig overrideAuthenticationMethodConfiguration;
        private boolean isCookieTrackingEnabled = false;
        private String populationId;
        private String smsAttribute;
        private String voiceAttribute;
        private String emailAttribute;
        private String whatsAppAttribute;
        private String usernameAttribute;
        private String defaultDeviceType;
        private String notificationTemplateVariantOverride;
        private String applicationIdForQRFlow;
        private boolean allowOnlyPredefineValuesForPhoneOrEmailDevices;

        public Builder setDefaultDeviceType(String defaultDeviceType) {
            this.defaultDeviceType = defaultDeviceType;
            return this;
        }

        public Builder setApplicationIdForQRFlow(String applicationIdForQRFlow) {
            this.applicationIdForQRFlow = applicationIdForQRFlow;
            return this;
        }

        public Builder setUsernameAttribute(String usernameAttribute) {
            this.usernameAttribute = usernameAttribute;
            return this;
        }

        public Builder setSmsAttribute(String smsAttribute) {
            this.smsAttribute = smsAttribute;
            return this;
        }

        public Builder setVoiceAttribute(String voiceAttribute) {
            this.voiceAttribute = voiceAttribute;
            return this;
        }

        public Builder setEmailAttribute(String emailAttribute) {
            this.emailAttribute = emailAttribute;
            return this;
        }

        public Builder setWhatsAppAttribute(String whatsAppAttribute) {
            this.whatsAppAttribute = whatsAppAttribute;
            return this;
        }

        public Builder setPopulationId(String populationId) {
            this.populationId = populationId;
            return this;
        }

        public Builder setOverwriteAuthenticationMethods(String overwriteAuthenticationMethods) {
            this.overrideAuthenticationMethodConfiguration = OverwriteAuthenticationMethodsConfig.fromValue(overwriteAuthenticationMethods);
            return this;
        }

        public Builder setUpdateAuthenticationMethods(boolean updateAuthenticationMethods) {
            this.updateAuthenticationMethods = updateAuthenticationMethods;
            return this;
        }

        public Builder setEnableCookieTracking(boolean isCookieTrackingEnabled) {
            this.isCookieTrackingEnabled = isCookieTrackingEnabled;
            return this;
        }

        public Builder setAllowSkipMfa(boolean allowSkipMfa) {
            this.allowSkipMfa = allowSkipMfa;
            return this;
        }

        public Builder setAllowSetupMfa(boolean allowSetupMfa) {
            this.allowSetupMfa = allowSetupMfa;
            return this;
        }

        public Builder setAllowAddOrRemoveMethod(boolean allowMgtDevices) {
            this.allowMgtDevices = allowMgtDevices;
            return this;
        }

        public Builder setProvisionUser(boolean provisionUser) {
            this.provisionUser = provisionUser;
            return this;
        }

        public Builder setProvisionAuthenticationMethods(boolean provisionAuthenticationMethods) {
            this.provisionAuthenticationMethods = provisionAuthenticationMethods;
            return this;
        }

        public Builder setChangeDeviceAllowed(boolean changeDeviceAllowed) {
            this.changeDeviceAllowed = changeDeviceAllowed;
            return this;
        }

        public Builder setAuditLoggingEnabled(boolean auditLoggingEnabled) {
            this.auditLoggingEnabled = auditLoggingEnabled;
            return this;
        }

        public Builder setRootedJailbrokenDeviceBypass(boolean rootedJailbrokenDeviceBypass) {
            this.rootedJailbrokenDeviceBypass = rootedJailbrokenDeviceBypass;
            return this;
        }

        public Builder setInvalidUserBypass(boolean invalidUserBypass) {
            this.invalidUserBypass = invalidUserBypass;
            return this;
        }

        public Builder setApiFailureBypass(boolean apiFailureBypass) {
            this.apiFailureBypass = apiFailureBypass;
            return this;
        }

        public Builder setShowSuccessScreen(boolean showSuccessScreen) {
            this.showSuccessScreen = showSuccessScreen;
            return this;
        }

        public Builder setShowErrorScreen(boolean showErrorScreen) {
            this.showErrorScreen = showErrorScreen;
            return this;
        }

        public Builder setShowTimeoutScreen(boolean showTimeoutScreen) {
            this.showTimeoutScreen = showTimeoutScreen;
            return this;
        }

        public Builder setAuthPath(String authPath) {
            this.authPath = authPath;
            return this;
        }

        public Builder setEnvId(String envId) {
            this.envId = envId;
            return this;
        }

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder setAuthenticationPolicy(String authenticationPolicy) {
            this.authenticationPolicy = authenticationPolicy;
            return this;
        }

        public Builder setRegistrationPolicy(String registrationPolicy) {
            this.registrationPolicy = registrationPolicy;
            return this;
        }

        public Builder setFlowsApiClient(FlowsApiClient flowsApiClient) {
            this.flowsApiClient = flowsApiClient;
            return this;
        }

        public Builder setWorkerApiClient(WorkerApiClient workerApiClient) {
            this.workerApiClient = workerApiClient;
            return this;
        }

        public Builder setTokenService(TokenService tokenService) {
            this.tokenService = tokenService;
            return this;
        }

        public Builder setPingOneMfaTemplateSupport(PingOneMfaTemplateSupport pingOneMfaTemplateSupport) {
            this.pingOneMfaTemplateSupport = pingOneMfaTemplateSupport;
            return this;
        }

        public Builder setPingOneMfaAuthnApiSupport(PingOneMfaAuthnApiSupport pingOneMfaAuthnApiSupport) {
            this.pingOneMfaAuthnApiSupport = pingOneMfaAuthnApiSupport;
            return this;
        }

        public Builder setNotificationTemplateVariantOverride(String notificationTemplateVariantOverride) {
            this.notificationTemplateVariantOverride = notificationTemplateVariantOverride;
            return this;
        }

        public Builder setAllowOnlyPredefineValuesForPhoneOrEmailDevices(boolean setAllowOnlyPredefineValuesForPhoneOrEmailDevices) {
            this.allowOnlyPredefineValuesForPhoneOrEmailDevices = setAllowOnlyPredefineValuesForPhoneOrEmailDevices;
            return this;
        }

        public Builder setAppSecretCache(AppSecretCache appSecretCache) {
            this.appSecretCache = appSecretCache;
            return this;
        }

        public PingOneMfaHandler build() {
            if (StringUtils.isNotBlank(this.authPath) && StringUtils.isNotBlank(this.envId) && StringUtils.isNotBlank(this.applicationId) && this.flowsApiClient != null && this.workerApiClient != null && this.tokenService != null && this.pingOneMfaTemplateSupport != null && this.pingOneMfaAuthnApiSupport != null && this.appSecretCache != null && this.populationId != null) {
                return new PingOneMfaHandler(this);
            }
            throw new IllegalArgumentException("All fields are required for an instance of " + PingOneMfaHandler.class.getSimpleName());
        }
    }
}

