/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.adapters.pingone.mfa.api.model.request.CustomChallenge;
import com.pingidentity.adapters.pingone.mfa.api.model.users.devices.Device;
import com.pingidentity.adapters.pingone.mfa.pingidsdk.DynamicData;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jws.JsonWebSignature;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.keys.HmacKey;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.lang.JoseException;
import com.pingidentity.adapters.pingone.mfa.util.ObjectMappers;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class RequestParamUtil {
    public static String generateRequestParamToken(String authPath, String clientId, String clientSecret, String envId, String remoteIP, String notificationsTemplate, String contextForTransactionApproval, String webAuthnChallenge, DynamicData dynamicData, boolean testDeviceAllowed) throws JoseException {
        return RequestParamUtil.generateRequestParamToken(authPath, clientId, clientSecret, envId, remoteIP, notificationsTemplate, contextForTransactionApproval, null, webAuthnChallenge, testDeviceAllowed);
    }

    public static String generateRequestParamToken(String authPath, String clientId, String clientSecret, String envId, String remoteIP, String notificationsTemplate, String contextForTransactionApproval, List<Device.Type> allowedMfaMethods, String customChallenge, boolean testDeviceAllowed) throws JoseException {
        JwtClaims jwtClaims = new JwtClaims();
        jwtClaims.setIssuer(clientId);
        try {
            Object jsonObject;
            if (StringUtils.isNotBlank(notificationsTemplate)) {
                jsonObject = ObjectMappers.getDefault().readValue(notificationsTemplate, Object.class);
                jwtClaims.setClaim("pi.template", jsonObject);
            }
            if (StringUtils.isNotBlank(contextForTransactionApproval)) {
                jsonObject = ObjectMappers.getDefault().readValue(contextForTransactionApproval, Object.class);
                jwtClaims.setClaim("pi.clientContext", jsonObject);
            }
            if (StringUtils.isNotBlank(customChallenge)) {
                String objectAsString = ObjectMappers.getDefault().writeValueAsString(new CustomChallenge(customChallenge));
                Object jsonObject2 = ObjectMappers.getDefault().readValue(objectAsString, Object.class);
                jwtClaims.setClaim("pi.webAuthn", jsonObject2);
            }
        }
        catch (JsonProcessingException objectAsString) {
            // empty catch block
        }
        if (allowedMfaMethods != null && !allowedMfaMethods.isEmpty()) {
            jwtClaims.setClaim("pi.allowedMfaMethods", allowedMfaMethods);
        }
        if (StringUtils.isNotBlank(remoteIP)) {
            jwtClaims.setClaim("pi.remoteIp", remoteIP);
        }
        if (testDeviceAllowed) {
            jwtClaims.setClaim("pi.testDevice", "allow");
        }
        jwtClaims.setAudience(authPath + "/" + envId + "/as");
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(jwtClaims.toJson());
        jws.setAlgorithmHeaderValue("HS256");
        jws.setKey(new HmacKey(clientSecret.getBytes(StandardCharsets.UTF_8)));
        return jws.getCompactSerialization();
    }
}

