/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util.accestoken;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.Log;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.logging.LogFactory;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.Consts;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.HttpResponse;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.HttpClient;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.entity.UrlEncodedFormEntity;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.methods.HttpPost;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.client.methods.HttpRequestBase;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.message.BasicNameValuePair;
import com.pingidentity.adapters.pingone.mfa.shade.org.apache.http.util.EntityUtils;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtConsumer;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtConsumerBuilder;
import com.pingidentity.pingonev2.AccessTokenResponse;
import com.pingidentity.pingonev2.InvalidGatewayCredentialException;
import java.io.IOException;
import java.util.ArrayList;

public class CustomPingOneV2APIClient {
    public static final String PARAM_NAME_GRANT_TYPE = "grant_type";
    public static final String PARAM_NAME_SUBJECT_TOKEN_TYPE = "subject_token_type";
    public static final String PARAM_NAME_SUBJECT_TOKEN = "subject_token";
    public static final String CRED_EXCHANGE_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    public static final String CRED_EXCHANGE_TOKEN_TYPE = "pingone_gateway_credential";
    public static final String CRED_EXCHANGE_PATH = "/as/token";
    private final HttpClient httpClient;
    private final String credential;
    private final CredentialReader credentialReader;
    private final ObjectMapper credentialMapper = this.getCredentialExchangeMapper();
    private static final Log log = LogFactory.getLog(CustomPingOneV2APIClient.class);

    public CustomPingOneV2APIClient(HttpClient httpClient, String credential) throws InvalidGatewayCredentialException {
        this.httpClient = httpClient;
        this.credential = credential;
        this.credentialReader = new CredentialReader(credential);
    }

    public String exchangeGatewayCredential() throws InvalidGatewayCredentialException, IOException {
        HttpPost httpPost = new HttpPost(this.credentialReader.getOauthBaseUrl() + "/" + this.credentialReader.getEnvId() + CRED_EXCHANGE_PATH);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_NAME_GRANT_TYPE, CRED_EXCHANGE_GRANT_TYPE));
        params.add(new BasicNameValuePair(PARAM_NAME_SUBJECT_TOKEN_TYPE, CRED_EXCHANGE_TOKEN_TYPE));
        params.add(new BasicNameValuePair(PARAM_NAME_SUBJECT_TOKEN, this.credential));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, Consts.UTF_8);
        httpPost.setEntity(entity);
        HttpResponse response = this.doRequest(httpPost);
        HttpEntity respEntity = response.getEntity();
        String responseString = EntityUtils.toString(respEntity, Consts.UTF_8);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String message = "Error exchanging gateway credential. Request to " + httpPost.getURI() + " returned " + statusCode + ": " + responseString;
            log.debug(message);
            throw new InvalidGatewayCredentialException(responseString);
        }
        AccessTokenResponse accessTokenResponse = this.credentialMapper.readValue(responseString, AccessTokenResponse.class);
        return accessTokenResponse.getAccessToken();
    }

    private HttpResponse doRequest(HttpRequestBase request) throws IOException {
        HttpResponse response;
        log.debug("Sending " + request.getMethod() + " request to " + request.getURI());
        try {
            response = this.httpClient.execute(request);
        }
        catch (IOException e) {
            log.debug("Error sending " + request.getMethod() + " request to " + request.getURI() + ": " + e.getMessage());
            throw e;
        }
        return response;
    }

    private ObjectMapper getCredentialExchangeMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        return objectMapper;
    }

    public static class CredentialReader {
        private String envId;
        private String gatewayId;
        private String oauthBaseUrl;
        private String apiBaseUrl;

        public CredentialReader(String credential) throws InvalidGatewayCredentialException {
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setDisableRequireSignature().setSkipSignatureVerification().build();
            try {
                JwtClaims claims = jwtConsumer.processToClaims(credential);
                this.envId = claims.getStringClaimValue("environmentId");
                this.gatewayId = claims.getStringClaimValue("gatewayId");
                this.apiBaseUrl = claims.getStringClaimValue("aud");
                this.oauthBaseUrl = claims.getClaimValueAsString("authUrl");
                if (this.envId == null || this.gatewayId == null || this.apiBaseUrl == null || this.oauthBaseUrl == null) {
                    String errorMessage = "Gateway credential does not contain all required claims.";
                    log.debug("Error processing gateway credential: " + errorMessage);
                    throw new InvalidGatewayCredentialException(errorMessage);
                }
            }
            catch (MalformedClaimException | InvalidJwtException e) {
                log.debug("Error processing gateway credential: " + e.getMessage());
                throw new InvalidGatewayCredentialException(e.getMessage());
            }
        }

        public String getEnvId() {
            return this.envId;
        }

        public String getGatewayId() {
            return this.gatewayId;
        }

        public String getOauthBaseUrl() {
            return this.oauthBaseUrl;
        }

        public String getApiBaseUrl() {
            return this.apiBaseUrl;
        }

        public void setEnvId(String envId) {
            this.envId = envId;
        }

        public void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        public void setOauthBaseUrl(String oauthBaseUrl) {
            this.oauthBaseUrl = oauthBaseUrl;
        }

        public void setApiBaseUrl(String apiBaseUrl) {
            this.apiBaseUrl = apiBaseUrl;
        }

        public CredentialReader() {
        }
    }
}

