/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.mfa.util.accestoken;

import com.pingidentity.adapters.pingone.mfa.PingOneMfaIdpAdapterLogEvent;
import com.pingidentity.adapters.pingone.mfa.exception.AccessTokenProviderException;
import com.pingidentity.adapters.pingone.mfa.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.JwtClaims;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.MalformedClaimException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.NumericDate;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.InvalidJwtException;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtConsumer;
import com.pingidentity.adapters.pingone.mfa.shade.org.jose4j.jwt.consumer.JwtConsumerBuilder;
import com.pingidentity.adapters.pingone.mfa.util.accestoken.AccessTokenProvider;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TokenService {
    private static final IntegrationsLogger LOG = new IntegrationsLogger(TokenService.class);
    private static final long SKEW = -5L;
    private static final ConcurrentMap<String, AccessTokenWrapper> tokenWrapperMap = new ConcurrentHashMap<String, AccessTokenWrapper>();
    private final AccessTokenProvider accessTokenProvider;
    private final String clientIdentifier;

    public TokenService(AccessTokenProvider accessTokenProvider, String clientIdentifier) {
        this.accessTokenProvider = accessTokenProvider;
        this.clientIdentifier = clientIdentifier;
    }

    public synchronized String getToken() throws AccessTokenProviderException {
        AccessTokenWrapper tokenWrapper = (AccessTokenWrapper)tokenWrapperMap.get(this.clientIdentifier);
        if (tokenWrapper == null || tokenWrapper.isExpired(-5L)) {
            LOG.log(PingOneMfaIdpAdapterLogEvent.TOKEN_REFRESH);
            return this.requestToken(this.clientIdentifier);
        }
        return tokenWrapper.getAccessToken();
    }

    private String requestToken(String clientIdentifier) throws AccessTokenProviderException {
        AccessTokenWrapper tokenWrapper;
        String accessToken = this.accessTokenProvider.getAccessToken();
        try {
            tokenWrapper = new AccessTokenWrapper(accessToken);
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new AccessTokenProviderException("Error processing access token", e);
        }
        tokenWrapperMap.put(clientIdentifier, tokenWrapper);
        return tokenWrapper.getAccessToken();
    }

    public static class AccessTokenWrapper {
        private final String accessToken;
        private final NumericDate expiresAt;

        public AccessTokenWrapper(String accessToken) throws InvalidJwtException, MalformedClaimException {
            this.accessToken = accessToken;
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipSignatureVerification().build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(accessToken);
            this.expiresAt = jwtClaims.getExpirationTime();
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public boolean isExpired(long skew) {
            this.expiresAt.addSeconds(skew);
            return NumericDate.now().isOnOrAfter(this.expiresAt);
        }

        public boolean isExpired() {
            return this.isExpired(0L);
        }
    }
}

