/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.oobauth.pingone.mfa;

import com.pingidentity.adapters.pingone.mfa.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.oobauth.pingone.mfa.TemplateVariable;
import com.pingidentity.sdk.oobauth.OOBAuthRequestContext;
import java.util.ArrayList;
import java.util.List;

public final class TemplateVariables {
    public static final String LOCALE = "locale";
    public static final String REQUESTED_SCOPE = "requestedScope";
    public static final String REQUESTING_APPLICATION_ID = "requestingApplicationId";
    public static final String REQUESTING_APPLICATION_NAME = "requestingApplicationName";
    public static final String REQUESTING_APPLICATION_LOGO_URL = "requestingApplicationLogoUrl";
    public static final String AUTH_USER_BINDING_MESSAGE = "authUserBindingMessage";

    private TemplateVariables() {
    }

    public static List<TemplateVariable> from(OOBAuthRequestContext oobAuthRequestContext) {
        String locale = oobAuthRequestContext.getLocale().toString();
        String requestedScope = String.join((CharSequence)"\n", oobAuthRequestContext.getRequestedScope().values());
        OOBAuthRequestContext.RequestingApplication requestingApplication = oobAuthRequestContext.getRequestingApplication();
        String requestingApplicationId = requestingApplication.getId();
        String requestingApplicationName = requestingApplication.getName();
        String requestingApplicationLogoUrl = requestingApplication.getLogoUrl();
        String authUserBindingMessage = oobAuthRequestContext.getUserAuthBindingMessage();
        ArrayList<TemplateVariable> templateVariables = new ArrayList<TemplateVariable>();
        TemplateVariables.addIfNotEmpty(templateVariables, LOCALE, locale);
        TemplateVariables.addIfNotEmpty(templateVariables, REQUESTED_SCOPE, requestedScope);
        TemplateVariables.addIfNotEmpty(templateVariables, REQUESTING_APPLICATION_ID, requestingApplicationId);
        TemplateVariables.addIfNotEmpty(templateVariables, REQUESTING_APPLICATION_NAME, requestingApplicationName);
        TemplateVariables.addIfNotEmpty(templateVariables, REQUESTING_APPLICATION_LOGO_URL, requestingApplicationLogoUrl);
        TemplateVariables.addIfNotEmpty(templateVariables, AUTH_USER_BINDING_MESSAGE, authUserBindingMessage);
        return templateVariables;
    }

    private static void addIfNotEmpty(List<TemplateVariable> templateVariables, String name, String value) {
        if (StringUtils.isNotEmpty(value)) {
            templateVariables.add(new TemplateVariable(name, value));
        }
    }
}

