/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.p14c;

public enum AuthenticationResult {
    DEFAULT("Default Error", "invalid.credentials", false),
    USER_NOT_FOUND("User Not Found", "user.not.found", false),
    INVALID_CREDENTIALS("Invalid Credentials", "invalid.credentials", false),
    NO_PASSWORD("No Password", "no.password.set", false),
    ACCOUNT_NOT_USABLE("Account Disabled", "account.not.usable", false),
    USER_MUST_RESET_PASSWORD("User Must Change Password", "user.must.change.password", true),
    PASSWORD_POLICY_VIOLATED("Password Policy Violated", "password.policy.violated", true),
    PASSWORD_LOCKEDOUT("Password Locked Out", "password.locked.out", false),
    PASSWORD_RESET_TOO_YOUNG("Password Too Young", "password.reset.too.young", true),
    USER_PASSWORD_EXPIRED("User Password Expired", "user.password.expired", true),
    ACCOUNT_RECOVERY_FORBIDDEN_ACCOUNT_NOT_USABLE("Account Recovery Forbidden", "account.recovery.forbidden.user.not.usable", false);

    private static final String MSG_KEY_PREFIX = "pingone.authn.srvr.msg.";
    private final String id;
    private final String displayName;
    private final String messageKey;
    private final boolean isRecoverable;

    private AuthenticationResult(String displayName, String id, boolean recoverable) {
        this.id = id;
        this.displayName = displayName;
        this.messageKey = MSG_KEY_PREFIX + id;
        this.isRecoverable = recoverable;
    }

    public String getId() {
        return this.id;
    }

    public static AuthenticationResult getById(String id) {
        for (AuthenticationResult value : AuthenticationResult.values()) {
            if (!value.getId().equals(id)) continue;
            return value;
        }
        return null;
    }

    public static AuthenticationResult getByDisplayName(String displayName) {
        for (AuthenticationResult value : AuthenticationResult.values()) {
            if (!value.getDisplayName().equals(displayName)) continue;
            return value;
        }
        return null;
    }

    public static AuthenticationResult getDefaultValue() {
        return INVALID_CREDENTIALS;
    }

    public static String[] getDisplayNames() {
        String[] s = new String[AuthenticationResult.values().length];
        for (int i = 0; i < AuthenticationResult.values().length; ++i) {
            s[i] = AuthenticationResult.values()[i].getDisplayName();
        }
        return s;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public boolean isRecoverable() {
        return this.isRecoverable;
    }

    public boolean isError() {
        return true;
    }

    public boolean isSuccess() {
        return false;
    }
}

