/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins.pcvs.p14c;

import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.plugins.pcvs.p14c.shade.com.pingidentity.integrations.logger.LogLevel;

public enum PCVLogEvent implements LogEvent
{
    NO_DATA_SOURCE(LogLevel.ERROR, "000", "Empty or invalid Custom Data Source"),
    RESPONSE_PROCESSING_ERROR(LogLevel.ERROR, "001", "Error processing response: %s"),
    READ_DATA_SOURCE_ERROR(LogLevel.DEBUG, "002", "Error while retrieving information from driver"),
    CREDENTIAL_ERROR(LogLevel.DEBUG, "003", "Error while validating credential"),
    CHANGE_PASSWORD(LogLevel.DEBUG, "004", "Changing user password"),
    CHANGE_PASSWORD_ERROR(LogLevel.DEBUG, "005", "Error while changing password"),
    FIND_BY_EMAIL(LogLevel.DEBUG, "006", "Finding user by email"),
    RETRIEVING_USER_ERROR(LogLevel.DEBUG, "007", "Error while retrieving user value"),
    RESET_PASSWORD(LogLevel.DEBUG, "008", "Resetting user password"),
    RESET_PASSWORD_ERROR(LogLevel.DEBUG, "009", "Error while resetting password"),
    UNLOCK_ACCOUNT(LogLevel.DEBUG, "010", "Unlocking account"),
    UNLOCK_ACCOUNT_ERROR(LogLevel.DEBUG, "011", "Error while unlocking account"),
    CHECK_ACCOUNT_LOCK(LogLevel.DEBUG, "012", "Checking if account is locked"),
    CHECK_ACCOUNT_LOCK_ERROR(LogLevel.DEBUG, "013", "Error while checking if account is locked"),
    GET_ACCESS_TOKEN(LogLevel.DEBUG, "014", "Getting new access token"),
    EXCEEDING_RETRY(LogLevel.DEBUG, "015", "Exceeded configured retries number or maximum retries attempt"),
    BACKOFF_ENFORCED(LogLevel.DEBUG, "016", "Exponential Backoff Algorithm delay enforced to handle rate limiting failures. Sleeping for %.2f seconds"),
    THREAD_INTERRUPTED(LogLevel.DEBUG, "017", "Thread interrupted: %s"),
    SEND_REQUEST(LogLevel.DEBUG, "018", "Sending %s request to %s"),
    RETRY_REQUEST(LogLevel.DEBUG, "019", "Retrying %s request to %s (retry #%d)"),
    REFRESH_ACCESS_TOKEN(LogLevel.DEBUG, "020", "Service returned %d, refreshing access token"),
    REQUEST_RESPONSE(LogLevel.TRACE, "021", "%s response to '%s' returned '%s'"),
    RESPONSE_OK(LogLevel.DEBUG, "022", "Response status code: %d"),
    RESPONSE_NOT_OK(LogLevel.DEBUG, "023", "Response status code: %d, Response: %s"),
    VALIDATE_USER(LogLevel.TRACE, "024", "Validating credentials for '%s'"),
    NO_DEVICE_INFO(LogLevel.TRACE, "025", "User with id %s has no device info"),
    USER_NOT_FOUND(LogLevel.TRACE, "026", "User with %s=%s not found"),
    ERROR_GETTING_ACCESS_TOKEN(LogLevel.DEBUG, "027", "Error getting access token."),
    ERROR_EVALUATING_JSON_POINTER(LogLevel.DEBUG, "028", "Error evaluating JSON Pointer: %s"),
    ACCOUNT_RECOVERY_NOT_ALLOWED_FOR_DISABLED_USER(LogLevel.ERROR, "029", "Account recovery not supported for disabled user account."),
    GENERIC_LOG(LogLevel.DEBUG, "030", "%s");

    private static final String PRODUCT_CODE = "IPOP";
    private final LogLevel level;
    private final String code;
    private final String message;

    private PCVLogEvent(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "IPOP-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

