/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect;

import com.pingidentity.adapters.pingone.protect.AuthnAdapterResponseConverter;
import com.pingidentity.adapters.pingone.protect.CoreContract;
import com.pingidentity.adapters.pingone.protect.RiskEventExtractor;
import com.pingidentity.adapters.pingone.protect.SessionStateSupportWrapper;
import com.pingidentity.adapters.pingone.protect.SessionStateSupportWrapperImpl;
import com.pingidentity.adapters.pingone.protect.TransactionalStateSupportWrapper;
import com.pingidentity.adapters.pingone.protect.TransactionalStateSupportWrapperImpl;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapper;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapperFactory;
import com.pingidentity.adapters.pingone.protect.api.authn.PingOneProtectAuthnApiSupport;
import com.pingidentity.adapters.pingone.protect.api.authn.StateSpec;
import com.pingidentity.adapters.pingone.protect.configuration.adapter.PingOneProtectAdapterConfiguration;
import com.pingidentity.adapters.pingone.protect.dto.CompletionStatus;
import com.pingidentity.adapters.pingone.protect.dto.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvent;
import com.pingidentity.adapters.pingone.protect.evaluation.PingOneProtectManagementAdapterTemplateSupport;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskService;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskServiceFactory;
import com.pingidentity.adapters.pingone.protect.log.LogCleaner;
import com.pingidentity.adapters.pingone.protect.log.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.util.ReflectionUtils;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.IdpAuthenticationAdapterV2;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.TransactionAwareAuthenticationAdapter;
import com.pingidentity.sdk.api.authn.AuthnApiPlugin;
import com.pingidentity.sdk.api.authn.AuthnApiPluginDescriptor;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.spec.AuthnStateSpec;
import com.pingidentity.sdk.api.authn.spec.PluginApiSpec;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.ConfigurableAuthnAdapter;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.idp.authn.AuthnPolicy;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthnAdapterDescriptor;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.util.log.AttributeMap;

public class PingOneProtectIdpAdapter
implements IdpAuthenticationAdapterV2,
TransactionAwareAuthenticationAdapter,
AuthnApiPlugin {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneProtectIdpAdapter.class);
    private static boolean supportsSetMetadata;
    private static boolean supportsPluginServiceAssociation;
    private static final String COOKIE_VALUE = "signals";
    private final AuthnApiSupport authnApiSupport;
    private PingOneProtectAuthnApiSupport p1ProtectManagementAdapterAuthnApiSupport;
    private String instanceId;
    private Map<String, OptionalUserAttribute> optionalUserAttributesMapping;
    private Map<String, String> predictorsMapping;
    private boolean includeDynamicDeviceProfile;
    private int deviceProfilingTimeout;
    private String deviceProfileCookieName;
    private String failureMode;
    private String fallbackValue;
    private boolean enablePingIdDeviceTrustPayload;
    private Integer deviceTrustPort;
    private Integer deviceTrustTimeout;
    private RiskService riskService;
    private final SessionStateSupportWrapper sessionStateSupportWrapper;
    private final TransactionalStateSupportWrapper transactionalStateSupportWrapper;
    private final PingOneProtectManagementAdapterTemplateSupport pingOneProtectManagementAdapterTemplateSupport;

    public PingOneProtectIdpAdapter() {
        this.authnApiSupport = AuthnApiSupport.getDefault();
        this.sessionStateSupportWrapper = new SessionStateSupportWrapperImpl(new SessionStateSupport());
        this.transactionalStateSupportWrapper = new TransactionalStateSupportWrapperImpl();
        this.pingOneProtectManagementAdapterTemplateSupport = new PingOneProtectManagementAdapterTemplateSupport();
        this.p1ProtectManagementAdapterAuthnApiSupport = new PingOneProtectAuthnApiSupport();
    }

    protected PingOneProtectIdpAdapter(SessionStateSupportWrapper sessionStateSupportWrapper, RiskService riskService, AuthnApiSupport authnApiSupport, TransactionalStateSupportWrapper transactionalStateSupportWrapper, PingOneProtectAuthnApiSupport p1ProtectManagementAdapterAuthnApiSupport, PingOneProtectManagementAdapterTemplateSupport pingOneProtectManagementAdapterTemplateSupport) {
        this.sessionStateSupportWrapper = sessionStateSupportWrapper;
        this.riskService = riskService;
        this.authnApiSupport = authnApiSupport;
        this.transactionalStateSupportWrapper = transactionalStateSupportWrapper;
        this.p1ProtectManagementAdapterAuthnApiSupport = p1ProtectManagementAdapterAuthnApiSupport;
        this.pingOneProtectManagementAdapterTemplateSupport = pingOneProtectManagementAdapterTemplateSupport;
    }

    public void configure(Configuration configuration) {
        this.configureInternalState(configuration);
        this.configureRiskService(configuration);
    }

    protected void configureInternalState(Configuration configuration) {
        this.instanceId = configuration.getId();
        this.optionalUserAttributesMapping = PingOneProtectAdapterConfiguration.OptionalUserAttributesTable.getOptionalUserAttributesMapping(configuration);
        this.predictorsMapping = PingOneProtectAdapterConfiguration.OptionalPredictorsTable.getOptionalPredictorsMapping(configuration);
        this.includeDynamicDeviceProfile = PingOneProtectAdapterConfiguration.IncludeDynamicDeviceProfileField.isIncludeDynamicDeviceProfile(configuration);
        this.deviceProfilingTimeout = PingOneProtectAdapterConfiguration.DeviceProfilingTimeoutField.getDeviceProfilingTimeout(configuration);
        this.deviceProfileCookieName = PingOneProtectAdapterConfiguration.DeviceProfileCookieNameField.getDeviceProfileCookieName(configuration);
        this.failureMode = PingOneProtectAdapterConfiguration.FailureModeField.getFailureMode(configuration);
        this.fallbackValue = PingOneProtectAdapterConfiguration.FallbackValueField.getFallbackValue(configuration);
        this.enablePingIdDeviceTrustPayload = PingOneProtectAdapterConfiguration.EnablePingIdDeviceTrustPayload.isPingIdDeviceTrustPayloadEnabled(configuration);
        this.deviceTrustPort = PingOneProtectAdapterConfiguration.PingIdAgentPortField.getPingIdAgentPort(configuration);
        this.deviceTrustTimeout = PingOneProtectAdapterConfiguration.PingIdAgentTimeoutField.getPingIdAgentTimeout(configuration);
    }

    private void configureRiskService(Configuration configuration) {
        PingOneEnvironmentAccessorWrapperFactory pingOneEnvironmentAccessorWrapperFactory = new PingOneEnvironmentAccessorWrapperFactory();
        PingOneEnvironmentAccessorWrapper pingOneEnvironmentAccessorWrapper = pingOneEnvironmentAccessorWrapperFactory.create(configuration);
        RiskServiceFactory riskServiceFactory = new RiskServiceFactory();
        this.riskService = riskServiceFactory.create(configuration, pingOneEnvironmentAccessorWrapper);
    }

    public AuthnAdapterResponse lookupAuthN(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) throws AuthnAdapterException, IOException {
        try {
            return this.handleLookupAuthN(request, response, inParameters);
        }
        catch (AuthnErrorException e) {
            this.authnApiSupport.writeErrorResponse(request, response, e.getValidationError());
            return PingOneProtectIdpAdapter.inProgressAuthAdapterResponse();
        }
    }

    private AuthnAdapterResponse handleLookupAuthN(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) throws AuthnAdapterException, IOException, AuthnErrorException {
        AuthnAdapterResponse authnResponseFromProvider = this.getAuthnResponseFromProvider(inParameters, request, response);
        if (authnResponseFromProvider != null) {
            return authnResponseFromProvider;
        }
        String username = RiskEventExtractor.getUsername(inParameters, request, this.authnApiSupport);
        if (StringUtils.isBlank(username)) {
            return this.createFailedAuthnAdapterResponse();
        }
        if (this.authnApiSupport.isApiRequest(request) && !request.getMethod().equals("GET") && !this.p1ProtectManagementAdapterAuthnApiSupport.isValidP1ProtectManagementAdapterAuthnApiPost(request, response, StateSpec.DEVICE_PROFILE_REQUIRED.getStatus())) {
            return PingOneProtectIdpAdapter.inProgressAuthAdapterResponse();
        }
        if (this.isSubmitDeviceProfileRequest(request) || this.isDeviceProfileFromProvider(request, response, inParameters)) {
            return this.preformRiskEvaluation(request, response, inParameters);
        }
        if (this.authnApiSupport.isApiRequest(request)) {
            if (this.includeDynamicDeviceProfile) {
                this.p1ProtectManagementAdapterAuthnApiSupport.writeDeviceProfileRequiredResponse(request, response, this.deviceProfilingTimeout);
                return PingOneProtectIdpAdapter.inProgressAuthAdapterResponse();
            }
            return this.preformRiskEvaluation(request, response, inParameters);
        }
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("deviceProfilingTimeout", this.deviceProfilingTimeout);
        customParams.put("collectDeviceTrustAttributes", this.enablePingIdDeviceTrustPayload);
        customParams.put("deviceTrustAgentPort", this.deviceTrustPort);
        customParams.put("deviceTrustAgentTimeout", this.deviceTrustTimeout);
        if (COOKIE_VALUE.equals(PingOneProtectIdpAdapter.getCookieValue(request, response, this.deviceProfileCookieName))) {
            this.pingOneProtectManagementAdapterTemplateSupport.renderDeviceProfileTemplate(request, response, inParameters, customParams);
            return PingOneProtectIdpAdapter.inProgressAuthAdapterResponse();
        }
        if (!this.includeDynamicDeviceProfile) {
            return this.preformRiskEvaluation(request, response, inParameters);
        }
        this.pingOneProtectManagementAdapterTemplateSupport.renderDeviceProfileTemplate(request, response, inParameters, customParams);
        return PingOneProtectIdpAdapter.inProgressAuthAdapterResponse();
    }

    private static String getCookieValue(HttpServletRequest request, HttpServletResponse response, String cookieName) {
        Cookie[] cookies = request.getCookies();
        if (Objects.isNull(cookies)) {
            return null;
        }
        return Arrays.stream(cookies).filter(cookie -> cookieName.equals(cookie.getName())).findFirst().map(cookie -> {
            String cookieValue = cookie.getValue();
            cookie.setValue("");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            return cookieValue;
        }).orElse(null);
    }

    private static AuthnAdapterResponse inProgressAuthAdapterResponse() {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.IN_PROGRESS);
        return authnAdapterResponse;
    }

    private AuthnAdapterResponse getAuthnResponseFromProvider(Map<String, Object> inParameters, HttpServletRequest request, HttpServletResponse response) {
        String resumeURL = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        return this.transactionalStateSupportWrapper.getAuthnResponse(resumeURL, request, response);
    }

    private AuthnAdapterResponse createFailedAuthnAdapterResponse() {
        AuthnAdapterResponse authnAdapterResponse = new AuthnAdapterResponse();
        authnAdapterResponse.setAuthnStatus(AuthnAdapterResponse.AUTHN_STATUS.FAILURE);
        return authnAdapterResponse;
    }

    public IdpAuthnAdapterDescriptor getAdapterDescriptor() {
        IdpAuthnAdapterDescriptor descriptor = new IdpAuthnAdapterDescriptor((ConfigurableAuthnAdapter)this, "PingOne Protect IdP Adapter 1.0.5", this.getContract(), true, PingOneProtectAdapterConfiguration.makeAdapterConfigurationGuiDescriptor(), false){

            public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
                return new GuiConfigDescriptorBuilder(){

                    public GuiConfigDescriptor buildNewGuiDescriptor() {
                        return PingOneProtectAdapterConfiguration.makeAdapterConfigurationGuiDescriptor();
                    }

                    public GuiConfigDescriptor buildConfiguredGuiDescriptor(Configuration configuration) {
                        return PingOneProtectAdapterConfiguration.makeAdapterConfigurationGuiDescriptor(configuration);
                    }
                };
            }
        };
        if (supportsSetMetadata && supportsPluginServiceAssociation) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                String pingOneServiceAssociation = (String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null);
                String displayName = ReflectionUtils.getFieldValue(pluginServiceAssociationClass, "PROTECT_SERVICE_DISPLAY_NAME", "Protect Service");
                descriptor.setMetadata(Collections.singletonMap(pingOneServiceAssociation, pluginServiceAssociationConstructor.newInstance("Protect Adapter", displayName)));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return descriptor;
    }

    public Map lookupAuthN(HttpServletRequest request, HttpServletResponse response, String spPartnerEntityId, AuthnPolicy authnPolicy, String resumePath) {
        return null;
    }

    public boolean logoutAuthN(Map map, HttpServletRequest request, HttpServletResponse response, String resumePath) {
        return true;
    }

    public Map<String, Object> getAdapterInfo() {
        return null;
    }

    public boolean isDeferAuthenticationSessionRegistration() {
        return false;
    }

    public void onTransactionComplete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> map, AttributeMap attributeMap) {
    }

    public void onTransactionComplete(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, AttributeMap policyResultMap, Map<String, Object> inParameters) {
        this.sendTransactionStatus(request, response, CompletionStatus.SUCCESS, inParameters);
    }

    public void onTransactionFailure(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap) {
        super.onTransactionFailure(request, response, authnIdentifiersMap);
    }

    public void onTransactionFailure(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, Map<String, Object> inParameters) {
        this.sendTransactionStatus(request, response, CompletionStatus.FAILED, inParameters);
    }

    private void sendTransactionStatus(HttpServletRequest request, HttpServletResponse response, CompletionStatus completionStatus, Map<String, Object> inParameters) {
        String riskEvaluationId = this.sessionStateSupportWrapper.getRiskEvaluationId(this.instanceId, request, response);
        String trackingId = RiskEventExtractor.getTrackingId(inParameters);
        String transactionId = RiskEventExtractor.getTransactionId(inParameters);
        LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.BEGIN_RISK_FEEDBACK, riskEvaluationId, "PingOne Protect IdP Adapter 1.0.5");
        this.sessionStateSupportWrapper.removeRiskEvaluationId(this.instanceId, request, response);
        try {
            if (StringUtils.isNotBlank(riskEvaluationId)) {
                this.riskService.feedbackRisk(riskEvaluationId, trackingId, transactionId, completionStatus);
                LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.SUCCESSFUL_RISK_FEEDBACK, riskEvaluationId, completionStatus.name());
            }
        }
        catch (Exception e) {
            String riskEvaluationIdLog = riskEvaluationId;
            riskEvaluationIdLog = LogCleaner.clean(riskEvaluationIdLog);
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_FEEDBACK_ERROR, riskEvaluationIdLog);
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_FEEDBACK_TRACE, e);
        }
    }

    public PluginApiSpec getApiSpec() {
        List<AuthnStateSpec<?>> authnStateSpecs = PingOneProtectAuthnApiSupport.getAuthnStateSpecs();
        return new PluginApiSpec(authnStateSpecs);
    }

    public AuthnApiPluginDescriptor getApiPluginDescriptor() {
        return super.getApiPluginDescriptor();
    }

    private Set<String> getContract() {
        return Arrays.stream(CoreContract.values()).map(CoreContract::toString).collect(Collectors.toSet());
    }

    private boolean isSubmitDeviceProfileRequest(HttpServletRequest request) {
        return this.p1ProtectManagementAdapterAuthnApiSupport.isSubmitDeviceProfileRequest(request) || this.pingOneProtectManagementAdapterTemplateSupport.isSubmitDeviceProfileRequest(request);
    }

    private boolean isDeviceProfileFromProvider(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) {
        String resumeURL = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        return this.transactionalStateSupportWrapper.getSignalsSdk(resumeURL, request, response) != null;
    }

    private AuthnAdapterResponse preformRiskEvaluation(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters) throws AuthnErrorException {
        RiskEvent riskEvent = RiskEventExtractor.extract(request, response, inParameters, this.transactionalStateSupportWrapper, this.optionalUserAttributesMapping, this.predictorsMapping, this.authnApiSupport);
        return AuthnAdapterResponseConverter.authnAdapterResponse(this.riskService.evaluateRisk(riskEvent), this.sessionStateSupportWrapper, this.instanceId, this.failureMode, this.fallbackValue, request, response);
    }

    static {
        Method[] methods = PluginDescriptor.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "setMetadata".equals(m.getName()))) {
            supportsSetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
    }
}

