/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect;

import com.pingidentity.adapters.pingone.protect.AuthnAdapterResponseConverter;
import com.pingidentity.adapters.pingone.protect.CoreContract;
import com.pingidentity.adapters.pingone.protect.RiskEventExtractor;
import com.pingidentity.adapters.pingone.protect.SessionStateSupportWrapper;
import com.pingidentity.adapters.pingone.protect.SessionStateSupportWrapperImpl;
import com.pingidentity.adapters.pingone.protect.TransactionalStateSupportWrapper;
import com.pingidentity.adapters.pingone.protect.TransactionalStateSupportWrapperImpl;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapper;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapperFactory;
import com.pingidentity.adapters.pingone.protect.api.model.Result;
import com.pingidentity.adapters.pingone.protect.configuration.provider.PingOneProtectProviderConfiguration;
import com.pingidentity.adapters.pingone.protect.dto.CompletionStatus;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvent;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskService;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskServiceFactory;
import com.pingidentity.adapters.pingone.protect.log.LogCleaner;
import com.pingidentity.adapters.pingone.protect.log.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.EnumUtils;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.util.ReflectionUtils;
import com.pingidentity.sdk.AuthnAdapterResponse;
import com.pingidentity.sdk.Plugin;
import com.pingidentity.sdk.PluginDescriptor;
import com.pingidentity.sdk.TransactionAwareAuthenticationAdapter;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import com.pingidentity.sdk.captchaprovider.CaptchaContext;
import com.pingidentity.sdk.captchaprovider.CaptchaProvider;
import com.pingidentity.sdk.captchaprovider.CaptchaProviderDescriptor;
import com.pingidentity.sdk.captchaprovider.CaptchaResult;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.common.VersionUtil;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.state.SessionStateSupport;
import org.sourceid.util.log.AttributeMap;

public class PingOneProtectProvider
implements CaptchaProvider,
TransactionAwareAuthenticationAdapter {
    private static final String JAVASCRIPT_FILE_NAME = "signals.js";
    private static final String CAPTCHA_SCORE = "captchaScore";
    private static final String CAPTCHA_CHALLENGE_TIME = "captchaChallengeTime";
    private Configuration configuration;
    private final AuthnApiSupport authnApiSupport;
    private String instanceId;
    private boolean enableRiskEvaluation;
    private String passwordEncryptionType;
    private boolean followRecommendedAction;
    private String failureMode;
    private String fallbackValue;
    private RiskService riskService;
    private final SessionStateSupportWrapper sessionStateSupportWrapper;
    private final TransactionalStateSupportWrapper transactionalStateSupportWrapper;
    PingOneEnvironmentAccessorWrapperFactory pingOneEnvironmentAccessorWrapperFactory;
    private boolean enablePingIdDeviceTrustPayload;
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(PingOneProtectProvider.class);
    private static boolean supportsSetMetadata;
    private static boolean supportsPluginServiceAssociation;

    public PingOneProtectProvider() {
        this.sessionStateSupportWrapper = new SessionStateSupportWrapperImpl(new SessionStateSupport());
        this.transactionalStateSupportWrapper = new TransactionalStateSupportWrapperImpl();
        this.authnApiSupport = AuthnApiSupport.getDefault();
    }

    protected PingOneProtectProvider(SessionStateSupportWrapper sessionStateSupportWrapper, RiskService riskService, TransactionalStateSupportWrapper transactionalStateSupportWrapper, AuthnApiSupport authnApiSupport) {
        this.sessionStateSupportWrapper = sessionStateSupportWrapper;
        this.riskService = riskService;
        this.transactionalStateSupportWrapper = transactionalStateSupportWrapper;
        this.authnApiSupport = authnApiSupport;
    }

    protected PingOneProtectProvider(SessionStateSupportWrapper sessionStateSupportWrapper, RiskService riskService, TransactionalStateSupportWrapper transactionalStateSupportWrapper, AuthnApiSupport authnApiSupport, PingOneEnvironmentAccessorWrapperFactory pingOneEnvironmentAccessorWrapperFactory) {
        this.sessionStateSupportWrapper = sessionStateSupportWrapper;
        this.riskService = riskService;
        this.transactionalStateSupportWrapper = transactionalStateSupportWrapper;
        this.authnApiSupport = authnApiSupport;
        this.pingOneEnvironmentAccessorWrapperFactory = pingOneEnvironmentAccessorWrapperFactory;
    }

    public String getJavaScriptFileName() {
        return JAVASCRIPT_FILE_NAME;
    }

    public Map<String, Object> getCaptchaAttributes(CaptchaContext captchaContext) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        this.appendDeviceTrustConfigIfNeeded(attributes);
        return attributes;
    }

    private void appendDeviceTrustConfigIfNeeded(Map<String, Object> attributes) {
        if (!this.enablePingIdDeviceTrustPayload) {
            return;
        }
        attributes.put("collectDeviceTrustAttributes", this.enablePingIdDeviceTrustPayload);
        Integer deviceTrustPort = PingOneProtectProviderConfiguration.PingIdAgentPortField.getPingIdAgentPort(this.configuration);
        Integer deviceTrustTimeout = PingOneProtectProviderConfiguration.PingIdAgentTimeoutField.getPingIdAgentTimeout(this.configuration);
        if (deviceTrustPort != 0) {
            attributes.put("deviceTrustAgentPort", deviceTrustPort);
        }
        if (deviceTrustTimeout != 0) {
            attributes.put("deviceTrustAgentTimeout", deviceTrustTimeout);
        }
    }

    public CaptchaResult validateCaptcha(CaptchaContext captchaContext) {
        AttributeMap attributeMap = new AttributeMap();
        HttpServletRequest request = captchaContext.getRequest();
        HttpServletResponse response = captchaContext.getResponse();
        String resumeURL = (String)captchaContext.getInParameters().get("com.pingidentity.adapter.input.parameter.resume.path");
        this.transactionalStateSupportWrapper.setSignalsSdk(resumeURL, RiskEventExtractor.getProviderSdk(request, this.authnApiSupport), request, response);
        String recommendedAction = null;
        if (this.enableRiskEvaluation) {
            AuthnAdapterResponse authnAdapterResponse = this.preformRiskEvaluation(request, response, captchaContext.getInParameters(), captchaContext.getAction());
            if (authnAdapterResponse.getAuthnStatus().equals((Object)AuthnAdapterResponse.AUTHN_STATUS.FAILURE)) {
                return CaptchaResult.createInvalidResult((AttributeMap)attributeMap);
            }
            attributeMap = AuthnAdapterResponseConverter.providerAttributeMap(authnAdapterResponse);
            recommendedAction = (String)authnAdapterResponse.getAttributeMap().get(CoreContract.RECOMMENDED_ACTION.toString());
            this.transactionalStateSupportWrapper.setAuthnResponse(resumeURL, authnAdapterResponse, request, response);
        }
        if (this.followRecommendedAction && EnumUtils.isValidEnum(Result.RecommendedAction.class, recommendedAction)) {
            return CaptchaResult.createInvalidResult((AttributeMap)attributeMap);
        }
        return CaptchaResult.createValidResult((AttributeMap)attributeMap);
    }

    public void postAuthenticationCallback(CaptchaProvider.AuthenticationStatus authenticationStatus, CaptchaContext captchaContext) {
        super.postAuthenticationCallback(authenticationStatus, captchaContext);
    }

    private AuthnAdapterResponse preformRiskEvaluation(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters, String action) {
        RiskEvent riskEvent = RiskEventExtractor.extractForProvider(request, response, inParameters, this.passwordEncryptionType, this.authnApiSupport, action);
        return AuthnAdapterResponseConverter.authnAdapterResponse(this.riskService.evaluateRisk(riskEvent), this.sessionStateSupportWrapper, this.instanceId, this.failureMode, this.fallbackValue, request, response);
    }

    public void configure(Configuration configuration) {
        this.configureInternalState(configuration);
        this.configureRiskService(configuration);
        this.configuration = configuration;
    }

    protected void configureInternalState(Configuration configuration) {
        this.instanceId = configuration.getId();
        this.enableRiskEvaluation = PingOneProtectProviderConfiguration.EnableRiskEvaluation.isRiskEvaluationEnabled(configuration);
        this.passwordEncryptionType = PingOneProtectProviderConfiguration.PasswordEncryptionTypeField.getPasswordEncryptionType(configuration);
        this.followRecommendedAction = PingOneProtectProviderConfiguration.FollowRecommendedActionField.isFollowRecommendedAction(configuration);
        this.failureMode = PingOneProtectProviderConfiguration.FailureModeField.getFailureMode(configuration);
        this.fallbackValue = PingOneProtectProviderConfiguration.FallbackValueField.getFallbackValue(configuration);
        this.enablePingIdDeviceTrustPayload = PingOneProtectProviderConfiguration.EnablePingIdDeviceTrustPayload.isPingIdDeviceTrustPayloadEnabled(configuration);
    }

    private void configureRiskService(Configuration configuration) {
        if (this.pingOneEnvironmentAccessorWrapperFactory == null) {
            this.pingOneEnvironmentAccessorWrapperFactory = new PingOneEnvironmentAccessorWrapperFactory();
        }
        PingOneEnvironmentAccessorWrapper pingOneEnvironmentAccessorWrapper = this.pingOneEnvironmentAccessorWrapperFactory.create(configuration);
        RiskServiceFactory riskServiceFactory = new RiskServiceFactory();
        this.riskService = riskServiceFactory.create(configuration, pingOneEnvironmentAccessorWrapper);
    }

    public PluginDescriptor getPluginDescriptor() {
        HashSet<String> attributeContract = new HashSet<String>(Arrays.asList(CAPTCHA_SCORE, CAPTCHA_CHALLENGE_TIME));
        CaptchaProviderDescriptor descriptor = new CaptchaProviderDescriptor("PingOne Protect", (Plugin)this, attributeContract, PingOneProtectProviderConfiguration.providerConfigurationGuiDescriptor(this.configuration), VersionUtil.getVersion());
        if (supportsSetMetadata && supportsPluginServiceAssociation) {
            try {
                Class<?> pluginMetadataKeysClass = Class.forName("com.pingidentity.sdk.PluginMetadataKeys");
                Class<?> pluginServiceAssociationClass = Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
                Constructor<?> pluginServiceAssociationConstructor = pluginServiceAssociationClass.getConstructor(String.class, String.class);
                String pingOneServiceAssociation = (String)pluginMetadataKeysClass.getField("PING_ONE_SERVICE_ASSOCIATION").get(null);
                String displayName = ReflectionUtils.getFieldValue(pluginServiceAssociationClass, "PROTECT_SERVICE_DISPLAY_NAME", "Protect Service");
                descriptor.setMetadata(Collections.singletonMap(pingOneServiceAssociation, pluginServiceAssociationConstructor.newInstance("Protect Risk and CAPTCHA Provider", displayName)));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return descriptor;
    }

    private void sendTransactionStatus(HttpServletRequest request, HttpServletResponse response, CompletionStatus completionStatus, Map<String, Object> inParameters) {
        String riskEvaluationId = this.sessionStateSupportWrapper.getRiskEvaluationId(this.instanceId, request, response);
        String trackingId = RiskEventExtractor.getTrackingId(inParameters);
        String transactionId = RiskEventExtractor.getTransactionId(inParameters);
        LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.BEGIN_RISK_FEEDBACK, riskEvaluationId, "PingOne Protect");
        this.sessionStateSupportWrapper.removeRiskEvaluationId(this.instanceId, request, response);
        try {
            if (StringUtils.isNotBlank(riskEvaluationId)) {
                this.riskService.feedbackRisk(riskEvaluationId, trackingId, transactionId, completionStatus);
                LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.SUCCESSFUL_RISK_FEEDBACK, riskEvaluationId, completionStatus.name());
            }
        }
        catch (Exception e) {
            String riskEvaluationIdLog = riskEvaluationId;
            riskEvaluationIdLog = LogCleaner.clean(riskEvaluationIdLog);
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_FEEDBACK_ERROR, riskEvaluationIdLog);
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_FEEDBACK_TRACE, e);
        }
    }

    public boolean isDeferAuthenticationSessionRegistration() {
        return false;
    }

    public void onTransactionComplete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Object> map, AttributeMap attributeMap) {
    }

    public void onTransactionComplete(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map, AttributeMap attributeMap, Map<String, Object> inParameters) {
        this.sendTransactionStatus(request, response, CompletionStatus.SUCCESS, inParameters);
    }

    public void onTransactionFailure(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap) {
        super.onTransactionFailure(request, response, authnIdentifiersMap);
    }

    public void onTransactionFailure(HttpServletRequest request, HttpServletResponse response, Map<String, Object> authnIdentifiersMap, Map<String, Object> inParameters) {
        this.sendTransactionStatus(request, response, CompletionStatus.FAILED, inParameters);
    }

    static {
        Method[] methods = PluginDescriptor.class.getMethods();
        if (Arrays.stream(methods).anyMatch(m -> "setMetadata".equals(m.getName()))) {
            supportsSetMetadata = true;
        }
        try {
            Class.forName("com.pingidentity.sdk.PluginServiceAssociation");
            supportsPluginServiceAssociation = true;
        }
        catch (ClassNotFoundException ignored) {
            supportsPluginServiceAssociation = false;
        }
    }
}

