/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect;

import com.google.common.hash.Hashing;
import com.pingidentity.adapters.pingone.protect.TransactionalStateSupportWrapper;
import com.pingidentity.adapters.pingone.protect.api.authn.SubmitDeviceProfile;
import com.pingidentity.adapters.pingone.protect.dto.Action;
import com.pingidentity.adapters.pingone.protect.dto.DeviceProfile;
import com.pingidentity.adapters.pingone.protect.dto.Flow;
import com.pingidentity.adapters.pingone.protect.dto.FlowType;
import com.pingidentity.adapters.pingone.protect.dto.Hash;
import com.pingidentity.adapters.pingone.protect.dto.OptionalUserAttribute;
import com.pingidentity.adapters.pingone.protect.dto.Password;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvent;
import com.pingidentity.adapters.pingone.protect.dto.SDK;
import com.pingidentity.adapters.pingone.protect.dto.Signals;
import com.pingidentity.adapters.pingone.protect.log.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.ObjectUtils;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.util.PredictorAttributeMappingUtil;
import com.pingidentity.sdk.api.authn.exception.AuthnErrorException;
import com.pingidentity.sdk.api.authn.util.AuthnApiSupport;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.attribute.AttrValueSupport;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class RiskEventExtractor {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(RiskEventExtractor.class);
    private static final String BROWSER_ID_COOKIE_NAME = "pingone.risk.browser.profile";
    public static final String SHA_256 = "SHA_256";
    public static final String SHA_384 = "SHA_384";
    public static final String CAPTCHA_RESPONSE = "captchaResponse";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String USER_AGENT = "user-agent";

    public static RiskEvent extract(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters, TransactionalStateSupportWrapper transactionalStateSupportWrapper, Map<String, OptionalUserAttribute> optionalUserAttributesMapping, Map<String, String> predictorsMapping, AuthnApiSupport authnApiSupport) throws AuthnErrorException {
        String ipAddress = RiskEventExtractor.getIpAddress(request);
        String username = RiskEventExtractor.getUsername(inParameters, request, authnApiSupport);
        String targetResourceId = RiskEventExtractor.getTargetResourceId(inParameters);
        String targetResourceName = RiskEventExtractor.getTargetResourceName(inParameters);
        String transactionId = RiskEventExtractor.getTransactionId(inParameters);
        String trackingId = RiskEventExtractor.getTrackingId(inParameters);
        String sharingType = RiskEventExtractor.getSharingType(inParameters);
        String browserId = RiskEventExtractor.getBrowserId(request, response, authnApiSupport.isApiRequest(request));
        String signalsSdkDeviceProfile = RiskEventExtractor.getSignalsSdkDeviceProfile(request, response, inParameters, transactionalStateSupportWrapper, authnApiSupport);
        DeviceProfile deviceProfile = RiskEventExtractor.setDeviceProfile(request, signalsSdkDeviceProfile);
        Map<OptionalUserAttribute, AttributeValue> optionalUserAttributes = RiskEventExtractor.getOptionalUserAttributes(inParameters, optionalUserAttributesMapping);
        Map<String, AttributeValue> riskPredictors = RiskEventExtractor.getOptionalRiskPredictors(inParameters, predictorsMapping);
        Flow flow = RiskEventExtractor.getFlow(null);
        return new RiskEvent.Builder().setIpAddress(ipAddress).setUsername(username).setSdk(RiskEventExtractor.sdk(signalsSdkDeviceProfile)).setDeviceProfile(deviceProfile).setTargetResourceId(targetResourceId).setTargetResourceName(targetResourceName).setFlow(flow).setTransactionId(transactionId).setTrackingId(trackingId).setSharingType(sharingType).setBrowserId(browserId).setOptionalUserAttributes(optionalUserAttributes).setOptionalRiskPredictors(riskPredictors).setOrigin(RiskEvent.Origin.PF_PROTECT_ADAPTER.name()).build();
    }

    public static RiskEvent extractForProvider(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters, String passwordEncryptionType, AuthnApiSupport authnApiSupport, String action) {
        String ipAddress = RiskEventExtractor.getIpAddress(request);
        String username = RiskEventExtractor.getUsername(inParameters, request, authnApiSupport);
        String password = RiskEventExtractor.getTypedPassword(request, authnApiSupport);
        String targetResourceId = RiskEventExtractor.getTargetResourceId(inParameters);
        String targetResourceName = RiskEventExtractor.getTargetResourceName(inParameters);
        String transactionId = RiskEventExtractor.getTransactionId(inParameters);
        String trackingId = RiskEventExtractor.getTrackingId(inParameters);
        String sharingType = RiskEventExtractor.getSharingType(inParameters);
        String browserId = RiskEventExtractor.getBrowserId(request, response, authnApiSupport.isApiRequest(request));
        String signalsSdkDeviceProfile = RiskEventExtractor.getProviderSdk(request, authnApiSupport);
        DeviceProfile deviceProfile = RiskEventExtractor.setDeviceProfile(request, signalsSdkDeviceProfile);
        Flow flow = RiskEventExtractor.getFlow(action);
        return new RiskEvent.Builder().setIpAddress(ipAddress).setUsername(username).setPassword(RiskEventExtractor.password(password, passwordEncryptionType)).setSdk(RiskEventExtractor.sdk(signalsSdkDeviceProfile)).setDeviceProfile(deviceProfile).setTargetResourceId(targetResourceId).setTargetResourceName(targetResourceName).setFlow(flow).setTransactionId(transactionId).setTrackingId(trackingId).setSharingType(sharingType).setBrowserId(browserId).setOrigin(RiskEvent.Origin.PF_PROTECT_PROVIDER.name()).build();
    }

    private static String apiRequestExtractor(HttpServletRequest request, String fieldKey, AuthnApiSupport authnApiSupport) {
        try {
            Map requestBody = authnApiSupport.deserializeAsMap(request);
            Object captchaResponseFromBody = requestBody.get(fieldKey);
            if (captchaResponseFromBody instanceof String) {
                return (String)captchaResponseFromBody;
            }
            LOGGER.log(LogEvent.INVALID_AUTHN_RESPONSE);
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isAuthnPostRequest(HttpServletRequest request, AuthnApiSupport authnApiSupport) {
        return authnApiSupport.isApiRequest(request) && request.getMethod().equals("POST");
    }

    public static String getProviderSdk(HttpServletRequest request, AuthnApiSupport authnApiSupport) {
        if (RiskEventExtractor.isAuthnPostRequest(request, authnApiSupport)) {
            return RiskEventExtractor.apiRequestExtractor(request, CAPTCHA_RESPONSE, authnApiSupport);
        }
        return Optional.ofNullable(request.getParameter("signals-response")).orElse("");
    }

    private static DeviceProfile setDeviceProfile(HttpServletRequest request, String signalsSdkDeviceProfile) {
        if (StringUtils.isEmpty(signalsSdkDeviceProfile)) {
            DeviceProfile deviceProfile = new DeviceProfile();
            deviceProfile.setUserAgent(request.getHeader(USER_AGENT));
            return deviceProfile;
        }
        return null;
    }

    private static String getTypedPassword(HttpServletRequest request, AuthnApiSupport authnApiSupport) {
        if (RiskEventExtractor.isAuthnPostRequest(request, authnApiSupport)) {
            return RiskEventExtractor.apiRequestExtractor(request, PASSWORD, authnApiSupport);
        }
        return Optional.ofNullable(request.getParameterMap()).map(map -> (String[])map.get("pf.pass")).filter(ObjectUtils::isNotEmpty).map(strings -> strings[0]).orElse("");
    }

    private static String encodePassword(String password, String encryptionType) {
        if (encryptionType.equals("SHA-384")) {
            return StringUtils.substring(Hashing.sha384().hashString((CharSequence)password, StandardCharsets.UTF_8).toString(), 0, 48);
        }
        return StringUtils.substring(Hashing.sha256().hashString((CharSequence)password, StandardCharsets.UTF_8).toString(), 0, 32);
    }

    private static String setEncryptionType(String encryptionType) {
        return encryptionType.equals("SHA-384") ? SHA_384 : SHA_256;
    }

    private static Password password(String password, String encryptionType) {
        if (encryptionType.equals("Disable") || ObjectUtils.isEmpty(password)) {
            return null;
        }
        return new Password.Builder().setHash(new Hash.Builder().setAlgorithm(RiskEventExtractor.setEncryptionType(encryptionType)).setValue(RiskEventExtractor.encodePassword(password, encryptionType)).build()).build();
    }

    private static SDK sdk(String signalsSdkDeviceProfile) {
        return new SDK.Builder().setSignals(new Signals.Builder().setData(signalsSdkDeviceProfile).build()).build();
    }

    private static String getIpAddress(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    private static Optional<AttributeValue> getFromChainedAttributes(Map<String, Object> inParameters, String key) {
        Map chainedAttributes = (Map)inParameters.get("com.pingidentity.adapter.input.parameter.chained.attributes");
        if (chainedAttributes != null && !chainedAttributes.isEmpty()) {
            return Optional.ofNullable(AttrValueSupport.make(chainedAttributes.get(key)));
        }
        LOGGER.log(LogEvent.NO_CHAINED_ATTRIBUTES);
        return Optional.empty();
    }

    protected static String getUsername(Map<String, Object> inParameters, HttpServletRequest request, AuthnApiSupport authnApiSupport) {
        String username = (String)inParameters.get("com.pingidentity.adapter.input.parameter.userid");
        if (StringUtils.isNotEmpty(username)) {
            return username;
        }
        if (RiskEventExtractor.isAuthnPostRequest(request, authnApiSupport)) {
            return RiskEventExtractor.apiRequestExtractor(request, USERNAME, authnApiSupport);
        }
        return Optional.ofNullable(request.getParameterMap()).map(map -> (String[])map.get("pf.username")).filter(ObjectUtils::isNotEmpty).map(strings -> strings[0]).orElse("");
    }

    private static String getSignalsSdkDeviceProfile(HttpServletRequest request, HttpServletResponse response, Map<String, Object> inParameters, TransactionalStateSupportWrapper transactionalStateSupportWrapper, AuthnApiSupport authnApiSupport) throws AuthnErrorException {
        String resumeURL = (String)inParameters.get("com.pingidentity.adapter.input.parameter.resume.path");
        String signalsSdk = transactionalStateSupportWrapper.getSignalsSdk(resumeURL, request, response);
        if (signalsSdk != null) {
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.DEVICE_PROFILE_FROM_PROVIDER, signalsSdk);
            return signalsSdk;
        }
        if (authnApiSupport.isApiRequest(request)) {
            Optional<String> deviceProfile = RiskEventExtractor.getSignalsSdkDeviceProfile(request, authnApiSupport);
            if (!deviceProfile.isPresent()) {
                LOGGER.log(LogEvent.DEVICE_PROFILE_ERROR_FROM_AUTHN_API);
                return null;
            }
            return deviceProfile.get();
        }
        String deviceProfileValue = request.getParameter("pingone.protect.device.profile");
        Optional<String> deviceProfile = Optional.ofNullable(deviceProfileValue);
        if (!deviceProfile.isPresent()) {
            LOGGER.log(LogEvent.DEVICE_PROFILE_NOT_RETRIEVED);
            return null;
        }
        return deviceProfile.get();
    }

    private static Optional<String> getSignalsSdkDeviceProfile(HttpServletRequest request, AuthnApiSupport authnApiSupport) throws AuthnErrorException {
        Optional<String> signalsSdk = Optional.empty();
        try {
            SubmitDeviceProfile submitDeviceProfile = (SubmitDeviceProfile)((Object)authnApiSupport.deserializeAsModel(request, SubmitDeviceProfile.class));
            signalsSdk = Optional.ofNullable(submitDeviceProfile).map(SubmitDeviceProfile::getSignalsSdkDeviceProfile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return signalsSdk;
    }

    private static String getTargetResourceId(Map<String, Object> inParameters) {
        String targetResourceId = "";
        String partnerEntityId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.partner.entityid");
        String spAdapterId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.sp.adapter.id");
        String oauthClientId = (String)inParameters.get("com.pingidentity.adapter.input.parameter.oauth.client.id");
        if (StringUtils.isNotBlank(partnerEntityId)) {
            targetResourceId = partnerEntityId;
        } else if (StringUtils.isNotBlank(spAdapterId)) {
            targetResourceId = spAdapterId;
        } else if (StringUtils.isNotBlank(oauthClientId)) {
            targetResourceId = oauthClientId;
        }
        return targetResourceId;
    }

    private static String getTargetResourceName(Map<String, Object> inParameters) {
        return (String)inParameters.get("com.pingidentity.adapter.input.parameter.application.name");
    }

    protected static String getTrackingId(Map<String, Object> inParameters) {
        return (String)inParameters.get("com.pingidentity.adapter.input.parameter.tracking.id");
    }

    protected static String getTransactionId(Map<String, Object> inParameters) {
        return (String)inParameters.get("com.pingidentity.adapter.input.parameter.transaction.id");
    }

    private static String getSharingType(Map<String, Object> inParameters) {
        return (String)inParameters.get("com.pingidentity.adapter.input.parameter.device.sharing.type");
    }

    private static String getBrowserId(HttpServletRequest request, HttpServletResponse response, boolean isApiRequest) {
        Cookie[] cookies = request.getCookies();
        Cookie browserIdCookie = null;
        if (cookies != null) {
            browserIdCookie = Arrays.stream(cookies).filter(cookie -> cookie != null && BROWSER_ID_COOKIE_NAME.equalsIgnoreCase(cookie.getName())).findFirst().orElse(null);
        }
        String browserId = null;
        if (browserIdCookie == null) {
            if (!isApiRequest) {
                browserId = UUID.randomUUID().toString();
            }
            browserIdCookie = new Cookie(BROWSER_ID_COOKIE_NAME, browserId);
            browserIdCookie.setMaxAge(31557600);
            browserIdCookie.setPath("/");
            browserIdCookie.setHttpOnly(true);
            browserIdCookie.setSecure(true);
            response.addCookie(browserIdCookie);
        } else {
            browserId = browserIdCookie.getValue();
        }
        return browserId;
    }

    private static Map<OptionalUserAttribute, AttributeValue> getOptionalUserAttributes(Map<String, Object> inParameters, Map<String, OptionalUserAttribute> optionalUserAttributesMapping) {
        EnumMap<OptionalUserAttribute, AttributeValue> optionalUserAttributes = new EnumMap<OptionalUserAttribute, AttributeValue>(OptionalUserAttribute.class);
        for (Map.Entry<String, OptionalUserAttribute> mapping : optionalUserAttributesMapping.entrySet()) {
            Optional<AttributeValue> optionalAttributeValue = RiskEventExtractor.getFromChainedAttributes(inParameters, mapping.getKey());
            if (optionalAttributeValue.isPresent()) {
                AttributeValue attributeValue = optionalAttributeValue.get();
                optionalUserAttributes.put(mapping.getValue(), attributeValue);
                continue;
            }
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.MISSING_OPTIONAL_USER_ATTRIBUTE, mapping.getValue().getValue(), mapping.getKey());
        }
        return optionalUserAttributes;
    }

    private static Map<String, AttributeValue> getOptionalRiskPredictors(Map<String, Object> inParameters, Map<String, String> mapping) {
        HashMap<String, AttributeValue> optionalRiskPredictors = new HashMap<String, AttributeValue>();
        for (Map.Entry<String, String> entry : mapping.entrySet()) {
            Optional<AttributeValue> optionalAttributeValue = RiskEventExtractor.getFromChainedAttributes(inParameters, entry.getKey());
            if (!optionalAttributeValue.isPresent()) continue;
            AttributeValue attributeValue = optionalAttributeValue.get();
            optionalRiskPredictors.put(PredictorAttributeMappingUtil.getValueAfterEvent(entry.getValue()), attributeValue);
        }
        return optionalRiskPredictors;
    }

    private static Flow getFlow(String actionName) {
        if (StringUtils.isEmpty(actionName)) {
            return new Flow(FlowType.AUTHENTICATION.name(), null);
        }
        return Action.findActionByName(actionName).map(action -> new Flow(action.getType().name(), Objects.nonNull((Object)action.getSubtype()) ? action.getSubtype().name() : null)).orElse(null);
    }
}

