/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.api;

import com.pingidentity.adapters.pingone.protect.api.RiskEvaluationResponseHandler;
import com.pingidentity.adapters.pingone.protect.api.RiskEventResponseHandler;
import com.pingidentity.adapters.pingone.protect.api.RiskPolicySetsResponseHandler;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEvaluationRequest;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEvaluationResponse;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEventRequest;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEventResponse;
import com.pingidentity.adapters.pingone.protect.api.model.RiskPolicySetsResponse;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.Executor;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.Request;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.ContentType;
import com.pingidentity.adapters.pingone.protect.util.ObjectMappers;
import java.io.IOException;

public class RiskApiClient {
    private static final String PING_ONE_ENVIRONMENT_PATH = "%s/v1/environments/%s";
    public static final String RISK_EVALUATIONS_ENDPOINT = "/riskEvaluations";
    public static final String RISK_POLICY_SETS_ENDPOINT = "/riskPolicySets";
    public static final String RISK_PREDICTORS_ENDPOINT = "/riskPredictors";
    public static final String TRANSACTION_ID = "X-Ping-External-Transaction-ID";
    public static final String TRACKING_ID = "X-Ping-External-Session-ID";
    private static final String RISK_EVALUATIONS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/riskEvaluations";
    private static final String RISK_POLICY_SETS_ENDPOINT_TEMPLATE = "%s/v1/environments/%s/riskPolicySets";
    private static final String BEARER_TOKEN_FORMAT = "Bearer %s";
    private static final String EVENT_PATH = "%s/event";
    private final Executor executor;
    private final String riskEvaluationsUrl;
    private final String riskPolicySetsUrl;

    public RiskApiClient(Executor executor, String apiPath, String envId) {
        this.executor = executor;
        this.riskEvaluationsUrl = String.format(RISK_EVALUATIONS_ENDPOINT_TEMPLATE, apiPath, envId);
        this.riskPolicySetsUrl = String.format(RISK_POLICY_SETS_ENDPOINT_TEMPLATE, apiPath, envId);
    }

    public RiskEvaluationResponse postRiskEvent(RiskEvaluationRequest request, String trackingId, String transactionId, String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String bodyString = ObjectMappers.getDefault().writeValueAsString(request);
        RiskEvaluationResponseHandler responseHandler = new RiskEvaluationResponseHandler();
        Request httpPostRequest = Request.post(this.riskEvaluationsUrl).setHeader("Authorization", authHeader).setHeader(TRACKING_ID, trackingId).setHeader(TRANSACTION_ID, transactionId).bodyString(bodyString, ContentType.APPLICATION_JSON);
        return this.executor.execute(httpPostRequest).handleResponse(responseHandler);
    }

    public RiskEventResponse putRiskEvent(RiskEventRequest request, String riskEvaluationId, String trackingId, String transactionId, String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        String bodyString = ObjectMappers.getDefault().writeValueAsString(request);
        RiskEventResponseHandler responseHandler = new RiskEventResponseHandler();
        return this.executor.execute(Request.put(this.riskEvaluationsUrl + "/" + String.format(EVENT_PATH, riskEvaluationId)).setHeader("Authorization", authHeader).setHeader(TRACKING_ID, trackingId).setHeader(TRANSACTION_ID, transactionId).bodyString(bodyString, ContentType.APPLICATION_JSON)).handleResponse(responseHandler);
    }

    public RiskPolicySetsResponse getRiskPolicySets(String accessToken) throws IOException {
        String authHeader = String.format(BEARER_TOKEN_FORMAT, accessToken);
        RiskPolicySetsResponseHandler responseHandler = new RiskPolicySetsResponseHandler();
        return this.executor.execute(Request.get(this.riskPolicySetsUrl).setHeader("Authorization", authHeader)).handleResponse(responseHandler);
    }
}

