/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.api.model;

import com.pingidentity.adapters.pingone.protect.shade.com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import java.util.Optional;

public class RiskPredictor {
    private String id;
    private String name;
    private String compactName;
    private String type;
    private MapPredictor map;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCompactName() {
        return this.compactName;
    }

    public void setCompactName(String compactName) {
        this.compactName = compactName;
    }

    public String getType() {
        return this.type;
    }

    public void setPredictorType(String type) {
        this.type = type;
    }

    public MapPredictor getMap() {
        return this.map;
    }

    public void setMap(MapPredictor map) {
        this.map = map;
    }

    public boolean isMapPredictor() {
        return this.type.equals("MAP");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RiskPredictor that = (RiskPredictor)o;
        return this.id.equals(that.id) && this.name.equals(that.name) && this.compactName.equals(that.compactName) && this.type.equals(that.type) && Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.compactName, this.type, this.map);
    }

    public String toString() {
        String value = "id='" + this.id + '\'' + ", Name='" + this.name + '\'' + ", Compact Name='" + this.compactName + '\'';
        String mappedAttribute = Optional.ofNullable(this.map).map(MapPredictor::getMappedAttribute).orElse(null);
        if (null != mappedAttribute) {
            value = value + ", Attribute mapping='" + mappedAttribute + '\'';
        }
        return value;
    }

    public static class RiskCondition {
        private String contains;

        public String getContains() {
            return this.contains;
        }

        public void setContains(String contains) {
            this.contains = contains;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RiskCondition that = (RiskCondition)o;
            return Objects.equals(this.contains, that.contains);
        }

        public int hashCode() {
            return Objects.hash(this.contains);
        }
    }

    public static class MapPredictor {
        private RiskCondition high;
        private RiskCondition medium;
        private RiskCondition low;

        public RiskCondition getHigh() {
            return this.high;
        }

        public RiskCondition getMedium() {
            return this.medium;
        }

        public RiskCondition getLow() {
            return this.low;
        }

        public void setHigh(RiskCondition high) {
            this.high = high;
        }

        public void setMedium(RiskCondition medium) {
            this.medium = medium;
        }

        public void setLow(RiskCondition low) {
            this.low = low;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapPredictor that = (MapPredictor)o;
            return this.high.equals(that.high) && this.medium.equals(that.medium) && this.low.equals(that.low);
        }

        public int hashCode() {
            return Objects.hash(this.high, this.medium, this.low);
        }

        @JsonIgnore
        public String getMappedAttribute() {
            if (this.getHigh() != null) {
                return this.getHigh().getContains();
            }
            if (this.getMedium() != null) {
                return this.getMedium().getContains();
            }
            if (this.getLow() != null) {
                return this.getLow().getContains();
            }
            return null;
        }
    }
}

