/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.configuration.adapter.action;

import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapper;
import com.pingidentity.adapters.pingone.protect.accessors.PingOneEnvironmentAccessorWrapperFactory;
import com.pingidentity.adapters.pingone.protect.api.ApiResponseException;
import com.pingidentity.adapters.pingone.protect.api.RiskServiceException;
import com.pingidentity.adapters.pingone.protect.api.TokenServiceException;
import com.pingidentity.adapters.pingone.protect.configuration.adapter.PingOneProtectAdapterConfiguration;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskService;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskServiceFactory;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.ActionDescriptor;

public class TestConnectionAction
implements ActionDescriptor.Action {
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(TestConnectionAction.class);
    private static final String CONNECTION_SUCCESSFUL = "Connection was successful. ";
    private static final String USING_RISK_POLICY_SET_NAME = "Risk policy \"%s\" will be used for risk evaluation. ";
    private static final String USING_DEFAULT_RISK_POLICY_SET = "The default risk policy will be used for risk evaluation. ";
    private static final String CONNECTION_UNSUCCESSFUL = "Connection was unsuccessful. ";
    private static final String WARNING_RISK_POLICY_SET_ID_NOT_FOUND = "Warning: risk policy id \"%s\" does not exist in PingOne Protect environment \"%s\".";
    private static final String STATUS_LINE_MESSAGE = "PingOne Protect returned HTTP status %s %s. ";
    private static final String CHECK_CONFIGURATION_MESSAGE = "Please check the value of the 'PingOne Environment' field";
    private static final String CHECK_PROXY_CONFIGURATION_MESSAGE = " as well as proxy configuration, if applicable.";
    private final RiskServiceFactory riskServiceFactory;
    private final PingOneEnvironmentAccessorWrapperFactory pingOneEnvironmentAccessorWrapperFactory;

    public TestConnectionAction() {
        this.riskServiceFactory = new RiskServiceFactory();
        this.pingOneEnvironmentAccessorWrapperFactory = new PingOneEnvironmentAccessorWrapperFactory();
    }

    protected TestConnectionAction(RiskServiceFactory riskServiceFactory, PingOneEnvironmentAccessorWrapperFactory pingOneEnvironmentAccessorWrapperFactory) {
        this.riskServiceFactory = riskServiceFactory;
        this.pingOneEnvironmentAccessorWrapperFactory = pingOneEnvironmentAccessorWrapperFactory;
    }

    public String actionInvoked(Configuration configuration) {
        String result;
        PingOneEnvironmentAccessorWrapper pingOneEnvironmentAccessor = this.pingOneEnvironmentAccessorWrapperFactory.create(configuration);
        RiskService riskService = this.riskServiceFactory.create(configuration, pingOneEnvironmentAccessor);
        try {
            result = CONNECTION_SUCCESSFUL;
            Map<String, String> riskPolicySetNames = riskService.getRiskPolicyNamesById();
            String riskPolicySetId = PingOneProtectAdapterConfiguration.PingOneRiskPolicyField.getRiskPolicyId(configuration);
            String riskPolicySetName = riskPolicySetNames.get(riskPolicySetId);
            if (StringUtils.isNotBlank(riskPolicySetId)) {
                if (riskPolicySetName == null) {
                    String envId = pingOneEnvironmentAccessor.getEnvironmentId();
                    result = result + String.format(WARNING_RISK_POLICY_SET_ID_NOT_FOUND, riskPolicySetId, envId);
                } else {
                    result = result + String.format(USING_RISK_POLICY_SET_NAME, riskPolicySetName);
                }
            } else {
                result = result + USING_DEFAULT_RISK_POLICY_SET;
            }
        }
        catch (RiskServiceException | TokenServiceException e) {
            LOGGER.log((LogEvent)com.pingidentity.adapters.pingone.protect.log.LogEvent.TEST_CONNECTION_ACTION_FAILURE, e);
            result = CONNECTION_UNSUCCESSFUL;
            if (e.getCause() instanceof ApiResponseException) {
                ApiResponseException apiResponseException = (ApiResponseException)e.getCause();
                int statusCode = apiResponseException.getStatusCode();
                String reasonPhrase = apiResponseException.getReasonPhrase();
                result = result + String.format(STATUS_LINE_MESSAGE, statusCode, reasonPhrase);
            }
            result = result + CHECK_CONFIGURATION_MESSAGE;
            result = e.getCause() instanceof ApiResponseException ? result + "." : result + CHECK_PROXY_CONFIGURATION_MESSAGE;
        }
        return result;
    }
}

