/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.configuration.provider;

import com.pingidentity.adapters.pingone.protect.api.model.Result;
import com.pingidentity.adapters.pingone.protect.dto.RiskPolicyPreRenderCallback;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import com.pingidentity.adapters.pingone.protect.validator.FallbackConfigurationValidator;
import com.pingidentity.adapters.pingone.protect.validator.ProviderEnvironmentConfigurationValidator;
import com.pingidentity.adapters.pingone.protect.validator.ProxyConfigurationValidator;
import com.pingidentity.sdk.GuiConfigDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.CheckBoxFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.RadioGroupFieldDescriptor;
import org.sourceid.saml20.adapter.gui.SelectFieldDescriptor;
import org.sourceid.saml20.adapter.gui.TextFieldDescriptor;
import org.sourceid.saml20.adapter.gui.event.PreRenderCallback;
import org.sourceid.saml20.adapter.gui.validation.ConfigurationValidator;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.IntegerValidator;
import org.sourceid.saml20.adapter.gui.validation.impl.RequiredFieldValidator;

public class PingOneProtectProviderConfiguration {
    private static final EnableRiskEvaluation ENABLE_RISK_EVALUATION = new EnableRiskEvaluation();
    private static final PasswordEncryptionTypeField ENCRYPTION_TYPE_FIELD = new PasswordEncryptionTypeField();
    private static final FollowRecommendedActionField RECOMMENDED_ACTION_FIELD = new FollowRecommendedActionField();
    private static final FailureModeField FAILURE_MODE_FIELD = new FailureModeField();
    private static final FallbackValueField FALLBACK_VALUE_FIELD = new FallbackValueField();
    private static final RequestTimeoutField REQUEST_TIMEOUT_FIELD = new RequestTimeoutField();
    private static final ProxySettingsField PROXY_SETTINGS_RADIO_GROUP_FIELD = new ProxySettingsField();
    private static final ProxyHostField PROXY_HOST_FIELD = new ProxyHostField();
    private static final ProxyPortField PROXY_PORT_FIELD = new ProxyPortField();
    private static final MaxConnectionPoolField MAX_CONNECTION_POOL_FIELD = new MaxConnectionPoolField();
    private static final EnablePingIdDeviceTrustPayload ENABLE_PINGID_DEVICE_TRUST_PAYLOAD = new EnablePingIdDeviceTrustPayload();
    private static final PingIdAgentPortField PINGID_AGENT_PORT_FIELD = new PingIdAgentPortField();
    private static final PingIdAgentTimeoutField PINGID_AGENT_TIMEOUT_FIELD = new PingIdAgentTimeoutField();

    public static GuiConfigDescriptor providerConfigurationGuiDescriptor(Configuration configuration) {
        GuiConfigDescriptor guiConfigDescriptor = new GuiConfigDescriptor();
        guiConfigDescriptor.addField(PingOneEnvironmentField.newPingOneEnvironmentField());
        if (configuration == null || PingOneEnvironmentField.isConfigured(configuration)) {
            guiConfigDescriptor.addField((FieldDescriptor)new PingOneRiskPolicyField(configuration));
            guiConfigDescriptor.addPreRenderCallback((PreRenderCallback)new RiskPolicyPreRenderCallback());
        }
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)ENABLE_RISK_EVALUATION);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)ENCRYPTION_TYPE_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)RECOMMENDED_ACTION_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)FAILURE_MODE_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)FALLBACK_VALUE_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)REQUEST_TIMEOUT_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PROXY_SETTINGS_RADIO_GROUP_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PROXY_HOST_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PROXY_PORT_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)MAX_CONNECTION_POOL_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)ENABLE_PINGID_DEVICE_TRUST_PAYLOAD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PINGID_AGENT_PORT_FIELD);
        guiConfigDescriptor.addAdvancedField((FieldDescriptor)PINGID_AGENT_TIMEOUT_FIELD);
        guiConfigDescriptor.addValidator((ConfigurationValidator)new ProxyConfigurationValidator());
        guiConfigDescriptor.addValidator((ConfigurationValidator)new FallbackConfigurationValidator());
        guiConfigDescriptor.addValidator((ConfigurationValidator)new ProviderEnvironmentConfigurationValidator());
        return guiConfigDescriptor;
    }

    public static boolean containsField(GuiConfigDescriptor guiConfigDescriptor, String fieldName) {
        return guiConfigDescriptor.getFields().stream().anyMatch(descriptor -> fieldName.equals(descriptor.getName()));
    }

    public static boolean containsAdvanceField(GuiConfigDescriptor guiConfigDescriptor, String fieldName) {
        return guiConfigDescriptor.getAdvancedFields().stream().anyMatch(descriptor -> fieldName.equals(descriptor.getName()));
    }

    public static class MaxConnectionPoolField
    extends TextFieldDescriptor {
        private MaxConnectionPoolField() {
            super("Custom connection pool", "The number of connections to PingOne Protect should range from a minimum of 25 to a maximum limit of 200.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(25, 200));
            this.setDefaultValue("50");
        }

        public static int getMaxConnectionPool(Configuration configuration) {
            return configuration.getIntFieldValue("Custom connection pool");
        }
    }

    public static class ProxyPortField
    extends TextFieldDescriptor {
        private ProxyPortField() {
            super("Custom Proxy Port", "The proxy server port to use when 'Proxy Settings' is set to 'Custom'.");
            this.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        }

        public static int getProxyPort(Configuration configuration) {
            return configuration.getIntFieldValue("Custom Proxy Port");
        }
    }

    public static class ProxyHostField
    extends TextFieldDescriptor {
        private ProxyHostField() {
            super("Custom Proxy Host", "The proxy server hostname to use when 'Proxy Settings' is set to 'Custom'.");
        }

        public static String getProxyHost(Configuration configuration) {
            return configuration.getFieldValue("Custom Proxy Host");
        }
    }

    public static class ProxySettingsField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"No Proxy", "System Defaults", "Custom"};

        private ProxySettingsField() {
            super("Proxy Settings", "Defines proxy settings for outbound HTTP requests.", OPTION_VALUES);
            this.setDefaultValue("System Defaults");
        }

        public static String getProxySettings(Configuration configuration) {
            return configuration.getFieldValue("Proxy Settings");
        }
    }

    public static class FailureModeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"Continue with fallback policy decision", "Fail"};

        private FailureModeField() {
            super("Failure Mode", "When PingOne Protect is unavailable or an error occurs, this setting determines whether the user's sign-on attempt should fail or continue with a pre-determined policy decision.", OPTION_VALUES);
            this.setDefaultValue("Continue with fallback policy decision");
        }

        public static String getFailureMode(Configuration configuration) {
            return configuration.getFieldValue("Failure Mode");
        }
    }

    public static class RequestTimeoutField
    extends TextFieldDescriptor {
        private RequestTimeoutField() {
            super("API Request Timeout", "The amount of time in milliseconds that PingFederate allows when establishing a connection with PingOne or waiting for a response to a request. The default value is '2000'. A value of 0 disables the timeout.");
            this.addValidator((FieldValidator)new RequiredFieldValidator());
            this.addValidator((FieldValidator)new IntegerValidator(0, Integer.MAX_VALUE));
            this.setDefaultValue("2000");
        }

        public static int getRequestTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("API Request Timeout");
        }
    }

    public static class FallbackValueField
    extends TextFieldDescriptor {
        private FallbackValueField() {
            super("Fallback Policy Decision Value", "The risk result (for example, \"LOW\", \"MEDIUM\", \"HIGH\", or \"unknown\") to use in the authentication policy when the PingOne Protect service is unavailable or an error occurs, and 'Failure Mode' is set to 'Continue with fallback policy decision'.");
            this.setDefaultValue(Result.Level.MEDIUM.toString());
        }

        public static String getFallbackValue(Configuration configuration) {
            return configuration.getFieldValue("Fallback Policy Decision Value");
        }
    }

    public static class FollowRecommendedActionField
    extends CheckBoxFieldDescriptor {
        public FollowRecommendedActionField() {
            super("Follow Recommended Action", "When enabled, the provider follow to \u2018Recommended Action: Bot Mitigation\u2019 and will halt the transaction immediately. If disabled or recommendedAction is not to bot mitigation, the provider will not act upon results and will pass the information forward. You can then configure the PingFederate policy to act upon PingOne Protect response.");
            this.setDefaultValue(true);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static boolean isFollowRecommendedAction(Configuration configuration) {
            return configuration.getBooleanFieldValue("Follow Recommended Action");
        }
    }

    public static class PasswordEncryptionTypeField
    extends RadioGroupFieldDescriptor {
        private static final String[] OPTION_VALUES = new String[]{"SHA-256", "SHA-384", "Disable"};

        private PasswordEncryptionTypeField() {
            super("Password Encryption", "For better detection of bots and brute force attacks, a subset of the password will be hashed and passed to PingOne Protect service. When disabled, the password will not be passed to PingOne Protect, and detection features will be decreased. All data on PingOne cloud is encrypted at rest.", OPTION_VALUES);
            this.setDefaultValue("SHA-256");
        }

        public static String getPasswordEncryptionType(Configuration configuration) {
            return configuration.getFieldValue("Password Encryption");
        }
    }

    public static class PingOneRiskPolicyField
    extends SelectFieldDescriptor {
        public PingOneRiskPolicyField(Configuration configuration) {
            super("PingOne Risk Policy", "The risk policy used by PingOne for the risk evaluation. Overrides the environment and global default policy selections. This list is populated when you select a PingOne Environment.");
            String defaultValue = PingOneRiskPolicyField.getRiskPolicyId(configuration);
            this.setDefaultValue(defaultValue);
            this.setDefaultForLegacyConfig(defaultValue);
        }

        public static String getRiskPolicyId(Configuration configuration) {
            String value = configuration == null ? null : configuration.getFieldValue("PingOne Risk Policy");
            return value;
        }
    }

    public static class PingOneEnvironmentField {
        public static FieldDescriptor newPingOneEnvironmentField() {
            try {
                Class<?> pingOneEnvironmentFieldClass = Class.forName("org.sourceid.saml20.adapter.gui.PingOneEnvironmentFieldDescriptor");
                Constructor<?> pingOneEnvironmentFieldConstructor = pingOneEnvironmentFieldClass.getConstructor(String.class, String.class);
                return (FieldDescriptor)pingOneEnvironmentFieldConstructor.newInstance("PingOne Environment", "Your PingOne environment. Create connections in System > External Systems > PingOne Connections.");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        public static String getPingOneEnvironment(Configuration configuration) {
            return Optional.ofNullable(configuration).map(conf -> conf.getFieldValue("PingOne Environment")).orElse(null);
        }

        public static boolean isConfigured(Configuration configuration) {
            return configuration != null && StringUtils.isNotEmpty(PingOneEnvironmentField.getPingOneEnvironment(configuration));
        }
    }

    public static class PingIdAgentPortField
    extends TextFieldDescriptor {
        private PingIdAgentPortField() {
            super("PingID Device Trust Agent Port", "The port number to use when connecting to the PingID Device Trust Agent. If left blank, the default port 9400 will be used.");
            this.addValidator((FieldValidator)new IntegerValidator(1, 65535), true);
        }

        public static Integer getPingIdAgentPort(Configuration configuration) {
            return configuration.getIntFieldValue("PingID Device Trust Agent Port");
        }
    }

    public static class PingIdAgentTimeoutField
    extends TextFieldDescriptor {
        private PingIdAgentTimeoutField() {
            super("PingID Device Trust Agent Timeout", "The time, in milliseconds, that PingFederate allows for establishing a connection with the PingID Device Trust Agent. If left blank, the default value is set by the Protect SDK. If specified, the value must be between 200 and 10,000 milliseconds.");
            this.addValidator((FieldValidator)new IntegerValidator(200, 10000), true);
        }

        public static Integer getPingIdAgentTimeout(Configuration configuration) {
            return configuration.getIntFieldValue("PingID Device Trust Agent Timeout");
        }
    }

    public static class EnablePingIdDeviceTrustPayload
    extends CheckBoxFieldDescriptor {
        public EnablePingIdDeviceTrustPayload() {
            super("Collect PingID Device Trust Attributes", "When enabled, the Protect SDK collects attributes from the PingID Device Trust Agent and sends them to PingOne Protect.");
            this.setDefaultValue(false);
        }

        public static boolean isPingIdDeviceTrustPayloadEnabled(Configuration configuration) {
            return Optional.ofNullable(configuration).map(conf -> conf.getBooleanFieldValue("Collect PingID Device Trust Attributes")).orElse(false);
        }
    }

    public static class EnableRiskEvaluation
    extends CheckBoxFieldDescriptor {
        public EnableRiskEvaluation() {
            super("Enable Risk Evaluation", "When enabled, the provider performs risk evaluation call to PingOne Protect. This includes passing data to PingOne Protect service.");
            this.setDefaultValue(true);
            this.addValidator((FieldValidator)new RequiredFieldValidator());
        }

        public static boolean isRiskEvaluationEnabled(Configuration configuration) {
            return Optional.ofNullable(configuration).map(conf -> conf.getBooleanFieldValue("Enable Risk Evaluation")).orElse(true);
        }
    }
}

