/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.dto;

import com.pingidentity.adapters.pingone.protect.dto.FlowSubType;
import com.pingidentity.adapters.pingone.protect.dto.FlowType;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import java.util.Arrays;
import java.util.Optional;

public enum Action {
    LOGIN(FlowType.AUTHENTICATION, FlowSubType.USER_PASSWORD),
    USERNAME_RECOVERY(FlowType.AUTHENTICATION, FlowSubType.USERNAME_RECOVERY),
    PASSWORD_RESET(FlowType.AUTHENTICATION, FlowSubType.ACCOUNT_RECOVERY),
    PASSWORD_CHANGE(FlowType.AUTHORIZATION, FlowSubType.CHANGE_PASSWORD),
    REGISTRATION(FlowType.REGISTRATION, null);

    private final FlowType type;
    private final FlowSubType subtype;

    private Action(FlowType type, FlowSubType subtype) {
        this.type = type;
        this.subtype = subtype;
    }

    public FlowType getType() {
        return this.type;
    }

    public FlowSubType getSubtype() {
        return this.subtype;
    }

    public static Optional<Action> findActionByName(String actionName) {
        if (StringUtils.isEmpty(actionName)) {
            return Optional.empty();
        }
        return Arrays.stream(Action.values()).filter(action -> Action.removeUnderscore(action.name()).equalsIgnoreCase(actionName.trim())).findFirst();
    }

    private static String removeUnderscore(String actionName) {
        if (StringUtils.isEmpty(actionName)) {
            return "";
        }
        return actionName.replaceAll("_", "");
    }
}

