/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.evaluation;

import com.pingidentity.adapters.pingone.protect.api.ApiResponseException;
import com.pingidentity.adapters.pingone.protect.api.RiskApiClient;
import com.pingidentity.adapters.pingone.protect.api.RiskServiceException;
import com.pingidentity.adapters.pingone.protect.api.TokenService;
import com.pingidentity.adapters.pingone.protect.api.TokenServiceException;
import com.pingidentity.adapters.pingone.protect.api.model.Event;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEvaluationRequest;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEvaluationResponse;
import com.pingidentity.adapters.pingone.protect.api.model.RiskEventRequest;
import com.pingidentity.adapters.pingone.protect.api.model.RiskPolicySet;
import com.pingidentity.adapters.pingone.protect.api.model.RiskPolicySetsResponse;
import com.pingidentity.adapters.pingone.protect.api.model.StandardApiErrorResponse;
import com.pingidentity.adapters.pingone.protect.dto.CompletionStatus;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvaluation;
import com.pingidentity.adapters.pingone.protect.dto.RiskEvent;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskEvaluationTranslator;
import com.pingidentity.adapters.pingone.protect.evaluation.RiskService;
import com.pingidentity.adapters.pingone.protect.log.LogCleaner;
import com.pingidentity.adapters.pingone.protect.log.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RiskServiceImpl
implements RiskService {
    private static final String RISK_EVALUATION_ERROR = "There was an error during risk evaluation.";
    private static final String RISK_FEEDBACK_ERROR = "There was an error during risk feedback.";
    private static final String RISK_POLICY_SETS_ERROR = "There was an error retrieving risk policies.";
    private final TokenService tokenService;
    private final RiskApiClient riskApiClient;
    private final Map<String, String> apiResponseMappings;
    private String riskPolicySetId;
    private static final IntegrationsLogger LOGGER = new IntegrationsLogger(RiskServiceImpl.class);

    public RiskServiceImpl(TokenService tokenService, RiskApiClient riskApiClient, Map<String, String> apiResponseMappings, String riskPolicySetId) {
        this.tokenService = tokenService;
        this.riskApiClient = riskApiClient;
        this.apiResponseMappings = apiResponseMappings;
        this.riskPolicySetId = riskPolicySetId;
    }

    @Override
    public RiskEvaluation evaluateRisk(RiskEvent riskEvent) {
        RiskEvaluation riskEvaluation = null;
        LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.BEGIN_RISK_EVALUATION, riskEvent.getUsername());
        try {
            riskEvaluation = this.evaluate(riskEvent);
        }
        catch (Exception e) {
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_EVALUATION_TRACE, e);
        }
        this.logRiskEvaluation(riskEvent.getUsername(), riskEvaluation);
        return riskEvaluation;
    }

    private RiskEvaluation evaluate(RiskEvent riskEvent) throws RiskServiceException, TokenServiceException {
        RiskEvaluationRequest riskEvaluationRequest = RiskEvaluationTranslator.translateToRequest(riskEvent);
        String trackingId = riskEvent.getTrackingId();
        String transactionId = riskEvent.getTransactionId();
        RiskEvaluation riskEvaluation = null;
        if (StringUtils.isNotBlank(this.riskPolicySetId)) {
            riskEvaluationRequest.setRiskPolicySet(new RiskPolicySet(this.riskPolicySetId));
        }
        String token = this.tokenService.getToken();
        try {
            RiskEvaluationResponse riskEvaluationResponse = this.riskApiClient.postRiskEvent(riskEvaluationRequest, trackingId, transactionId, token);
            riskEvaluation = RiskEvaluationTranslator.translateFromResponse(riskEvaluationResponse, this.apiResponseMappings);
        }
        catch (ApiResponseException e) {
            this.processApiResponseException(e, RISK_EVALUATION_ERROR);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_EVALUATION_ERROR, e);
        }
        return riskEvaluation;
    }

    @Override
    public void feedbackRisk(String riskEvaluationId, String trackingId, String transactionId, CompletionStatus completionStatus) throws RiskServiceException, TokenServiceException {
        String token = this.tokenService.getToken();
        try {
            Event event = new Event();
            event.setCompletionStatus(completionStatus.name());
            RiskEventRequest riskEventRequest = new RiskEventRequest(event);
            this.riskApiClient.putRiskEvent(riskEventRequest, riskEvaluationId, trackingId, transactionId, token);
        }
        catch (ApiResponseException e) {
            this.processApiResponseException(e, RISK_FEEDBACK_ERROR);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_FEEDBACK_ERROR, e);
        }
    }

    @Override
    public Map<String, String> getRiskPolicyNamesById() throws TokenServiceException, RiskServiceException {
        HashMap<String, String> riskPolicySetNames = new HashMap<String, String>();
        String token = this.tokenService.getToken();
        try {
            RiskPolicySetsResponse riskPolicySetsResponse = this.riskApiClient.getRiskPolicySets(token);
            List<RiskPolicySet> riskPolicySets = riskPolicySetsResponse.getEmbedded().getRiskPolicySets();
            if (riskPolicySets != null) {
                riskPolicySets.forEach(riskPolicySet -> riskPolicySetNames.put(riskPolicySet.getId(), riskPolicySet.getName()));
            }
        }
        catch (ApiResponseException e) {
            this.processApiResponseException(e, RISK_POLICY_SETS_ERROR);
        }
        catch (IOException e) {
            throw new RiskServiceException(RISK_POLICY_SETS_ERROR, e);
        }
        return riskPolicySetNames;
    }

    private void processApiResponseException(ApiResponseException e, String errorMessage) throws RiskServiceException {
        StandardApiErrorResponse standardApiErrorResponse = (StandardApiErrorResponse)e.getErrorResponse();
        if (standardApiErrorResponse != null) {
            throw new RiskServiceException.Builder().setMessage(errorMessage).setCause(e).setStatusCode(e.getStatusCode()).setApiErrorId(standardApiErrorResponse.getId()).setApiErrorCode(standardApiErrorResponse.getCode()).setApiErrorMessage(standardApiErrorResponse.getMessage()).build();
        }
        throw new RiskServiceException(errorMessage, e);
    }

    private void logRiskEvaluation(String username, RiskEvaluation riskEvaluation) {
        if (riskEvaluation != null && riskEvaluation.getRiskLevel() != null && StringUtils.isNotBlank(riskEvaluation.getRiskValue())) {
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_EVALUATION_VALUE_INFO, username, riskEvaluation.getRiskLevel(), riskEvaluation.getRiskValue(), riskEvaluation.getId());
            return;
        }
        if (riskEvaluation != null && riskEvaluation.getRiskLevel() != null) {
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_EVALUATION_LEVEL_INFO, username, riskEvaluation.getRiskLevel(), riskEvaluation.getId());
            return;
        }
        if (riskEvaluation != null) {
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.NO_RISK_RESULT, riskEvaluation.getId(), username);
        }
        if (riskEvaluation == null) {
            LOGGER.log((com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent)LogEvent.RISK_EVALUATION_ERROR, LogCleaner.clean(username));
        }
    }
}

