/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.log;

import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogLevel;

public enum LogEvent implements com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent
{
    NO_USERNAME_ERROR(LogLevel.ERROR, "000", "No user id was provided."),
    BEGIN_RISK_EVALUATION(LogLevel.TRACE, "001", "Begin risk evaluation for user \"%s\"."),
    RISK_EVALUATION_ERROR(LogLevel.ERROR, "002", "Risk evaluation \"%s\"."),
    RISK_EVALUATION_TRACE(LogLevel.TRACE, "003", "Exception was thrown during risk evaluation."),
    RISK_EVALUATION_VALUE_INFO(LogLevel.INFO, "004", "Risk evaluation result for user \"%s\" was LEVEL=\"%s\", VALUE=\"%s\", with risk evaluation id \"%s\"."),
    RISK_EVALUATION_LEVEL_INFO(LogLevel.INFO, "005", "Risk level for user \"%s\" was \"%s\" with risk evaluation id \"%s\"."),
    BEGIN_RISK_FEEDBACK(LogLevel.DEBUG, "006", "Begin risk feedback for risk evaluation \"%s\" from \"%s\"."),
    SUCCESSFUL_RISK_FEEDBACK(LogLevel.DEBUG, "007", "Risk feedback successful for risk evaluation \"%s\" with completion status \"%s\"."),
    RISK_FEEDBACK_ERROR(LogLevel.ERROR, "008", "Risk feedback failed for risk evaluation id \"%s\"."),
    RISK_FEEDBACK_TRACE(LogLevel.TRACE, "009", "Exception was thrown during risk feedback."),
    NO_CHAINED_ATTRIBUTES(LogLevel.WARN, "010", "Unable to retrieve attributes; no chained attributes were available."),
    MISSING_OPTIONAL_USER_ATTRIBUTE(LogLevel.WARN, "011", "Unable to retrieve optional user attribute \"%s\"; chained attribute \"%s\" was not available."),
    USING_FALLBACK(LogLevel.INFO, "012", "Failure Mode is 'Continue with fallback policy decision' so using fallback risk level and risk value of \"%s\"."),
    USING_FAILURE(LogLevel.INFO, "013", "Failure Mode is 'Fail' so failing authentication."),
    NO_RISK_RESULT(LogLevel.INFO, "014", "Risk evaluation \"%s\" for user \"%s\" did not include a risk result."),
    GET_RISK_POLICY_SETS_ACTION_FAILURE(LogLevel.DEBUG, "015", "Attempt to get risk policies from PingOne Protect was unsuccessful."),
    TEST_CONNECTION_ACTION_FAILURE(LogLevel.DEBUG, "016", "Connection test to PingOne Protect was unsuccessful."),
    REQUESTING_NEW_TOKEN(LogLevel.DEBUG, "017", "PingOne Protect access token is not cached or has expired. Requesting new token."),
    REUSING_TOKEN(LogLevel.DEBUG, "018", "Reusing PingOne Protect access token."),
    DEVICE_PROFILE_NOT_RETRIEVED(LogLevel.DEBUG, "019", "Device profile not retrieved."),
    DEVICE_PROFILE_ERROR_PREV_ADPT(LogLevel.WARN, "020", "Device profile could not be retrieved from a previous adapter."),
    DEVICE_PROFILE_FROM_PROVIDER(LogLevel.DEBUG, "021", "Device profile retrieved from provider. %s"),
    DEVICE_PROFILE_ERROR_FROM_AUTHN_API(LogLevel.WARN, "022", "Device profile could not be retrieved from the AuthN API request."),
    GET_RISK_POLICY(LogLevel.DEBUG, "023", "Cache for risk policy id is null, fetching risk policy id."),
    GET_RISK_POLICY_ERROR(LogLevel.ERROR, "024", "There was an error retrieving risk policies from PingOne."),
    GET_RISK_PREDICTORS_ACTION_FAILURE(LogLevel.DEBUG, "025", "Attempt to get risk predictors from PingOne Protect was unsuccessful."),
    USE_RISK_POLICY_ID_FROM_CHAINED_ATTRS(LogLevel.DEBUG, "026", "Using Risk Policy ID passed in from chained attributes: %s"),
    INTERNAL_FAILURE(LogLevel.DEBUG, "027", "Internal failure."),
    CONFIGURATION_LOG(LogLevel.DEBUG, "028", "Configuration: %s"),
    INVALID_AUTHN_RESPONSE(LogLevel.DEBUG, "029", "API response not of expected type.");

    private static final String PRODUCT_CODE = "RISK";
    private final LogLevel level;
    private final String code;
    private final String message;

    private LogEvent(LogLevel level, String code, String message) {
        this.level = level;
        this.code = code;
        this.message = message;
    }

    @Override
    public LogLevel getLevel() {
        return this.level;
    }

    @Override
    public String getCode() {
        return "RISK-" + this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }
}

