/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger;

import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogEvent;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.LogLevel;
import com.pingidentity.adapters.pingone.protect.shade.com.pingidentity.integrations.logger.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationsLogger
implements Logger {
    private static final String TRUNCATED_RESOURCE_ID = "%.3s***";
    private static final String PLAINTEXT_RESOURCE_ID = "%s";
    private final transient org.slf4j.Logger logger;

    public IntegrationsLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    @Override
    public void log(LogEvent logEvent) {
        this.log(null, logEvent, null);
    }

    @Override
    public void log(LogEvent logEvent, Throwable t) {
        this.log(null, logEvent, t);
    }

    @Override
    public void log(String resourceId, LogEvent logEvent) {
        this.log(resourceId, logEvent, null);
    }

    @Override
    public void log(String resourceId, LogEvent logEvent, Throwable t) {
        String resourceIdDisplay = TRUNCATED_RESOURCE_ID;
        LogLevel logLevel = logEvent.getLevel();
        if (logLevel != null && (logLevel == LogLevel.DEBUG || logLevel == LogLevel.TRACE)) {
            resourceIdDisplay = PLAINTEXT_RESOURCE_ID;
        }
        String msg = resourceId != null && !resourceId.isEmpty() ? String.format("[%s] [Resource: " + resourceIdDisplay + "] %s", logEvent.getCode(), resourceId, logEvent.getMessage()) : this.logFormat(logEvent.getCode(), logEvent.getMessage());
        this.log(logEvent.getLevel(), msg, t);
    }

    @Override
    public void logMethodEntry() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String msg = String.format("Entering : %s.%s()", stackTrace[2].getClassName(), stackTrace[2].getMethodName());
        this.log(LogLevel.DEBUG, msg, null);
    }

    @Override
    public void logMethodExit() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String msg = String.format("Exiting : %s.%s()", stackTrace[2].getClassName(), stackTrace[2].getMethodName());
        this.log(LogLevel.DEBUG, msg, null);
    }

    @Override
    public void log(LogEvent logEvent, Object ... args) {
        this.log(logEvent, null, args);
    }

    @Override
    public void log(LogEvent logEvent, Throwable t, Object ... args) {
        String logMessage = String.format(logEvent.getMessage(), args);
        logMessage = this.logFormat(logEvent.getCode(), logMessage);
        this.log(logEvent.getLevel(), logMessage, t);
    }

    private void log(LogLevel l, String msg, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(msg, t);
            return;
        }
        switch (l) {
            case ERROR: {
                this.logger.error(msg);
                break;
            }
            case WARN: {
                this.logger.warn(msg);
                break;
            }
            case INFO: {
                this.logger.info(msg);
                break;
            }
            case DEBUG: {
                this.logger.debug(msg, t);
                break;
            }
            default: {
                this.logger.trace(msg, t);
            }
        }
    }

    private String logFormat(String logCode, String logMessage) {
        return String.format("[%s] %s", logCode, logMessage);
    }
}

