/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent;

import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.auth.AuthCache;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.auth.AuthScope;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.auth.Credentials;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.auth.CredentialsStore;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.auth.NTCredentials;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.cookie.CookieStore;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.Request;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.fluent.Response;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.auth.BasicScheme;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpHost;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.util.TimeValue;
import java.io.IOException;
import java.net.URISyntaxException;

public class Executor {
    static final CloseableHttpClient CLIENT = HttpClientBuilder.create().setConnectionManager(PoolingHttpClientConnectionManagerBuilder.create().useSystemProperties().setMaxConnPerRoute(100).setMaxConnTotal(200).setValidateAfterInactivity(TimeValue.ofSeconds(10L)).build()).useSystemProperties().evictExpiredConnections().evictIdleConnections(TimeValue.ofMinutes(1L)).build();
    private final CloseableHttpClient httpclient;
    private final AuthCache authCache;
    private volatile CredentialsStore credentialsStore;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(CloseableHttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsStore credentialsStore) {
        this.credentialsStore = credentialsStore;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials credentials) {
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot == null) {
            this.credentialsStore = credentialsStoreSnapshot = new BasicCredentialsProvider();
        }
        credentialsStoreSnapshot.setCredentials(authScope, credentials);
        return this;
    }

    public Executor auth(HttpHost host, Credentials credentials) {
        return this.auth(new AuthScope(host), credentials);
    }

    public Executor auth(String host, Credentials credentials) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create(host);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        return this.auth(httpHost, credentials);
    }

    public Executor authPreemptive(HttpHost host) {
        Credentials credentials;
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null && (credentials = credentialsStoreSnapshot.getCredentials(new AuthScope(host), null)) != null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(host, basicScheme);
        }
        return this;
    }

    public Executor authPreemptive(String host) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create(host);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + host);
        }
        return this.authPreemptive(httpHost);
    }

    public Executor authPreemptiveProxy(HttpHost proxy) {
        Credentials credentials;
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null && (credentials = credentialsStoreSnapshot.getCredentials(new AuthScope(proxy), null)) != null) {
            BasicScheme basicScheme = new BasicScheme();
            basicScheme.initPreemptive(credentials);
            this.authCache.put(proxy, basicScheme);
        }
        return this;
    }

    public Executor authPreemptiveProxy(String proxy) {
        HttpHost httpHost;
        try {
            httpHost = HttpHost.create(proxy);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException("Invalid host: " + proxy);
        }
        return this.authPreemptiveProxy(httpHost);
    }

    public Executor auth(HttpHost host, String username, char[] password) {
        return this.auth(host, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host, String username, char[] password, String workstation, String domain) {
        return this.auth(host, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null) {
            credentialsStoreSnapshot.clear();
        }
        return this;
    }

    public Executor use(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
        return this;
    }

    public Executor clearCookies() {
        CookieStore cookieStoreSnapshot = this.cookieStore;
        if (cookieStoreSnapshot != null) {
            cookieStoreSnapshot.clear();
        }
        return this;
    }

    public Response execute(Request request) throws IOException {
        CookieStore cookieStoreSnapshot;
        HttpClientContext localContext = HttpClientContext.create();
        CredentialsStore credentialsStoreSnapshot = this.credentialsStore;
        if (credentialsStoreSnapshot != null) {
            localContext.setAttribute("http.auth.credentials-provider", credentialsStoreSnapshot);
        }
        if (this.authCache != null) {
            localContext.setAttribute("http.auth.auth-cache", this.authCache);
        }
        if ((cookieStoreSnapshot = this.cookieStore) != null) {
            localContext.setAttribute("http.cookie-store", cookieStoreSnapshot);
        }
        return new Response(request.internalExecute(this.httpclient, localContext));
    }
}

