/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.impl.async;

import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.HttpRequestRetryStrategy;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.HttpRoute;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.async.AsyncExecCallback;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.async.AsyncExecChain;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.async.AsyncExecChainHandler;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.client5.http.protocol.HttpClientContext;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.annotation.Contract;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.annotation.Internal;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.EntityDetails;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpException;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpRequest;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.HttpResponse;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.nio.AsyncDataConsumer;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.nio.AsyncEntityProducer;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.nio.entity.NoopEntityConsumer;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.http.support.BasicRequestBuilder;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.util.Args;
import com.pingidentity.adapters.pingone.protect.shade.org.apache.hc.core5.util.TimeValue;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
@Internal
public final class AsyncHttpRequestRetryExec
implements AsyncExecChainHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncHttpRequestRetryExec.class);
    private final HttpRequestRetryStrategy retryStrategy;

    public AsyncHttpRequestRetryExec(HttpRequestRetryStrategy retryStrategy) {
        Args.notNull(retryStrategy, "retryStrategy");
        this.retryStrategy = retryStrategy;
    }

    private void internalExecute(final State state, final HttpRequest request, final AsyncEntityProducer entityProducer, final AsyncExecChain.Scope scope, AsyncExecChain chain, final AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        final String exchangeId = scope.exchangeId;
        chain.proceed(BasicRequestBuilder.copy(request).build(), entityProducer, scope, new AsyncExecCallback(){

            @Override
            public AsyncDataConsumer handleResponse(HttpResponse response, EntityDetails entityDetails) throws HttpException, IOException {
                HttpClientContext clientContext = scope.clientContext;
                if (entityProducer != null && !entityProducer.isRepeatable()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                    }
                    return asyncExecCallback.handleResponse(response, entityDetails);
                }
                state.retrying = AsyncHttpRequestRetryExec.this.retryStrategy.retryRequest(response, scope.execCount.get(), clientContext);
                if (state.retrying) {
                    state.delay = AsyncHttpRequestRetryExec.this.retryStrategy.getRetryInterval(response, scope.execCount.get(), clientContext);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{} retrying request in {}", (Object)exchangeId, (Object)state.delay);
                    }
                    return new NoopEntityConsumer();
                }
                return asyncExecCallback.handleResponse(response, entityDetails);
            }

            @Override
            public void handleInformationResponse(HttpResponse response) throws HttpException, IOException {
                asyncExecCallback.handleInformationResponse(response);
            }

            @Override
            public void completed() {
                if (state.retrying) {
                    scope.execCount.incrementAndGet();
                    if (entityProducer != null) {
                        entityProducer.releaseResources();
                    }
                    scope.scheduler.scheduleExecution(request, entityProducer, scope, asyncExecCallback, state.delay);
                } else {
                    asyncExecCallback.completed();
                }
            }

            @Override
            public void failed(Exception cause) {
                if (cause instanceof IOException) {
                    HttpRoute route = scope.route;
                    HttpClientContext clientContext = scope.clientContext;
                    if (entityProducer != null && !entityProducer.isRepeatable()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} cannot retry non-repeatable request", (Object)exchangeId);
                        }
                    } else if (AsyncHttpRequestRetryExec.this.retryStrategy.retryRequest(request, (IOException)cause, scope.execCount.get(), clientContext)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} {}", new Object[]{exchangeId, cause.getMessage(), cause});
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Recoverable I/O exception ({}) caught when processing request to {}", (Object)cause.getClass().getName(), (Object)route);
                        }
                        scope.execRuntime.discardEndpoint();
                        if (entityProducer != null) {
                            entityProducer.releaseResources();
                        }
                        state.retrying = true;
                        scope.execCount.incrementAndGet();
                        scope.scheduler.scheduleExecution(request, entityProducer, scope, asyncExecCallback, state.delay);
                        return;
                    }
                }
                asyncExecCallback.failed(cause);
            }
        });
    }

    @Override
    public void execute(HttpRequest request, AsyncEntityProducer entityProducer, AsyncExecChain.Scope scope, AsyncExecChain chain, AsyncExecCallback asyncExecCallback) throws HttpException, IOException {
        State state = new State();
        state.retrying = false;
        this.internalExecute(state, request, entityProducer, scope, chain, asyncExecCallback);
    }

    private static class State {
        volatile boolean retrying;
        volatile TimeValue delay;

        private State() {
        }
    }
}

