/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.shade.org.jose4j.jwe;

import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.jwe.CipherStrengthSupport;
import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.jwe.ContentEncryptionAlgorithm;
import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.jwe.WrappingKeyManagementAlgorithm;
import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.jwx.KeyValidationSupport;
import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.keys.KeyPersuasion;
import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.lang.ExceptionHelp;
import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.lang.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class AesKeyWrapManagementAlgorithm
extends WrappingKeyManagementAlgorithm {
    int keyByteLength;

    public AesKeyWrapManagementAlgorithm(String alg, int keyByteLength) {
        super("AESWrap", alg);
        this.setKeyType("oct");
        this.setKeyPersuasion(KeyPersuasion.SYMMETRIC);
        this.keyByteLength = keyByteLength;
    }

    int getKeyByteLength() {
        return this.keyByteLength;
    }

    @Override
    public void validateEncryptionKey(Key managementKey, ContentEncryptionAlgorithm contentEncryptionAlg) throws InvalidKeyException {
        this.validateKey(managementKey);
    }

    @Override
    public void validateDecryptionKey(Key managementKey, ContentEncryptionAlgorithm contentEncryptionAlg) throws InvalidKeyException {
        this.validateKey(managementKey);
    }

    void validateKey(Key managementKey) throws InvalidKeyException {
        KeyValidationSupport.validateAesWrappingKey(managementKey, this.getAlgorithmIdentifier(), this.getKeyByteLength());
    }

    @Override
    public boolean isAvailable() {
        int aesByteKeyLength = this.getKeyByteLength();
        String alg = this.getJavaAlgorithm();
        try {
            Cipher.getInstance(alg);
            return CipherStrengthSupport.isAvailable(alg, aesByteKeyLength);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            this.log.debug("{} for {} is not available ({}).", new Object[]{alg, this.getAlgorithmIdentifier(), ExceptionHelp.toStringWithCauses(e)});
            return false;
        }
    }

    AesKeyWrapManagementAlgorithm setUseGeneralProviderContext() {
        this.useSuppliedKeyProviderContext = false;
        return this;
    }

    public static class Aes256
    extends AesKeyWrapManagementAlgorithm {
        public Aes256() {
            super("A256KW", 32);
        }
    }

    public static class Aes192
    extends AesKeyWrapManagementAlgorithm {
        public Aes192() {
            super("A192KW", 24);
        }
    }

    public static class Aes128
    extends AesKeyWrapManagementAlgorithm {
        public Aes128() {
            super("A128KW", 16);
        }
    }
}

