/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.shade.org.jose4j.jwe;

import com.pingidentity.adapters.pingone.protect.shade.org.jose4j.lang.ByteUtil;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherStrengthSupport {
    private static final Logger log = LoggerFactory.getLogger(CipherStrengthSupport.class);

    public static boolean isAvailable(String algorithm, int keyByteLength) {
        boolean isAvailable;
        int bitKeyLength = ByteUtil.bitLength(keyByteLength);
        try {
            int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(algorithm);
            boolean bl = isAvailable = bitKeyLength <= maxAllowedKeyLength;
            if (!isAvailable) {
                log.debug("max allowed key length for {} is {}", (Object)algorithm, (Object)maxAllowedKeyLength);
            }
        }
        catch (NoSuchAlgorithmException e) {
            log.debug("Unknown/unsupported algorithm, {} {}", (Object)algorithm, (Object)e);
            isAvailable = false;
        }
        return isAvailable;
    }
}

