/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapters.pingone.protect.validator;

import com.pingidentity.adapters.pingone.protect.util.PredictorAttributeMappingUtil;
import java.util.function.Predicate;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.adapter.gui.validation.EnhancedRowValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class PredictorAttributeMappingValidator
implements EnhancedRowValidator {
    private String tableName;
    private String keyName;

    public PredictorAttributeMappingValidator(String tableName, String keyName) {
        this.tableName = tableName;
        this.keyName = keyName;
    }

    static boolean duplicates(Table table, Predicate<Row> isDuplicate) {
        return table.getRows().stream().filter(isDuplicate).count() > 1L;
    }

    public void validate(FieldList fieldsInRow, Configuration configuration) throws ValidationException {
        Table table = configuration.getTable(this.tableName);
        String key = fieldsInRow.getFieldValue(this.keyName);
        String currentValueAfterEvent = PredictorAttributeMappingUtil.getValueAfterEvent(key);
        if (null == currentValueAfterEvent) {
            throw new ValidationException(this.keyName + " in " + this.tableName + " must be start with '${event.'.");
        }
        Predicate<Row> isDuplicate = row -> PredictorAttributeMappingUtil.getValueAfterEvent(row.getFieldValue(this.keyName)).equals(currentValueAfterEvent);
        if (PredictorAttributeMappingValidator.duplicates(table, isDuplicate)) {
            throw new ValidationException(this.keyName + " in " + this.tableName + " must be unique. The mapping beginning with '${event." + currentValueAfterEvent + "' already exists.");
        }
    }

    public void validate(FieldList fieldsInRow) throws ValidationException {
    }
}

