/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.io.cpl.pingone.exception;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;

class ProvisionerException
extends Exception {
    private static final long serialVersionUID = 5055457399126195993L;
    protected static final String SEPARATOR = "[prov_exception_msg]";
    private final String message;
    private final String[] args;
    private int remainingAttempts;
    private long suggestedMillisBeforeRetry;

    @JsonCreator
    protected ProvisionerException(@JsonProperty(value="message") String message, String ... args) {
        this.message = message;
        this.args = args;
    }

    protected static String buildErrorMsg(String exceptionMsg, String provisionerMsg) {
        StringBuilder builder = new StringBuilder();
        builder.append(exceptionMsg);
        if (provisionerMsg == null || provisionerMsg.isEmpty()) {
            return builder.toString();
        }
        builder.append(" ");
        builder.append(SEPARATOR);
        builder.append(" ");
        builder.append(provisionerMsg);
        return builder.toString();
    }

    @Override
    public String getMessage() {
        return this.getFormattedMessage();
    }

    @JsonIgnore
    public String getFormattedMessage() {
        if (this.message == null) {
            return "The exception contains no message but the arguments were " + Arrays.toString(this.args);
        }
        return String.format(this.message, this.args);
    }

    @JsonIgnore
    public boolean isRetryable() {
        return this.remainingAttempts > 0;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public int getRemainingAttempts() {
        return this.remainingAttempts;
    }

    public void setRemainingAttempts(int remainingAttempts) {
        this.remainingAttempts = remainingAttempts;
    }

    public long getSuggestedMillisBeforeRetry() {
        return this.suggestedMillisBeforeRetry;
    }

    public void setSuggestedMillisBeforeRetry(long suggestedMillisBeforeRetry) {
        this.suggestedMillisBeforeRetry = suggestedMillisBeforeRetry;
    }
}

