/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone.cplv3Mock;

import com.pingidentity.io.cpl.pingone.metadata.AttributeMetadata;
import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BooleanAttribute;
import com.pingidentity.io.cpl.pingone.metadata.Capabilities;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttribute;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttributes;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionProfile;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionProfiles;
import com.pingidentity.io.cpl.pingone.metadata.Enhancements;
import com.pingidentity.io.cpl.pingone.metadata.ProvisionerInformation;
import com.pingidentity.io.cpl.pingone.metadata.ReferenceAttribute;
import com.pingidentity.io.cpl.pingone.metadata.StringAttribute;

public class MockMetadataBuilder {
    private ProvisionerInformation info;
    private Attributes userAttributes;
    private Attributes groupAttributes;
    private ConnectionProfiles connectionProfiles;
    private AttributeMetadata attributeMetadata;

    public MockMetadataBuilder() {
        this.build();
    }

    private void build() {
        Capabilities capabilities = null;
        Enhancements enhancements = null;
        this.connectionProfiles = this.buildConnectionProfiles();
        this.userAttributes = this.buildUserAttributes();
        this.groupAttributes = this.buildGroupAttributes();
        Attributes membershipAttributes = null;
        this.attributeMetadata = new AttributeMetadata();
        this.attributeMetadata.setCapabilities(capabilities);
        this.attributeMetadata.setEnhancements(enhancements);
        this.attributeMetadata.setGroupAttributes(this.groupAttributes);
        this.attributeMetadata.setUserAttributes(this.userAttributes);
        this.attributeMetadata.setMembershipAttributes(membershipAttributes);
        this.info = new ProvisionerInformation();
        String imageUrl = "";
        String description = "Mock Provisioner for Testing Purposes";
        String name = "Mock Provisioner";
        boolean requiresConnectionInformation = false;
        boolean requiresURL = false;
        this.info.setImageUrl(imageUrl);
        this.info.setDisplayName(description);
        this.info.setConnectionInformationRequired(requiresConnectionInformation);
        this.info.setBaseURLRequired(requiresURL);
        this.info.setKey(name);
    }

    private Attributes buildGroupAttributes() {
        Attributes attributes = new Attributes();
        StringAttribute name = new StringAttribute("name");
        name.setCreatable(true);
        name.setDisplayName("Name");
        name.setDistinguishingAttribute(false);
        name.setReferenceAttribute(ReferenceAttribute.DISPLAY_NAME.getKey());
        name.setRequiredOnCreate(false);
        name.setRequiredOnUpdate(false);
        name.setUnique(false);
        name.setUpdateable(true);
        name.setCaseSensitive(false);
        attributes.add(name);
        return attributes;
    }

    private ConnectionProfiles buildConnectionProfiles() {
        ConnectionProfiles profiles = new ConnectionProfiles();
        ConnectionProfile cp1 = new ConnectionProfile();
        cp1.setName("Default Connection Profile");
        ConnectionAttributes attributes = new ConnectionAttributes();
        ConnectionAttribute ca1 = new ConnectionAttribute();
        ca1.setKey("OAUTH_TOKEN");
        ca1.setDescription("Put OAuth Token Here");
        ca1.setDisplayLabel("OAuth Token");
        ca1.setRequired(true);
        ca1.setSensitive(true);
        attributes.add(ca1);
        cp1.setConnectionAttributes(attributes);
        profiles.add(cp1);
        return profiles;
    }

    private Attributes buildUserAttributes() {
        Attributes attributes = new Attributes();
        StringAttribute email = new StringAttribute("EMAIL");
        email.setCreatable(true);
        email.setDisplayName("Email");
        email.setDistinguishingAttribute(true);
        email.setReferenceAttribute(ReferenceAttribute.WORK_EMAIL.getKey());
        email.setRequiredOnCreate(true);
        email.setRequiredOnUpdate(false);
        email.setUnique(true);
        email.setUpdateable(false);
        email.setCaseSensitive(false);
        StringAttribute firstName = new StringAttribute("FIRST_NAME");
        firstName.setCreatable(false);
        firstName.setDisplayName("First Name");
        firstName.setDistinguishingAttribute(false);
        firstName.setReferenceAttribute(ReferenceAttribute.GIVEN_NAME.getKey());
        firstName.setRequiredOnCreate(false);
        firstName.setRequiredOnUpdate(false);
        firstName.setUnique(false);
        firstName.setUpdateable(true);
        firstName.setCaseSensitive(false);
        BooleanAttribute active = new BooleanAttribute("ACTIVE");
        active.setCreatable(true);
        active.setDisplayName("Active");
        active.setDefaultedOnCreate(true);
        active.setDefaultValue(true);
        active.setReferenceAttribute(ReferenceAttribute.ACTIVE.getKey());
        active.setRequiredOnCreate(false);
        active.setRequiredOnUpdate(false);
        active.setUpdateable(true);
        attributes.add(email);
        attributes.add(firstName);
        attributes.add(active);
        return attributes;
    }

    public ProvisionerInformation getInfo() {
        return this.info;
    }

    public ConnectionProfiles getConnectionProfiles() {
        return this.connectionProfiles;
    }

    public AttributeMetadata getAttributeMetadata() {
        return this.attributeMetadata;
    }
}

