/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.prov.saas.pingone.request.groups;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.CreateGroupsRequest;
import com.pingidentity.io.cpl.pingone.request.Request;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.prov.saas.pingone.request.RequestBuilder;
import com.pingidentity.prov.saas.pingone.request.RequestParameters;
import com.pingidentity.prov.saas.pingone.request.groups.GroupRequestBuilder;
import com.pingidentity.prov.saas.pingone.request.groups.GroupRequestParameters;
import com.pingidentity.provisioner.sdk.SaasGroupData;

public class CreateGroupRequestBuilder
extends GroupRequestBuilder
implements RequestBuilder {
    private Attributes attributes;

    public CreateGroupRequestBuilder(Attributes attributes, String groupNameAttributeName) {
        super(groupNameAttributeName);
        this.attributes = attributes;
    }

    @Override
    public Request build(RequestParameters requestParameters) {
        Attributes createableAttributes = new Attributes();
        for (String groupAttributeKey : this.attributes.keySet()) {
            BaseAttribute attribute = (BaseAttribute)this.attributes.get(groupAttributeKey);
            boolean createable = attribute.isCreatable();
            boolean required = attribute.isRequiredOnCreate();
            if (!required && !createable) continue;
            createableAttributes.add(attribute);
        }
        GroupRequestParameters parameters = (GroupRequestParameters)requestParameters;
        SaasGroupData data = parameters.getSaasGroupData();
        ConnectionFields connectionFields = parameters.getConnectionFields();
        ResourceAttributes attributes = this.buildAttributes(data, createableAttributes);
        Group group = new Group(attributes, new ResourceUniqueId(data.getGuid()));
        return new CreateGroupsRequest(connectionFields, group);
    }
}

