/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone;

import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public enum ComplexUserAttribute {
    ADDRESS("address", new HashSet<String>(Arrays.asList(ResourceFieldKey.STREET_ADDRESS.getLabel(), ResourceFieldKey.CITY.getLabel(), ResourceFieldKey.STATE_REGION.getLabel(), ResourceFieldKey.ZIP_CODE.getLabel(), ResourceFieldKey.COUNTRY.getLabel()))),
    NAME("name", new HashSet<String>(Arrays.asList(ResourceFieldKey.FULL_NAME.getLabel(), ResourceFieldKey.FIRST_NAME.getLabel(), ResourceFieldKey.MIDDLE_NAME.getLabel(), ResourceFieldKey.LAST_NAME.getLabel(), ResourceFieldKey.HONORIFIC_PREFIX.getLabel(), ResourceFieldKey.HONORIFIC_SUFFIX.getLabel()))),
    PHOTO("photo", Collections.singleton(ResourceFieldKey.PROFILE_IMAGE.getLabel()));

    private final String key;
    private final Set<String> subAttributes;

    private ComplexUserAttribute(String key, Set<String> subAttributes) {
        this.key = key;
        this.subAttributes = subAttributes == null ? new HashSet() : subAttributes;
    }

    public String getKey() {
        return this.key;
    }

    public Set<String> getSubAttributes() {
        return new HashSet<String>(this.subAttributes);
    }

    public static Optional<ComplexUserAttribute> of(String key) {
        if (key == null || key.isEmpty()) {
            return Optional.empty();
        }
        for (ComplexUserAttribute map : ComplexUserAttribute.values()) {
            if (!map.getKey().equalsIgnoreCase(key)) continue;
            return Optional.of(map);
        }
        return Optional.empty();
    }
}

