/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone;

import java.util.HashMap;
import java.util.Map;

public enum Region {
    NA("North America (US)", "https://api.pingone.com/v1", "https://auth.pingone.com"),
    CA("North America (Canada)", "https://api.pingone.ca/v1", "https://auth.pingone.ca"),
    EU("European Union", "https://api.pingone.eu/v1", "https://auth.pingone.eu"),
    ASIA("Asia-Pacific", "https://api.pingone.asia/v1", "https://auth.pingone.asia"),
    AU("Australia", "https://api.pingone.com.au/v1", "https://auth.pingone.com.au");

    private final String name;
    private final String apiUrl;
    private final String authUrl;
    private static final Map<String, Region> NAME_INDEX;

    private Region(String name, String apiUrl, String authUrl) {
        this.name = name;
        this.apiUrl = apiUrl;
        this.authUrl = authUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public static Region valueOfName(String name) {
        return NAME_INDEX.get(name);
    }

    public static boolean isValidName(String name) {
        return NAME_INDEX.containsKey(name);
    }

    static {
        NAME_INDEX = new HashMap<String, Region>();
        for (Region region : Region.values()) {
            NAME_INDEX.put(region.name, region);
        }
    }
}

