/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.metadata.attribute;

import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.metadata.BaseAttribute;
import com.pingidentity.io.cpl.pingone.metadata.BooleanAttribute;
import com.pingidentity.io.cpl.pingone.metadata.CustomAttribute;
import com.pingidentity.io.cpl.pingone.metadata.DecimalAttribute;
import com.pingidentity.io.cpl.pingone.metadata.IntegerAttribute;
import com.pingidentity.io.cpl.pingone.metadata.StringAttribute;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneAttribute;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.PingOneAttributes;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.IntegrationsLogger;
import java.io.IOException;
import java.util.Map;

public abstract class AbstractAttributeBuilder {
    private static final IntegrationsLogger logger = new IntegrationsLogger(AbstractAttributeBuilder.class);
    protected static PingOneAttributes allAttributes;

    protected static Attributes convert(Map<String, PingOneAttribute> attributeMap) {
        Attributes attributes = new Attributes();
        for (PingOneAttribute a : attributeMap.values()) {
            BaseAttribute b;
            switch (a.getType()) {
                case STRING: {
                    StringAttribute sAttr = new StringAttribute(a.getKey());
                    sAttr.setCaseSensitive(a.isCaseSensitive());
                    sAttr.setMaxLength(a.getMaxLength());
                    sAttr.setMinLength(a.getMinLength());
                    sAttr.setDefaultValue(a.getDefaultValue());
                    b = sAttr;
                    break;
                }
                case BOOLEAN: {
                    BooleanAttribute bAttr = new BooleanAttribute(a.getKey());
                    bAttr.setDefaultValue(new Boolean(a.getDefaultValue()));
                    b = bAttr;
                    break;
                }
                case DECIMAL: {
                    DecimalAttribute dAttr = new DecimalAttribute(a.getKey());
                    dAttr.setDefaultValue(new Double(a.getDefaultValue()));
                    dAttr.setScale(a.getScale());
                    dAttr.setPrecision(a.getPrecision());
                    b = dAttr;
                    break;
                }
                case INTEGER: {
                    IntegerAttribute iAttr = new IntegerAttribute(a.getKey());
                    iAttr.setDefaultValue(new Integer(a.getDefaultValue()));
                    iAttr.setByteLength(a.getByteLength());
                    iAttr.setDigits(a.getDigits());
                    b = iAttr;
                    break;
                }
                default: {
                    b = new CustomAttribute(a.getKey(), a.getType());
                }
            }
            b.setReferenceAttribute(a.getReferenceAttributes());
            b.setDistinguishingAttribute(a.isDistinguishingAttribute());
            b.setCreatable(a.isCreatable());
            b.setUpdateable(a.isUpdateable());
            b.setDefaultedOnCreate(a.isDefaultedOnCreate());
            b.setNillable(a.isNillable());
            b.setUnique(a.isUnique());
            b.setPicklistValues(a.getPicklistValues());
            b.setSensitive(a.isSensitive());
            b.setDisplayName(a.getDisplayName());
            b.setRequiredOnUpdate(a.isRequiredOnUpdate());
            b.setRequiredOnCreate(a.isRequiredOnCreate());
            b.setStandard(a.getStandard());
            b.setPattern(a.getPattern());
            b.setDerived(a.isDerived());
            b.setMaxNumberOfValues(a.getMaxNumberOfValues());
            b.setMinNumberOfValues(a.getMinNumberOfValues());
            b.setOrdered(a.isOrdered());
            attributes.add(b);
        }
        return attributes;
    }

    static {
        ObjectMapper mapper = new ObjectMapper();
        try {
            allAttributes = mapper.readValue(AbstractAttributeBuilder.class.getClassLoader().getResourceAsStream("pingone-attributes.json"), PingOneAttributes.class);
        }
        catch (IOException e) {
            logger.log(PingOneLogEvents.UNABLE_TO_READ_ATTRS);
        }
    }
}

