/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.metadata.attribute;

import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttribute;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionAttributes;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionProfile;
import com.pingidentity.io.cpl.pingone.metadata.ConnectionProfiles;
import com.pingidentity.provisioner.integrations.pingone.ConnectionFieldKey;
import com.pingidentity.provisioner.integrations.pingone.DeviceMgmtOption;
import com.pingidentity.provisioner.integrations.pingone.Region;
import com.pingidentity.provisioner.integrations.pingone.metadata.PingOneConnectionProfile;
import com.pingidentity.provisioner.integrations.pingone.metadata.attribute.ConnectionProfilesBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.MfaMethod;

public class PingOneConnectionProfileBuilder
implements ConnectionProfilesBuilder {
    @Override
    public ConnectionProfiles build() {
        ConnectionProfiles profiles = new ConnectionProfiles();
        profiles.add(this.buildClientCredsProfile());
        profiles.add(this.buildInternalUseProfile());
        return profiles;
    }

    private ConnectionProfile buildClientCredsProfile() {
        ConnectionProfile clientCredsProfile = this.buildBasicProfile();
        clientCredsProfile.setName(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS.getName());
        clientCredsProfile.setDescription(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS.getDesc());
        clientCredsProfile.setDocumentationUrl(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS.getDocUrl());
        clientCredsProfile.setSpecUrl(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS.getSpecUrl());
        ConnectionAttributes connectionAttributes = clientCredsProfile.getConnectionAttributes();
        connectionAttributes.add(this.toConnectionAttribute(ConnectionFieldKey.CLIENT_ID));
        connectionAttributes.add(this.toConnectionAttribute(ConnectionFieldKey.CLIENT_SECRET));
        return clientCredsProfile;
    }

    private ConnectionProfile buildInternalUseProfile() {
        ConnectionProfile profile = this.buildClientCredsProfile();
        profile.setName(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS_INTERNAL_USE.getName());
        profile.setDescription(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS_INTERNAL_USE.getDesc());
        profile.setDocumentationUrl(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS_INTERNAL_USE.getDocUrl());
        profile.setSpecUrl(PingOneConnectionProfile.OAUTH_CLIENT_CREDENTIALS_INTERNAL_USE.getSpecUrl());
        profile.getConnectionAttributes().addAll(this.buildInternalAttributes());
        return profile;
    }

    private ConnectionProfile buildBasicProfile() {
        ConnectionProfile basicProfile = new ConnectionProfile();
        ConnectionAttributes connectionAttributes = new ConnectionAttributes();
        ConnectionAttribute environmentId = new ConnectionAttribute();
        environmentId.setKey(ConnectionFieldKey.ENVIRONMENT_ID.getKey());
        environmentId.setDescription(ConnectionFieldKey.ENVIRONMENT_ID.getDesc());
        environmentId.setDisplayLabel(ConnectionFieldKey.ENVIRONMENT_ID.getDisplay());
        environmentId.setRequired(ConnectionFieldKey.ENVIRONMENT_ID.isRequired());
        environmentId.setSensitive(ConnectionFieldKey.ENVIRONMENT_ID.isSensitive());
        connectionAttributes.add(environmentId);
        ConnectionAttribute createNewUsers = new ConnectionAttribute();
        createNewUsers.setKey(ConnectionFieldKey.CREATE_USERS_PROV_OPT.getKey());
        createNewUsers.setDescription(ConnectionFieldKey.CREATE_USERS_PROV_OPT.getDesc());
        createNewUsers.setDisplayLabel(ConnectionFieldKey.CREATE_USERS_PROV_OPT.getDisplay());
        createNewUsers.setRequired(ConnectionFieldKey.CREATE_USERS_PROV_OPT.isRequired());
        createNewUsers.setSensitive(ConnectionFieldKey.CREATE_USERS_PROV_OPT.isSensitive());
        createNewUsers.setTypeBoolean(true);
        connectionAttributes.add(createNewUsers);
        ConnectionAttribute updateNewUsers = new ConnectionAttribute();
        updateNewUsers.setKey(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getKey());
        updateNewUsers.setDescription(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getDesc());
        updateNewUsers.setDisplayLabel(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.getDisplay());
        updateNewUsers.setRequired(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.isRequired());
        updateNewUsers.setSensitive(ConnectionFieldKey.UPDATE_USERS_PROV_OPT.isSensitive());
        updateNewUsers.setTypeBoolean(true);
        connectionAttributes.add(updateNewUsers);
        ConnectionAttribute disableNewUsers = new ConnectionAttribute();
        disableNewUsers.setKey(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getKey());
        disableNewUsers.setDescription(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getDesc());
        disableNewUsers.setDisplayLabel(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.getDisplay());
        disableNewUsers.setRequired(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.isRequired());
        disableNewUsers.setSensitive(ConnectionFieldKey.REMOVE_USERS_PROV_OPT.isSensitive());
        disableNewUsers.setTypeBoolean(true);
        connectionAttributes.add(disableNewUsers);
        ConnectionAttribute provisionDisabledUsers = new ConnectionAttribute();
        provisionDisabledUsers.setKey(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getKey());
        provisionDisabledUsers.setDescription(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getDesc());
        provisionDisabledUsers.setDisplayLabel(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.getDisplay());
        provisionDisabledUsers.setRequired(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.isRequired());
        provisionDisabledUsers.setSensitive(ConnectionFieldKey.PROVISION_DISABLED_USERS_PROV_OPT.isSensitive());
        provisionDisabledUsers.setTypeBoolean(true);
        connectionAttributes.add(provisionDisabledUsers);
        ConnectionAttribute removeUserAction = new ConnectionAttribute();
        removeUserAction.setKey(ConnectionFieldKey.REMOVE_ACTION.getKey());
        removeUserAction.setDescription(ConnectionFieldKey.REMOVE_ACTION.getDesc());
        removeUserAction.setDisplayLabel(ConnectionFieldKey.REMOVE_ACTION.getDisplay());
        removeUserAction.setRequired(ConnectionFieldKey.REMOVE_ACTION.isRequired());
        removeUserAction.setSensitive(ConnectionFieldKey.REMOVE_ACTION.isSensitive());
        removeUserAction.setPossibleValues(new String[]{"Disable", "Delete"});
        connectionAttributes.add(removeUserAction);
        ConnectionAttribute mfaDeviceManagement = new ConnectionAttribute();
        mfaDeviceManagement.setKey(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getKey());
        mfaDeviceManagement.setDescription(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getDesc());
        mfaDeviceManagement.setDisplayLabel(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.getDisplay());
        mfaDeviceManagement.setRequired(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.isRequired());
        mfaDeviceManagement.setSensitive(ConnectionFieldKey.MFA_USER_DEVICE_MANAGEMENT.isSensitive());
        mfaDeviceManagement.setPossibleValues(new String[]{DeviceMgmtOption.MERGE.getName(), DeviceMgmtOption.OVERWRITE.getName(), DeviceMgmtOption.UNMANAGED.getName()});
        connectionAttributes.add(mfaDeviceManagement);
        ConnectionAttribute region = new ConnectionAttribute();
        region.setKey(ConnectionFieldKey.REGION.getKey());
        region.setDescription(ConnectionFieldKey.REGION.getDesc());
        region.setDisplayLabel(ConnectionFieldKey.REGION.getDisplay());
        region.setRequired(ConnectionFieldKey.REGION.isRequired());
        region.setSensitive(ConnectionFieldKey.REGION.isSensitive());
        region.setPossibleValues(new String[]{Region.NA.getName(), Region.CA.getName(), Region.EU.getName(), Region.ASIA.getName(), Region.AU.getName()});
        connectionAttributes.add(region);
        ConnectionAttribute defaultAuthMethod = new ConnectionAttribute();
        defaultAuthMethod.setKey(ConnectionFieldKey.DEFAULT_AUTH_METHOD.getKey());
        defaultAuthMethod.setDescription(ConnectionFieldKey.DEFAULT_AUTH_METHOD.getDesc());
        defaultAuthMethod.setDisplayLabel(ConnectionFieldKey.DEFAULT_AUTH_METHOD.getDisplay());
        defaultAuthMethod.setRequired(ConnectionFieldKey.DEFAULT_AUTH_METHOD.isRequired());
        defaultAuthMethod.setSensitive(ConnectionFieldKey.DEFAULT_AUTH_METHOD.isSensitive());
        defaultAuthMethod.setPossibleValues(new String[]{MfaMethod.EMAIL_1.getName(), MfaMethod.SMS_1.getName(), MfaMethod.VOICE_1.getName()});
        connectionAttributes.add(defaultAuthMethod);
        ConnectionAttribute filterDisabledUserAttributes = new ConnectionAttribute();
        filterDisabledUserAttributes.setKey(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.getKey());
        filterDisabledUserAttributes.setDescription(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.getDesc());
        filterDisabledUserAttributes.setDisplayLabel(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.getDisplay());
        filterDisabledUserAttributes.setRequired(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.isRequired());
        filterDisabledUserAttributes.setSensitive(ConnectionFieldKey.FILTER_DISABLED_USER_ATTRIBUTES.isSensitive());
        filterDisabledUserAttributes.setTypeBoolean(true);
        connectionAttributes.add(filterDisabledUserAttributes);
        basicProfile.setConnectionAttributes(connectionAttributes);
        return basicProfile;
    }

    private ConnectionAttributes buildInternalAttributes() {
        ConnectionAttributes internalAttributes = new ConnectionAttributes();
        for (ConnectionFieldKey key : ConnectionFieldKey.getInternalConnectionFieldKeys()) {
            internalAttributes.add(this.toConnectionAttribute(key));
        }
        return internalAttributes;
    }

    private ConnectionAttribute toConnectionAttribute(ConnectionFieldKey key) {
        ConnectionAttribute attribute = new ConnectionAttribute();
        attribute.setKey(key.getKey());
        attribute.setDescription(key.getDesc());
        attribute.setDisplayLabel(key.getDisplay());
        attribute.setRequired(key.isRequired());
        attribute.setSensitive(key.isSensitive());
        return attribute;
    }
}

