/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.pf.cache;

import com.pingidentity.provisioner.integrations.pingone.pf.AccessTokenProviderException;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectedPingOneEnvironmentAccessor;
import com.pingidentity.provisioner.integrations.pingone.pf.ReflectionException;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.Clock;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.IClock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class AccessTokenCache {
    private static Logger logger = Logger.getLogger(AccessTokenCache.class);
    private final long EXPIRY_OFFSET_SECONDS = -30L;
    private static final ConcurrentMap<String, AccessTokenWrapper> tokenWrapperMap = new ConcurrentHashMap<String, AccessTokenWrapper>();
    private static volatile AccessTokenCache accessTokenCache;
    private final long expiryOffsetInSeconds;
    private IClock clock;

    private AccessTokenCache() {
        this.expiryOffsetInSeconds = -30L;
        this.clock = new Clock();
    }

    AccessTokenCache(long expiryOffsetInSeconds, IClock clock) {
        this.expiryOffsetInSeconds = expiryOffsetInSeconds;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessTokenCache getInstance() {
        if (accessTokenCache != null) return accessTokenCache;
        Class<AccessTokenCache> clazz = AccessTokenCache.class;
        synchronized (AccessTokenCache.class) {
            if (accessTokenCache != null) return accessTokenCache;
            accessTokenCache = new AccessTokenCache();
            logger.info((Object)"Access Token Cache has been created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return accessTokenCache;
        }
    }

    public synchronized String getToken(ReflectedPingOneEnvironmentAccessor accessTokenProvider, String clientIdentifier, boolean requestNewToken) throws ReflectionException, AccessTokenProviderException {
        AccessTokenWrapper tokenWrapper = (AccessTokenWrapper)tokenWrapperMap.get(clientIdentifier);
        long currentTime = this.clock.getCurrentTimeInMilliseconds();
        if (tokenWrapper == null || requestNewToken || tokenWrapper.isExpired(currentTime)) {
            return this.requestToken(accessTokenProvider, clientIdentifier, this.expiryOffsetInSeconds);
        }
        return tokenWrapper.getAccessToken();
    }

    private String requestToken(ReflectedPingOneEnvironmentAccessor accessTokenProvider, String clientIdentifier, long expiryOffsetInSeconds) throws AccessTokenProviderException, ReflectionException {
        AccessTokenWrapper tokenWrapper;
        String accessToken = accessTokenProvider.getAccessToken();
        try {
            tokenWrapper = new AccessTokenWrapper(accessToken, expiryOffsetInSeconds);
        }
        catch (MalformedClaimException | InvalidJwtException e) {
            throw new AccessTokenProviderException("Encountered exception processing access token", e);
        }
        logger.debug((Object)("Access Token for " + clientIdentifier + " expires at " + tokenWrapper.expiresAt));
        tokenWrapperMap.put(clientIdentifier, tokenWrapper);
        return tokenWrapper.getAccessToken();
    }

    public static class AccessTokenWrapper {
        private final String accessToken;
        private final NumericDate expiresAt;

        public AccessTokenWrapper(String accessToken, long expiryOffset) throws InvalidJwtException, MalformedClaimException {
            this.accessToken = accessToken;
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setSkipAllValidators().setSkipSignatureVerification().build();
            JwtClaims jwtClaims = jwtConsumer.processToClaims(accessToken);
            NumericDate expirationTime = jwtClaims.getExpirationTime();
            expirationTime.addSeconds(expiryOffset);
            this.expiresAt = expirationTime;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public boolean isExpired(long currentTime) {
            return NumericDate.fromMilliseconds((long)currentTime).isOnOrAfter(this.expiresAt);
        }
    }
}

