/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.pf.cache;

import com.pingidentity.io.cpl.pingone.metadata.AttributeMetadata;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.AttributeMetadataCache;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.Clock;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.ExpiringAttributeMetadata;
import com.pingidentity.provisioner.integrations.pingone.pf.cache.IClock;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingOneAttributeMetadataCache
implements AttributeMetadataCache {
    private static final long EXPIRY_IN_MILLIS = 10000L;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, ExpiringAttributeMetadata> cache;
    private IClock clock;
    private static AttributeMetadataCache singleton = new PingOneAttributeMetadataCache();

    private PingOneAttributeMetadataCache() {
        this.cache = Collections.synchronizedMap(new ConcurrentHashMap());
        this.clock = new Clock();
    }

    public PingOneAttributeMetadataCache(IClock clock) {
        this.cache = new HashMap<String, ExpiringAttributeMetadata>();
        this.clock = clock;
    }

    public static synchronized AttributeMetadataCache getInstance() {
        return singleton;
    }

    @Override
    public AttributeMetadata get(String channelId) {
        ExpiringAttributeMetadata expiryMetadata = this.cache.get(channelId);
        long currenttime = this.clock.getCurrentTimeInMilliseconds();
        if (expiryMetadata == null) {
            return null;
        }
        if (currenttime > expiryMetadata.getExpiry()) {
            this.clear(channelId);
            return null;
        }
        AttributeMetadata metadata = expiryMetadata.getMetadata();
        this.put(channelId, metadata);
        return metadata;
    }

    @Override
    public void put(String channelId, AttributeMetadata metadata) {
        long currentTime = this.clock.getCurrentTimeInMilliseconds();
        long expiryTime = currentTime + 10000L;
        this.logger.debug("AttributeMetadata cache expires on: " + new Date(expiryTime));
        this.cache.put(channelId, new ExpiringAttributeMetadata(expiryTime, metadata));
    }

    @Override
    public boolean clear(String channelId) {
        return this.cache.remove(channelId) != null;
    }
}

