/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.cache;

import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.saas.cache.Clock;
import com.pingidentity.provisioner.integrations.pingone.saas.cache.IClock;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudClient;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.CrudException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.ClientConfig;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.Schema;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaAttributeProperty;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.schema.SchemaCrudClientFactory;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.IntegrationsLogger;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.integrations.logger.LogEvent;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SchemaCache {
    private static final long SCHEMA_CACHE_EXPIRY_IN_MILLIS = 10000L;
    private static final IntegrationsLogger LOG = new IntegrationsLogger(SchemaCache.class);
    private static final ConcurrentMap<String, SchemaAttributesCacheWrapper> schemaAttributesCacheMap = new ConcurrentHashMap<String, SchemaAttributesCacheWrapper>();
    private static final ConcurrentMap<String, SchemaCacheWrapper> schemaCacheMap = new ConcurrentHashMap<String, SchemaCacheWrapper>();
    private static volatile SchemaCache schemaCache;
    private final CrudClient<ClientConfig, Schema> schemaClient;
    private final CrudClient<ClientConfig, SchemaAttribute> schemaAttributeClient;
    private final long expiryInMillis;
    private IClock clock;

    private SchemaCache() {
        this.schemaClient = new SchemaCrudClientFactory().make();
        this.schemaAttributeClient = new SchemaAttributeCrudClientFactory().make();
        this.expiryInMillis = 10000L;
        this.clock = new Clock();
    }

    SchemaCache(CrudClient<ClientConfig, Schema> schemaClient, CrudClient<ClientConfig, SchemaAttribute> schemaAttributeClient, long expiryInMillis, IClock clock) {
        this.schemaClient = schemaClient;
        this.schemaAttributeClient = schemaAttributeClient;
        this.expiryInMillis = expiryInMillis;
        this.clock = clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemaCache getInstance() {
        if (schemaCache != null) return schemaCache;
        Class<SchemaCache> clazz = SchemaCache.class;
        synchronized (SchemaCache.class) {
            if (schemaCache != null) return schemaCache;
            schemaCache = new SchemaCache();
            LOG.log(PingOneLogEvents.SCHEMA_CACHE_CREATE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return schemaCache;
        }
    }

    public synchronized List<Schema> getSchemas(Map<ClientConfig, String> clientConfig) throws CrudException {
        String envId = ClientConfig.getEnvId(clientConfig);
        SchemaCacheWrapper schemaCacheWrapper = (SchemaCacheWrapper)schemaCacheMap.get(envId);
        long currentTime = this.clock.getCurrentTimeInMilliseconds();
        if (schemaCacheWrapper == null || schemaCacheWrapper.isExpired(currentTime)) {
            return this.requestSchemas(envId, clientConfig);
        }
        List<Schema> cachedSchemas = schemaCacheWrapper.getSchema();
        long updatedExpiry = this.clock.getCurrentTimeInMilliseconds() + this.expiryInMillis;
        schemaCacheWrapper.setExpiresAt(updatedExpiry);
        LOG.log((LogEvent)PingOneLogEvents.SCHEMA_CACHE_EXPIRY_UPDATED, envId, new Date(schemaCacheWrapper.expiresAt).toString());
        return cachedSchemas;
    }

    private List<Schema> requestSchemas(String key, Map<ClientConfig, String> clientConfig) throws CrudException {
        List<Schema> returnedSchema = this.schemaClient.search(clientConfig, new Schema());
        long currentTime = this.clock.getCurrentTimeInMilliseconds();
        SchemaCacheWrapper schemaCacheWrapper = new SchemaCacheWrapper(returnedSchema, currentTime, this.expiryInMillis);
        schemaCacheMap.put(key, schemaCacheWrapper);
        LOG.log((LogEvent)PingOneLogEvents.SCHEMA_CACHE_EXPIRY, key, new Date(schemaCacheWrapper.expiresAt).toString());
        return schemaCacheWrapper.getSchema();
    }

    public synchronized List<SchemaAttribute> getSchemaAttributes(Map<ClientConfig, String> clientConfig, SchemaAttribute schemaAttribute) throws CrudException {
        String envId = ClientConfig.getEnvId(clientConfig);
        String schemaId = schemaAttribute.getOne(SchemaAttributeProperty.SCHEMA_ID);
        String key = envId + "|" + schemaId;
        SchemaAttributesCacheWrapper schemaAttributesCacheWrapper = (SchemaAttributesCacheWrapper)schemaAttributesCacheMap.get(key);
        long currentTime = this.clock.getCurrentTimeInMilliseconds();
        if (schemaAttributesCacheWrapper == null || schemaAttributesCacheWrapper.isExpired(currentTime)) {
            return this.requestSchemaAttributes(clientConfig, schemaAttribute, key);
        }
        List<SchemaAttribute> cachedSchemaAttributes = schemaAttributesCacheWrapper.getSchemaAttributes();
        long updatedExpiry = this.clock.getCurrentTimeInMilliseconds() + this.expiryInMillis;
        schemaAttributesCacheWrapper.setExpiresAt(updatedExpiry);
        LOG.log((LogEvent)PingOneLogEvents.SCHEMA_ATTRIBUTE_CACHE_EXPIRY_UPDATED, key, new Date(schemaAttributesCacheWrapper.expiresAt).toString());
        return cachedSchemaAttributes;
    }

    private List<SchemaAttribute> requestSchemaAttributes(Map<ClientConfig, String> clientConfig, SchemaAttribute schemaAttribute, String key) throws CrudException {
        List<SchemaAttribute> returnedSchemaAttributes = this.schemaAttributeClient.search(clientConfig, schemaAttribute);
        SchemaAttributesCacheWrapper schemaAttributesCacheWrapper = new SchemaAttributesCacheWrapper(returnedSchemaAttributes, this.clock.getCurrentTimeInMilliseconds(), this.expiryInMillis);
        schemaAttributesCacheMap.put(key, schemaAttributesCacheWrapper);
        LOG.log((LogEvent)PingOneLogEvents.SCHEMA_ATTRIBUTE_CACHE_EXPIRY, key, new Date(schemaAttributesCacheWrapper.expiresAt).toString());
        return schemaAttributesCacheWrapper.getSchemaAttributes();
    }

    public static class SchemaCacheWrapper {
        private final List<Schema> schema;
        private long expiresAt;

        public SchemaCacheWrapper(List<Schema> schema, long currentTime, long expiryInMillis) {
            long expiryTime;
            this.schema = schema;
            this.expiresAt = expiryTime = currentTime + expiryInMillis;
        }

        public void setExpiresAt(long expiresAt) {
            this.expiresAt = expiresAt;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public List<Schema> getSchema() {
            return this.schema;
        }

        public boolean isExpired(long currentTime) {
            return currentTime > this.expiresAt;
        }
    }

    public static class SchemaAttributesCacheWrapper {
        private final List<SchemaAttribute> schemaAttributes;
        private long expiresAt;

        public SchemaAttributesCacheWrapper(List<SchemaAttribute> schemaAttributes, long currentTime, long expiryInMillis) {
            long expiryTime;
            this.schemaAttributes = schemaAttributes;
            this.expiresAt = expiryTime = currentTime + expiryInMillis;
        }

        public List<SchemaAttribute> getSchemaAttributes() {
            return this.schemaAttributes;
        }

        public boolean isExpired(long currentTime) {
            return currentTime > this.expiresAt;
        }

        public void setExpiresAt(long expiresAt) {
            this.expiresAt = expiresAt;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }
    }
}

