/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.http;

import com.pingidentity.io.cpl.pingone.exception.ResourceCollisionException;
import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotModifiedException;
import com.pingidentity.io.cpl.pingone.exception.ResourceUnknownStateException;
import com.pingidentity.io.cpl.pingone.exception.ServiceAuthenticationException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.exception.ServiceUnavailableException;
import com.pingidentity.io.cpl.pingone.exception.ServiceUnknownStateException;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Membership;
import com.pingidentity.io.cpl.pingone.resource.Resource;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.saas.http.PingOneHttpHeader;
import com.pingidentity.provisioner.integrations.pingone.saas.http.PingOneStatusCode;
import com.pingidentity.provisioner.integrations.pingone.saas.http.Validator;
import com.pingidentity.provisioner.integrations.pingone.saas.serialization.PingOneDeserializer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneErrorDetails;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneErrorMessage;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.Header;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.HttpResponse;
import java.util.List;

public class PingOneValidator
implements Validator {
    private static final int NUMBER_OF_MILLIS_IN_A_SECOND = 1000;
    final String MESSAGE = "%1s PingOne responded with the message: %2s";
    final String HTTP_STATUS_CODE = "%1s Http Status Code: %2s";

    @Override
    public void validateFullRequest(Resource resource, HttpResponse response, String respBody) throws ServiceException, ResourceException {
        PingOneDeserializer deserializer = new PingOneDeserializer();
        int statusCode = response.getCode();
        String body = "";
        if (this.successful(statusCode)) {
            return;
        }
        this.forbidden(statusCode, resource, response, respBody);
        this.serviceUnavailable(statusCode, resource, response, respBody);
        this.serverError(statusCode, resource, response, respBody);
        if (statusCode == PingOneStatusCode.RATE_LIMITED.getStatusCode()) {
            ResourceNotModifiedException exception = new ResourceNotModifiedException(resource, String.format("%s Rate Limiting in process.", PingOneLogEvents.ERR_RATE_LIMITED.getCode()));
            Long suggestedMillisBeforeRetry = this.getSuggestedWaitTimeInMillis(response);
            exception.setSuggestedMillisBeforeRetry(suggestedMillisBeforeRetry);
            exception.setRemainingAttempts(1);
            throw exception;
        }
        PingOneErrorMessage errors = null;
        try {
            if (respBody != null && !respBody.isEmpty()) {
                errors = deserializer.deserialize(respBody, PingOneErrorMessage.class);
            }
        }
        catch (ServiceUnknownStateException e) {
            throw new ResourceNotModifiedException(resource, String.format("%s Bad request.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()), this.getIdentifier(resource));
        }
        if (statusCode == PingOneStatusCode.BAD_REQUEST.getStatusCode()) {
            Boolean thereAreErrors;
            if (errors != null && (thereAreErrors = Boolean.valueOf(errors.getDetails() != null && !errors.getDetails().isEmpty())).booleanValue()) {
                List<PingOneErrorDetails> details = errors.getDetails();
                StringBuilder problemsStringBuilder = new StringBuilder();
                for (PingOneErrorDetails detail : details) {
                    if (!problemsStringBuilder.toString().isEmpty()) {
                        problemsStringBuilder.append(", ");
                    }
                    String currentProblemString = String.format("[%1s][%2s: %3s]", detail.getCode(), detail.getTarget(), detail.getMessage());
                    problemsStringBuilder.append(currentProblemString);
                }
                String problems = problemsStringBuilder.toString();
                throw new ResourceNotModifiedException(resource, String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), problems), this.getIdentifier(resource));
            }
            throw new ResourceNotModifiedException(resource, String.format("%s Bad request.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()), this.getIdentifier(resource));
        }
        if (statusCode == PingOneStatusCode.RESOURCE_NOT_FOUND.getStatusCode()) {
            throw new ResourceNotFoundException(resource, String.format("%s Resource Not Found", PingOneLogEvents.ERR_RESOURCE_NOT_FOUND.getCode()), this.getIdentifier(resource));
        }
        if (statusCode == PingOneStatusCode.CONFLICT.getStatusCode()) {
            Boolean thereAreErrors;
            if (errors != null && (thereAreErrors = Boolean.valueOf(errors.getDetails() != null && !errors.getDetails().isEmpty())).booleanValue()) {
                List<PingOneErrorDetails> details = errors.getDetails();
                StringBuilder problemsStringBuilder = new StringBuilder();
                for (PingOneErrorDetails detail : details) {
                    if (!problemsStringBuilder.toString().isEmpty()) {
                        problemsStringBuilder.append(", ");
                    }
                    String currentProblemString = String.format("[%1s][%2s: %3s]", detail.getCode(), detail.getTarget(), detail.getMessage());
                    problemsStringBuilder.append(currentProblemString);
                }
                String problems = problemsStringBuilder.toString();
                throw new ResourceCollisionException(resource, String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_CONFLICT.getCode(), problems), this.getIdentifier(resource));
            }
            throw new ResourceCollisionException(resource, String.format("%s Conflict.", PingOneLogEvents.ERR_CONFLICT.getCode()), this.getIdentifier(resource));
        }
        throw new ResourceUnknownStateException(resource, String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_CONFLICT.getCode(), body), this.getIdentifier(resource));
    }

    @Override
    public void validateServiceRequest(Resource resource, HttpResponse response, String respBody) throws ServiceException {
        int statusCode = response.getCode();
        if (this.successful(statusCode)) {
            return;
        }
        this.forbidden(statusCode, resource, response, respBody);
        this.serviceUnavailable(statusCode, resource, response, respBody);
        this.serverError(statusCode, resource, response, respBody);
        if (statusCode == PingOneStatusCode.RATE_LIMITED.getStatusCode()) {
            ServiceUnavailableException exception = new ServiceUnavailableException(String.format("%s Rate Limiting in process.", PingOneLogEvents.ERR_RATE_LIMITED.getCode()));
            Long suggestedMillisBeforeRetry = this.getSuggestedWaitTimeInMillis(response);
            exception.setSuggestedMillisBeforeRetry(suggestedMillisBeforeRetry);
            exception.setRemainingAttempts(1);
            throw exception;
        }
        if (statusCode == PingOneStatusCode.BAD_REQUEST.getStatusCode()) {
            if (respBody != null && !respBody.isEmpty()) {
                throw new ServiceAuthenticationException(String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), respBody));
            }
            throw new ServiceAuthenticationException(String.format("%1s Http Status Code: %2s", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), String.valueOf(statusCode)));
        }
        if (statusCode == PingOneStatusCode.RESOURCE_NOT_FOUND.getStatusCode()) {
            throw new ServiceUnknownStateException(String.format("%s Resource Not Found", PingOneLogEvents.ERR_RESOURCE_NOT_FOUND.getCode()));
        }
        throw new ServiceUnknownStateException(String.format("%1s Http Status Code: %2s", PingOneLogEvents.ERR_UNKNOWN_STATE.getCode(), String.valueOf(statusCode)));
    }

    private boolean successful(int statusCode) {
        return statusCode == PingOneStatusCode.CREATED.getStatusCode() || statusCode == PingOneStatusCode.UPDATED.getStatusCode() || statusCode == PingOneStatusCode.NO_CONTENT.getStatusCode();
    }

    private void serverError(int statusCode, Resource resource, HttpResponse response, String respBody) throws ServiceException {
        if (statusCode == PingOneStatusCode.SERVER_ERROR.getStatusCode()) {
            PingOneDeserializer deserializer = new PingOneDeserializer();
            PingOneErrorMessage errors = null;
            if (respBody != null && !respBody.isEmpty()) {
                errors = deserializer.deserialize(respBody, PingOneErrorMessage.class);
            }
            if (errors != null && errors.getMessage() != null && !errors.getMessage().isEmpty()) {
                throw new ServiceUnavailableException(String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), errors.getMessage()));
            }
            throw new ServiceUnavailableException(String.format("%1s Http Status Code: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), String.valueOf(statusCode)));
        }
    }

    private void serviceUnavailable(int statusCode, Resource resource, HttpResponse response, String respBody) throws ServiceException {
        if (statusCode == PingOneStatusCode.SERVICE_UNAVAILABLE.getStatusCode()) {
            if (respBody != null && !respBody.isEmpty()) {
                throw new ServiceUnavailableException(String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), respBody));
            }
            throw new ServiceUnavailableException(String.format("%1s Http Status Code: %2s", PingOneLogEvents.ERR_SERVER_ERROR.getCode(), String.valueOf(statusCode)));
        }
    }

    private void forbidden(int statusCode, Resource resource, HttpResponse response, String respBody) throws ServiceException {
        if (statusCode == PingOneStatusCode.FORBIDDEN.getStatusCode() || statusCode == PingOneStatusCode.UNAUTHORIZED.getStatusCode()) {
            if (respBody != null && !respBody.isEmpty()) {
                throw new ServiceAuthenticationException(String.format("%1s PingOne responded with the message: %2s", PingOneLogEvents.ERR_FORBIDDEN.getCode(), respBody));
            }
            throw new ServiceAuthenticationException(String.format("%1s Http Status Code: %2s", PingOneLogEvents.ERR_FORBIDDEN.getCode(), String.valueOf(statusCode)));
        }
    }

    private long getSuggestedWaitTimeInMillis(HttpResponse response) {
        Header retryAfterHeader = response.getFirstHeader(PingOneHttpHeader.RETRY_AFTER.getValue());
        if (retryAfterHeader == null) {
            return 0L;
        }
        long suggestedWaitTimeInSeconds = 0L;
        try {
            suggestedWaitTimeInSeconds = Long.parseLong(retryAfterHeader.getValue());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        return 1000L * suggestedWaitTimeInSeconds;
    }

    private String getIdentifier(Resource resource) {
        if (resource instanceof User) {
            return resource.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel());
        }
        if (resource instanceof Group) {
            return resource.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
        }
        if (resource instanceof Membership) {
            Membership membership = (Membership)resource;
            return String.format("User %s of Group %s", membership.getMemberId().getId(), membership.getGroupId().getId());
        }
        return "Unknown Resource type";
    }
}

