/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.request_builder;

import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceMalformedException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotModifiedException;
import com.pingidentity.io.cpl.pingone.exception.ServiceAuthenticationException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.metadata.Attributes;
import com.pingidentity.io.cpl.pingone.request.ConnectionFields;
import com.pingidentity.io.cpl.pingone.request.PageFields;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Membership;
import com.pingidentity.io.cpl.pingone.resource.ResourceAttributes;
import com.pingidentity.io.cpl.pingone.resource.ResourceUniqueId;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.provisioner.integrations.pingone.ConnectionFieldKey;
import com.pingidentity.provisioner.integrations.pingone.PageFieldsKey;
import com.pingidentity.provisioner.integrations.pingone.PingOneLogEvents;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.saas.UserRequestBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.request_builder.PingOneEndpoint;
import com.pingidentity.provisioner.integrations.pingone.saas.serialization.SerializationException;
import com.pingidentity.provisioner.integrations.pingone.saas.serialization.Serializer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.GroupProfile;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneIdp;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOnePopulation;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.UserProfile;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.commons.codec.binary.Base64;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.commons.lang3.ArrayUtils;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.commons.lang3.StringUtils;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpDelete;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpPut;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.ContentType;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.io.entity.StringEntity;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.http.message.BasicHeader;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.org.apache.hc.core5.net.URIBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;

public class PingOneUserRequestBuilder
implements UserRequestBuilder {
    private static final String ERR_SERIALIZATION_USER = "%1s There was a problem serializing the user: %2s";
    private static final String ERR_SERIALIZATION_GROUP = "%1s There was a problem serializing the group: %2s";
    private static final String CONTENT_TYPE_KEY = "content-type";
    private static final String CONTENT_TYPE_VALUE = "application/vnd.pingidentity.user.import+json";
    private static final String CONTENT_TYPE_PASSWORD = "application/vnd.pingidentity.password.set+json";
    private static final String AUTHORIZATION_HEADER_KEY = "Authorization";
    private static final String AUTHORIZATION_HEADER_PREFIX = "Bearer ";
    private static final String ACCEPT_KEY = "Accept";
    private static final String ACCEPT_VALUE = "application/json";
    private static final String AUTHORIZATION_BASIC_HEADER_PREFIX = "Basic ";
    private static final String AUTHORIZATION_HEADER_FORMAT = "%s:%s";
    private static final int PAGE_SIZE_LIMIT = 500;
    private static final String DEFAULT_MIGRATION_HOST = "https://directory-api.pingone.com";
    private final Serializer serializer;

    public PingOneUserRequestBuilder(Serializer serializer) {
        this.serializer = serializer;
    }

    @Override
    public HttpUriRequest buildCreateUserRequest(ConnectionFields connectionFields, ResourceAttributes resourceAttributes, Attributes customAttributes) throws ResourceException, ServiceException {
        String createUserUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.CREATE_USER, new String[0]);
        UserProfile pingoneUser = new UserProfile(resourceAttributes, customAttributes);
        String idp = resourceAttributes.getValueOf(ResourceFieldKey.AUTHORITATIVE_IDP.getLabel());
        if (idp != null && !idp.isEmpty()) {
            pingoneUser.setIdentityProvider(new PingOneIdp(idp));
        }
        String serializedUser = this.serialize(pingoneUser);
        HttpPost httpRequest = new HttpPost(createUserUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        StringEntity entity = new StringEntity(serializedUser, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildGetUserRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ResourceException, ServiceException {
        String userId = id.getId();
        if (userId == null) {
            userId = "";
        }
        String getUserUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.GET_USER, userId);
        HttpGet httpRequest = new HttpGet(getUserUrl);
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildGetUserRequest(ConnectionFields connectionFields, String attributeValue) throws ResourceException, ServiceException {
        return this.getUserByFilter(connectionFields, attributeValue, "username eq \"%s\"");
    }

    @Override
    public HttpUriRequest buildGetAllUsers(ConnectionFields connectionFields, PageFields pageFields) throws ServiceException {
        String startIndex = pageFields.get(PageFieldsKey.START_INDEX.getKey()) == null || ((String)pageFields.get(PageFieldsKey.START_INDEX.getKey())).isEmpty() ? "1" : (String)pageFields.get(PageFieldsKey.START_INDEX.getKey());
        String itemsPerPage = pageFields.get(PageFieldsKey.ITEMS_PER_PAGE.getKey()) == null || ((String)pageFields.get(PageFieldsKey.ITEMS_PER_PAGE.getKey())).isEmpty() ? String.valueOf(500) : (String)pageFields.get(PageFieldsKey.ITEMS_PER_PAGE.getKey());
        String getUsersUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.GET_ALL_USERS, startIndex, itemsPerPage);
        HttpGet httpRequest = new HttpGet(getUsersUrl);
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdateUserRequest(ConnectionFields connectionFields, User user, Attributes customAttributes) throws ResourceException, ServiceException {
        if (user == null || user.getResourceUniqueId() == null || user.getResourceUniqueId().getId() == null || user.getResourceUniqueId().getId().isEmpty()) {
            throw new ResourceNotModifiedException(user, String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String updateUserUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.UPDATE_USER, user.getResourceUniqueId().getId());
        UserProfile pingoneUser = new UserProfile(user.getResourceAttributes(), customAttributes);
        pingoneUser.setPingOnePopulation(null);
        String serializedUser = this.serialize(pingoneUser);
        HttpPut httpRequest = new HttpPut(updateUserUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        StringEntity entity = new StringEntity(serializedUser, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdatePopulationRequest(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        if (user == null || user.getResourceUniqueId() == null || user.getResourceUniqueId().getId() == null || user.getResourceUniqueId().getId().isEmpty()) {
            throw new ResourceNotModifiedException(user, String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String updatePopulationUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.UPDATE_POPULATION, user.getResourceUniqueId().getId());
        PingOnePopulation population = new PingOnePopulation(user.getResourceAttributes().getValueOf(ResourceFieldKey.POPULATION_ID.getLabel()));
        String serializedPopulation = this.serialize(population);
        HttpPut httpRequest = new HttpPut(updatePopulationUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        StringEntity entity = new StringEntity(serializedPopulation, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdateEnabledRequest(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        if (user == null || user.getResourceUniqueId() == null || user.getResourceUniqueId().getId() == null || user.getResourceUniqueId().getId().isEmpty()) {
            throw new ResourceNotModifiedException(user, String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String updateEnabledUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.UPDATE_ENABLED, user.getResourceUniqueId().getId());
        String serializedUser = String.format("{\"enabled\": %s}", user.getResourceAttributes().getValueOf(ResourceFieldKey.ENABLED.getLabel()));
        HttpPut httpRequest = new HttpPut(updateEnabledUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        StringEntity entity = new StringEntity(serializedUser, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdateMfaEnabledRequest(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        if (user == null || user.getResourceUniqueId() == null || user.getResourceUniqueId().getId() == null || user.getResourceUniqueId().getId().isEmpty()) {
            throw new ResourceNotModifiedException(user, String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String updateMfaEnabledUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.UPDATE_MFA_ENABLED, user.getResourceUniqueId().getId());
        String serializedUser = String.format("{\"mfaEnabled\": %s}", user.getResourceAttributes().getValueOf(ResourceFieldKey.MFA_ENABLED.getLabel()).toLowerCase());
        HttpPut httpRequest = new HttpPut(updateMfaEnabledUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        StringEntity entity = new StringEntity(serializedUser, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdatePasswordRequest(ConnectionFields connectionFields, User user) throws ResourceException, ServiceException {
        if (user == null || user.getResourceUniqueId() == null || user.getResourceUniqueId().getId() == null || user.getResourceUniqueId().getId().isEmpty()) {
            throw new ResourceNotModifiedException(user, String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String updatePasswordUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.UPDATE_PASSWORD, user.getResourceUniqueId().getId());
        String password = user.getResourceAttributes().getValueOf(ResourceFieldKey.PASSWORD.getLabel());
        String forceChangePassword = user.getResourceAttributes().getValueOf(ResourceFieldKey.FORCE_CHANGE_PASSWORD.getLabel());
        String serializedUser = String.format("{\"value\": \"%s\",\"forceChange\": %s}", password, forceChangePassword);
        HttpPut httpRequest = new HttpPut(updatePasswordUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_PASSWORD);
        StringEntity entity = new StringEntity(serializedUser, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildDeleteUserRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ResourceException, ServiceException {
        if (id == null || id.getId() == null || id.getId().isEmpty()) {
            throw new ResourceNotModifiedException(new User(id), String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String deleteUserUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.DELETE_USER, id.getId());
        HttpDelete httpRequest = new HttpDelete(deleteUserUrl);
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildPasswordMigrationRequest(ConnectionFields connectionFields, String username) throws ResourceException, ServiceException {
        if (username == null || username.trim().isEmpty()) {
            throw new ResourceNotModifiedException(null, String.format("%1s Error creating URL: No valid username.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String cfPasswordMigrationUrl = (String)connectionFields.get(ConnectionFieldKey.P14E_URL.getKey());
        String passwordMigrationURL = (cfPasswordMigrationUrl != null && !cfPasswordMigrationUrl.isEmpty() ? cfPasswordMigrationUrl : DEFAULT_MIGRATION_HOST) + PingOneEndpoint.PASSWORD_MIGRATION.getEndpoint();
        String serializedRequest = String.format("{\"userName\": \"%s\"}", username);
        HttpPost httpRequest = new HttpPost(passwordMigrationURL);
        this.buildPasswordMigrationHeaders(connectionFields, httpRequest);
        StringEntity entity = new StringEntity(serializedRequest, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdateIdentityProviderRequest(ConnectionFields cf, ResourceUniqueId ruid, String idpId) throws ResourceException, ServiceException {
        if (ruid == null || ruid.getId() == null || ruid.getId().isEmpty()) {
            throw new ResourceNotModifiedException(new User(ruid), String.format("%1s Error creating URL: No valid resource id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        if (idpId == null) {
            throw new ResourceNotModifiedException(new User(ruid), String.format("%1s Error creating URL: No valid idp id.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String uid = ruid.getId();
        String updateIdpUrl = this.getUrl(cf, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.UPDATE_IDP, uid);
        String serializedIdp = null;
        try {
            serializedIdp = this.serializer.serialize(new PingOneIdp(idpId));
        }
        catch (SerializationException e) {
            throw new ResourceNotModifiedException(null, String.format(ERR_SERIALIZATION_USER, PingOneLogEvents.SERIALIZE_IDENTITY_PROVIDERS_ERROR.getCode(), uid));
        }
        HttpPut httpRequest = new HttpPut(updateIdpUrl);
        this.buildHeaders(cf, httpRequest, CONTENT_TYPE_VALUE);
        StringEntity entity = new StringEntity(serializedIdp, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildCreateGroupRequest(ConnectionFields connectionFields, ResourceAttributes resourceAttributes) throws ResourceException, ServiceException {
        String createGroupUrl = this.getUrl(connectionFields, PingOneEndpoint.GROUPS_RESOURCE, PingOneEndpoint.CREATE_GROUP, new String[0]);
        GroupProfile groupProfile = new GroupProfile(resourceAttributes);
        HttpPost httpRequest = new HttpPost(createGroupUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        String serializedGroup = this.serialize(groupProfile);
        StringEntity entity = new StringEntity(serializedGroup, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildGetGroupRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ServiceException {
        String groupId = id.getId();
        if (groupId == null) {
            groupId = "";
        }
        String getGroupUrl = this.getUrl(connectionFields, PingOneEndpoint.GROUPS_RESOURCE, PingOneEndpoint.GET_GROUP, groupId);
        HttpGet httpRequest = new HttpGet(getGroupUrl);
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildGetGroupRequest(ConnectionFields connectionFields, String groupName) throws ResourceException, ServiceException {
        HttpGet httpRequest;
        if (StringUtils.isBlank(groupName)) {
            throw new ResourceNotModifiedException(null, String.format("%1s Error creating URL: Invalid group name.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        String getGroupUrl = this.getUrl(connectionFields, PingOneEndpoint.GROUPS_RESOURCE, PingOneEndpoint.GET_GROUP_BY_FILTER, new String[0]);
        try {
            URIBuilder builder = new URIBuilder(getGroupUrl);
            String filterParam = String.format("name eq \"%s\"", groupName);
            builder.setParameter("filter", filterParam);
            httpRequest = new HttpGet(builder.build());
        }
        catch (URISyntaxException e) {
            throw new ResourceNotModifiedException(null, String.format("%1s Error creating URL: %2s", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), e.getMessage()));
        }
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildUpdateGroupRequest(ConnectionFields connectionFields, Group group) throws ResourceException, ServiceException {
        String updateGroupUrl = this.getUrl(connectionFields, PingOneEndpoint.GROUPS_RESOURCE, PingOneEndpoint.UPDATE_GROUP, group.getResourceUniqueId().getId());
        group.getResourceAttributes().remove(ResourceFieldKey.GROUP_ID.getLabel());
        GroupProfile groupProfile = new GroupProfile(group.getResourceAttributes());
        HttpPut httpRequest = new HttpPut(updateGroupUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        String serializedGroup = this.serialize(groupProfile);
        StringEntity entity = new StringEntity(serializedGroup, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildDeleteGroupRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ServiceException {
        String deleteGroupUrl = this.getUrl(connectionFields, PingOneEndpoint.GROUPS_RESOURCE, PingOneEndpoint.DELETE_GROUP, id.getId());
        HttpDelete httpRequest = new HttpDelete(deleteGroupUrl);
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildCreateMembershipRequest(ConnectionFields connectionFields, Membership membership) throws ResourceException, ServiceException {
        String createMembershipUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.CREATE_MEMBERSHIP, membership.getMemberId().getId());
        GroupProfile groupProfile = new GroupProfile();
        groupProfile.setId(membership.getGroupId().getId());
        HttpPost httpRequest = new HttpPost(createMembershipUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        String serializedGroup = this.serialize(groupProfile);
        StringEntity entity = new StringEntity(serializedGroup, ContentType.APPLICATION_JSON);
        httpRequest.setEntity(entity);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildDeleteMembershipRequest(ConnectionFields connectionFields, Membership membership) throws ServiceException {
        String deleteMembershipUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.DELETE_MEMBERSHIP, membership.getMemberId().getId(), membership.getGroupId().getId());
        HttpDelete httpRequest = new HttpDelete(deleteMembershipUrl);
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    @Override
    public HttpUriRequest buildGetMembershipRequest(ConnectionFields connectionFields, ResourceUniqueId id) throws ResourceException {
        return null;
    }

    @Override
    public HttpUriRequest buildGetAllMembersOfGroupRequest(ConnectionFields connectionFields, ResourceUniqueId id, PageFields pageFields) throws ResourceException, ServiceException {
        HttpGet httpRequest;
        String nextPageUrl;
        String groupId = id.getId();
        if (groupId == null) {
            groupId = "";
        }
        if ((nextPageUrl = (String)pageFields.get(PageFieldsKey.NEXT_PAGE_URL.getKey())) == null) {
            String getMembershipUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.GET_GROUP_MEMBERS, new String[0]);
            try {
                URIBuilder builder = new URIBuilder(getMembershipUrl);
                String filterParam = String.format("memberOfGroups[id eq \"%s\"]", groupId);
                builder.setParameter("filter", filterParam);
                builder.setParameter("limit", String.valueOf(500));
                httpRequest = new HttpGet(builder.build());
            }
            catch (URISyntaxException e) {
                throw new ResourceNotModifiedException(null, String.format("%1s Error creating URL: %2s", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), e.getMessage()));
            }
        } else {
            httpRequest = new HttpGet(nextPageUrl);
        }
        this.buildHeaders(connectionFields, httpRequest, null);
        return httpRequest;
    }

    private HttpUriRequest getUserByFilter(ConnectionFields connectionFields, String username, String filter) throws ResourceException, ServiceException {
        String getUserUrl;
        if (username == null || username.isEmpty()) {
            throw new ResourceNotModifiedException(null, String.format("%1s Error creating URL: No valid username.", PingOneLogEvents.ERR_BAD_REQUEST.getCode()));
        }
        if (filter != null) {
            try {
                username = URLEncoder.encode(String.format(filter, username), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceNotModifiedException(null, String.format("%1s Error creating URL: %2s", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), e.getMessage()));
            }
            getUserUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.GET_USER_BY_FILTER, username);
        } else {
            getUserUrl = this.getUrl(connectionFields, PingOneEndpoint.USERS_RESOURCE, PingOneEndpoint.GET_ALL_USERS, new String[0]);
        }
        HttpGet httpRequest = new HttpGet(getUserUrl);
        this.buildHeaders(connectionFields, httpRequest, CONTENT_TYPE_VALUE);
        return httpRequest;
    }

    private void buildHeaders(ConnectionFields connectionFields, HttpUriRequest httpRequest, String contentType) {
        String authorizationHeaderValue = AUTHORIZATION_HEADER_PREFIX + (String)connectionFields.get(ConnectionFieldKey.ACCESS_TOKEN.getKey());
        BasicHeader authorizationHeader = new BasicHeader(AUTHORIZATION_HEADER_KEY, authorizationHeaderValue);
        httpRequest.addHeader(authorizationHeader);
        if (contentType != null) {
            BasicHeader contentTypeHeader = new BasicHeader(CONTENT_TYPE_KEY, contentType);
            httpRequest.addHeader(contentTypeHeader);
        }
        BasicHeader acceptTypeTypeHeader = new BasicHeader(ACCEPT_KEY, ACCEPT_VALUE);
        httpRequest.addHeader(acceptTypeTypeHeader);
    }

    private void buildPasswordMigrationHeaders(ConnectionFields connectionFields, HttpUriRequest httpRequest) throws ServiceException {
        String username = this.getConnectionFieldValue(connectionFields, ConnectionFieldKey.P14E_DIRECTORY_ACCOUNT_ID.getKey());
        String password = this.getConnectionFieldValue(connectionFields, ConnectionFieldKey.P14E_DIRECTORY_API_KEY.getKey());
        String authorizationHeaderValue = String.format(AUTHORIZATION_HEADER_FORMAT, username, password);
        byte[] authorizationHeaderByteValue = authorizationHeaderValue.getBytes();
        Base64 encoder = new Base64();
        authorizationHeaderByteValue = encoder.encode(authorizationHeaderByteValue);
        authorizationHeaderValue = AUTHORIZATION_BASIC_HEADER_PREFIX + new String(authorizationHeaderByteValue);
        BasicHeader authorizationHeader = new BasicHeader(AUTHORIZATION_HEADER_KEY, authorizationHeaderValue);
        BasicHeader acceptTypeHeader = new BasicHeader(ACCEPT_KEY, ACCEPT_VALUE);
        httpRequest.addHeader(authorizationHeader);
        httpRequest.addHeader(acceptTypeHeader);
    }

    private String serialize(UserProfile user) throws ResourceException {
        String objStr = "";
        try {
            objStr = this.serializer.serialize(user);
        }
        catch (Exception e) {
            throw new ResourceNotModifiedException(null, String.format(ERR_SERIALIZATION_USER, PingOneLogEvents.ERR_UNKNOWN_STATE.getCode(), user.toString()));
        }
        return objStr;
    }

    private String serialize(PingOnePopulation population) throws ResourceException {
        String objStr = "";
        try {
            objStr = this.serializer.serialize(population);
        }
        catch (Exception e) {
            throw new ResourceNotModifiedException(null, String.format(ERR_SERIALIZATION_USER, PingOneLogEvents.ERR_UNKNOWN_STATE.getCode(), population.toString()));
        }
        return objStr;
    }

    private String serialize(GroupProfile group) throws ResourceException {
        String objStr = "";
        try {
            objStr = this.serializer.serialize(group);
        }
        catch (SerializationException e) {
            throw new ResourceMalformedException(null, String.format(ERR_SERIALIZATION_GROUP, PingOneLogEvents.ERR_UNKNOWN_STATE.getCode(), group.toString()));
        }
        return objStr;
    }

    private String getUrl(ConnectionFields connectionFields, PingOneEndpoint baseResource, PingOneEndpoint type, String ... resourceIds) throws ServiceException {
        String baseUrl = StringUtils.isBlank((CharSequence)connectionFields.get(ConnectionFieldKey.P1_DIRECTORY_BASE_URL.getKey())) ? (String)connectionFields.get(ConnectionFieldKey.MGMT_URL.getKey()) : (String)connectionFields.get(ConnectionFieldKey.P1_DIRECTORY_BASE_URL.getKey());
        String urlTemplate = baseUrl + PingOneEndpoint.ENV_PATH.getEndpoint() + baseResource.getEndpoint() + type.getEndpoint();
        String envId = this.getConnectionFieldValue(connectionFields, ConnectionFieldKey.ENV_ID.getKey());
        return String.format(urlTemplate, ArrayUtils.add(resourceIds, 0, envId));
    }

    private String getConnectionFieldValue(ConnectionFields connectionFields, String key) throws ServiceException {
        if (connectionFields.get(key) != null && !((String)connectionFields.get(key)).trim().isEmpty()) {
            return ((String)connectionFields.get(key)).trim();
        }
        throw new ServiceAuthenticationException(String.format("%s Connection Field [%s] is null or empty.", PingOneLogEvents.ERR_BAD_REQUEST.getCode(), key));
    }
}

