/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.resource_builder;

import com.pingidentity.io.cpl.pingone.exception.ResourceException;
import com.pingidentity.io.cpl.pingone.exception.ResourceMalformedException;
import com.pingidentity.io.cpl.pingone.exception.ResourceNotFoundException;
import com.pingidentity.io.cpl.pingone.exception.ServiceException;
import com.pingidentity.io.cpl.pingone.exception.ServiceUnknownStateException;
import com.pingidentity.io.cpl.pingone.request.PageFields;
import com.pingidentity.io.cpl.pingone.resource.Group;
import com.pingidentity.io.cpl.pingone.resource.Groups;
import com.pingidentity.io.cpl.pingone.resource.Membership;
import com.pingidentity.io.cpl.pingone.resource.Memberships;
import com.pingidentity.io.cpl.pingone.resource.User;
import com.pingidentity.io.cpl.pingone.resource.Users;
import com.pingidentity.provisioner.integrations.pingone.PageFieldsKey;
import com.pingidentity.provisioner.integrations.pingone.ResourceFieldKey;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasGroup;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasMembership;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUser;
import com.pingidentity.provisioner.integrations.pingone.saas.SaasUserGroupBuilder;
import com.pingidentity.provisioner.integrations.pingone.saas.serialization.Deserializer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.GroupProfile;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.IdaasDirectoryPassword;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.MembershipProfile;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneGroupsContainer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneListContainer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.PingOneUsersContainer;
import com.pingidentity.provisioner.integrations.pingone.saas.wrapper.UserProfile;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.type.TypeReference;
import java.util.Arrays;
import java.util.List;

public class PingOneResourceBuilder
implements SaasUserGroupBuilder {
    public static final TypeReference<PingOneListContainer<PingOneUsersContainer>> USER_LIST_TYPE_REF = new TypeReference<PingOneListContainer<PingOneUsersContainer>>(){};
    public static final TypeReference<PingOneListContainer<PingOneGroupsContainer>> GROUP_LIST_TYPE_REF = new TypeReference<PingOneListContainer<PingOneGroupsContainer>>(){};
    private final Deserializer deserializer;

    public PingOneResourceBuilder(Deserializer deserializer) {
        this.deserializer = deserializer;
    }

    @Override
    public SaasUser buildUser(String jsonResponseString, User user) throws ResourceException {
        SaasUser saasUser = null;
        try {
            saasUser = this.deserializer.deserialize(jsonResponseString, UserProfile.class);
        }
        catch (Exception e) {
            String identifier = user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel());
            throw new ResourceMalformedException(user, "Error Parsing User JSON: \"" + jsonResponseString + "\"", identifier);
        }
        return saasUser;
    }

    @Override
    public SaasUser buildUserByFilter(String jsonResponseString, User user) throws ResourceException {
        UserProfile userProfile = null;
        try {
            List<UserProfile> users;
            PingOneListContainer<PingOneUsersContainer> listContainer = this.deserializer.deserialize(jsonResponseString, USER_LIST_TYPE_REF);
            if (listContainer != null && listContainer.getEmbedded() != null && Integer.parseInt(listContainer.getCount()) > 0) {
                PingOneUsersContainer userContainer = listContainer.getEmbedded();
                users = Arrays.asList(userContainer.getUserProfiles());
                int numUsers = users.size();
                if (numUsers == 0) {
                    String identifier = user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel());
                    throw new ResourceNotFoundException(user, "There is an unexpected number of users in the response: \"" + jsonResponseString + "\"", identifier);
                }
            } else {
                String identifier = user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel());
                throw new ResourceNotFoundException(user, "There is an unexpected number of users in the response: \"" + jsonResponseString + "\"", identifier);
            }
            userProfile = users.get(0);
        }
        catch (ServiceException e) {
            String identifier = user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel());
            throw new ResourceMalformedException(user, "There was a problem decoding users: \"" + jsonResponseString + "\"", identifier);
        }
        catch (RuntimeException e) {
            String identifier = user.getResourceAttributes().getValueOf(ResourceFieldKey.USERNAME.getLabel());
            throw new ResourceMalformedException(user, "Error Parsing Users JSON: \"" + jsonResponseString + "\"", identifier);
        }
        return userProfile;
    }

    @Override
    public Users buildUsers(String jsonResponseString, PageFields pageFields) throws ServiceException {
        Users cplUsers = new Users();
        try {
            PingOneUsersContainer userContainer;
            List<UserProfile> users;
            PingOneListContainer<PingOneUsersContainer> listContainer = this.deserializer.deserialize(jsonResponseString, USER_LIST_TYPE_REF);
            if (listContainer != null && listContainer.getEmbedded() != null && Integer.parseInt(listContainer.getCount()) > 0 && !(users = Arrays.asList((userContainer = listContainer.getEmbedded()).getUserProfiles())).isEmpty()) {
                for (UserProfile user : users) {
                    cplUsers.add(user.getCplUser());
                }
            }
            return cplUsers;
        }
        catch (RuntimeException e) {
            throw new ServiceUnknownStateException("Error Parsing Users JSON: \"" + jsonResponseString + "\"");
        }
    }

    @Override
    public IdaasDirectoryPassword buildIdaasDirectoryPassword(String passwordMigrationJson, User user) throws ServiceException {
        IdaasDirectoryPassword directoryPassword = null;
        try {
            directoryPassword = this.deserializer.deserialize(passwordMigrationJson, IdaasDirectoryPassword.class);
        }
        catch (Exception e) {
            throw new ServiceUnknownStateException("Error Parsing User JSON: \"" + passwordMigrationJson + "\"");
        }
        return directoryPassword;
    }

    @Override
    public SaasGroup buildGroup(String jsonGroup, Group group) throws ResourceException {
        GroupProfile groupProfile;
        try {
            groupProfile = this.deserializer.deserialize(jsonGroup, GroupProfile.class);
        }
        catch (ServiceException e) {
            String identifier = group.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
            throw new ResourceMalformedException(group, "There was a problem deserializing group: \"" + jsonGroup + "\"", identifier);
        }
        return groupProfile;
    }

    @Override
    public SaasGroup buildGroupByFilter(String jsonGroup, Group group) throws ResourceException {
        PingOneListContainer<PingOneGroupsContainer> listContainer;
        try {
            listContainer = this.deserializer.deserialize(jsonGroup, GROUP_LIST_TYPE_REF);
        }
        catch (ServiceException e) {
            String identifier = group.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
            throw new ResourceMalformedException(group, "There was a problem deserializing groups: \"" + jsonGroup + "\"", identifier);
        }
        if (listContainer != null && listContainer.getEmbedded() != null && Integer.parseInt(listContainer.getCount()) > 0) {
            List<GroupProfile> groups = listContainer.getEmbedded().getGroupProfiles();
            return groups.get(0);
        }
        String identifier = group.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
        throw new ResourceNotFoundException(group, "There is an unexpected number of groups in the response: \"" + jsonGroup + "\"", identifier);
    }

    @Override
    public Groups buildGroups(String jsonGroups, PageFields pageFields) throws ServiceException {
        return null;
    }

    @Override
    public SaasMembership buildMembership(String jsonGroup, Membership membership) throws ResourceException {
        GroupProfile groupProfile;
        try {
            groupProfile = this.deserializer.deserialize(jsonGroup, GroupProfile.class);
        }
        catch (ServiceException e) {
            String identifier = String.format("User %s of Group %s", membership.getMemberId().getId(), membership.getGroupId().getId());
            throw new ResourceMalformedException(membership, "There was a problem deserializing membership: [" + jsonGroup + "]", identifier);
        }
        return new MembershipProfile(groupProfile.getId(), membership.getMemberId().getId());
    }

    @Override
    public Memberships buildMemberships(String jsonMemberships, Group group, PageFields pageFields) throws ResourceException {
        String nextPageUrl;
        PingOneListContainer<PingOneUsersContainer> listContainer;
        try {
            listContainer = this.deserializer.deserialize(jsonMemberships, USER_LIST_TYPE_REF);
        }
        catch (ServiceException e) {
            String identifier = group.getResourceAttributes().getValueOf(ResourceFieldKey.GROUP_NAME.getLabel());
            throw new ResourceMalformedException(group, "There was a problem deserializing memberships: [" + jsonMemberships + "]", identifier);
        }
        Memberships memberships = new Memberships();
        if (listContainer.getEmbedded() != null) {
            for (UserProfile user : listContainer.getEmbedded().getUserProfiles()) {
                MembershipProfile membership = new MembershipProfile(group.getResourceUniqueId().getId(), user.getId());
                memberships.add(membership.getCplMembership());
            }
        }
        String string = nextPageUrl = listContainer.getLinks() != null && listContainer.getLinks().getNext() != null ? listContainer.getLinks().getNext().getHref() : null;
        if (nextPageUrl != null) {
            pageFields.put(PageFieldsKey.NEXT_PAGE_URL.getKey(), nextPageUrl);
        } else {
            pageFields.clear();
        }
        return memberships;
    }
}

