/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.pingone.saas.wrapper;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceAttribute;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.DeviceType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public enum MfaMethod {
    EMAIL_1("Email 1", "mfaDeviceEmail1", DeviceType.EMAIL, DeviceAttribute.EMAIL),
    EMAIL_2("Email 2", "mfaDeviceEmail2", DeviceType.EMAIL, DeviceAttribute.EMAIL),
    EMAIL_3("Email 3", "mfaDeviceEmail3", DeviceType.EMAIL, DeviceAttribute.EMAIL),
    SMS_1("SMS 1", "mfaDeviceSms1", DeviceType.SMS, DeviceAttribute.PHONE),
    SMS_2("SMS 2", "mfaDeviceSms2", DeviceType.SMS, DeviceAttribute.PHONE),
    SMS_3("SMS 3", "mfaDeviceSms3", DeviceType.SMS, DeviceAttribute.PHONE),
    VOICE_1("Voice 1", "mfaDeviceVoice1", DeviceType.VOICE, DeviceAttribute.PHONE),
    VOICE_2("Voice 2", "mfaDeviceVoice2", DeviceType.VOICE, DeviceAttribute.PHONE),
    VOICE_3("Voice 3", "mfaDeviceVoice3", DeviceType.VOICE, DeviceAttribute.PHONE);

    private String name;
    private String resourceFieldName;
    private DeviceType type;
    private DeviceAttribute valueAttribute;
    private static final Map<String, MfaMethod> NAME_INDEX;
    protected static final List<MfaMethod> DEFAULT_ORDER;

    private MfaMethod(String name, String resourceFieldName, DeviceType type, DeviceAttribute valueAttribute) {
        this.name = name;
        this.resourceFieldName = resourceFieldName;
        this.type = type;
        this.valueAttribute = valueAttribute;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceFieldName() {
        return this.resourceFieldName;
    }

    public DeviceType getType() {
        return this.type;
    }

    public DeviceAttribute getValueAttribute() {
        return this.valueAttribute;
    }

    public static MfaMethod valueOfName(String name) {
        return NAME_INDEX.get(name);
    }

    public static boolean isValidName(String name) {
        return NAME_INDEX.containsKey(name);
    }

    public static List<MfaMethod> getMethodOrder(MfaMethod firstMethod) {
        LinkedList<MfaMethod> order = new LinkedList<MfaMethod>(DEFAULT_ORDER);
        if (firstMethod == null || DEFAULT_ORDER.get(0).equals((Object)firstMethod)) {
            return order;
        }
        order.remove((Object)firstMethod);
        order.add(0, firstMethod);
        return order;
    }

    static {
        NAME_INDEX = new HashMap<String, MfaMethod>();
        for (MfaMethod device : MfaMethod.values()) {
            NAME_INDEX.put(device.name, device);
        }
        DEFAULT_ORDER = Arrays.asList(EMAIL_1, EMAIL_2, EMAIL_3, SMS_1, SMS_2, SMS_3, VOICE_1, VOICE_2, VOICE_3);
    }
}

