/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonPointer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResponseParser;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpBody;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpResponse;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.Device;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.DeviceDtoTransformer;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.Translator;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.dto.DeviceDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.dto.DevicesResponseDto;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.exception.DeviceNotFoundException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.exception.InvalidDataException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.device.crud.exception.LimitExceededException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DeviceResponseParser
implements ResponseParser<Device> {
    private ObjectMapper mapper;
    private Translator<DeviceDto, Device> translator;
    private static final String FALLBACK_DEVICE_ERROR = "%s Status: %s. Body: %s.";
    private static final String DEFAULT_DEVICE_ERROR = "%s Status: %s. Correlation Id: %s. Error Code: %s. Error Message: %s";

    public DeviceResponseParser() {
        this(new ObjectMapper(), new DeviceDtoTransformer());
    }

    public DeviceResponseParser(ObjectMapper mapper, Translator<DeviceDto, Device> translator) {
        this.mapper = mapper;
        this.translator = translator;
    }

    @Override
    public Device parseCreateResponse(GenericHttpResponse resp) throws ResourceException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 201) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Device was not created.", statusCode, body));
            }
            String errorCode = errorResponseMap.get("code");
            if (statusCode == 400 && (errorCode.equalsIgnoreCase("REQUEST_LIMITED") || errorCode.equalsIgnoreCase("LIMIT_EXCEEDED"))) {
                throw new LimitExceededException(statusCode.toString(), errorResponseMap.get("id"), errorCode, errorResponseMap.get("message"));
            }
            if (errorCode.equalsIgnoreCase("INVALID_DATA") || errorCode.equalsIgnoreCase("INVALID_VALUE")) {
                throw new InvalidDataException(statusCode.toString(), errorResponseMap.get("id"), errorCode, errorResponseMap.get("message"));
            }
            throw new ResourceException(String.format(DEFAULT_DEVICE_ERROR, "Unable to create device.", statusCode, errorResponseMap.get("id"), errorCode, errorResponseMap.get("message")));
        }
        DeviceDto resource = null;
        try {
            resource = this.mapper.readValue(body, DeviceDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize Device.", e);
        }
        return this.translator.translate(resource);
    }

    @Override
    public Device parseReadResponse(GenericHttpResponse resp) throws ResourceException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode == 404) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Device could not be found.", statusCode, body));
            }
            throw new DeviceNotFoundException(statusCode.toString(), errorResponseMap.get("id"), errorResponseMap.get("code"), errorResponseMap.get("message"));
        }
        if (statusCode != null && statusCode != 200) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Device could not be read.", statusCode, body));
            }
            throw new ResourceException(String.format(DEFAULT_DEVICE_ERROR, "Device could not be read.", statusCode, errorResponseMap.get("id"), errorResponseMap.get("code"), errorResponseMap.get("message")));
        }
        DeviceDto resource = null;
        try {
            resource = this.mapper.readValue(body, DeviceDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize Device.", e);
        }
        return this.translator.translate(resource);
    }

    @Override
    public Optional<Device> parsePartialUpdateResponse(GenericHttpResponse resp) throws ResourceException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode == 404) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Device could not be found.", statusCode, body));
            }
            throw new DeviceNotFoundException(statusCode.toString(), errorResponseMap.get("id"), errorResponseMap.get("code"), errorResponseMap.get("message"));
        }
        if (statusCode != null && statusCode != 200) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Device could not be read.", statusCode, body));
            }
            throw new ResourceException(String.format(DEFAULT_DEVICE_ERROR, "Device could not be read.", statusCode, errorResponseMap.get("id"), errorResponseMap.get("code"), errorResponseMap.get("message")));
        }
        return Optional.empty();
    }

    @Override
    public Device parseUpdateResponse(GenericHttpResponse resp) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Device update response parsing is not supported.");
    }

    @Override
    public void parseDeleteResponse(GenericHttpResponse resp) throws ResourceException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 204) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Device could not be deleted.", statusCode, body));
            }
            throw new ResourceException(String.format(DEFAULT_DEVICE_ERROR, "Device could not be deleted.", statusCode, errorResponseMap.get("id"), errorResponseMap.get("code"), errorResponseMap.get("message")));
        }
    }

    @Override
    public List<Device> parseSearchResponse(GenericHttpResponse resp) throws ResourceException {
        String body;
        Integer statusCode = resp.getStatusCode();
        GenericHttpBody ghb = resp.getBody();
        String string = body = ghb != null ? ghb.getContent() : null;
        if (statusCode != null && statusCode != 200) {
            Map<String, String> errorResponseMap = this.parseErrorResponse(body);
            if (errorResponseMap.isEmpty()) {
                throw new ResourceException(String.format(FALLBACK_DEVICE_ERROR, "Devices could not be read.", statusCode, body));
            }
            throw new ResourceException(String.format(DEFAULT_DEVICE_ERROR, "Devices could not be read.", statusCode, errorResponseMap.get("id"), errorResponseMap.get("code"), errorResponseMap.get("message")));
        }
        DevicesResponseDto devicesContainer = null;
        List<DeviceDto> resources = null;
        try {
            devicesContainer = this.mapper.readValue(body, DevicesResponseDto.class);
        }
        catch (JsonProcessingException e) {
            throw new ResourceException("Unable to deserialize searched Devices.", e);
        }
        if (devicesContainer.getDevicesDto() != null) {
            resources = devicesContainer.getDevicesDto().getDevices();
        }
        ArrayList<Device> foundDevices = new ArrayList<Device>();
        if (resources != null) {
            resources.stream().forEach(resource -> foundDevices.add(this.translator.translate((DeviceDto)resource)));
        }
        return foundDevices;
    }

    private Map<String, String> parseErrorResponse(String error) {
        HashMap<String, String> parsedMessageMap = new HashMap<String, String>();
        try {
            JsonNode root = this.mapper.readTree(error);
            String id = root.at(JsonPointer.valueOf("/id")).asText();
            JsonNode details = root.at("/details");
            String errorMessage = details.at(JsonPointer.valueOf("/0/message")) != null ? details.at(JsonPointer.valueOf("/0/message")).asText() : root.at(JsonPointer.valueOf("/message")).asText();
            String errorCode = details.at(JsonPointer.valueOf("/0/code")) != null ? details.at(JsonPointer.valueOf("/0/code")).asText() : root.at(JsonPointer.valueOf("/code")).asText();
            parsedMessageMap.put("id", id);
            parsedMessageMap.put("message", errorMessage);
            parsedMessageMap.put("code", errorCode);
        }
        catch (JsonProcessingException e) {
            return parsedMessageMap;
        }
        return parsedMessageMap;
    }
}

