/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud;

import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.RequestBuilder;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ResourceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.crud.ServiceException;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpHeaders;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpMethod;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.http.GenericHttpRequest;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.ClientConfig;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.IdentityProvider;
import com.pingidentity.provisioner.integrations.prov_pingone.shaded.com.pingidentity.common.saas.pingone.idp.crud.exception.ConfigValidationException;
import java.util.Map;
import java.util.Optional;

public class IdpRequestBuilder
implements RequestBuilder<ClientConfig, IdentityProvider> {
    private static final String GET_ALL_IDP_ENDPOINT = "/environments/%s/identityProviders";
    private static final String GET_IDP_ENDPOINT = "/environments/%s/identityProviders/%s";

    @Override
    public GenericHttpRequest buildCreateRequest(Map<ClientConfig, String> connectionConfig, IdentityProvider resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildCreateRequest(connectionConfig, resource);
    }

    @Override
    public GenericHttpRequest buildReadRequest(Map<ClientConfig, String> connectionConfig, IdentityProvider resource) throws ResourceException, ServiceException {
        String baseUrl = ClientConfig.getIdentityProviderBaseUrl(connectionConfig);
        String envId = ClientConfig.getEnvId(connectionConfig);
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        this.validateConfig(baseUrl, envId, accessToken);
        String idpId = resource.getId();
        this.validateIdp(idpId);
        String url = String.format(baseUrl.concat(GET_IDP_ENDPOINT), envId, idpId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.GET, url, headers);
        return req;
    }

    @Override
    public GenericHttpRequest buildUpdateRequest(Map<ClientConfig, String> connectionConfig, IdentityProvider resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildUpdateRequest(connectionConfig, resource);
    }

    @Override
    public Optional<GenericHttpRequest> buildPartialUpdateRequest(Map<ClientConfig, String> connectionConfig, IdentityProvider oldResource, IdentityProvider newResource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildPartialUpdateRequest(connectionConfig, oldResource, newResource);
    }

    @Override
    public GenericHttpRequest buildDeleteRequest(Map<ClientConfig, String> connectionConfig, IdentityProvider resource) throws ResourceException, ServiceException {
        return RequestBuilder.super.buildDeleteRequest(connectionConfig, resource);
    }

    @Override
    public GenericHttpRequest buildSearchRequest(Map<ClientConfig, String> connectionConfig, IdentityProvider resource) throws ResourceException, ServiceException {
        String baseUrl = ClientConfig.getIdentityProviderBaseUrl(connectionConfig);
        String envId = ClientConfig.getEnvId(connectionConfig);
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        this.validateConfig(baseUrl, envId, accessToken);
        String url = String.format(baseUrl.concat(GET_ALL_IDP_ENDPOINT), envId);
        GenericHttpHeaders headers = this.buildHeaders(connectionConfig);
        GenericHttpRequest req = new GenericHttpRequest(GenericHttpMethod.GET, url, headers);
        return req;
    }

    private void validateConfig(String baseUrl, String envId, String accessToken) throws ConfigValidationException {
        if (baseUrl == null || baseUrl.trim().isEmpty()) {
            throw new ConfigValidationException("PingOne Base Url is missing or empty.");
        }
        if (envId == null || envId.trim().isEmpty()) {
            throw new ConfigValidationException("Environment Id is missing or empty.");
        }
        if (accessToken == null || accessToken.trim().isEmpty()) {
            throw new ConfigValidationException("Access Token is missing or empty.");
        }
    }

    private void validateIdp(String idpId) throws ConfigValidationException {
        if (idpId == null || idpId.trim().isEmpty()) {
            throw new ConfigValidationException("PingOne Base Url is missing or empty.");
        }
    }

    private GenericHttpHeaders buildHeaders(Map<ClientConfig, String> connectionConfig) throws ResourceException {
        String accessToken = ClientConfig.getAccessToken(connectionConfig);
        GenericHttpHeaders headers = new GenericHttpHeaders();
        headers.addHeader("Accept", "application/json");
        headers.addHeader("Authorization", "Bearer " + accessToken);
        return headers;
    }
}

